/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication;

import org.ws4d.java.communication.CommunicationManagerRegistry;
import org.ws4d.java.communication.ContextID;
import org.ws4d.java.communication.ProtocolInfo;
import org.ws4d.java.types.URI;

public abstract class ProtocolData {
    public static final boolean DIRECTION_IN = true;
    public static final boolean DIRECTION_OUT = false;
    protected boolean direction = true;
    private ProtocolInfo protocolInfo = null;

    protected ProtocolData(boolean bl) {
        this.direction = bl;
    }

    public boolean isIncoming() {
        return this.direction;
    }

    public abstract ProtocolData createSwappedProtocolData();

    public abstract String getCommunicationManagerId();

    public boolean sourceMatches(URI uRI) {
        return CommunicationManagerRegistry.getManager(this.getCommunicationManagerId()).addressMatches(uRI, true, this);
    }

    public boolean destinationMatches(URI uRI) {
        return CommunicationManagerRegistry.getManager(this.getCommunicationManagerId()).addressMatches(uRI, false, this);
    }

    public abstract String getIFace();

    public abstract String getSourceAddress();

    public abstract String getDestinationAddress();

    public ProtocolInfo getProtocolInfo() {
        return this.protocolInfo;
    }

    public void setProtocolInfo(ProtocolInfo protocolInfo) {
        if (this.protocolInfo != null && protocolInfo != null) {
            this.protocolInfo.merge(protocolInfo);
        }
        this.protocolInfo = protocolInfo;
    }

    public abstract ContextID getCurrentMIMEContext();

    public abstract void setCurrentMIMEContext(ContextID var1);

    public abstract URI getTransportAddress();

    public abstract void setTransportAddress(URI var1);

    public abstract String getDestinationHost();

    public abstract int getDestinationPort();

    public abstract Long getInstanceId();
}

