/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication;

import org.ws4d.java.communication.IncomingMIMEReceiver;
import org.ws4d.java.communication.IncomingSOAPReceiver;
import org.ws4d.java.communication.ProtocolData;
import org.ws4d.java.communication.ResponseCallback;
import org.ws4d.java.communication.protocol.soap.generator.MessageReceiver;
import org.ws4d.java.communication.protocol.soap.generator.UnexpectedMessageException;
import org.ws4d.java.dispatch.MessageInformer;
import org.ws4d.java.message.FaultMessage;
import org.ws4d.java.message.InvokeMessage;
import org.ws4d.java.message.Message;
import org.ws4d.java.message.discovery.ByeMessage;
import org.ws4d.java.message.discovery.HelloMessage;
import org.ws4d.java.message.discovery.ProbeMatchesMessage;
import org.ws4d.java.message.discovery.ProbeMessage;
import org.ws4d.java.message.discovery.ResolveMatchesMessage;
import org.ws4d.java.message.discovery.ResolveMessage;
import org.ws4d.java.message.eventing.GetStatusMessage;
import org.ws4d.java.message.eventing.GetStatusResponseMessage;
import org.ws4d.java.message.eventing.RenewMessage;
import org.ws4d.java.message.eventing.RenewResponseMessage;
import org.ws4d.java.message.eventing.SubscribeMessage;
import org.ws4d.java.message.eventing.SubscribeResponseMessage;
import org.ws4d.java.message.eventing.SubscriptionEndMessage;
import org.ws4d.java.message.eventing.UnsubscribeMessage;
import org.ws4d.java.message.eventing.UnsubscribeResponseMessage;
import org.ws4d.java.message.metadata.GetMessage;
import org.ws4d.java.message.metadata.GetMetadataMessage;
import org.ws4d.java.message.metadata.GetMetadataResponseMessage;
import org.ws4d.java.message.metadata.GetResponseMessage;
import org.ws4d.java.service.OperationDescription;
import org.ws4d.java.util.Log;

final class SOAPResponseReceiver
implements MessageReceiver {
    private static final MessageInformer MESSAGE_INFORMER = MessageInformer.getInstance();
    private final Message request;
    private final ResponseCallback callback;

    SOAPResponseReceiver(Message message, ResponseCallback responseCallback) {
        this.request = message;
        this.callback = responseCallback;
    }

    public void receive(HelloMessage helloMessage, ProtocolData protocolData) {
        this.receiveUnexpectedMessage(helloMessage, protocolData);
    }

    public void receive(ByeMessage byeMessage, ProtocolData protocolData) {
        this.receiveUnexpectedMessage(byeMessage, protocolData);
    }

    public void receive(ProbeMessage probeMessage, ProtocolData protocolData) {
        this.receiveUnexpectedMessage(probeMessage, protocolData);
    }

    public void receive(ProbeMatchesMessage probeMatchesMessage, ProtocolData protocolData) {
        IncomingSOAPReceiver.markIncoming(probeMatchesMessage);
        this.callback.handle(this.request, probeMatchesMessage, protocolData);
        MESSAGE_INFORMER.forwardMessage(probeMatchesMessage, protocolData);
    }

    public void receive(ResolveMessage resolveMessage, ProtocolData protocolData) {
        this.receiveUnexpectedMessage(resolveMessage, protocolData);
    }

    public void receive(ResolveMatchesMessage resolveMatchesMessage, ProtocolData protocolData) {
        this.receiveUnexpectedMessage(resolveMatchesMessage, protocolData);
    }

    public void receive(GetMessage getMessage, ProtocolData protocolData) {
        this.receiveUnexpectedMessage(getMessage, protocolData);
    }

    public void receive(GetResponseMessage getResponseMessage, ProtocolData protocolData) {
        IncomingSOAPReceiver.markIncoming(getResponseMessage);
        this.callback.handle(this.request, getResponseMessage, protocolData);
        MESSAGE_INFORMER.forwardMessage(getResponseMessage, protocolData);
    }

    public void receive(GetMetadataMessage getMetadataMessage, ProtocolData protocolData) {
        this.receiveUnexpectedMessage(getMetadataMessage, protocolData);
    }

    public void receive(GetMetadataResponseMessage getMetadataResponseMessage, ProtocolData protocolData) {
        IncomingSOAPReceiver.markIncoming(getMetadataResponseMessage);
        this.callback.handle(this.request, getMetadataResponseMessage, protocolData);
        MESSAGE_INFORMER.forwardMessage(getMetadataResponseMessage, protocolData);
    }

    public void receive(SubscribeMessage subscribeMessage, ProtocolData protocolData) {
        this.receiveUnexpectedMessage(subscribeMessage, protocolData);
    }

    public void receive(SubscribeResponseMessage subscribeResponseMessage, ProtocolData protocolData) {
        IncomingSOAPReceiver.markIncoming(subscribeResponseMessage);
        this.callback.handle(this.request, subscribeResponseMessage, protocolData);
        MESSAGE_INFORMER.forwardMessage(subscribeResponseMessage, protocolData);
    }

    public void receive(GetStatusMessage getStatusMessage, ProtocolData protocolData) {
        this.receiveUnexpectedMessage(getStatusMessage, protocolData);
    }

    public void receive(GetStatusResponseMessage getStatusResponseMessage, ProtocolData protocolData) {
        IncomingSOAPReceiver.markIncoming(getStatusResponseMessage);
        this.callback.handle(this.request, getStatusResponseMessage, protocolData);
        MESSAGE_INFORMER.forwardMessage(getStatusResponseMessage, protocolData);
    }

    public void receive(RenewMessage renewMessage, ProtocolData protocolData) {
        this.receiveUnexpectedMessage(renewMessage, protocolData);
    }

    public void receive(RenewResponseMessage renewResponseMessage, ProtocolData protocolData) {
        IncomingSOAPReceiver.markIncoming(renewResponseMessage);
        this.callback.handle(this.request, renewResponseMessage, protocolData);
        MESSAGE_INFORMER.forwardMessage(renewResponseMessage, protocolData);
    }

    public void receive(UnsubscribeMessage unsubscribeMessage, ProtocolData protocolData) {
        this.receiveUnexpectedMessage(unsubscribeMessage, protocolData);
    }

    public void receive(UnsubscribeResponseMessage unsubscribeResponseMessage, ProtocolData protocolData) {
        IncomingSOAPReceiver.markIncoming(unsubscribeResponseMessage);
        this.callback.handle(this.request, unsubscribeResponseMessage, protocolData);
        MESSAGE_INFORMER.forwardMessage(unsubscribeResponseMessage, protocolData);
    }

    public void receive(SubscriptionEndMessage subscriptionEndMessage, ProtocolData protocolData) {
        this.receiveUnexpectedMessage(subscriptionEndMessage, protocolData);
    }

    public void receive(InvokeMessage invokeMessage, ProtocolData protocolData) {
        IncomingMIMEReceiver.storeMIMEContext(invokeMessage.getContent(), protocolData);
        IncomingSOAPReceiver.markIncoming(invokeMessage);
        this.callback.handle(this.request, invokeMessage, protocolData);
        MESSAGE_INFORMER.forwardMessage(invokeMessage, protocolData);
    }

    public void receive(FaultMessage faultMessage, ProtocolData protocolData) {
        IncomingSOAPReceiver.markIncoming(faultMessage);
        this.callback.handle(this.request, faultMessage, protocolData);
        MESSAGE_INFORMER.forwardMessage(faultMessage, protocolData);
    }

    public void receiveFailed(Exception exception, ProtocolData protocolData) {
        this.callback.handleMalformedResponseException(this.request, exception, protocolData);
    }

    public void sendFailed(Exception exception, ProtocolData protocolData) {
        this.callback.handleTransmissionException(this.request, exception, protocolData);
    }

    private void receiveUnexpectedMessage(Message message, ProtocolData protocolData) {
        IncomingSOAPReceiver.markIncoming(message);
        String string = message.getAction().toString();
        Log.error("<I> Unexpected SOAP response message: " + string);
        if (Log.isDebug()) {
            Log.error(message.toString());
        }
        this.callback.handleMalformedResponseException(this.request, new UnexpectedMessageException(string), protocolData);
        MESSAGE_INFORMER.forwardMessage(message, protocolData);
    }

    public OperationDescription getOperation(String string) {
        return this.callback.getOperation();
    }
}

