/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication;

import org.ws4d.java.communication.IncomingSOAPReceiver;
import org.ws4d.java.communication.ProtocolData;
import org.ws4d.java.communication.protocol.soap.generator.MessageReceiver;
import org.ws4d.java.dispatch.MessageInformer;
import org.ws4d.java.dispatch.RequestResponseCoordinator;
import org.ws4d.java.message.FaultMessage;
import org.ws4d.java.message.InvokeMessage;
import org.ws4d.java.message.Message;
import org.ws4d.java.message.discovery.ByeMessage;
import org.ws4d.java.message.discovery.HelloMessage;
import org.ws4d.java.message.discovery.ProbeMatchesMessage;
import org.ws4d.java.message.discovery.ProbeMessage;
import org.ws4d.java.message.discovery.ResolveMatchesMessage;
import org.ws4d.java.message.discovery.ResolveMessage;
import org.ws4d.java.message.eventing.GetStatusMessage;
import org.ws4d.java.message.eventing.GetStatusResponseMessage;
import org.ws4d.java.message.eventing.RenewMessage;
import org.ws4d.java.message.eventing.RenewResponseMessage;
import org.ws4d.java.message.eventing.SubscribeMessage;
import org.ws4d.java.message.eventing.SubscribeResponseMessage;
import org.ws4d.java.message.eventing.SubscriptionEndMessage;
import org.ws4d.java.message.eventing.UnsubscribeMessage;
import org.ws4d.java.message.eventing.UnsubscribeResponseMessage;
import org.ws4d.java.message.metadata.GetMessage;
import org.ws4d.java.message.metadata.GetMetadataMessage;
import org.ws4d.java.message.metadata.GetMetadataResponseMessage;
import org.ws4d.java.message.metadata.GetResponseMessage;
import org.ws4d.java.service.OperationDescription;
import org.ws4d.java.util.Log;

final class UDPResponseReceiver
implements MessageReceiver {
    private static final MessageInformer MESSAGE_INFORMER = MessageInformer.getInstance();
    private final RequestResponseCoordinator rrc;

    UDPResponseReceiver(RequestResponseCoordinator requestResponseCoordinator) {
        this.rrc = requestResponseCoordinator;
    }

    public void receive(HelloMessage helloMessage, ProtocolData protocolData) {
        this.receiveUnexpectedMessage(helloMessage, protocolData);
    }

    public void receive(ByeMessage byeMessage, ProtocolData protocolData) {
        this.receiveUnexpectedMessage(byeMessage, protocolData);
    }

    public void receive(ProbeMessage probeMessage, ProtocolData protocolData) {
        this.receiveUnexpectedMessage(probeMessage, protocolData);
    }

    public void receive(ProbeMatchesMessage probeMatchesMessage, ProtocolData protocolData) {
        IncomingSOAPReceiver.markIncoming(probeMatchesMessage);
        if (probeMatchesMessage.getHeader().isValidated()) {
            this.rrc.handleResponse(probeMatchesMessage, protocolData);
            MESSAGE_INFORMER.forwardMessage(probeMatchesMessage, protocolData);
        }
    }

    public void receive(ResolveMessage resolveMessage, ProtocolData protocolData) {
        this.receiveUnexpectedMessage(resolveMessage, protocolData);
    }

    public void receive(ResolveMatchesMessage resolveMatchesMessage, ProtocolData protocolData) {
        IncomingSOAPReceiver.markIncoming(resolveMatchesMessage);
        if (resolveMatchesMessage.getHeader().isValidated()) {
            this.rrc.handleResponse(resolveMatchesMessage, protocolData);
            MESSAGE_INFORMER.forwardMessage(resolveMatchesMessage, protocolData);
        }
    }

    public void receive(GetMessage getMessage, ProtocolData protocolData) {
        this.receiveUnexpectedMessage(getMessage, protocolData);
    }

    public void receive(GetResponseMessage getResponseMessage, ProtocolData protocolData) {
        this.receiveUnexpectedMessage(getResponseMessage, protocolData);
    }

    public void receive(GetMetadataMessage getMetadataMessage, ProtocolData protocolData) {
        this.receiveUnexpectedMessage(getMetadataMessage, protocolData);
    }

    public void receive(GetMetadataResponseMessage getMetadataResponseMessage, ProtocolData protocolData) {
        this.receiveUnexpectedMessage(getMetadataResponseMessage, protocolData);
    }

    public void receive(SubscribeMessage subscribeMessage, ProtocolData protocolData) {
        this.receiveUnexpectedMessage(subscribeMessage, protocolData);
    }

    public void receive(SubscribeResponseMessage subscribeResponseMessage, ProtocolData protocolData) {
        this.receiveUnexpectedMessage(subscribeResponseMessage, protocolData);
    }

    public void receive(GetStatusMessage getStatusMessage, ProtocolData protocolData) {
        this.receiveUnexpectedMessage(getStatusMessage, protocolData);
    }

    public void receive(GetStatusResponseMessage getStatusResponseMessage, ProtocolData protocolData) {
        this.receiveUnexpectedMessage(getStatusResponseMessage, protocolData);
    }

    public void receive(RenewMessage renewMessage, ProtocolData protocolData) {
        this.receiveUnexpectedMessage(renewMessage, protocolData);
    }

    public void receive(RenewResponseMessage renewResponseMessage, ProtocolData protocolData) {
        this.receiveUnexpectedMessage(renewResponseMessage, protocolData);
    }

    public void receive(UnsubscribeMessage unsubscribeMessage, ProtocolData protocolData) {
        this.receiveUnexpectedMessage(unsubscribeMessage, protocolData);
    }

    public void receive(UnsubscribeResponseMessage unsubscribeResponseMessage, ProtocolData protocolData) {
        this.receiveUnexpectedMessage(unsubscribeResponseMessage, protocolData);
    }

    public void receive(SubscriptionEndMessage subscriptionEndMessage, ProtocolData protocolData) {
        this.receiveUnexpectedMessage(subscriptionEndMessage, protocolData);
    }

    public void receive(InvokeMessage invokeMessage, ProtocolData protocolData) {
        this.receiveUnexpectedMessage(invokeMessage, protocolData);
    }

    public void receive(FaultMessage faultMessage, ProtocolData protocolData) {
        this.receiveUnexpectedMessage(faultMessage, protocolData);
    }

    public void receiveFailed(Exception exception, ProtocolData protocolData) {
        Log.error("Unable to receive SOAP-over-UDP response from " + protocolData.getDestinationAddress());
    }

    public void sendFailed(Exception exception, ProtocolData protocolData) {
    }

    private void receiveUnexpectedMessage(Message message, ProtocolData protocolData) {
        IncomingSOAPReceiver.markIncoming(message);
        String string = message.getAction().toString();
        Log.error("<I> Unexpected unicast SOAP-over-UDP response message from " + protocolData.getDestinationAddress() + ": " + string);
        if (Log.isDebug()) {
            Log.error(message.toString());
        }
        MESSAGE_INFORMER.forwardMessage(message, protocolData);
    }

    public OperationDescription getOperation(String string) {
        return null;
    }
}

