/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication.connection.ip;

public class IPAddress {
    private String address;
    private String addressWithoutNicId;
    private final boolean isLoopback;
    private final boolean isIPv6;
    private final boolean isIPv6LinkLocal;

    public IPAddress(String string, boolean bl, boolean bl2, boolean bl3) {
        this.isIPv6 = bl2;
        this.address = string.trim();
        this.addBrackets();
        this.isLoopback = bl;
        this.isIPv6LinkLocal = bl3;
        this.createAddressWithoutNicId();
    }

    public IPAddress(String string) {
        this.isIPv6 = string.indexOf(58) != -1;
        this.address = string.trim();
        this.addBrackets();
        this.isLoopback = false;
        this.isIPv6LinkLocal = false;
        this.createAddressWithoutNicId();
    }

    public String getAddress() {
        return this.address;
    }

    public String getAddressWithoutNicId() {
        return this.addressWithoutNicId;
    }

    public boolean isLoopback() {
        return this.isLoopback;
    }

    public boolean isIPv6() {
        return this.isIPv6;
    }

    public boolean isIPv6LinkLocal() {
        return this.isIPv6LinkLocal;
    }

    public String toString() {
        return this.address;
    }

    public int hashCode() {
        int n = 31 + (this.address == null ? 0 : this.address.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        IPAddress iPAddress = (IPAddress)object;
        return !(this.address == null ? iPAddress.address != null : !this.address.equals(iPAddress.address));
    }

    private void addBrackets() {
        if (this.isIPv6) {
            if (this.address.charAt(0) != '[') {
                this.address = "[" + this.address;
            }
            if (this.address.charAt(this.address.length() - 1) != ']') {
                this.address = this.address + "]";
            }
        }
    }

    private void createAddressWithoutNicId() {
        int n;
        this.addressWithoutNicId = this.isIPv6() ? ((n = this.address.indexOf(37)) != -1 ? this.address.substring(0, n) + "]" : this.address) : this.address;
    }
}

