/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication.connection.tcp;

import java.io.IOException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import org.ws4d.java.DPWSFramework;
import org.ws4d.java.communication.connection.ip.IPAddress;
import org.ws4d.java.communication.connection.tcp.SESecureSocket;
import org.ws4d.java.communication.connection.tcp.ServerSocket;
import org.ws4d.java.communication.connection.tcp.Socket;
import org.ws4d.java.security.ForcedAliasKeyManager;

public class SESecureServerSocket
implements ServerSocket {
    private IPAddress ipAddress = null;
    private int port = -1;
    java.net.ServerSocket server = null;
    private String alias = null;
    protected static final int PORT_RETRIES = 3;

    public SESecureServerSocket(IPAddress iPAddress, int n, String string) throws IOException {
        this.alias = string;
        this.ipAddress = iPAddress;
        this.port = n;
        try {
            SSLServerSocketFactory sSLServerSocketFactory = this.getSSLServerSocketFactory();
            this.server = sSLServerSocketFactory.createServerSocket(n);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage() + "For " + iPAddress + " at port " + n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Socket accept() throws IOException {
        return new SESecureSocket(this.server.accept());
    }

    public void close() throws IOException {
        this.server.close();
    }

    public IPAddress getIPAddress() {
        return this.ipAddress;
    }

    public int getPort() {
        return this.port;
    }

    protected SSLServerSocketFactory getSSLServerSocketFactory() throws IOException, Exception {
        KeyManager[] keyManagerArray = (KeyManager[])DPWSFramework.getSecurityManager().getKeyManagers();
        TrustManager[] trustManagerArray = (TrustManager[])DPWSFramework.getSecurityManager().getTrustManagers();
        if (this.alias != null) {
            for (int i = 0; i < keyManagerArray.length; ++i) {
                if (!(keyManagerArray[i] instanceof X509KeyManager)) continue;
                keyManagerArray[i] = new ForcedAliasKeyManager((X509KeyManager)keyManagerArray[i], this.alias);
            }
        }
        SSLContext sSLContext = SSLContext.getInstance("SSL");
        sSLContext.init(keyManagerArray, trustManagerArray, null);
        SSLServerSocketFactory sSLServerSocketFactory = sSLContext.getServerSocketFactory();
        return sSLServerSocketFactory;
    }
}

