/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication.connection.tcp;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import org.ws4d.java.DPWSFramework;
import org.ws4d.java.communication.connection.ip.IPAddress;
import org.ws4d.java.communication.connection.ip.IPNetworkDetection;
import org.ws4d.java.communication.connection.tcp.Socket;
import org.ws4d.java.security.ForcedAliasKeyManager;

public class SESecureSocket
implements Socket {
    private static final int DEFAULT_OUT_BUFFER_SIZE = 8192;
    java.net.Socket socket;
    private IPAddress ipAddress = null;
    private int port = -1;
    private InputStream in = null;
    private OutputStream out = null;
    private String alias = null;

    public SESecureSocket(IPAddress iPAddress, int n, String string) throws IOException {
        try {
            this.alias = string;
            SSLSocketFactory sSLSocketFactory = this.getSSLSocketFactory();
            this.socket = sSLSocketFactory.createSocket(iPAddress.getAddressWithoutNicId(), n);
        }
        catch (KeyStoreException keyStoreException) {
            keyStoreException.printStackTrace();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public SESecureSocket(java.net.Socket socket) {
        this.socket = socket;
    }

    public void close() throws IOException {
        if (this.socket == null) {
            throw new IOException("No open connection. Can not close connection");
        }
        this.socket.close();
    }

    public InputStream getInputStream() throws IOException {
        if (this.socket == null) {
            throw new IOException("No open connection. Can not open input stream");
        }
        if (this.in == null) {
            this.in = this.socket.getInputStream();
        }
        return this.in;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.socket == null) {
            throw new IOException("No open connection. Can not open output stream");
        }
        if (this.out == null) {
            this.out = new BufferedOutputStream(this.socket.getOutputStream(), 8192);
        }
        return this.out;
    }

    public IPAddress getRemoteAddress() {
        if (this.socket == null) {
            return null;
        }
        InetAddress inetAddress = this.socket.getInetAddress();
        if (inetAddress != null) {
            return new IPAddress(inetAddress.getHostAddress());
        }
        return null;
    }

    public int getRemotePort() {
        if (this.socket == null) {
            return -1;
        }
        return this.socket.getPort();
    }

    public IPAddress getLocalAddress() {
        if (this.ipAddress == null) {
            this.ipAddress = IPNetworkDetection.getInstance().getIPAddress(this.socket.getLocalAddress().getHostAddress());
        }
        return this.ipAddress;
    }

    public int getLocalPort() {
        if (this.port == -1) {
            this.port = this.socket.getLocalPort();
        }
        return this.port;
    }

    protected SSLSocketFactory getSSLSocketFactory() throws IOException, Exception {
        KeyManager[] keyManagerArray = (KeyManager[])DPWSFramework.getSecurityManager().getKeyManagers();
        TrustManager[] trustManagerArray = (TrustManager[])DPWSFramework.getSecurityManager().getTrustManagers();
        if (this.alias != null && keyManagerArray != null) {
            for (int i = 0; i < keyManagerArray.length; ++i) {
                if (!(keyManagerArray[i] instanceof X509KeyManager)) continue;
                keyManagerArray[i] = new ForcedAliasKeyManager((X509KeyManager)keyManagerArray[i], this.alias);
            }
        }
        SSLContext sSLContext = SSLContext.getInstance("SSL");
        sSLContext.init(keyManagerArray, trustManagerArray, null);
        SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
        return sSLSocketFactory;
    }
}

