/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication.connection.tcp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.ws4d.java.DPWSFramework;
import org.ws4d.java.communication.DPWSProtocolData;
import org.ws4d.java.communication.connection.ip.IPAddress;
import org.ws4d.java.communication.connection.tcp.Socket;
import org.ws4d.java.communication.connection.tcp.SocketFactory;
import org.ws4d.java.communication.connection.tcp.TCPConnection;
import org.ws4d.java.communication.monitor.MonitoredInputStream;
import org.ws4d.java.communication.monitor.MonitoredOutputStream;
import org.ws4d.java.security.DPWSSecurityManager;
import org.ws4d.java.util.Log;

public class TCPClient {
    private Socket socket = null;
    private TCPConnection connection = null;

    public static TCPClient connect(IPAddress iPAddress, int n) throws IOException {
        return TCPClient.connect(iPAddress, n, false, null);
    }

    public static TCPClient connect(IPAddress iPAddress, int n, boolean bl, String string) throws IOException {
        if (iPAddress == null) {
            throw new IOException("Cannot connect. No IP address given.");
        }
        if (n < 1 || n > 65535) {
            throw new IOException("Cannot connect. Port number invalid.");
        }
        TCPClient tCPClient = new TCPClient(iPAddress, n, bl, string);
        return tCPClient;
    }

    private TCPClient(IPAddress iPAddress, int n, boolean bl, String string) throws IOException {
        OutputStream outputStream;
        Object object;
        if (DPWSFramework.hasModule(64)) {
            object = DPWSFramework.getSecurityManager();
            this.socket = bl && object != null && object instanceof DPWSSecurityManager ? ((DPWSSecurityManager)object).getSecureSocket(iPAddress, n, string) : SocketFactory.getInstance().createSocket(iPAddress, n);
        } else {
            this.socket = SocketFactory.getInstance().createSocket(iPAddress, n);
        }
        DPWSProtocolData dPWSProtocolData = new DPWSProtocolData(null, false, this.socket.getLocalAddress().getAddressWithoutNicId(), this.socket.getLocalPort(), this.socket.getRemoteAddress().getAddressWithoutNicId(), this.socket.getRemotePort(), true);
        if (DPWSFramework.getMonitorStreamFactory() != null) {
            object = new MonitoredInputStream(this.socket.getInputStream(), dPWSProtocolData.createSwappedProtocolData());
            outputStream = new MonitoredOutputStream(this.socket.getOutputStream(), dPWSProtocolData);
        } else {
            object = this.socket.getInputStream();
            outputStream = this.socket.getOutputStream();
        }
        this.connection = new TCPConnection((InputStream)object, outputStream, this.socket, dPWSProtocolData);
        if (Log.isDebug()) {
            Log.debug("<O-TCP> To " + this.socket.getLocalAddress() + "@" + this.socket.getLocalPort() + " from " + this.socket.getRemoteAddress() + "@" + this.socket.getRemotePort() + ", " + this.connection, 1);
        }
    }

    public TCPConnection getConnection() {
        return this.connection;
    }
}

