/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication.connection.udp;

import org.ws4d.java.communication.connection.ip.IPAddress;
import org.ws4d.java.communication.connection.udp.DatagramSocket;

public class Datagram {
    private static final Object INSTANCE_ID_LOCK = new Object();
    private static long instanceIdInc = 0L;
    private final long instanceId;
    private final DatagramSocket creator;
    private IPAddress address = null;
    private byte[] data = null;
    private int len = 0;
    private int port = -1;
    private IPAddress socketAddress = null;
    private int sPort = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datagram(DatagramSocket datagramSocket, byte[] byArray, int n) {
        this.creator = datagramSocket;
        this.data = byArray;
        this.len = n;
        Object object = INSTANCE_ID_LOCK;
        synchronized (object) {
            this.instanceId = instanceIdInc++;
        }
    }

    public void setAddress(IPAddress iPAddress) {
        this.address = iPAddress;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public int getPort() {
        return this.port;
    }

    public IPAddress getIPAddress() {
        return this.address;
    }

    public IPAddress getSocketAddress() {
        return this.socketAddress;
    }

    public int getSocketPort() {
        return this.sPort;
    }

    void setSocketAddress(IPAddress iPAddress) {
        this.socketAddress = iPAddress;
    }

    void setSocketPort(int n) {
        this.sPort = n;
    }

    public int getLength() {
        return this.data.length;
    }

    public int getContentLength() {
        return this.len;
    }

    public byte[] getData() {
        return this.data;
    }

    public void release() {
        if (this.creator != null) {
            this.creator.release(this);
        }
    }

    public long getIdentifier() {
        return this.instanceId;
    }

    public String toString() {
        return "UDP Datagram [ id = " + this.instanceId + ", length = " + this.len + " ]";
    }
}

