/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication.connection.udp;

import java.io.IOException;
import org.ws4d.java.DPWSFramework;
import org.ws4d.java.communication.DPWSDiscoveryBinding;
import org.ws4d.java.communication.DPWSProtocolData;
import org.ws4d.java.communication.connection.ip.IPAddress;
import org.ws4d.java.communication.connection.udp.Datagram;
import org.ws4d.java.communication.connection.udp.DatagramSocket;
import org.ws4d.java.communication.connection.udp.DatagramSocketFactory;
import org.ws4d.java.communication.connection.udp.UDPDatagramHandler;
import org.ws4d.java.configuration.IPProperties;
import org.ws4d.java.util.Log;

public class UDPListener
implements Runnable {
    private static final int ACCEPT_RETRIES = 3;
    private static final int ACCEPT_RETRY_DELAY = 1000;
    private IPAddress ipAddress = null;
    private int port = -1;
    private Object lockObj = new Object();
    private volatile boolean running = false;
    private DatagramSocket datagramSocket = null;
    private UDPDatagramHandler handler = null;
    private String iface = null;

    UDPListener(IPAddress iPAddress, int n, String string, UDPDatagramHandler uDPDatagramHandler) throws IOException {
        this(iPAddress, n, string, uDPDatagramHandler, false);
    }

    UDPListener(IPAddress iPAddress, int n, String string, UDPDatagramHandler uDPDatagramHandler, boolean bl) throws IOException {
        if (uDPDatagramHandler == null) {
            throw new IOException("Cannot listen for incoming data. No handler set for connection handling.");
        }
        if (iPAddress == null) {
            throw new IOException("Cannot listen for incoming data. No IP address given.");
        }
        if (n < 0 || n > 65535) {
            throw new IOException("Cannot listen for incoming data. Port number invalid.");
        }
        this.handler = uDPDatagramHandler;
        this.ipAddress = iPAddress;
        this.iface = string;
        bl = bl || (iPAddress == DPWSDiscoveryBinding.DPWS_MCAST_GROUP_IPv4 || iPAddress == DPWSDiscoveryBinding.DPWS_MCAST_GROUP_IPv6) && n == 3702;
        this.datagramSocket = bl ? DatagramSocketFactory.getInstance().registerMulticastGroup(iPAddress, n, string) : DatagramSocketFactory.getInstance().createDatagramServerSocket(iPAddress, n, string);
        this.port = this.datagramSocket.getSocketPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (Log.isDebug()) {
            Log.debug("UDP listener up for " + this.ipAddress + "(" + this.iface + ") and port " + this.port + ".", 1);
        }
        int n = 0;
        Object object = this.lockObj;
        synchronized (object) {
            this.running = true;
            this.lockObj.notifyAll();
        }
        while (this.isRunning()) {
            try {
                object = this.datagramSocket.receive();
                if (!this.isRunning()) break;
                if (object == null) {
                    Log.warn("Incoming UDP datagram was empty. Re-listening for new connections.");
                    continue;
                }
                if (!IPProperties.getInstance().isAllowedByIPFilter(((Datagram)object).getIPAddress())) continue;
                DPWSFramework.getThreadPool().execute(new UDPDatagramThread((Datagram)object, this.handler));
            }
            catch (Exception exception) {
                if (!this.isRunning()) break;
                if (n++ < 3) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        Log.warn("UDP listener interrupted. UDP listener shutdown for " + this.ipAddress + " and port " + this.port + ".");
                        break;
                    }
                    Log.warn("Can not open port " + this.port + " for " + this.ipAddress + ". Try " + n + ".");
                    continue;
                }
                Log.error("Can not open port " + this.port + " for " + this.ipAddress + ". UDP listener shutdown for " + this.ipAddress + " and port " + this.port + ".");
                break;
            }
        }
    }

    public synchronized DatagramSocket getDatagramSocket() {
        return this.datagramSocket;
    }

    public synchronized UDPDatagramHandler getUDPDatagramHandler() {
        return this.handler;
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean start() {
        if (this.running) {
            return true;
        }
        Object object = this.lockObj;
        synchronized (object) {
            try {
                if (DPWSFramework.getThreadPool().executeOrAbort(this)) {
                    while (!this.running) {
                        this.lockObj.wait();
                    }
                    return true;
                }
                return false;
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
    }

    public synchronized void stop() throws IOException {
        if (!this.running) {
            return;
        }
        this.datagramSocket.close();
        if (Log.isDebug()) {
            Log.debug("UDP listener shutdown for " + this.ipAddress + "(" + this.iface + ") and port " + this.port + ".", 1);
        }
        this.running = false;
    }

    public int getPort() {
        return this.port;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.ipAddress == null ? 0 : this.ipAddress.hashCode());
        n = 31 * n + this.port;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        UDPListener uDPListener = (UDPListener)object;
        if (this.ipAddress == null ? uDPListener.ipAddress != null : !this.ipAddress.equals(uDPListener.ipAddress)) {
            return false;
        }
        return this.port == uDPListener.port;
    }

    private class UDPDatagramThread
    implements Runnable {
        private Datagram datagram = null;
        private UDPDatagramHandler handler = null;

        UDPDatagramThread(Datagram datagram, UDPDatagramHandler uDPDatagramHandler) {
            this.datagram = datagram;
            this.handler = uDPDatagramHandler;
        }

        public void run() {
            try {
                if (Log.isDebug()) {
                    Log.debug("<I-UDP> From " + this.datagram.getIPAddress() + "@" + this.datagram.getPort() + " to " + this.datagram.getSocketAddress() + "@" + this.datagram.getSocketPort() + ", " + this.datagram, 1);
                }
                this.handler.handle(this.datagram, new DPWSProtocolData(UDPListener.this.iface, true, this.datagram.getIPAddress().getAddressWithoutNicId(), this.datagram.getPort(), UDPListener.this.ipAddress.getAddressWithoutNicId(), UDPListener.this.port, false));
            }
            catch (IOException iOException) {
                Log.warn("Incoming UDP datagram (" + this.datagram.getIdentifier() + ") could not be handled. " + iOException.getMessage() + ".");
            }
        }
    }
}

