/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication.monitor;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.ws4d.java.DPWSFramework;
import org.ws4d.java.communication.ProtocolData;
import org.ws4d.java.communication.monitor.MonitorStreamFactory;
import org.ws4d.java.communication.monitor.StreamMonitor;
import org.ws4d.java.util.Log;

public final class MonitoredInputStream
extends InputStream {
    private static int count = 0;
    private InputStream in = null;
    private StreamMonitor stMon = null;
    private int len = 0;
    private boolean monWarn = true;

    public MonitoredInputStream(InputStream inputStream, ProtocolData protocolData) {
        MonitorStreamFactory monitorStreamFactory = DPWSFramework.getMonitorStreamFactory();
        if (monitorStreamFactory != null) {
            this.stMon = monitorStreamFactory.getInputMonitor(protocolData);
            monitorStreamFactory.linkIn(protocolData, this.stMon);
        }
        this.in = inputStream;
        ++count;
    }

    public int read() throws IOException {
        int n;
        block3: {
            OutputStream outputStream;
            ++this.len;
            n = this.in.read();
            if (this.stMon != null && this.stMon.getOutputStream() != null && (outputStream = this.stMon.getOutputStream()) != null) {
                try {
                    outputStream.write(n);
                }
                catch (IOException iOException) {
                    if (!this.monWarn) break block3;
                    Log.error("Monitoring failed in MonitoredInputStream.read() (" + this.intToString(n) + ")");
                    Log.printStackTrace(iOException);
                    this.monWarn = false;
                }
            }
        }
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        block3: {
            OutputStream outputStream;
            n3 = this.in.read(byArray, n, n2);
            this.len += n3;
            if (this.stMon != null && this.stMon.getOutputStream() != null && (outputStream = this.stMon.getOutputStream()) != null) {
                try {
                    outputStream.write(byArray, n, n3);
                }
                catch (IOException iOException) {
                    if (!this.monWarn) break block3;
                    Log.error("Monitoring failed in MonitoredInputStream.read(byte[" + byArray.length + "], off: " + n + ", len: " + n2 + ") (bytes read: " + n3 + ", " + this.byteArrayToString(byArray) + ")");
                    Log.printStackTrace(iOException);
                    this.monWarn = false;
                }
            }
        }
        return n3;
    }

    public void close() throws IOException {
        block3: {
            OutputStream outputStream;
            if (this.stMon != null && this.stMon.getOutputStream() != null && (outputStream = this.stMon.getOutputStream()) != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    if (!this.monWarn) break block3;
                    Log.error("Monitoring failed in MonitoredInputStream.close()");
                    Log.printStackTrace(iOException);
                    this.monWarn = false;
                }
            }
        }
        this.in.close();
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public void reset() throws IOException {
        this.in.reset();
    }

    public long skip(int n) throws IOException {
        return this.in.skip(n);
    }

    public void mark(int n) {
        this.in.mark(n);
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.in == null ? 0 : this.in.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MonitoredInputStream monitoredInputStream = (MonitoredInputStream)object;
        return !(this.in == null ? monitoredInputStream.in != null : !this.in.equals(monitoredInputStream.in));
    }

    private String byteArrayToString(byte[] byArray) {
        char[] cArray = new char[byArray.length + 1];
        cArray[byArray.length] = 125;
        for (int i = 0; i < byArray.length; ++i) {
            cArray[i] = (char)byArray[i];
        }
        return "byte[" + byArray.length + "]: {" + new String(cArray);
    }

    private String intToString(int n) {
        if (n > 32 && n < 127) {
            return "" + (char)n;
        }
        if (n == 32) {
            return "\"space character\"";
        }
        return "dec: " + n;
    }
}

