/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication.monitor;

import java.io.IOException;
import java.io.OutputStream;
import org.ws4d.java.DPWSFramework;
import org.ws4d.java.communication.ProtocolData;
import org.ws4d.java.communication.monitor.MonitorStreamFactory;
import org.ws4d.java.communication.monitor.StreamMonitor;
import org.ws4d.java.util.Log;

public class MonitoredOutputStream
extends OutputStream {
    private static int count = 0;
    private OutputStream out = null;
    private StreamMonitor stMon = null;
    private int len = 0;
    private boolean monWarn = true;

    public MonitoredOutputStream(OutputStream outputStream, ProtocolData protocolData) {
        MonitorStreamFactory monitorStreamFactory = DPWSFramework.getMonitorStreamFactory();
        if (monitorStreamFactory != null) {
            this.stMon = monitorStreamFactory.getOutputMonitor(protocolData);
            monitorStreamFactory.linkOut(protocolData, this.stMon);
        }
        this.out = outputStream;
        ++count;
    }

    public void write(int n) throws IOException {
        block3: {
            OutputStream outputStream;
            ++this.len;
            this.out.write(n);
            if (this.stMon != null && this.stMon.getOutputStream() != null && (outputStream = this.stMon.getOutputStream()) != null) {
                try {
                    outputStream.write(n);
                }
                catch (IOException iOException) {
                    if (!this.monWarn) break block3;
                    Log.error("Monitoring failed in MonitoredOutputStream.write(" + this.intToString(n) + ")");
                    Log.printStackTrace(iOException);
                    this.monWarn = false;
                }
            }
        }
    }

    public void write(byte[] byArray) throws IOException {
        block3: {
            OutputStream outputStream;
            this.out.write(byArray);
            this.len += byArray.length;
            if (this.stMon != null && this.stMon.getOutputStream() != null && (outputStream = this.stMon.getOutputStream()) != null) {
                try {
                    outputStream.write(byArray);
                }
                catch (IOException iOException) {
                    if (!this.monWarn) break block3;
                    Log.error("Monitoring failed in MonitoredOutputStream.write(" + this.byteArrayToString(byArray) + ")");
                    Log.printStackTrace(iOException);
                    this.monWarn = false;
                }
            }
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        block3: {
            OutputStream outputStream;
            this.out.write(byArray, n, n2);
            this.len += n2;
            if (this.stMon != null && this.stMon.getOutputStream() != null && (outputStream = this.stMon.getOutputStream()) != null) {
                try {
                    outputStream.write(byArray, n, n2);
                }
                catch (IOException iOException) {
                    if (!this.monWarn) break block3;
                    Log.error("Monitoring failed in MonitoredOutputStream.write(off: " + n + ", len: " + n2 + ", " + this.byteArrayToString(byArray) + ")");
                    Log.printStackTrace(iOException);
                    this.monWarn = false;
                }
            }
        }
    }

    public void flush() throws IOException {
        block3: {
            OutputStream outputStream;
            this.out.flush();
            if (this.stMon != null && this.stMon.getOutputStream() != null && (outputStream = this.stMon.getOutputStream()) != null) {
                try {
                    outputStream.flush();
                }
                catch (IOException iOException) {
                    if (!this.monWarn) break block3;
                    Log.error("Monitoring failed in MonitoredOutputStream.flush()");
                    Log.printStackTrace(iOException);
                    this.monWarn = false;
                }
            }
        }
    }

    public void close() throws IOException {
        block3: {
            OutputStream outputStream;
            this.flush();
            this.out.close();
            if (this.stMon != null && this.stMon.getOutputStream() != null && (outputStream = this.stMon.getOutputStream()) != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    if (!this.monWarn) break block3;
                    Log.error("Monitoring failed in MonitoredOutputStream.close()");
                    Log.printStackTrace(iOException);
                    this.monWarn = false;
                }
            }
        }
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.out == null ? 0 : this.out.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MonitoredOutputStream monitoredOutputStream = (MonitoredOutputStream)object;
        return !(this.out == null ? monitoredOutputStream.out != null : !this.out.equals(monitoredOutputStream.out));
    }

    private String byteArrayToString(byte[] byArray) {
        char[] cArray = new char[byArray.length + 1];
        cArray[byArray.length] = 125;
        for (int i = 0; i < byArray.length; ++i) {
            cArray[i] = (char)byArray[i];
        }
        return "byte[" + byArray.length + "]: {" + new String(cArray);
    }

    private String intToString(int n) {
        if (n > 32 && n < 127) {
            return "" + (char)n;
        }
        if (n == 32) {
            return "\"space character\"";
        }
        return "dec: " + n;
    }
}

