/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication.protocol.http;

import java.io.IOException;
import java.io.OutputStream;
import org.ws4d.java.communication.protocol.http.HTTPChunkHeader;

public class ChunkedOutputStream
extends OutputStream {
    private static final int CHUNK_SIZE = 8192;
    private OutputStream out = null;
    private byte[] buffer = null;
    private int i = 0;
    private boolean trailer = false;
    private long totalLength = 0L;
    private boolean last = false;

    public ChunkedOutputStream(OutputStream outputStream, int n, boolean bl) {
        this.out = outputStream;
        this.trailer = bl;
        this.buffer = new byte[n];
    }

    public ChunkedOutputStream(OutputStream outputStream, boolean bl) {
        this(outputStream, 8192, bl);
    }

    public void write(int n) throws IOException {
        if (this.last) {
            return;
        }
        this.buffer[this.i++] = (byte)n;
        if (this.i == this.buffer.length) {
            this.flushBuffer();
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.last) {
            return;
        }
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        int n3 = this.i + n2;
        if (n3 >= this.buffer.length) {
            HTTPChunkHeader hTTPChunkHeader = new HTTPChunkHeader(n3, null, null);
            hTTPChunkHeader.toStream(this.out);
            this.out.write(this.buffer, 0, this.i);
            this.i = 0;
            this.out.write(byArray, n, n2);
            this.totalLength += (long)n3;
            this.out.write(13);
            this.out.write(10);
        } else {
            System.arraycopy(byArray, n, this.buffer, this.i, n2);
            this.i += n2;
        }
    }

    public void flush() throws IOException {
        this.flushBuffer();
        this.out.flush();
    }

    public void close() throws IOException {
        this.last();
        this.out.close();
    }

    public static void writeLastChunk(ChunkedOutputStream chunkedOutputStream) throws IOException {
        chunkedOutputStream.last();
    }

    private void flushBuffer() throws IOException {
        if (this.i > 0) {
            HTTPChunkHeader hTTPChunkHeader = new HTTPChunkHeader(this.i, null, null);
            hTTPChunkHeader.toStream(this.out);
            this.out.write(this.buffer, 0, this.i);
            this.totalLength += (long)this.i;
            this.i = 0;
            this.out.write(13);
            this.out.write(10);
        }
    }

    private void last() throws IOException {
        if (this.last) {
            return;
        }
        this.flushBuffer();
        this.buffer = null;
        HTTPChunkHeader hTTPChunkHeader = new HTTPChunkHeader(0, null, null);
        hTTPChunkHeader.toStream(this.out);
        if (this.trailer) {
            this.out.write(("Content-Length: " + String.valueOf(this.totalLength)).toString().getBytes());
            this.out.write(13);
            this.out.write(10);
        }
        this.out.write(13);
        this.out.write(10);
        this.last = true;
        this.out.flush();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.out == null ? 0 : this.out.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ChunkedOutputStream chunkedOutputStream = (ChunkedOutputStream)object;
        return !(this.out == null ? chunkedOutputStream.out != null : !this.out.equals(chunkedOutputStream.out));
    }
}

