/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication.protocol.http;

import java.io.IOException;
import java.io.InputStream;
import org.ws4d.java.communication.ProtocolException;
import org.ws4d.java.communication.protocol.http.HTTPChunkHeader;
import org.ws4d.java.communication.protocol.http.HTTPUtil;
import org.ws4d.java.util.Sync;

public class HTTPInputStream
extends InputStream {
    private InputStream in = null;
    private int size = 0;
    private int read = 0;
    private String encoding = null;
    private boolean end = false;
    private InputStream wrapped = null;
    protected HTTPChunkHeader chunkedheader = null;
    protected boolean chunked = false;
    private Sync notify = null;

    public HTTPInputStream(InputStream inputStream, String string, int n) {
        this(inputStream, string, n, null);
    }

    public HTTPInputStream(InputStream inputStream, String string, int n, Sync sync) {
        this.in = inputStream;
        this.encoding = string;
        if ("chunked".equals(string)) {
            this.chunked = true;
        }
        this.size = n < 0 ? 0 : n;
        this.notify = sync;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            if (this.in == null) {
                throw new IOException("InputStream not available");
            }
            if (this.notify != null) {
                Sync sync = this.notify;
                synchronized (sync) {
                    this.notify.notifyNow();
                }
            }
            if (this.wrapped != null) {
                this.wrapped.close();
            }
            this.in.close();
        }
        catch (IOException iOException) {
            if (this.notify != null) {
                Sync sync = this.notify;
                synchronized (sync) {
                    this.notify.notifyNow(iOException);
                }
            }
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int read() throws IOException {
        try {
            if (this.in == null) {
                throw new IOException("InputStream not available");
            }
            if (this.end) {
                if (this.notify != null) {
                    Sync sync = this.notify;
                    synchronized (sync) {
                        this.notify.notifyNow();
                    }
                }
                return -1;
            }
            int n = -1;
            n = !this.chunked ? this.readNonChunked() : this.readChunked();
            if (this.notify != null && n == -1) {
                Sync sync = this.notify;
                synchronized (sync) {
                    this.notify.notifyNow();
                }
            }
            return n;
        }
        catch (IOException iOException) {
            if (this.notify != null) {
                Sync sync = this.notify;
                synchronized (sync) {
                    this.notify.notifyNow(iOException);
                }
            }
            throw iOException;
        }
    }

    private int readNonChunked() throws IOException {
        if (this.size > 0) {
            if (this.wrapped == null) {
                this.wrapped = this.wrap(this.size);
            }
            ++this.read;
            return this.wrapped.read();
        }
        return -1;
    }

    private int readChunked() throws IOException {
        int n;
        int n2;
        if (this.chunkedheader == null) {
            this.readChunkHeader();
        }
        if ((n2 = this.chunkedheader.getSize()) == 0) {
            this.end = true;
            return -1;
        }
        if (this.wrapped == null) {
            this.wrapped = this.wrap(n2);
        }
        if ((n = this.wrapped.read()) == -1) {
            this.chunkedheader = null;
            this.wrapped = null;
            this.read = 0;
            HTTPUtil.readRequestLine(this.in);
            return this.readChunked();
        }
        ++this.read;
        return n;
    }

    private void readChunkHeader() throws IOException {
        try {
            this.chunkedheader = HTTPUtil.readChunkHeader(this.in);
        }
        catch (ProtocolException protocolException) {
            this.chunkedheader = null;
            throw new IOException("Cannot read HTTP chunk header. " + protocolException.getMessage());
        }
    }

    private InputStream wrap(int n) {
        return new WrappedInputStream(this.in, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() throws IOException {
        try {
            if (this.end) {
                return 0;
            }
            if (!this.chunked) {
                return this.size - this.read;
            }
            if (this.chunkedheader == null) {
                this.readChunkHeader();
            }
            return this.chunkedheader.getSize() - this.read;
        }
        catch (IOException iOException) {
            if (this.notify != null) {
                Sync sync = this.notify;
                synchronized (sync) {
                    this.notify.notifyNow(iOException);
                }
            }
            throw iOException;
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.in == null ? 0 : this.in.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        HTTPInputStream hTTPInputStream = (HTTPInputStream)object;
        return !(this.in == null ? hTTPInputStream.in != null : !this.in.equals(hTTPInputStream.in));
    }

    private class WrappedInputStream
    extends InputStream {
        private int size = 0;
        private int read = 0;
        private InputStream in = null;

        WrappedInputStream(InputStream inputStream, int n) {
            this.in = inputStream;
            this.size = n;
        }

        public int available() throws IOException {
            return this.read - this.size;
        }

        public int read() throws IOException {
            if (this.read == this.size) {
                return -1;
            }
            ++this.read;
            return this.in.read();
        }

        private HTTPInputStream getOuterType() {
            return HTTPInputStream.this;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.getOuterType().hashCode();
            n = 31 * n + (this.in == null ? 0 : this.in.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            WrappedInputStream wrappedInputStream = (WrappedInputStream)object;
            if (!this.getOuterType().equals(wrappedInputStream.getOuterType())) {
                return false;
            }
            return !(this.in == null ? wrappedInputStream.in != null : !this.in.equals(wrappedInputStream.in));
        }
    }
}

