/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication.protocol.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.ws4d.java.communication.ProtocolException;
import org.ws4d.java.communication.protocol.http.ChunkedOutputStream;
import org.ws4d.java.communication.protocol.http.HTTPUtil;
import org.ws4d.java.communication.protocol.http.header.HTTPResponseHeader;
import org.ws4d.java.html.HTMLDocument;
import org.ws4d.java.html.SimpleHTML;
import org.ws4d.java.structures.ByteArray;
import org.ws4d.java.structures.HashMap;
import org.ws4d.java.types.InternetMediaType;
import org.ws4d.java.types.URI;
import org.ws4d.java.util.Log;

public class HTTPResponseUtil {
    private HTTPResponseUtil() {
    }

    public static void sendCountinueResponse(OutputStream outputStream, String string) {
        HTTPResponseUtil.sendResponse(outputStream, 100, string);
    }

    public static void sendOKResponse(OutputStream outputStream, String string) {
        HTTPResponseUtil.sendResponse(outputStream, 200, string);
    }

    public static void sendOKResponse(OutputStream outputStream, HTMLDocument hTMLDocument) {
        HTTPResponseUtil.sendResponse(outputStream, 200, hTMLDocument);
    }

    public static void sendNoContentResponse(OutputStream outputStream, String string) {
        HTTPResponseUtil.sendResponse(outputStream, 204, string);
    }

    public static void sendNotFoundResponse(OutputStream outputStream, HTMLDocument hTMLDocument) {
        HTTPResponseUtil.sendResponse(outputStream, 404, hTMLDocument);
    }

    public static void sendNotFoundResponse(OutputStream outputStream, String string) {
        HTTPResponseUtil.sendResponse(outputStream, 404, string);
    }

    public static void sendResponse(OutputStream outputStream, int n, String string) {
        HTTPResponseHeader hTTPResponseHeader = HTTPResponseUtil.getResponseHeader(n);
        String string2 = "text/plain";
        int n2 = 0;
        byte[] byArray = null;
        if (string != null) {
            byArray = string.getBytes();
            n2 = byArray.length;
            hTTPResponseHeader.addHeaderFieldValue("Content-Length", String.valueOf(n2));
            hTTPResponseHeader.addHeaderFieldValue("Content-Type", string2);
        }
        HTTPResponseUtil.sendResponse(outputStream, byArray, hTTPResponseHeader);
    }

    public static void sendResponse(OutputStream outputStream, int n, HTMLDocument hTMLDocument) {
        HTTPResponseHeader hTTPResponseHeader = HTTPResponseUtil.getResponseHeader(n);
        String string = "text/html";
        int n2 = 0;
        byte[] byArray = null;
        if (hTMLDocument != null) {
            byArray = hTMLDocument.getData();
            n2 = byArray.length;
            hTTPResponseHeader.addHeaderFieldValue("Content-Length", String.valueOf(n2));
            hTTPResponseHeader.addHeaderFieldValue("Content-Type", string);
        }
        HTTPResponseUtil.sendResponse(outputStream, byArray, hTTPResponseHeader);
    }

    public static void sendResponse(OutputStream outputStream, byte[] byArray, HTTPResponseHeader hTTPResponseHeader) {
        try {
            hTTPResponseHeader.toStream(outputStream);
            if (byArray != null) {
                outputStream.write(byArray);
            }
            outputStream.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void sendBadRequest(OutputStream outputStream, String string) {
        HTTPResponseHeader hTTPResponseHeader = HTTPResponseUtil.getResponseHeader(400);
        try {
            hTTPResponseHeader.toStream(outputStream);
            if (string != null) {
                outputStream.write(string.getBytes());
            }
            outputStream.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void sendInternalServerError(OutputStream outputStream, String string) {
        HTTPResponseHeader hTTPResponseHeader = HTTPResponseUtil.getResponseHeader(500);
        hTTPResponseHeader.addHeaderFieldValue("Connection", "close");
        try {
            hTTPResponseHeader.toStream(outputStream);
            if (string != null) {
                outputStream.write(string.getBytes());
            }
            outputStream.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void sendHTTPVersionNotSupported(OutputStream outputStream, String string) {
        HTTPResponseHeader hTTPResponseHeader = HTTPResponseUtil.getResponseHeader(505);
        hTTPResponseHeader.addHeaderFieldValue("Connection", "close");
        try {
            hTTPResponseHeader.toStream(outputStream);
            if (string != null) {
                outputStream.write(string.getBytes());
            }
            outputStream.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void sendUnsupportedMediaType(OutputStream outputStream, String string) {
        HTTPResponseHeader hTTPResponseHeader = HTTPResponseUtil.getResponseHeader(415);
        try {
            hTTPResponseHeader.toStream(outputStream);
            if (string != null) {
                outputStream.write(string.getBytes());
            }
            outputStream.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void sendRedirect(OutputStream outputStream, URI uRI, String string) {
        HTTPResponseHeader hTTPResponseHeader = HTTPResponseUtil.getResponseHeader(307);
        hTTPResponseHeader.addHeaderFieldValue("Location", uRI.getPath());
        try {
            hTTPResponseHeader.toStream(outputStream);
            if (string != null) {
                outputStream.write(string.getBytes());
            }
            outputStream.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void sendDefaultErrorDocument(OutputStream outputStream, String string) {
        SimpleHTML simpleHTML = new SimpleHTML("Not Found");
        simpleHTML.addParagraph("The requested URI " + string + " was not found on this server.");
        simpleHTML.addHorizontalRule();
        simpleHTML.addParagraph("<i>Java Multi Edition DPWS Framework</i>");
        HTTPResponseUtil.sendNotFoundResponse(outputStream, simpleHTML);
    }

    public static void sendDefaultDocument(OutputStream outputStream) {
        SimpleHTML simpleHTML = new SimpleHTML("It works!");
        HTTPResponseUtil.sendOKResponse(outputStream, simpleHTML);
    }

    public static HTTPResponseHeader getResponseHeader() {
        return HTTPResponseUtil.getResponseHeader(204);
    }

    public static HTTPResponseHeader getResponseHeader(int n) {
        String string = "HTTP/1.1";
        String string2 = null;
        switch (n) {
            case 100: {
                string2 = "Continue";
                break;
            }
            case 200: {
                string2 = "OK";
                break;
            }
            case 202: {
                string2 = "Accepted";
                break;
            }
            case 204: {
                string2 = "No Content";
                break;
            }
            case 300: {
                string2 = "Multiple Choices";
                break;
            }
            case 301: {
                string2 = "Moved Permanently";
                break;
            }
            case 302: {
                string2 = "Found";
                break;
            }
            case 303: {
                string2 = "See Other";
                break;
            }
            case 304: {
                string2 = "Not Modified";
                break;
            }
            case 307: {
                string2 = "Temporary Redirect";
                break;
            }
            case 400: {
                string2 = "Bad Request";
                break;
            }
            case 401: {
                string2 = "Unauthorized";
                break;
            }
            case 403: {
                string2 = "Forbidden";
                break;
            }
            case 404: {
                string2 = "Not Found";
                break;
            }
            case 415: {
                string2 = "Unsupported Media Type";
                break;
            }
            case 500: {
                string2 = "Internal Server Error";
                break;
            }
            case 501: {
                string2 = "Not Implemented";
                break;
            }
            case 505: {
                string2 = "HTTP Version not supported";
            }
        }
        return new HTTPResponseHeader(string, n, string2);
    }

    public static HTTPResponseHeader handleResponse(InputStream inputStream) throws IOException, ProtocolException {
        String string = null;
        String string2 = null;
        String string3 = null;
        string = HTTPUtil.readElement(inputStream);
        string2 = HTTPUtil.readElement(inputStream);
        string3 = HTTPUtil.readRequestLine(inputStream);
        HashMap hashMap = new HashMap();
        HTTPUtil.readHeaderFields(inputStream, hashMap);
        int n = 0;
        try {
            n = Integer.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Cannot determinate HTTP version.");
        }
        return new HTTPResponseHeader(string, n, string3, hashMap);
    }

    public static OutputStream writeResponse(OutputStream outputStream, int n, InternetMediaType internetMediaType, boolean bl, boolean bl2) throws IOException {
        HTTPResponseHeader hTTPResponseHeader = HTTPResponseUtil.getResponseHeader(n);
        if (Log.isDebug()) {
            Log.debug("<O> " + hTTPResponseHeader.toString(), 1);
        }
        hTTPResponseHeader.addHeaderFieldValue("Content-Type", internetMediaType.toString());
        if (bl) {
            hTTPResponseHeader.addHeaderFieldValue("Transfer-Encoding", "chunked");
            hTTPResponseHeader.toStream(outputStream);
            return new ChunkedOutputStream(outputStream, bl2);
        }
        hTTPResponseHeader.toStream(outputStream);
        return outputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean sendResource(OutputStream outputStream, String string, InternetMediaType internetMediaType, boolean bl, boolean bl2) {
        InputStream inputStream = outputStream.getClass().getResourceAsStream(string);
        if (inputStream == null) {
            return false;
        }
        try {
            outputStream = HTTPResponseUtil.writeResponse(outputStream, 200, internetMediaType, bl, bl2);
            if (bl) {
                int n = -1;
                if (Log.isDebug()) {
                    Log.debug("Sending chunked resource [ " + string + " ] over HTTP.", 1);
                }
                while (inputStream.available() > 0 && (n = inputStream.read()) != -1) {
                    outputStream.write(n);
                }
            } else {
                if (Log.isDebug()) {
                    Log.debug("Sending resource [ " + string + " ] over HTTP.", 1);
                }
                HTTPResponseHeader hTTPResponseHeader = HTTPResponseUtil.getResponseHeader(200);
                String string2 = internetMediaType.getMediaType();
                hTTPResponseHeader.addHeaderFieldValue("Content-Type", string2);
                int n = -1;
                ByteArray byteArray = new ByteArray();
                while (inputStream.available() > 0 && (n = inputStream.read()) != -1) {
                    byteArray.append((byte)n);
                }
                hTTPResponseHeader.addHeaderFieldValue("Content-Length", String.valueOf(byteArray.size()));
                hTTPResponseHeader.toStream(outputStream);
                outputStream.write(byteArray.getBytes());
            }
            outputStream.flush();
        }
        catch (IOException iOException) {
            Log.printStackTrace(iOException);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                Log.printStackTrace(iOException);
            }
        }
        return true;
    }
}

