/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication.protocol.http;

import java.io.IOException;
import java.io.InputStream;
import org.ws4d.java.communication.ProtocolException;
import org.ws4d.java.communication.protocol.http.HTTPChunkHeader;
import org.ws4d.java.structures.HashMap;

public class HTTPUtil {
    private HTTPUtil() {
    }

    public static String readElement(InputStream inputStream) throws IOException {
        return HTTPUtil.readElement(inputStream, 0);
    }

    public static String readElement(InputStream inputStream, int n) throws IOException {
        int n2 = -1;
        int n3 = -1;
        StringBuffer stringBuffer = new StringBuffer();
        while (n3 < n && (n2 = inputStream.read()) != -1 && (byte)n2 != 32) {
            if (n > 0) {
                ++n3;
            }
            stringBuffer.append((char)n2);
        }
        if (n2 == -1) {
            return null;
        }
        return stringBuffer.toString();
    }

    public static String readRequestLine(InputStream inputStream) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        while ((n = inputStream.read()) != -1) {
            if ((byte)n == 13) {
                bl = true;
                continue;
            }
            if ((byte)n == 10 && bl) {
                bl = false;
                return stringBuffer.toString();
            }
            stringBuffer.append((char)n);
        }
        throw new IOException("Unexpected end of stream.");
    }

    public static String readRequestVersion(InputStream inputStream) throws IOException, ProtocolException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        int n3 = 0;
        byte[] byArray = new byte[]{72, 84, 84, 80};
        while ((n = inputStream.read()) != -1) {
            if (n2 < byArray.length && n3 == 0) {
                if ((byte)n != byArray[n2]) {
                    throw new ProtocolException("Malformed HTTP request line.");
                }
                stringBuffer.append((char)n);
                ++n2;
                continue;
            }
            if (n2 == byArray.length) {
                if ((byte)n == 47) {
                    stringBuffer.append((char)n);
                    n3 = 1;
                    n2 = 0;
                    continue;
                }
                throw new ProtocolException("Malformed HTTP request line.");
            }
            if (n3 == 1) {
                if ((byte)n >= 48 && (byte)n <= 57) {
                    stringBuffer.append((char)n);
                    continue;
                }
                if ((byte)n == 46) {
                    stringBuffer.append((char)n);
                    n3 = 2;
                    continue;
                }
                throw new ProtocolException("Malformed HTTP request line.");
            }
            if (n3 == 2) {
                if ((byte)n >= 48 && (byte)n <= 57) {
                    stringBuffer.append((char)n);
                    continue;
                }
                if ((byte)n == 13) {
                    n3 = 3;
                    continue;
                }
                throw new ProtocolException("Malformed HTTP request line.");
            }
            if (n3 != 3 || (byte)n != 10) continue;
            n2 = 0;
            n3 = 0;
            return stringBuffer.toString();
        }
        throw new IOException("Unexpected end of stream.");
    }

    public static void readHeaderFields(InputStream inputStream, HashMap hashMap) throws IOException, ProtocolException {
        int n;
        String string = null;
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while ((n = inputStream.read()) != -1) {
            if (string == null) {
                if ((byte)n == 13) {
                    n4 = 1;
                    continue;
                }
                if ((byte)n == 10 && n4 == 1) {
                    n4 = 0;
                    return;
                }
                if ((byte)n == 58) {
                    string = stringBuffer.toString().toLowerCase();
                    stringBuffer = new StringBuffer();
                    n2 = 1;
                    continue;
                }
                if ((byte)n >= 0 && (char)n <= '\u001f') {
                    throw new ProtocolException("Malformed HTTP header field. (" + stringBuffer.toString() + ")");
                }
                if ((byte)n == 40 || (byte)n == 41 || (byte)n == 60 || (byte)n == 61 || (byte)n == 62 || (byte)n == 64 || (byte)n == 44 || (byte)n == 63 || (byte)n == 59 || (byte)n == 47 || (byte)n == 92 || (byte)n == 91 || (byte)n == 93 || (byte)n == 123 || (byte)n == 125 || (byte)n == 34 || (byte)n == 32 || (byte)n == 9) {
                    throw new ProtocolException("Malformed HTTP header field. (" + stringBuffer.toString() + ")");
                }
            } else {
                if ((byte)n == 32 || (byte)n == 9) {
                    stringBuffer.append(' ');
                    ++n2;
                    continue;
                }
                if ((byte)n == 13) {
                    n4 = 1;
                }
                if ((byte)n == 10 && n4 == 1) {
                    n2 = 0;
                    ++n3;
                    n4 = 2;
                }
                if (n3 > 1) {
                    string2 = stringBuffer.toString();
                    string2 = string2.trim();
                    string = string.toLowerCase();
                    hashMap.put(string, string2);
                    n2 = 0;
                    n3 = 0;
                    n4 = 0;
                    string = null;
                    string2 = null;
                    return;
                }
                if (n4 > 0) {
                    if (n4 != 2) continue;
                    n4 = 0;
                    continue;
                }
                if (n2 == 0) {
                    string2 = stringBuffer.toString();
                    string2 = string2.trim();
                    string = string.toLowerCase();
                    hashMap.put(string, string2);
                    stringBuffer = new StringBuffer();
                    string = null;
                    string2 = null;
                }
            }
            stringBuffer.append((char)n);
            ++n2;
            n3 = 0;
            n4 = 0;
        }
        throw new IOException("Unexpected end of stream. (" + stringBuffer.toString() + ")");
    }

    public static HTTPChunkHeader readChunkHeader(InputStream inputStream) throws IOException, ProtocolException {
        int n;
        int n2 = 0;
        HashMap hashMap = null;
        HashMap hashMap2 = null;
        int n3 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = inputStream.read()) != -1) {
            if ((byte)n >= 48 && (byte)n <= 57 || (byte)n >= 65 && (byte)n <= 70 || (byte)n >= 97 && (byte)n <= 102) {
                stringBuffer.append((char)n);
                continue;
            }
            if ((byte)n == 59) {
                try {
                    int n4 = Integer.parseInt(stringBuffer.toString(), 16);
                    n3 = 3;
                    n2 = n4;
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IOException("Malformed HTTP chunk header. (" + stringBuffer.toString() + ")");
                }
            }
            if ((byte)n == 13) {
                n3 = 1;
                continue;
            }
            if ((byte)n != 10 || n3 != 1) continue;
            try {
                int n5 = Integer.parseInt(stringBuffer.toString(), 16);
                n3 = 2;
                n2 = n5;
                break;
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("Malformed HTTP chunk header. (" + stringBuffer.toString() + ")");
            }
        }
        if (n == -1) {
            throw new IOException("Unexpected end of stream. (" + stringBuffer.toString() + ")");
        }
        hashMap = new HashMap();
        if (n3 == 3) {
            HTTPUtil.readChunkExtensions(inputStream, hashMap);
        }
        if (n2 == 0) {
            hashMap2 = new HashMap();
            HTTPUtil.readHeaderFields(inputStream, hashMap2);
        }
        if (hashMap.size() == 0) {
            hashMap = null;
        }
        if (hashMap2 != null && hashMap2.size() == 0) {
            hashMap2 = null;
        }
        return new HTTPChunkHeader(n2, hashMap, hashMap2);
    }

    public static void readChunkExtensions(InputStream inputStream, HashMap hashMap) throws IOException, ProtocolException {
        int n;
        String string = null;
        String string2 = null;
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = inputStream.read()) != -1) {
            if (string == null) {
                if ((byte)n == 61) {
                    string = stringBuffer.toString().toLowerCase();
                    stringBuffer = new StringBuffer();
                    continue;
                }
                if ((byte)n >= 0 && (byte)n <= 31) {
                    throw new ProtocolException("Malformed HTTP chunk header. (" + stringBuffer.toString() + ")");
                }
                if ((byte)n == 40 || (byte)n == 41 || (byte)n == 60 || (byte)n == 61 || (byte)n == 62 || (byte)n == 64 || (byte)n == 44 || (byte)n == 63 || (byte)n == 59 || (byte)n == 47 || (byte)n == 92 || (byte)n == 91 || (byte)n == 93 || (byte)n == 123 || (byte)n == 125 || (byte)n == 34 || (byte)n == 32 || (byte)n == 9) {
                    throw new ProtocolException("Malformed HTTP chunk header. (" + stringBuffer.toString() + ")");
                }
            } else {
                if ((byte)n == 13) {
                    bl = true;
                    continue;
                }
                if ((byte)n == 10 && bl) {
                    bl = false;
                    string2 = stringBuffer.toString();
                    string = string.trim();
                    string = string.toLowerCase();
                    hashMap.put(string, string2);
                    return;
                }
                if ((byte)n == 59) {
                    string2 = stringBuffer.toString();
                    string = string.trim();
                    string = string.toLowerCase();
                    hashMap.put(string, string2);
                    stringBuffer = new StringBuffer();
                    string = null;
                    continue;
                }
            }
            stringBuffer.append((char)n);
        }
        throw new IOException("Unexpected end of stream. (" + stringBuffer.toString() + ")");
    }

    public static byte[] camelCase(String string) {
        byte[] byArray = string.getBytes();
        boolean bl = true;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] >= 97 && byArray[i] <= 122 && bl) {
                byArray[i] = (byte)(byArray[i] - 32);
                bl = false;
            }
            if (byArray[i] == 32 && !bl) {
                bl = true;
            }
            if (byArray[i] != 45 || bl) continue;
            bl = true;
        }
        return byArray;
    }
}

