/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication.protocol.http.header;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.ws4d.java.communication.ResponseHeader;
import org.ws4d.java.communication.protocol.http.HTTPStatus;
import org.ws4d.java.communication.protocol.http.HTTPUtil;
import org.ws4d.java.communication.protocol.http.header.HTTPHeader;
import org.ws4d.java.structures.HashMap;
import org.ws4d.java.structures.Iterator;

public class HTTPResponseHeader
extends HTTPHeader
implements HTTPStatus,
ResponseHeader {
    private String version = null;
    private int status = 0;
    private String reason = null;

    public HTTPResponseHeader(String string, int n, String string2) {
        this.version = string;
        this.status = n;
        this.reason = string2;
    }

    public HTTPResponseHeader(String string, int n, String string2, HashMap hashMap) {
        this.version = string;
        this.status = n;
        this.reason = string2;
        this.headerfields = hashMap;
    }

    public String getVersion() {
        return this.version;
    }

    public int getStatus() {
        return this.status;
    }

    public String getReason() {
        return this.reason;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("HTTP response [ ");
        stringBuffer.append("status=");
        stringBuffer.append(this.status);
        stringBuffer.append(", ");
        stringBuffer.append("reason=");
        stringBuffer.append(this.reason);
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }

    public void toStream(OutputStream outputStream) throws IOException {
        outputStream.write("HTTP/1.1".getBytes());
        outputStream.write(32);
        outputStream.write(String.valueOf(this.status).getBytes());
        outputStream.write(32);
        outputStream.write(this.reason.getBytes());
        outputStream.write(13);
        outputStream.write(10);
        if (this.headerfields != null && this.headerfields.size() > 0) {
            Iterator iterator = this.headerfields.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = (String)this.headerfields.get(string);
                outputStream.write(HTTPUtil.camelCase(string));
                outputStream.write(58);
                outputStream.write(32);
                outputStream.write(string2.getBytes());
                outputStream.write(13);
                outputStream.write(10);
            }
        }
        outputStream.write(13);
        outputStream.write(10);
    }

    public byte[] getBytes() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.toStream(byteArrayOutputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }
}

