/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication.protocol.http.server.responses;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.ws4d.java.communication.ProtocolData;
import org.ws4d.java.communication.Resource;
import org.ws4d.java.communication.monitor.MonitoringContext;
import org.ws4d.java.communication.protocol.http.HTTPResponse;
import org.ws4d.java.communication.protocol.http.HTTPResponseUtil;
import org.ws4d.java.communication.protocol.http.header.HTTPRequestHeader;
import org.ws4d.java.communication.protocol.http.header.HTTPResponseHeader;
import org.ws4d.java.structures.HashMap;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.structures.Set;
import org.ws4d.java.types.URI;

public class DefaultResourceResponse
extends HTTPResponse {
    private final Resource resource;
    private final InputStream requestBody;
    private HTTPResponseHeader responseHeader = null;

    public DefaultResourceResponse(Resource resource, InputStream inputStream) {
        this.resource = resource;
        this.requestBody = inputStream;
        long l = resource.size();
        this.responseHeader = HTTPResponseUtil.getResponseHeader(200);
        this.responseHeader.addHeaderFieldValue("Content-Type", resource.getContentType().getMediaType());
        HashMap hashMap = resource.getHeaderFields();
        if (hashMap != null) {
            Set set = hashMap.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = (String)hashMap.get(string);
                this.responseHeader.addHeaderFieldValue(string, string2);
            }
        }
        if (l == -1L) {
            this.responseHeader.addHeaderFieldValue("Transfer-Encoding", "chunked");
        } else {
            this.responseHeader.addHeaderFieldValue("Content-Length", Long.toString(l));
        }
    }

    public HTTPResponseHeader getResponseHeader() {
        return this.responseHeader;
    }

    public void serializeResponseBody(URI uRI, HTTPRequestHeader hTTPRequestHeader, OutputStream outputStream, ProtocolData protocolData, MonitoringContext monitoringContext) throws IOException {
        this.resource.serialize(uRI, hTTPRequestHeader, this.requestBody, outputStream);
        outputStream.flush();
    }
}

