/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication.protocol.mime;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.ws4d.java.DPWSFramework;
import org.ws4d.java.communication.ContextID;
import org.ws4d.java.communication.ProtocolData;
import org.ws4d.java.communication.monitor.MonitoringContext;
import org.ws4d.java.communication.protocol.http.HTTPRequest;
import org.ws4d.java.communication.protocol.http.HTTPResponse;
import org.ws4d.java.communication.protocol.http.HTTPResponseHandler;
import org.ws4d.java.communication.protocol.http.HTTPResponseUtil;
import org.ws4d.java.communication.protocol.http.header.HTTPRequestHeader;
import org.ws4d.java.communication.protocol.http.header.HTTPResponseHeader;
import org.ws4d.java.communication.protocol.http.server.HTTPRequestHandler;
import org.ws4d.java.communication.protocol.mime.MIMEBodyHeader;
import org.ws4d.java.communication.protocol.mime.MIMEEntityInput;
import org.ws4d.java.communication.protocol.mime.MIMEEntityOutput;
import org.ws4d.java.communication.protocol.mime.MIMEHandler;
import org.ws4d.java.communication.protocol.mime.MIMEReader;
import org.ws4d.java.structures.HashMap;
import org.ws4d.java.structures.Queue;
import org.ws4d.java.types.InternetMediaType;
import org.ws4d.java.types.URI;
import org.ws4d.java.util.IDGenerator;
import org.ws4d.java.util.Log;
import org.ws4d.java.util.MIMEUtil;
import org.ws4d.java.util.Sync;

public class DefaultMIMEHandler
implements HTTPRequestHandler,
HTTPResponseHandler {
    private InternetMediaType mimeType = null;
    private volatile long mimeMessageNumber = 0L;
    private HashMap handlers = new HashMap();

    public static String createMimeBoundary() {
        return "boundary." + IDGenerator.getUUID();
    }

    private InternetMediaType getMimeType() {
        if (this.mimeType == null) {
            this.mimeType = InternetMediaType.cloneAndSetParameter(InternetMediaType.getMultipartRelated(), "boundary", DefaultMIMEHandler.createMimeBoundary());
        }
        return this.mimeType;
    }

    public void register(MIMEHandler mIMEHandler) {
        this.register(null, -1, mIMEHandler);
    }

    public void register(InternetMediaType internetMediaType, MIMEHandler mIMEHandler) {
        this.register(internetMediaType, -1, mIMEHandler);
    }

    public void register(int n, MIMEHandler mIMEHandler) {
        this.register(null, n, mIMEHandler);
    }

    public void register(int n, int n2, MIMEHandler mIMEHandler) {
        this.register(null, n, n2, mIMEHandler);
    }

    public void register(InternetMediaType internetMediaType, int n, MIMEHandler mIMEHandler) {
        this.register(internetMediaType, 1, n, mIMEHandler);
    }

    public void register(InternetMediaType internetMediaType, int n, int n2, MIMEHandler mIMEHandler) {
        if (n2 != -1) {
            for (int i = n; i <= n2; ++i) {
                MappingEntry mappingEntry = new MappingEntry(internetMediaType, i, i);
                this.handlers.put(mappingEntry, mIMEHandler);
            }
        } else {
            MappingEntry mappingEntry = new MappingEntry(internetMediaType, n, n2);
            this.handlers.put(mappingEntry, mIMEHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTTPResponse handle(URI uRI, HTTPRequestHeader hTTPRequestHeader, InputStream inputStream, ProtocolData protocolData, MonitoringContext monitoringContext) throws IOException {
        Object object;
        Queue queue = new Queue();
        String string = hTTPRequestHeader.getHeaderFieldValue("Content-Type");
        InternetMediaType internetMediaType = new InternetMediaType(string);
        String string2 = internetMediaType.getParameter("boundary");
        if (string2 == null) {
            return new MIMEoverHTTPResponse(hTTPRequestHeader, queue);
        }
        ContextID contextID = new ContextID(protocolData.getInstanceId(), this.mimeMessageNumber++);
        protocolData.setCurrentMIMEContext(contextID);
        Sync sync = new Sync();
        Sync sync2 = new Sync();
        MIMEReader mIMEReader = new MIMEReader(inputStream, string2.getBytes(), sync);
        InternalHandler internalHandler = new InternalHandler(mIMEReader, sync, sync2, queue, protocolData, monitoringContext);
        DPWSFramework.getThreadPool().execute(internalHandler);
        Object object2 = sync2;
        synchronized (object2) {
            while (!sync2.isNotified()) {
                try {
                    sync2.wait();
                    object = internalHandler.getIOException();
                    if (object == null) continue;
                    throw object;
                }
                catch (InterruptedException interruptedException) {
                    Log.printStackTrace(interruptedException);
                }
            }
        }
        if (queue.size() > 0 && (object = (object2 = (MIMEEntityOutput)queue.checkFirst()).getHTTPResponse()) != null) {
            ((HTTPResponse)object).setMIMEReaderToWaitFor(mIMEReader);
            return object;
        }
        return new MIMEoverHTTPResponse(hTTPRequestHeader, queue, mIMEReader);
    }

    public void handle(HTTPResponseHeader hTTPResponseHeader, InputStream inputStream, HTTPRequest hTTPRequest, ProtocolData protocolData, MonitoringContext monitoringContext) throws IOException {
        String string = hTTPResponseHeader.getHeaderFieldValue("Content-Type");
        InternetMediaType internetMediaType = new InternetMediaType(string);
        String string2 = internetMediaType.getParameter("boundary");
        if (string2 != null) {
            ContextID contextID = new ContextID(protocolData.getInstanceId(), this.mimeMessageNumber++);
            protocolData.setCurrentMIMEContext(contextID);
            Sync sync = new Sync();
            MIMEReader mIMEReader = new MIMEReader(inputStream, string2.getBytes(), sync);
            this.handleInternal(mIMEReader, sync, null, null, protocolData, monitoringContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleInternal(MIMEReader mIMEReader, Sync sync, Sync sync2, Queue queue, ProtocolData protocolData, MonitoringContext monitoringContext) throws IOException {
        while (mIMEReader.nextPart()) {
            Object object;
            MIMEHandler mIMEHandler = this.getHandler(mIMEReader);
            IncomingMIMEEntitiy incomingMIMEEntitiy = new IncomingMIMEEntitiy(mIMEReader);
            if (Log.isDebug()) {
                object = incomingMIMEEntitiy.getEntityHeader();
                Log.debug("Reading incoming MIME with " + object);
            }
            object = new StreamConsumerThread(incomingMIMEEntitiy, mIMEHandler, sync2, queue, protocolData, monitoringContext);
            if (mIMEReader.getPartNumber() == 1) {
                sync2 = null;
            }
            sync.reset();
            Sync sync3 = sync;
            synchronized (sync3) {
                while (!sync.isNotified()) {
                    try {
                        DPWSFramework.getThreadPool().execute((Runnable)object);
                        sync.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                Exception exception = sync.getException();
                if (exception != null) {
                    if (exception instanceof IOException) {
                        throw (IOException)exception;
                    }
                    Log.error("A problem occured during MIME read. " + exception.getMessage());
                }
            }
        }
    }

    private MIMEHandler getHandler(MIMEReader mIMEReader) {
        int n;
        MappingEntry mappingEntry;
        MIMEHandler mIMEHandler;
        int n2 = mIMEReader.getPartNumber();
        MIMEBodyHeader mIMEBodyHeader = mIMEReader.getMIMEBodyHeader();
        String string = mIMEBodyHeader.getHeaderFieldValue("Content-Type");
        InternetMediaType internetMediaType = null;
        if (string != null) {
            internetMediaType = new InternetMediaType(string);
        }
        if ((mIMEHandler = (MIMEHandler)this.handlers.get(mappingEntry = new MappingEntry(internetMediaType, n2, n2))) != null) {
            return mIMEHandler;
        }
        mappingEntry = new MappingEntry(null, n2, n2);
        mIMEHandler = (MIMEHandler)this.handlers.get(mappingEntry);
        if (mIMEHandler != null) {
            return mIMEHandler;
        }
        for (n = n2; n >= 1; --n) {
            mappingEntry = new MappingEntry(internetMediaType, n, -1);
            mIMEHandler = (MIMEHandler)this.handlers.get(mappingEntry);
            if (mIMEHandler == null) continue;
            return mIMEHandler;
        }
        for (n = n2; n >= 1; --n) {
            mappingEntry = new MappingEntry(null, n, -1);
            mIMEHandler = (MIMEHandler)this.handlers.get(mappingEntry);
            if (mIMEHandler == null) continue;
            return mIMEHandler;
        }
        return null;
    }

    private class MIMEoverHTTPResponse
    extends HTTPResponse {
        private HTTPResponseHeader responseHeader = null;
        private Queue responses = null;

        MIMEoverHTTPResponse(HTTPRequestHeader hTTPRequestHeader, Queue queue, MIMEReader mIMEReader) {
            this(hTTPRequestHeader, queue);
            this.setMIMEReaderToWaitFor(mIMEReader);
        }

        MIMEoverHTTPResponse(HTTPRequestHeader hTTPRequestHeader, Queue queue) {
            this.responses = queue;
            if (queue.size() == 0) {
                this.responseHeader = HTTPResponseUtil.getResponseHeader(202);
                this.responseHeader.addHeaderFieldValue("Content-Length", "0");
                this.responseHeader.addHeaderFieldValue("JMEDS-Debug", hTTPRequestHeader.getRequest());
            } else if (queue.size() == 1) {
                MIMEEntityOutput mIMEEntityOutput = (MIMEEntityOutput)queue.checkFirst();
                this.responseHeader = HTTPResponseUtil.getResponseHeader(200);
                MIMEBodyHeader mIMEBodyHeader = mIMEEntityOutput.getEntityHeader();
                String string = mIMEBodyHeader.getHeaderFieldValue("Content-Type");
                this.responseHeader.addHeaderFieldValue("Content-Transfer-Encoding", "chunked");
                this.responseHeader.addHeaderFieldValue("Content-Type", string);
                this.responseHeader.addHeaderFieldValue("JMEDS-Debug", hTTPRequestHeader.getRequest());
            } else {
                this.responseHeader = HTTPResponseUtil.getResponseHeader(200);
                this.responseHeader.addHeaderFieldValue("Content-Transfer-Encoding", "chunked");
                this.responseHeader.addHeaderFieldValue("Content-Type", DefaultMIMEHandler.this.getMimeType().toString());
                this.responseHeader.addHeaderFieldValue("JMEDS-Debug", hTTPRequestHeader.getRequest());
            }
        }

        public HTTPResponseHeader getResponseHeader() {
            return this.responseHeader;
        }

        public void serializeResponseBody(URI uRI, HTTPRequestHeader hTTPRequestHeader, OutputStream outputStream, ProtocolData protocolData, MonitoringContext monitoringContext) throws IOException {
            if (this.responses.size() == 0) {
                return;
            }
            if (this.responses.size() == 1) {
                MIMEEntityOutput mIMEEntityOutput = (MIMEEntityOutput)this.responses.get();
                mIMEEntityOutput.serialize(outputStream);
                outputStream.flush();
            } else {
                String string = DefaultMIMEHandler.this.getMimeType().getParameter("boundary");
                while (!this.responses.isEmpty()) {
                    MIMEEntityOutput mIMEEntityOutput = (MIMEEntityOutput)this.responses.get();
                    MIMEBodyHeader mIMEBodyHeader = mIMEEntityOutput.getEntityHeader();
                    MIMEUtil.writeBoundary(outputStream, string.getBytes(), false, false);
                    mIMEBodyHeader.toStream(outputStream);
                    mIMEEntityOutput.serialize(outputStream);
                }
                MIMEUtil.writeBoundary(outputStream, string.getBytes(), false, true);
            }
        }
    }

    private class IncomingMIMEEntitiy
    implements MIMEEntityInput {
        private MIMEReader reader = null;

        IncomingMIMEEntitiy(MIMEReader mIMEReader) {
            this.reader = mIMEReader;
        }

        public InputStream getBodyInputStream() {
            return this.reader.getInputStream();
        }

        public MIMEBodyHeader getEntityHeader() {
            return this.reader.getMIMEBodyHeader();
        }
    }

    private class StreamConsumerThread
    implements Runnable {
        private MIMEHandler handler;
        private MIMEEntityInput input;
        private Queue responseContainer;
        private final MonitoringContext context;
        private final ProtocolData protocolData;
        private Sync responseLock;

        StreamConsumerThread(MIMEEntityInput mIMEEntityInput, MIMEHandler mIMEHandler, Sync sync, Queue queue, ProtocolData protocolData, MonitoringContext monitoringContext) {
            this.handler = mIMEHandler;
            this.input = mIMEEntityInput;
            this.responseContainer = queue;
            this.protocolData = protocolData;
            this.context = monitoringContext;
            this.responseLock = sync;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block14: {
                if (this.handler != null) {
                    try {
                        if (this.responseContainer == null) {
                            this.handler.handleResponse(this.input, this.protocolData, this.context);
                            break block14;
                        }
                        this.handler.handleRequest(this.input, this.responseContainer, this.protocolData, this.context);
                        if (this.responseLock == null) break block14;
                        Sync sync = this.responseLock;
                        synchronized (sync) {
                            this.responseLock.notifyNow();
                        }
                    }
                    catch (IOException iOException) {
                        int n = 0;
                        try {
                            InputStream inputStream = this.input.getBodyInputStream();
                            while (inputStream.read() != -1) {
                                ++n;
                            }
                            Log.warn("MIME part could not be handled by " + this.handler.getClass().getName() + ". " + n + " bytes omitted.");
                        }
                        catch (IOException iOException2) {
                            Log.error("Could not consume omitted bytes from MIME part.");
                        }
                    }
                } else {
                    int n = 0;
                    try {
                        InputStream inputStream = this.input.getBodyInputStream();
                        while (inputStream.read() != -1) {
                            ++n;
                        }
                        Log.warn("No handler found for this MIME part. " + n + " bytes omitted.");
                    }
                    catch (IOException iOException) {
                        Log.error("Could not consume omitted bytes from MIME part.");
                    }
                }
            }
        }
    }

    private class InternalHandler
    implements Runnable {
        private MIMEReader reader;
        private Sync incomingMIMEPartLock;
        private Sync responseLock;
        private Queue responses;
        private ProtocolData protocolData;
        private MonitoringContext context;
        private IOException exception;

        InternalHandler(MIMEReader mIMEReader, Sync sync, Sync sync2, Queue queue, ProtocolData protocolData, MonitoringContext monitoringContext) {
            this.reader = mIMEReader;
            this.incomingMIMEPartLock = sync;
            this.responseLock = sync2;
            this.responses = queue;
            this.protocolData = protocolData;
            this.context = monitoringContext;
        }

        public void run() {
            try {
                DefaultMIMEHandler.this.handleInternal(this.reader, this.incomingMIMEPartLock, this.responseLock, this.responses, this.protocolData, this.context);
            }
            catch (IOException iOException) {
                this.exception = iOException;
            }
        }

        public IOException getIOException() {
            return this.exception;
        }
    }

    private class MappingEntry {
        private InternetMediaType type = null;
        private int partMin = 1;
        private int partMax = -1;

        MappingEntry(InternetMediaType internetMediaType, int n, int n2) {
            this.type = internetMediaType;
            this.partMin = n;
            this.partMax = n2;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.getOuterType().hashCode();
            n = 31 * n + this.partMax;
            n = 31 * n + this.partMin;
            n = 31 * n + (this.type == null ? 0 : this.type.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            MappingEntry mappingEntry = (MappingEntry)object;
            if (!this.getOuterType().equals(mappingEntry.getOuterType())) {
                return false;
            }
            if (this.partMax != mappingEntry.partMax) {
                return false;
            }
            if (this.partMin != mappingEntry.partMin) {
                return false;
            }
            return !(this.type == null ? mappingEntry.type != null : !this.type.equals(mappingEntry.type));
        }

        private DefaultMIMEHandler getOuterType() {
            return DefaultMIMEHandler.this;
        }
    }
}

