/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication.protocol.mime;

import java.io.IOException;
import java.io.InputStream;
import org.ws4d.java.communication.ProtocolException;
import org.ws4d.java.communication.protocol.http.HTTPUtil;
import org.ws4d.java.communication.protocol.mime.MIMEBodyHeader;
import org.ws4d.java.structures.HashMap;
import org.ws4d.java.util.Log;
import org.ws4d.java.util.MIMEUtil;
import org.ws4d.java.util.Search;
import org.ws4d.java.util.Sync;

public class MIMEReader {
    private byte[] boundaryBytes = null;
    private int[] boundaryFaultFunction = null;
    private int part = 0;
    protected static final String FAULT_UNEXPECTED_END = "Unexpected end of stream.";
    protected static final String FAULT_MALFORMED_HEADERFIELD = "Malformed MIME header field.";
    protected static final String FAULT_NOT_FINISHED = "Previous part not finished.";
    protected InputStream in = null;
    protected MIMEInputStream mimeIn = null;
    private MIMEBodyHeader header = null;
    private Sync incomingMIMEPartLock = null;
    private volatile boolean finished = false;

    public MIMEReader(InputStream inputStream, byte[] byArray) throws IOException {
        this(inputStream, byArray, null);
    }

    public MIMEReader(InputStream inputStream, byte[] byArray, Sync sync) throws IOException {
        MIMEUtil.readBoundary(inputStream, byArray);
        this.in = inputStream;
        this.boundaryBytes = new byte[byArray.length + 2];
        System.arraycopy(byArray, 0, this.boundaryBytes, 2, byArray.length);
        this.boundaryBytes[0] = 45;
        this.boundaryBytes[1] = 45;
        this.boundaryFaultFunction = Search.createFaultFunction(this.boundaryBytes);
        try {
            this.readMIMEPartHeader();
        }
        catch (ProtocolException protocolException) {
            Log.error("Cannot read first MIME header. " + protocolException.getMessage());
        }
        this.incomingMIMEPartLock = sync;
        this.part = 1;
    }

    public synchronized boolean nextPart() throws IOException {
        try {
            if (this.mimeIn == null && this.part > 1) {
                this.finished = true;
                this.notifyAll();
                return false;
            }
            if (this.mimeIn == null) {
                this.mimeIn = new MIMEInputStream();
                return true;
            }
            if (this.mimeIn.isInUse() && !this.mimeIn.isClosed()) {
                throw new IOException(FAULT_NOT_FINISHED);
            }
            int n = this.in.read();
            if (n == 13) {
                n = this.in.read();
                if (n == 10) {
                    try {
                        this.readMIMEPartHeader();
                    }
                    catch (ProtocolException protocolException) {
                        Log.error("Cannot read MIME header. " + protocolException.getMessage());
                        this.finished = true;
                        this.notifyAll();
                        return false;
                    }
                    this.mimeIn = new MIMEInputStream();
                    ++this.part;
                    return true;
                }
            } else if (n == 45 && (n = this.in.read()) == 45) {
                HTTPUtil.readRequestLine(this.in);
                this.finished = true;
                this.notifyAll();
                return false;
            }
            this.finished = true;
            this.notifyAll();
            return false;
        }
        catch (IOException iOException) {
            if (!FAULT_NOT_FINISHED.equals(iOException.getMessage())) {
                this.finished = true;
                this.notifyAll();
            }
            throw iOException;
        }
    }

    public int getPartNumber() {
        return this.part;
    }

    public MIMEBodyHeader getMIMEBodyHeader() {
        return this.header;
    }

    public InputStream getInputStream() {
        if (this.mimeIn == null) {
            this.mimeIn = new MIMEInputStream();
        }
        return this.mimeIn;
    }

    public synchronized void waitFor() {
        while (!this.finished) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private synchronized void readMIMEPartHeader() throws IOException, ProtocolException {
        HashMap hashMap = new HashMap();
        MIMEUtil.readHeaderFields(this.in, hashMap);
        this.header = new MIMEBodyHeader(hashMap);
    }

    private class MIMEInputStream
    extends InputStream {
        private InputStream inKMP = null;
        private boolean closed = false;
        private boolean read = false;

        public MIMEInputStream() {
            this.inKMP = Search.getSearchPatternWrapper(MIMEReader.this.in, MIMEReader.this.boundaryBytes, MIMEReader.this.boundaryFaultFunction);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int available() throws IOException {
            try {
                return this.inKMP.available();
            }
            catch (IOException iOException) {
                if (MIMEReader.this.incomingMIMEPartLock != null) {
                    Sync sync = MIMEReader.this.incomingMIMEPartLock;
                    synchronized (sync) {
                        MIMEReader.this.incomingMIMEPartLock.notifyNow(iOException);
                    }
                }
                throw iOException;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read() throws IOException {
            try {
                if (this.closed) {
                    return -1;
                }
                this.read = true;
                int n = this.inKMP.read();
                if (n == -1) {
                    if (MIMEReader.this.incomingMIMEPartLock != null) {
                        Sync sync = MIMEReader.this.incomingMIMEPartLock;
                        synchronized (sync) {
                            this.closed = true;
                            MIMEReader.this.incomingMIMEPartLock.notifyNow();
                        }
                    } else {
                        this.closed = true;
                    }
                }
                return n;
            }
            catch (IOException iOException) {
                if (MIMEReader.this.incomingMIMEPartLock != null) {
                    Sync sync = MIMEReader.this.incomingMIMEPartLock;
                    synchronized (sync) {
                        MIMEReader.this.incomingMIMEPartLock.notifyNow(iOException);
                    }
                }
                throw iOException;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            try {
                if (MIMEReader.this.incomingMIMEPartLock != null) {
                    Sync sync = MIMEReader.this.incomingMIMEPartLock;
                    synchronized (sync) {
                        MIMEReader.this.incomingMIMEPartLock.notifyNow();
                    }
                }
                this.inKMP.close();
            }
            catch (IOException iOException) {
                if (MIMEReader.this.incomingMIMEPartLock != null) {
                    Sync sync = MIMEReader.this.incomingMIMEPartLock;
                    synchronized (sync) {
                        MIMEReader.this.incomingMIMEPartLock.notifyNow(iOException);
                    }
                }
                throw iOException;
            }
        }

        public boolean isInUse() {
            return this.read;
        }

        public boolean isClosed() {
            return this.closed;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.getOuterType().hashCode();
            n = 31 * n + (this.inKMP == null ? 0 : this.inKMP.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            MIMEInputStream mIMEInputStream = (MIMEInputStream)object;
            if (!this.getOuterType().equals(mIMEInputStream.getOuterType())) {
                return false;
            }
            return !(this.inKMP == null ? mIMEInputStream.inKMP != null : !this.inKMP.equals(mIMEInputStream.inKMP));
        }

        private MIMEReader getOuterType() {
            return MIMEReader.this;
        }
    }
}

