/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication.protocol.soap;

import java.io.IOException;
import java.io.OutputStream;
import org.ws4d.java.DPWSFramework;
import org.ws4d.java.communication.CommunicationManager;
import org.ws4d.java.communication.DPWSProtocolInfo;
import org.ws4d.java.communication.ProtocolData;
import org.ws4d.java.communication.monitor.MonitoringContext;
import org.ws4d.java.communication.protocol.http.HTTPResponse;
import org.ws4d.java.communication.protocol.http.HTTPResponseUtil;
import org.ws4d.java.communication.protocol.http.header.HTTPRequestHeader;
import org.ws4d.java.communication.protocol.http.header.HTTPResponseHeader;
import org.ws4d.java.communication.protocol.mime.DefaultMIMEHandler;
import org.ws4d.java.dispatch.MessageInformer;
import org.ws4d.java.message.FaultMessage;
import org.ws4d.java.message.InvokeMessage;
import org.ws4d.java.message.Message;
import org.ws4d.java.service.parameter.ParameterValue;
import org.ws4d.java.structures.List;
import org.ws4d.java.types.InternetMediaType;
import org.ws4d.java.types.URI;
import org.ws4d.java.util.ParameterUtil;

public class SOAPResponse
extends HTTPResponse {
    private static final MessageInformer MESSAGE_INFORMER = MessageInformer.getInstance();
    private final Message response;
    private final HTTPResponseHeader header;
    private String mimeBoundary = null;
    private List attachments = null;

    public SOAPResponse(int n, Message message) {
        Object object;
        Object object2;
        this.response = message;
        this.header = HTTPResponseUtil.getResponseHeader(n);
        int n2 = -1;
        if (message != null && (object2 = message.getProtocolInfo()) instanceof DPWSProtocolInfo) {
            object = (DPWSProtocolInfo)object2;
            n2 = ((DPWSProtocolInfo)object).getHttpResponseChunkedMode();
        }
        if (n2 == 1) {
            this.header.addHeaderFieldValue("Transfer-Encoding", "chunked");
        } else if (n2 == 2 && message.getType() == 400) {
            this.header.addHeaderFieldValue("Transfer-Encoding", "chunked");
        }
        object2 = InternetMediaType.getSOAPXML().getMediaType();
        if (message instanceof InvokeMessage) {
            object = (InvokeMessage)message;
            object2 = this.inspectAttachments((String)object2, ((InvokeMessage)object).getContent());
        } else if (message instanceof FaultMessage) {
            object = (FaultMessage)message;
            object2 = this.inspectAttachments((String)object2, ((FaultMessage)object).getDetail());
        }
        this.header.addHeaderFieldValue("Content-Type", (String)object2);
    }

    public HTTPResponseHeader getResponseHeader() {
        return this.header;
    }

    public void serializeResponseBody(URI uRI, HTTPRequestHeader hTTPRequestHeader, OutputStream outputStream, ProtocolData protocolData, MonitoringContext monitoringContext) throws IOException {
        if (this.response == null) {
            return;
        }
        CommunicationManager communicationManager = DPWSFramework.getCommunicationManager(protocolData.getCommunicationManagerId());
        communicationManager.serializeMessageWithAttachments(this.response, this.mimeBoundary, this.attachments, outputStream, protocolData);
        MESSAGE_INFORMER.forwardMessage(this.response, protocolData);
        if (monitoringContext != null) {
            monitoringContext.setMessage(this.response);
        }
    }

    private String inspectAttachments(String string, ParameterValue parameterValue) {
        if (parameterValue != null && ParameterUtil.hasAttachment(parameterValue)) {
            this.mimeBoundary = DefaultMIMEHandler.createMimeBoundary();
            InternetMediaType internetMediaType = InternetMediaType.cloneAndSetParameter(InternetMediaType.getMultipartRelated(), "boundary", this.mimeBoundary);
            string = internetMediaType.toString();
            this.attachments = ParameterUtil.getAttachments(parameterValue);
        }
        return string;
    }
}

