/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication.protocol.soap;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.ws4d.java.DPWSFramework;
import org.ws4d.java.communication.ProtocolData;
import org.ws4d.java.communication.connection.ip.IPAddress;
import org.ws4d.java.communication.connection.udp.Datagram;
import org.ws4d.java.communication.connection.udp.DatagramInputStream;
import org.ws4d.java.communication.connection.udp.UDPClient;
import org.ws4d.java.communication.connection.udp.UDPDatagramHandler;
import org.ws4d.java.communication.monitor.MonitorStreamFactory;
import org.ws4d.java.communication.monitor.MonitoredInputStream;
import org.ws4d.java.communication.monitor.MonitoredMessageReceiver;
import org.ws4d.java.communication.monitor.MonitoredOutputStream;
import org.ws4d.java.communication.monitor.MonitoringContext;
import org.ws4d.java.communication.protocol.soap.generator.DefaultMessageDiscarder;
import org.ws4d.java.communication.protocol.soap.generator.MessageReceiver;
import org.ws4d.java.communication.protocol.soap.generator.SOAPMessageGeneratorFactory;
import org.ws4d.java.message.Message;
import org.ws4d.java.message.SOAPHeader;
import org.ws4d.java.structures.HashMap;
import org.ws4d.java.structures.MessageIdBuffer;
import org.ws4d.java.types.ByteArrayBuffer;
import org.ws4d.java.util.Math;

public class SOAPoverUDPClient {
    public static final int MULTICAST_UNICAST_UDP_REPEAT = 1;
    public static final int UDP_MIN_DELAY = 50;
    public static final int UDP_MAX_DELAY = 250;
    public static final int UDP_UPPER_DELAY = 450;
    private UDPClient client = null;
    private static HashMap clients = new HashMap();

    public static synchronized SOAPoverUDPClient get(IPAddress iPAddress, int n, String string) {
        if (n == 0) {
            return new SOAPoverUDPClient(UDPClient.get(iPAddress, n, string));
        }
        String string2 = iPAddress.getAddress() + "@" + n + "%" + string;
        SOAPoverUDPClient sOAPoverUDPClient = (SOAPoverUDPClient)clients.get(string2);
        if (sOAPoverUDPClient != null) {
            return sOAPoverUDPClient;
        }
        sOAPoverUDPClient = new SOAPoverUDPClient(UDPClient.get(iPAddress, n, string));
        clients.put(string2, sOAPoverUDPClient);
        return sOAPoverUDPClient;
    }

    private SOAPoverUDPClient(UDPClient uDPClient) {
        this.client = uDPClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(IPAddress iPAddress, int n, Message message, SOAPoverUDPHandler sOAPoverUDPHandler, ProtocolData protocolData) throws IOException {
        int n2;
        if (this.client.isClosed()) {
            return;
        }
        ByteArrayBuffer byteArrayBuffer = SOAPMessageGeneratorFactory.getInstance().getMessage2SOAPGeneratorForCurrentThread().generateSOAPMessage(message, protocolData);
        boolean bl = this.client.getPort() == 0;
        this.sendInternal(iPAddress, n, message, sOAPoverUDPHandler, protocolData, byteArrayBuffer);
        if (bl) {
            String string = this.client.getIPAddress().getAddress() + "@" + this.client.getPort() + "%" + this.client.getIfaceName();
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                clients.put(string, this);
            }
        }
        if ((n2 = 1) <= 0) {
            return;
        }
        int n3 = Math.nextInt(50, 250);
        while (true) {
            try {
                Thread.sleep(n3);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.sendInternal(iPAddress, n, message, sOAPoverUDPHandler, protocolData, byteArrayBuffer);
            if (--n2 == 0) break;
            if ((n3 *= 2) <= 450) continue;
            n3 = 450;
        }
    }

    private void sendInternal(IPAddress iPAddress, int n, Message message, SOAPoverUDPHandler sOAPoverUDPHandler, ProtocolData protocolData, ByteArrayBuffer byteArrayBuffer) throws IOException {
        MonitorStreamFactory monitorStreamFactory = DPWSFramework.getMonitorStreamFactory();
        MonitoringContext monitoringContext = null;
        try {
            if (monitorStreamFactory != null) {
                OutputStream outputStream = new ByteArrayOutputStream(byteArrayBuffer.getContentLength());
                outputStream = new MonitoredOutputStream(outputStream, protocolData);
                monitoringContext = monitorStreamFactory.getNewMonitoringContextOut(protocolData);
                outputStream.write(byteArrayBuffer.getBuffer(), 0, byteArrayBuffer.getContentLength());
                outputStream.flush();
                outputStream.close();
            }
            this.client.send(iPAddress, n, byteArrayBuffer.getBuffer(), byteArrayBuffer.getContentLength(), sOAPoverUDPHandler, protocolData);
        }
        catch (IOException iOException) {
            if (monitorStreamFactory != null) {
                monitorStreamFactory.sendFault(protocolData, monitoringContext, iOException);
            }
            throw iOException;
        }
        if (monitorStreamFactory != null) {
            monitorStreamFactory.send(protocolData, monitoringContext, message);
        }
    }

    public synchronized void close() throws IOException {
        this.client.close();
    }

    public synchronized boolean isClosed() {
        return this.client.isClosed();
    }

    public static class DuplicateMessageDiscarder
    extends DefaultMessageDiscarder {
        private final MessageIdBuffer relMessages = new MessageIdBuffer();

        public int discardMessage(SOAPHeader sOAPHeader, ProtocolData protocolData) {
            int n = super.discardMessage(sOAPHeader, protocolData);
            if (n != 0) {
                return n;
            }
            if (this.relMessages.containsOrEnqueue(sOAPHeader.getMessageId())) {
                return 2;
            }
            return 0;
        }
    }

    public static class SOAPoverUDPHandler
    implements UDPDatagramHandler {
        private final MessageReceiver receiver;
        private final DefaultMessageDiscarder discarder;

        public SOAPoverUDPHandler(MessageReceiver messageReceiver) {
            this.receiver = messageReceiver;
            this.discarder = new DuplicateMessageDiscarder();
        }

        public void handle(Datagram datagram, ProtocolData protocolData) throws IOException {
            MessageReceiver messageReceiver;
            InputStream inputStream = null;
            MonitorStreamFactory monitorStreamFactory = DPWSFramework.getMonitorStreamFactory();
            inputStream = monitorStreamFactory != null ? new MonitoredInputStream(new DatagramInputStream(datagram), protocolData) : new DatagramInputStream(datagram);
            if (monitorStreamFactory != null) {
                MonitoringContext monitoringContext = monitorStreamFactory.getNewMonitoringContextIn(protocolData);
                messageReceiver = new MonitoredMessageReceiver(this.receiver, monitoringContext);
            } else {
                messageReceiver = this.receiver;
            }
            SOAPMessageGeneratorFactory.getInstance().getSOAP2MessageGeneratorForCurrentThread().deliverMessage(inputStream, messageReceiver, protocolData, this.discarder);
            inputStream.close();
        }
    }
}

