/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication.protocol.soap.generator;

import java.io.IOException;
import org.ws4d.java.DPWSFramework;
import org.ws4d.java.communication.CommunicationBinding;
import org.ws4d.java.communication.CommunicationManager;
import org.ws4d.java.communication.CommunicationUtil;
import org.ws4d.java.communication.ProtocolData;
import org.ws4d.java.communication.protocol.soap.generator.MessageSerializer;
import org.ws4d.java.configuration.FrameworkProperties;
import org.ws4d.java.constants.ConstantsHelper;
import org.ws4d.java.eventing.EventSink;
import org.ws4d.java.io.xml.ElementHandler;
import org.ws4d.java.io.xml.ElementHandlerRegistry;
import org.ws4d.java.io.xml.XmlSerializer;
import org.ws4d.java.message.FaultMessage;
import org.ws4d.java.message.InvokeMessage;
import org.ws4d.java.message.Message;
import org.ws4d.java.message.SOAPHeader;
import org.ws4d.java.message.discovery.ByeMessage;
import org.ws4d.java.message.discovery.HelloMessage;
import org.ws4d.java.message.discovery.ProbeMatch;
import org.ws4d.java.message.discovery.ProbeMatchesMessage;
import org.ws4d.java.message.discovery.ProbeMessage;
import org.ws4d.java.message.discovery.ResolveMatch;
import org.ws4d.java.message.discovery.ResolveMatchesMessage;
import org.ws4d.java.message.discovery.ResolveMessage;
import org.ws4d.java.message.eventing.GetStatusMessage;
import org.ws4d.java.message.eventing.GetStatusResponseMessage;
import org.ws4d.java.message.eventing.RenewMessage;
import org.ws4d.java.message.eventing.RenewResponseMessage;
import org.ws4d.java.message.eventing.SubscribeMessage;
import org.ws4d.java.message.eventing.SubscribeResponseMessage;
import org.ws4d.java.message.eventing.SubscriptionEndMessage;
import org.ws4d.java.message.eventing.UnsubscribeMessage;
import org.ws4d.java.message.eventing.UnsubscribeResponseMessage;
import org.ws4d.java.message.metadata.GetMessage;
import org.ws4d.java.message.metadata.GetMetadataMessage;
import org.ws4d.java.message.metadata.GetMetadataResponseMessage;
import org.ws4d.java.message.metadata.GetResponseMessage;
import org.ws4d.java.service.parameter.ParameterValue;
import org.ws4d.java.structures.ArrayList;
import org.ws4d.java.structures.DataStructure;
import org.ws4d.java.structures.HashMap;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.structures.List;
import org.ws4d.java.types.AppSequence;
import org.ws4d.java.types.AttributedURI;
import org.ws4d.java.types.CustomizeMData;
import org.ws4d.java.types.CustomizeMDataHandler;
import org.ws4d.java.types.Delivery;
import org.ws4d.java.types.DiscoveryData;
import org.ws4d.java.types.EndpointReference;
import org.ws4d.java.types.EndpointReferenceSet;
import org.ws4d.java.types.EprInfo;
import org.ws4d.java.types.Filter;
import org.ws4d.java.types.HostMData;
import org.ws4d.java.types.HostedMData;
import org.ws4d.java.types.LocalizedString;
import org.ws4d.java.types.MetadataMData;
import org.ws4d.java.types.ProbeScopeSet;
import org.ws4d.java.types.QName;
import org.ws4d.java.types.QNameSet;
import org.ws4d.java.types.ReferenceParametersMData;
import org.ws4d.java.types.RelationshipMData;
import org.ws4d.java.types.ScopeSet;
import org.ws4d.java.types.ThisDeviceMData;
import org.ws4d.java.types.ThisModelMData;
import org.ws4d.java.types.URI;
import org.ws4d.java.types.URISet;
import org.ws4d.java.types.UnknownDataContainer;
import org.ws4d.java.types.XAddressInfoSet;
import org.ws4d.java.util.Log;
import org.ws4d.java.util.SerializeUtil;
import org.xmlpull.v1.IllegalStateException;

class DefaultMessageSerializer
extends MessageSerializer {
    public static final int MAX_QNAME_SERIALIZATION = 10;

    DefaultMessageSerializer() {
    }

    public void serialize(HelloMessage helloMessage, XmlSerializer xmlSerializer, ProtocolData protocolData) throws IOException {
        ConstantsHelper constantsHelper = this.getConstantsHelper(helloMessage, protocolData);
        xmlSerializer.startTag("http://www.w3.org/2003/05/soap-envelope", "Body");
        if (DPWSFramework.hasModule(64)) {
            xmlSerializer.attribute("", "ID", "BID1");
        }
        xmlSerializer.startTag(constantsHelper.getWSDNamespace(), "Hello");
        this.serializeUnknownAttributes(xmlSerializer, helloMessage);
        this.serialize(helloMessage.getDiscoveryData(), xmlSerializer, constantsHelper);
        this.serializeUnknownElements(xmlSerializer, helloMessage);
        xmlSerializer.endTag(constantsHelper.getWSDNamespace(), "Hello");
        xmlSerializer.endTag("http://www.w3.org/2003/05/soap-envelope", "Body");
    }

    public void serialize(ByeMessage byeMessage, XmlSerializer xmlSerializer, ProtocolData protocolData) throws IOException {
        ConstantsHelper constantsHelper = this.getConstantsHelper(byeMessage, protocolData);
        xmlSerializer.startTag("http://www.w3.org/2003/05/soap-envelope", "Body");
        if (DPWSFramework.hasModule(64)) {
            xmlSerializer.attribute("", "ID", "BID1");
        }
        xmlSerializer.startTag(constantsHelper.getWSDNamespace(), "Bye");
        this.serializeUnknownAttributes(xmlSerializer, byeMessage);
        this.serialize(byeMessage.getDiscoveryData(), xmlSerializer, constantsHelper);
        this.serializeUnknownElements(xmlSerializer, byeMessage);
        xmlSerializer.endTag(constantsHelper.getWSDNamespace(), "Bye");
        xmlSerializer.endTag("http://www.w3.org/2003/05/soap-envelope", "Body");
    }

    public void serialize(ProbeMessage probeMessage, XmlSerializer xmlSerializer, ProtocolData protocolData) throws IOException {
        ProbeScopeSet probeScopeSet;
        ConstantsHelper constantsHelper = this.getConstantsHelper(probeMessage, protocolData);
        xmlSerializer.startTag("http://www.w3.org/2003/05/soap-envelope", "Body");
        xmlSerializer.startTag(constantsHelper.getWSDNamespace(), "Probe");
        this.serializeUnknownAttributes(xmlSerializer, probeMessage);
        QNameSet qNameSet = probeMessage.getTypes();
        if (qNameSet != null) {
            this.serialize(qNameSet, xmlSerializer, constantsHelper.getWSDNamespace(), "Types");
        }
        if ((probeScopeSet = probeMessage.getScopes()) != null) {
            this.serialize(probeScopeSet, xmlSerializer, constantsHelper.getWSDNamespace());
        }
        this.serializeUnknownElements(xmlSerializer, probeMessage);
        xmlSerializer.endTag(constantsHelper.getWSDNamespace(), "Probe");
        xmlSerializer.endTag("http://www.w3.org/2003/05/soap-envelope", "Body");
    }

    public void serialize(ProbeMatchesMessage probeMatchesMessage, XmlSerializer xmlSerializer, ProtocolData protocolData) throws IOException {
        ConstantsHelper constantsHelper = this.getConstantsHelper(probeMatchesMessage, protocolData);
        xmlSerializer.startTag("http://www.w3.org/2003/05/soap-envelope", "Body");
        if (DPWSFramework.hasModule(64)) {
            xmlSerializer.attribute("", "ID", "BID1");
        }
        xmlSerializer.startTag(constantsHelper.getWSDNamespace(), "ProbeMatches");
        this.serializeUnknownAttributes(xmlSerializer, probeMatchesMessage);
        DataStructure dataStructure = probeMatchesMessage.getProbeMatches();
        if (dataStructure != null && !probeMatchesMessage.isEmpty()) {
            Iterator iterator = dataStructure.iterator();
            while (iterator.hasNext()) {
                ProbeMatch probeMatch = (ProbeMatch)iterator.next();
                this.serialize(probeMatch, xmlSerializer, constantsHelper);
            }
        }
        this.serializeUnknownElements(xmlSerializer, probeMatchesMessage);
        xmlSerializer.endTag(constantsHelper.getWSDNamespace(), "ProbeMatches");
        xmlSerializer.endTag("http://www.w3.org/2003/05/soap-envelope", "Body");
    }

    public void serialize(InvokeMessage invokeMessage, XmlSerializer xmlSerializer, ProtocolData protocolData) throws IOException {
        xmlSerializer.startTag("http://www.w3.org/2003/05/soap-envelope", "Body");
        ParameterValue parameterValue = invokeMessage.getContent();
        if (parameterValue != null) {
            parameterValue.serialize(xmlSerializer);
        }
        xmlSerializer.endTag("http://www.w3.org/2003/05/soap-envelope", "Body");
    }

    public void serialize(GetStatusMessage getStatusMessage, XmlSerializer xmlSerializer, ProtocolData protocolData) throws IOException {
        xmlSerializer.startTag("http://www.w3.org/2003/05/soap-envelope", "Body");
        xmlSerializer.startTag("http://schemas.xmlsoap.org/ws/2004/08/eventing", "GetStatus");
        xmlSerializer.endTag("http://schemas.xmlsoap.org/ws/2004/08/eventing", "GetStatus");
        xmlSerializer.endTag("http://www.w3.org/2003/05/soap-envelope", "Body");
    }

    public void serialize(GetStatusResponseMessage getStatusResponseMessage, XmlSerializer xmlSerializer, ProtocolData protocolData) throws IOException {
        xmlSerializer.startTag("http://www.w3.org/2003/05/soap-envelope", "Body");
        xmlSerializer.startTag("http://schemas.xmlsoap.org/ws/2004/08/eventing", "GetStatusResponse");
        this.serializeUnknownAttributes(xmlSerializer, getStatusResponseMessage);
        String string = getStatusResponseMessage.getExpires();
        if (string != null && !string.equals("")) {
            SerializeUtil.serializeTag(xmlSerializer, "http://schemas.xmlsoap.org/ws/2004/08/eventing", "Expires", string);
        }
        this.serializeUnknownElements(xmlSerializer, getStatusResponseMessage);
        xmlSerializer.endTag("http://schemas.xmlsoap.org/ws/2004/08/eventing", "GetStatusResponse");
        xmlSerializer.endTag("http://www.w3.org/2003/05/soap-envelope", "Body");
    }

    public void serialize(RenewMessage renewMessage, XmlSerializer xmlSerializer, ProtocolData protocolData) throws IOException {
        xmlSerializer.startTag("http://www.w3.org/2003/05/soap-envelope", "Body");
        xmlSerializer.startTag("http://schemas.xmlsoap.org/ws/2004/08/eventing", "Renew");
        this.serializeUnknownAttributes(xmlSerializer, renewMessage);
        String string = renewMessage.getExpires();
        if (string != null && !string.equals("")) {
            SerializeUtil.serializeTag(xmlSerializer, "http://schemas.xmlsoap.org/ws/2004/08/eventing", "Expires", string);
        }
        this.serializeUnknownElements(xmlSerializer, renewMessage);
        xmlSerializer.endTag("http://schemas.xmlsoap.org/ws/2004/08/eventing", "Renew");
        xmlSerializer.endTag("http://www.w3.org/2003/05/soap-envelope", "Body");
    }

    public void serialize(RenewResponseMessage renewResponseMessage, XmlSerializer xmlSerializer, ProtocolData protocolData) throws IOException {
        xmlSerializer.startTag("http://www.w3.org/2003/05/soap-envelope", "Body");
        xmlSerializer.startTag("http://schemas.xmlsoap.org/ws/2004/08/eventing", "RenewResponse");
        this.serializeUnknownAttributes(xmlSerializer, renewResponseMessage);
        String string = renewResponseMessage.getExpires();
        if (string != null && !string.equals("")) {
            SerializeUtil.serializeTag(xmlSerializer, "http://schemas.xmlsoap.org/ws/2004/08/eventing", "Expires", string);
        }
        this.serializeUnknownElements(xmlSerializer, renewResponseMessage);
        xmlSerializer.endTag("http://schemas.xmlsoap.org/ws/2004/08/eventing", "RenewResponse");
        xmlSerializer.endTag("http://www.w3.org/2003/05/soap-envelope", "Body");
    }

    public void serialize(SubscribeMessage subscribeMessage, XmlSerializer xmlSerializer, ProtocolData protocolData) throws IOException {
        Object object;
        Object object2;
        ConstantsHelper constantsHelper = this.getConstantsHelper(subscribeMessage, protocolData);
        xmlSerializer.startTag("http://www.w3.org/2003/05/soap-envelope", "Body");
        xmlSerializer.startTag("http://schemas.xmlsoap.org/ws/2004/08/eventing", "Subscribe");
        this.serializeUnknownAttributes(xmlSerializer, subscribeMessage);
        EndpointReference endpointReference = subscribeMessage.getEndTo();
        if (endpointReference != null) {
            this.serialize(endpointReference, xmlSerializer, constantsHelper, "http://schemas.xmlsoap.org/ws/2004/08/eventing", "EndTo");
        }
        Delivery delivery = subscribeMessage.getDelivery();
        EventSink eventSink = subscribeMessage.getEventSink();
        if (delivery != null) {
            if (eventSink != null) {
                object2 = null;
                object = eventSink.getBindings();
                while (object.hasNext()) {
                    CommunicationBinding communicationBinding = (CommunicationBinding)object.next();
                    URI uRI = communicationBinding.getTransportAddress();
                    if (protocolData.sourceMatches(uRI)) {
                        if (FrameworkProperties.REFERENCE_PARAM_MODE) {
                            object2 = uRI;
                            break;
                        }
                        object2 = (URI)uRI.clone();
                        ((URI)object2).setFragmentEncoded(delivery.getNotifyTo().getReferenceParameters().getWseIdentifier());
                        break;
                    }
                    if (object.hasNext()) continue;
                    object2 = uRI;
                    if (!Log.isWarn()) continue;
                    Log.warn("No appropriate local address found for event notification, fallbacking to: " + object2);
                }
                delivery.setNotifyTo(new EndpointReference((URI)object2, delivery.getNotifyTo().getReferenceParameters()));
            }
            this.serialize(delivery, xmlSerializer, constantsHelper);
        }
        if ((object2 = subscribeMessage.getExpires()) != null && !((String)object2).equals("")) {
            SerializeUtil.serializeTag(xmlSerializer, "http://schemas.xmlsoap.org/ws/2004/08/eventing", "Expires", (String)object2);
        }
        if ((object = subscribeMessage.getFilter()) != null) {
            this.serialize((Filter)object, xmlSerializer, constantsHelper);
        }
        this.serializeUnknownElements(xmlSerializer, subscribeMessage);
        xmlSerializer.endTag("http://schemas.xmlsoap.org/ws/2004/08/eventing", "Subscribe");
        xmlSerializer.endTag("http://www.w3.org/2003/05/soap-envelope", "Body");
    }

    public void serialize(SubscribeResponseMessage subscribeResponseMessage, XmlSerializer xmlSerializer, ProtocolData protocolData) throws IOException {
        String string;
        ConstantsHelper constantsHelper = this.getConstantsHelper(subscribeResponseMessage, protocolData);
        xmlSerializer.startTag("http://www.w3.org/2003/05/soap-envelope", "Body");
        xmlSerializer.startTag("http://schemas.xmlsoap.org/ws/2004/08/eventing", "SubscribeResponse");
        this.serializeUnknownAttributes(xmlSerializer, subscribeResponseMessage);
        EndpointReference endpointReference = subscribeResponseMessage.getSubscriptionManager();
        if (endpointReference != null) {
            if (!FrameworkProperties.REFERENCE_PARAM_MODE) {
                // empty if block
            }
            this.serialize(endpointReference, xmlSerializer, constantsHelper, "http://schemas.xmlsoap.org/ws/2004/08/eventing", "SubscriptionManager");
        }
        if ((string = subscribeResponseMessage.getExpires()) != null && !string.equals("")) {
            SerializeUtil.serializeTag(xmlSerializer, "http://schemas.xmlsoap.org/ws/2004/08/eventing", "Expires", string);
        }
        this.serializeUnknownElements(xmlSerializer, subscribeResponseMessage);
        xmlSerializer.endTag("http://schemas.xmlsoap.org/ws/2004/08/eventing", "SubscribeResponse");
        xmlSerializer.endTag("http://www.w3.org/2003/05/soap-envelope", "Body");
    }

    public void serialize(SubscriptionEndMessage subscriptionEndMessage, XmlSerializer xmlSerializer, ProtocolData protocolData) throws IOException {
        LocalizedString localizedString;
        URI uRI;
        ConstantsHelper constantsHelper = this.getConstantsHelper(subscriptionEndMessage, protocolData);
        xmlSerializer.startTag("http://www.w3.org/2003/05/soap-envelope", "Body");
        xmlSerializer.startTag("http://schemas.xmlsoap.org/ws/2004/08/eventing", "SubscriptionEnd");
        this.serializeUnknownAttributes(xmlSerializer, subscriptionEndMessage);
        EndpointReference endpointReference = subscriptionEndMessage.getSubscriptionManager();
        if (endpointReference != null) {
            this.serialize(endpointReference, xmlSerializer, constantsHelper, "http://schemas.xmlsoap.org/ws/2004/08/eventing", "SubscriptionManager");
        }
        if ((uRI = subscriptionEndMessage.getStatus()) != null) {
            SerializeUtil.serializeTag(xmlSerializer, "http://schemas.xmlsoap.org/ws/2004/08/eventing", "Status", uRI.toString());
        }
        if ((localizedString = subscriptionEndMessage.getReason()) != null) {
            SerializeUtil.serializeTagWithAttribute(xmlSerializer, "http://schemas.xmlsoap.org/ws/2004/08/eventing", "Reason", localizedString.getValue(), "http://www.w3.org/XML/1998/namespace", "lang", localizedString.getLanguage());
        }
        this.serializeUnknownElements(xmlSerializer, subscriptionEndMessage);
        xmlSerializer.endTag("http://schemas.xmlsoap.org/ws/2004/08/eventing", "SubscriptionEnd");
        xmlSerializer.endTag("http://www.w3.org/2003/05/soap-envelope", "Body");
    }

    public void serialize(UnsubscribeMessage unsubscribeMessage, XmlSerializer xmlSerializer, ProtocolData protocolData) throws IOException {
        xmlSerializer.startTag("http://www.w3.org/2003/05/soap-envelope", "Body");
        xmlSerializer.startTag("http://schemas.xmlsoap.org/ws/2004/08/eventing", "Unsubscribe");
        xmlSerializer.endTag("http://schemas.xmlsoap.org/ws/2004/08/eventing", "Unsubscribe");
        xmlSerializer.endTag("http://www.w3.org/2003/05/soap-envelope", "Body");
    }

    public void serialize(UnsubscribeResponseMessage unsubscribeResponseMessage, XmlSerializer xmlSerializer, ProtocolData protocolData) throws IOException {
        xmlSerializer.startTag("http://www.w3.org/2003/05/soap-envelope", "Body");
        xmlSerializer.endTag("http://www.w3.org/2003/05/soap-envelope", "Body");
    }

    public void serialize(GetMessage getMessage, XmlSerializer xmlSerializer, ProtocolData protocolData) throws IOException {
        xmlSerializer.startTag("http://www.w3.org/2003/05/soap-envelope", "Body");
        xmlSerializer.endTag("http://www.w3.org/2003/05/soap-envelope", "Body");
    }

    public void serialize(GetResponseMessage getResponseMessage, XmlSerializer xmlSerializer, ProtocolData protocolData) throws IOException {
        CustomizeMData customizeMData;
        RelationshipMData relationshipMData;
        ThisDeviceMData thisDeviceMData;
        ConstantsHelper constantsHelper = this.getConstantsHelper(getResponseMessage, protocolData);
        xmlSerializer.startTag("http://www.w3.org/2003/05/soap-envelope", "Body");
        xmlSerializer.startTag("http://schemas.xmlsoap.org/ws/2004/09/mex", "Metadata");
        this.serializeUnknownAttributes(xmlSerializer, getResponseMessage);
        ThisModelMData thisModelMData = getResponseMessage.getThisModel();
        if (thisModelMData != null) {
            xmlSerializer.startTag("http://schemas.xmlsoap.org/ws/2004/09/mex", "MetadataSection");
            xmlSerializer.attribute(null, "Dialect", constantsHelper.getMetadataDialectThisModel());
            this.serialize(thisModelMData, xmlSerializer, constantsHelper);
            xmlSerializer.endTag("http://schemas.xmlsoap.org/ws/2004/09/mex", "MetadataSection");
        }
        if ((thisDeviceMData = getResponseMessage.getThisDevice()) != null) {
            xmlSerializer.startTag("http://schemas.xmlsoap.org/ws/2004/09/mex", "MetadataSection");
            xmlSerializer.attribute(null, "Dialect", constantsHelper.getMetadataDialectThisDevice());
            this.serialize(thisDeviceMData, xmlSerializer, constantsHelper);
            xmlSerializer.endTag("http://schemas.xmlsoap.org/ws/2004/09/mex", "MetadataSection");
        }
        if ((relationshipMData = getResponseMessage.getRelationship()) != null) {
            xmlSerializer.startTag("http://schemas.xmlsoap.org/ws/2004/09/mex", "MetadataSection");
            xmlSerializer.attribute(null, "Dialect", constantsHelper.getMetatdataDialectRelationship());
            this.serialize(relationshipMData, xmlSerializer, constantsHelper);
            xmlSerializer.endTag("http://schemas.xmlsoap.org/ws/2004/09/mex", "MetadataSection");
        }
        if ((customizeMData = getResponseMessage.getCustomMdataInstance()) != null) {
            xmlSerializer.startTag("http://schemas.xmlsoap.org/ws/2004/09/mex", "MetadataSection");
            HashMap hashMap = ElementHandlerRegistry.getRegistry().getAllElementHandler();
            if (!hashMap.isEmpty()) {
                Iterator iterator = hashMap.keySet().iterator();
                while (iterator.hasNext()) {
                    QName qName = (QName)iterator.next();
                    Object object = hashMap.get(qName);
                    ElementHandler elementHandler = ElementHandlerRegistry.getRegistry().getElementHandler(qName);
                    if (elementHandler.equals(null)) {
                        elementHandler.serializeElement(xmlSerializer, qName, object);
                        continue;
                    }
                    CustomizeMDataHandler.getInstance().serializeElement(xmlSerializer, CustomizeMData.CUSTOM, customizeMData.getUnknownElements());
                }
            }
            xmlSerializer.endTag("http://schemas.xmlsoap.org/ws/2004/09/mex", "MetadataSection");
        }
        this.serializeUnknownElements(xmlSerializer, getResponseMessage);
        xmlSerializer.endTag("http://schemas.xmlsoap.org/ws/2004/09/mex", "Metadata");
        xmlSerializer.endTag("http://www.w3.org/2003/05/soap-envelope", "Body");
    }

    public void serialize(GetMetadataMessage getMetadataMessage, XmlSerializer xmlSerializer, ProtocolData protocolData) throws IOException {
        URI uRI;
        xmlSerializer.startTag("http://www.w3.org/2003/05/soap-envelope", "Body");
        xmlSerializer.startTag("http://schemas.xmlsoap.org/ws/2004/09/mex", "GetMetadata");
        this.serializeUnknownAttributes(xmlSerializer, getMetadataMessage);
        URI uRI2 = getMetadataMessage.getDialect();
        if (uRI2 != null) {
            SerializeUtil.serializeTag(xmlSerializer, "http://schemas.xmlsoap.org/ws/2004/09/mex", "Dialect", uRI2.toString() == null ? "" : uRI2.toString());
        }
        if ((uRI = getMetadataMessage.getIdentifier()) != null) {
            SerializeUtil.serializeTag(xmlSerializer, "http://schemas.xmlsoap.org/ws/2004/09/mex", "Identifier", uRI.toString() == null ? "" : uRI.toString());
        }
        this.serializeUnknownElements(xmlSerializer, getMetadataMessage);
        xmlSerializer.endTag("http://schemas.xmlsoap.org/ws/2004/09/mex", "GetMetadata");
        xmlSerializer.endTag("http://www.w3.org/2003/05/soap-envelope", "Body");
    }

    public void serialize(GetMetadataResponseMessage getMetadataResponseMessage, XmlSerializer xmlSerializer, ProtocolData protocolData) throws IOException {
        Object object;
        Object object2;
        ConstantsHelper constantsHelper = this.getConstantsHelper(getMetadataResponseMessage, protocolData);
        xmlSerializer.startTag("http://www.w3.org/2003/05/soap-envelope", "Body");
        xmlSerializer.startTag("http://schemas.xmlsoap.org/ws/2004/09/mex", "Metadata");
        this.serializeUnknownAttributes(xmlSerializer, getMetadataResponseMessage);
        EndpointReferenceSet endpointReferenceSet = getMetadataResponseMessage.getMetadataReferences();
        if (endpointReferenceSet != null) {
            object2 = endpointReferenceSet.iterator();
            while (object2.hasNext()) {
                object = (EndpointReference)object2.next();
                xmlSerializer.startTag("http://schemas.xmlsoap.org/ws/2004/09/mex", "MetadataSection");
                xmlSerializer.attribute(null, "Dialect", "http://schemas.xmlsoap.org/wsdl");
                this.serialize((EndpointReference)object, xmlSerializer, constantsHelper, "http://schemas.xmlsoap.org/ws/2004/09/mex", "MetadataReference");
                xmlSerializer.endTag("http://schemas.xmlsoap.org/ws/2004/09/mex", "MetadataSection");
            }
        }
        if ((object2 = getMetadataResponseMessage.getMetadataLocations()) != null) {
            object = ((URISet)object2).iterator();
            while (object.hasNext()) {
                URI uRI = (URI)object.next();
                xmlSerializer.startTag("http://schemas.xmlsoap.org/ws/2004/09/mex", "MetadataSection");
                xmlSerializer.attribute(null, "Dialect", "http://schemas.xmlsoap.org/wsdl");
                SerializeUtil.serializeTag(xmlSerializer, "http://schemas.xmlsoap.org/ws/2004/09/mex", "Location", uRI.toString() == null ? "" : uRI.toString());
                xmlSerializer.endTag("http://schemas.xmlsoap.org/ws/2004/09/mex", "MetadataSection");
            }
        }
        xmlSerializer.startTag("http://schemas.xmlsoap.org/ws/2004/09/mex", "MetadataSection");
        xmlSerializer.attribute(null, "Dialect", constantsHelper.getMetatdataDialectRelationship());
        object = getMetadataResponseMessage.getRelationship();
        if (object != null) {
            this.serialize((RelationshipMData)object, xmlSerializer, constantsHelper);
        }
        xmlSerializer.endTag("http://schemas.xmlsoap.org/ws/2004/09/mex", "MetadataSection");
        this.serializeUnknownElements(xmlSerializer, getMetadataResponseMessage);
        xmlSerializer.endTag("http://schemas.xmlsoap.org/ws/2004/09/mex", "Metadata");
        xmlSerializer.endTag("http://www.w3.org/2003/05/soap-envelope", "Body");
    }

    public void serialize(ResolveMessage resolveMessage, XmlSerializer xmlSerializer, ProtocolData protocolData) throws IOException {
        ConstantsHelper constantsHelper = this.getConstantsHelper(resolveMessage, protocolData);
        xmlSerializer.startTag("http://www.w3.org/2003/05/soap-envelope", "Body");
        xmlSerializer.startTag(constantsHelper.getWSDNamespace(), "Resolve");
        this.serializeUnknownAttributes(xmlSerializer, resolveMessage);
        EndpointReference endpointReference = resolveMessage.getEndpointReference();
        if (endpointReference != null) {
            this.serialize(endpointReference, xmlSerializer, constantsHelper, constantsHelper.getWSANamespace(), "EndpointReference");
        }
        this.serializeUnknownElements(xmlSerializer, resolveMessage);
        xmlSerializer.endTag(constantsHelper.getWSDNamespace(), "Resolve");
        xmlSerializer.endTag("http://www.w3.org/2003/05/soap-envelope", "Body");
    }

    public void serialize(ResolveMatchesMessage resolveMatchesMessage, XmlSerializer xmlSerializer, ProtocolData protocolData) throws IOException {
        ConstantsHelper constantsHelper = this.getConstantsHelper(resolveMatchesMessage, protocolData);
        xmlSerializer.startTag("http://www.w3.org/2003/05/soap-envelope", "Body");
        if (DPWSFramework.hasModule(64)) {
            xmlSerializer.attribute("", "ID", "BID1");
        }
        xmlSerializer.startTag(constantsHelper.getWSDNamespace(), "ResolveMatches");
        this.serializeUnknownAttributes(xmlSerializer, resolveMatchesMessage);
        ResolveMatch resolveMatch = resolveMatchesMessage.getResolveMatch();
        if (resolveMatch != null) {
            this.serialize(resolveMatch, xmlSerializer, constantsHelper);
        }
        this.serializeUnknownElements(xmlSerializer, resolveMatchesMessage);
        xmlSerializer.endTag(constantsHelper.getWSDNamespace(), "ResolveMatches");
        xmlSerializer.endTag("http://www.w3.org/2003/05/soap-envelope", "Body");
    }

    public void serialize(ResolveMatch resolveMatch, XmlSerializer xmlSerializer, ConstantsHelper constantsHelper) throws IllegalArgumentException, IllegalStateException, IOException {
        xmlSerializer.startTag(constantsHelper.getWSDNamespace(), "ResolveMatch");
        this.serializeUnknownAttributes(xmlSerializer, resolveMatch);
        this.serialize((DiscoveryData)resolveMatch, xmlSerializer, constantsHelper);
        this.serializeUnknownElements(xmlSerializer, resolveMatch);
        xmlSerializer.endTag(constantsHelper.getWSDNamespace(), "ResolveMatch");
    }

    public void serialize(FaultMessage faultMessage, XmlSerializer xmlSerializer, ProtocolData protocolData) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        xmlSerializer.startTag("http://www.w3.org/2003/05/soap-envelope", "Body");
        xmlSerializer.startTag("http://www.w3.org/2003/05/soap-envelope", "Fault");
        this.serializeUnknownAttributes(xmlSerializer, faultMessage);
        QName qName = faultMessage.getCode();
        if (qName != null) {
            xmlSerializer.startTag("http://www.w3.org/2003/05/soap-envelope", "Code");
            xmlSerializer.startTag("http://www.w3.org/2003/05/soap-envelope", "Value");
            object4 = xmlSerializer.getPrefix(qName.getNamespace(), true);
            xmlSerializer.text((String)object4 + ":" + qName.getLocalPart());
            xmlSerializer.endTag("http://www.w3.org/2003/05/soap-envelope", "Value");
            object3 = faultMessage.getSubcode();
            if (object3 != null) {
                xmlSerializer.startTag("http://www.w3.org/2003/05/soap-envelope", "Subcode");
                xmlSerializer.startTag("http://www.w3.org/2003/05/soap-envelope", "Value");
                object2 = xmlSerializer.getPrefix(((QName)object3).getNamespace(), true);
                xmlSerializer.text((String)object2 + ":" + ((QName)object3).getLocalPart());
                xmlSerializer.endTag("http://www.w3.org/2003/05/soap-envelope", "Value");
                object = faultMessage.getSubsubcode();
                if (object != null) {
                    xmlSerializer.startTag("http://www.w3.org/2003/05/soap-envelope", "Subcode");
                    xmlSerializer.startTag("http://www.w3.org/2003/05/soap-envelope", "Value");
                    String string = xmlSerializer.getPrefix(((QName)object).getNamespace(), true);
                    xmlSerializer.text(string + ":" + ((QName)object).getLocalPart());
                    xmlSerializer.endTag("http://www.w3.org/2003/05/soap-envelope", "Value");
                    xmlSerializer.endTag("http://www.w3.org/2003/05/soap-envelope", "Subcode");
                }
                xmlSerializer.endTag("http://www.w3.org/2003/05/soap-envelope", "Subcode");
            }
            xmlSerializer.endTag("http://www.w3.org/2003/05/soap-envelope", "Code");
        }
        if ((object4 = faultMessage.getReason()) != null) {
            object3 = (ArrayList)object4;
            xmlSerializer.startTag("http://www.w3.org/2003/05/soap-envelope", "Reason");
            object2 = ((List)object3).iterator();
            while (object2.hasNext()) {
                object = (LocalizedString)object2.next();
                SerializeUtil.serializeTagWithAttribute(xmlSerializer, "http://www.w3.org/2003/05/soap-envelope", "Text", ((LocalizedString)object).getValue(), "http://www.w3.org/XML/1998/namespace", "lang", ((LocalizedString)object).getLanguage());
            }
            xmlSerializer.endTag("http://www.w3.org/2003/05/soap-envelope", "Reason");
        }
        if ((object3 = faultMessage.getDetail()) != null) {
            xmlSerializer.startTag("http://www.w3.org/2003/05/soap-envelope", "Detail");
            ((ParameterValue)object3).serialize(xmlSerializer);
            xmlSerializer.endTag("http://www.w3.org/2003/05/soap-envelope", "Detail");
        }
        this.serializeUnknownElements(xmlSerializer, faultMessage);
        xmlSerializer.endTag("http://www.w3.org/2003/05/soap-envelope", "Fault");
        xmlSerializer.endTag("http://www.w3.org/2003/05/soap-envelope", "Body");
    }

    public void serialize(SOAPHeader sOAPHeader, XmlSerializer xmlSerializer, ProtocolData protocolData) throws IOException {
        ConstantsHelper constantsHelper = this.getConstantsHelper(sOAPHeader, protocolData);
        ReferenceParametersMData referenceParametersMData = sOAPHeader.getReferenceParameters();
        if (referenceParametersMData != null) {
            this.serializeNamespacePrefixes(referenceParametersMData, xmlSerializer);
        }
        xmlSerializer.startTag("http://www.w3.org/2003/05/soap-envelope", "Header");
        this.serializeUnknownAttributes(xmlSerializer, sOAPHeader);
        sOAPHeader.getAction().serialize(xmlSerializer, constantsHelper.getWSANamespace(), "Action");
        if (sOAPHeader.getMessageId() != null) {
            sOAPHeader.getMessageId().serialize(xmlSerializer, constantsHelper.getWSANamespace(), "MessageID");
        }
        if (sOAPHeader.getRelatesTo() != null) {
            sOAPHeader.getRelatesTo().serialize(xmlSerializer, constantsHelper.getWSANamespace(), "RelatesTo");
        }
        if (sOAPHeader.getReplyTo() != null) {
            this.serialize(sOAPHeader.getReplyTo(), xmlSerializer, constantsHelper, constantsHelper.getWSANamespace(), "ReplyTo");
        }
        if (sOAPHeader.getTo() != null) {
            sOAPHeader.getTo().serialize(xmlSerializer, constantsHelper.getWSANamespace(), "To");
        }
        if (referenceParametersMData != null && !referenceParametersMData.isEmpty()) {
            this.serialize(referenceParametersMData, xmlSerializer, constantsHelper, true);
        }
        if (sOAPHeader.getAppSequence() != null) {
            this.serialize(sOAPHeader.getAppSequence(), xmlSerializer, constantsHelper);
        }
        this.serializeUnknownElements(xmlSerializer, sOAPHeader);
        xmlSerializer.endTag("http://www.w3.org/2003/05/soap-envelope", "Header");
    }

    private void serializeUnknownElements(XmlSerializer xmlSerializer, UnknownDataContainer unknownDataContainer) throws IOException {
        HashMap hashMap = unknownDataContainer.getUnknownElements();
        if (hashMap != null) {
            Iterator iterator = hashMap.entrySet().iterator();
            while (iterator.hasNext()) {
                HashMap.Entry entry = (HashMap.Entry)iterator.next();
                QName qName = (QName)entry.getKey();
                xmlSerializer.unknownElements(qName, (List)entry.getValue());
            }
        }
    }

    private void serializeUnknownAttributes(XmlSerializer xmlSerializer, UnknownDataContainer unknownDataContainer) throws IOException {
        HashMap hashMap = unknownDataContainer.getUnknownAttributes();
        if (hashMap != null) {
            Iterator iterator = hashMap.entrySet().iterator();
            while (iterator.hasNext()) {
                HashMap.Entry entry = (HashMap.Entry)iterator.next();
                QName qName = (QName)entry.getKey();
                String string = (String)entry.getValue();
                xmlSerializer.attribute(qName.getNamespace(), qName.getLocalPart(), string);
            }
        }
    }

    private void serialize(ProbeMatch probeMatch, XmlSerializer xmlSerializer, ConstantsHelper constantsHelper) throws IllegalArgumentException, IllegalStateException, IOException {
        xmlSerializer.startTag(constantsHelper.getWSDNamespace(), "ProbeMatch");
        this.serializeUnknownAttributes(xmlSerializer, probeMatch);
        this.serialize((DiscoveryData)probeMatch, xmlSerializer, constantsHelper);
        this.serializeUnknownElements(xmlSerializer, probeMatch);
        xmlSerializer.endTag(constantsHelper.getWSDNamespace(), "ProbeMatch");
    }

    private void serialize(DiscoveryData discoveryData, XmlSerializer xmlSerializer, ConstantsHelper constantsHelper) throws IOException {
        long l;
        XAddressInfoSet xAddressInfoSet;
        ScopeSet scopeSet;
        EndpointReference endpointReference = discoveryData.getEndpointReference();
        this.serialize(endpointReference, xmlSerializer, constantsHelper, constantsHelper.getWSANamespace(), "EndpointReference");
        QNameSet qNameSet = discoveryData.getTypes();
        if (qNameSet != null) {
            this.serialize(qNameSet, xmlSerializer, constantsHelper.getWSDNamespace(), "Types");
        }
        if ((scopeSet = discoveryData.getScopes()) != null) {
            this.serialize(scopeSet, xmlSerializer, constantsHelper.getWSDNamespace());
        }
        if ((xAddressInfoSet = discoveryData.getXAddressInfoSet()) != null) {
            this.serialize(xAddressInfoSet, xmlSerializer, constantsHelper.getWSDNamespace());
        }
        if ((l = discoveryData.getMetadataVersion()) >= 1L) {
            SerializeUtil.serializeTag(xmlSerializer, constantsHelper.getWSDNamespace(), "MetadataVersion", "" + l);
        }
        this.serializeUnknownElements(xmlSerializer, discoveryData);
    }

    private void serialize(AppSequence appSequence, XmlSerializer xmlSerializer, ConstantsHelper constantsHelper) throws IllegalArgumentException, IllegalStateException, IOException {
        String string;
        long l;
        xmlSerializer.startTag(constantsHelper.getWSDNamespace(), "AppSequence");
        this.serializeUnknownAttributes(xmlSerializer, appSequence);
        long l2 = appSequence.getInstanceId();
        if (l2 >= 1L) {
            xmlSerializer.attribute(null, "InstanceId", "" + l2);
        }
        if ((l = appSequence.getMessageNumber()) >= 1L) {
            xmlSerializer.attribute(null, "MessageNumber", "" + l);
        }
        if ((string = appSequence.getSequenceId()) != null) {
            xmlSerializer.attribute(null, "SequenceId", "" + string);
        }
        this.serializeUnknownElements(xmlSerializer, appSequence);
        xmlSerializer.endTag(constantsHelper.getWSDNamespace(), "AppSequence");
    }

    private void serialize(EndpointReference endpointReference, XmlSerializer xmlSerializer, ConstantsHelper constantsHelper, String string, String string2) throws IOException {
        MetadataMData metadataMData;
        xmlSerializer.startTag(string, string2);
        this.serializeUnknownAttributes(xmlSerializer, endpointReference);
        AttributedURI attributedURI = endpointReference.getAddress();
        attributedURI.serialize(xmlSerializer, constantsHelper.getWSANamespace(), "Address");
        ReferenceParametersMData referenceParametersMData = endpointReference.getReferenceParameters();
        if (referenceParametersMData != null && !referenceParametersMData.isEmpty()) {
            xmlSerializer.startTag(constantsHelper.getWSANamespace(), "ReferenceParameters");
            this.serializeNamespacePrefixes(referenceParametersMData, xmlSerializer);
            this.serializeUnknownAttributes(xmlSerializer, referenceParametersMData);
            xmlSerializer.text("");
            this.serialize(referenceParametersMData, xmlSerializer, constantsHelper, false);
            xmlSerializer.endTag(constantsHelper.getWSANamespace(), "ReferenceParameters");
        }
        if ((metadataMData = endpointReference.getEndpointMetadata()) != null) {
            xmlSerializer.startTag(constantsHelper.getWSANamespace(), "Metadata");
            this.serializeUnknownAttributes(xmlSerializer, metadataMData);
            this.serializeUnknownElements(xmlSerializer, metadataMData);
            xmlSerializer.endTag(constantsHelper.getWSANamespace(), "Metadata");
        }
        this.serializeUnknownElements(xmlSerializer, endpointReference);
        xmlSerializer.endTag(string, string2);
    }

    private void serialize(Delivery delivery, XmlSerializer xmlSerializer, ConstantsHelper constantsHelper) throws IllegalArgumentException, IllegalStateException, IOException {
        xmlSerializer.startTag("http://schemas.xmlsoap.org/ws/2004/08/eventing", "Delivery");
        this.serializeUnknownAttributes(xmlSerializer, delivery);
        URI uRI = delivery.getMode();
        if (uRI != null) {
            xmlSerializer.attribute(null, "Mode", uRI.toString());
        }
        EndpointReference endpointReference = delivery.getNotifyTo();
        this.serialize(endpointReference, xmlSerializer, constantsHelper, "http://schemas.xmlsoap.org/ws/2004/08/eventing", "NotifyTo");
        this.serializeUnknownElements(xmlSerializer, delivery);
        xmlSerializer.endTag("http://schemas.xmlsoap.org/ws/2004/08/eventing", "Delivery");
    }

    private void serialize(Filter filter, XmlSerializer xmlSerializer, ConstantsHelper constantsHelper) throws IllegalArgumentException, IllegalStateException, IOException {
        URISet uRISet;
        xmlSerializer.startTag("http://schemas.xmlsoap.org/ws/2004/08/eventing", "Filter");
        this.serializeUnknownAttributes(xmlSerializer, filter);
        URI uRI = filter.getDialect();
        if (uRI != null) {
            xmlSerializer.attribute(null, "Dialect", uRI.toString());
        }
        if ((uRISet = filter.getActions()) != null) {
            Iterator iterator = uRISet.iterator();
            while (iterator.hasNext()) {
                URI uRI2 = (URI)iterator.next();
                xmlSerializer.text(uRI2.toString());
                if (!iterator.hasNext()) continue;
                xmlSerializer.text(" ");
            }
        }
        this.serializeUnknownElements(xmlSerializer, filter);
        xmlSerializer.endTag("http://schemas.xmlsoap.org/ws/2004/08/eventing", "Filter");
    }

    private void serialize(HostedMData hostedMData, XmlSerializer xmlSerializer, ConstantsHelper constantsHelper) throws IllegalArgumentException, IllegalStateException, IOException {
        Object object;
        xmlSerializer.startTag(constantsHelper.getDPWSNamespace(), constantsHelper.getDPWSElementRelationshipHosted());
        this.serializeUnknownAttributes(xmlSerializer, hostedMData);
        Object object2 = hostedMData.getEprInfoSet().iterator();
        while (object2.hasNext()) {
            object = (EprInfo)object2.next();
            this.serialize(((EprInfo)object).getEndpointReference(), xmlSerializer, constantsHelper, constantsHelper.getWSANamespace(), "EndpointReference");
        }
        object2 = hostedMData.getTypes();
        if (object2 != null) {
            this.serialize((QNameSet)object2, xmlSerializer, constantsHelper.getDPWSNamespace(), constantsHelper.getDPWSElementTypes());
        }
        if ((object = hostedMData.getServiceId()) != null) {
            SerializeUtil.serializeTag(xmlSerializer, constantsHelper.getDPWSNamespace(), constantsHelper.getDPWSElementServiceId(), object == null ? null : ((URI)object).toString());
        }
        this.serializeUnknownElements(xmlSerializer, hostedMData);
        xmlSerializer.endTag(constantsHelper.getDPWSNamespace(), constantsHelper.getDPWSElementRelationshipHosted());
    }

    private void serialize(HostMData hostMData, XmlSerializer xmlSerializer, ConstantsHelper constantsHelper) throws IllegalArgumentException, IllegalStateException, IOException {
        QNameSet qNameSet;
        xmlSerializer.startTag(constantsHelper.getDPWSNamespace(), constantsHelper.getDPWSElementRelationshipHost());
        this.serializeUnknownAttributes(xmlSerializer, hostMData);
        EndpointReference endpointReference = hostMData.getEndpointReference();
        if (endpointReference != null) {
            this.serialize(endpointReference, xmlSerializer, constantsHelper, constantsHelper.getWSANamespace(), "EndpointReference");
        }
        if ((qNameSet = hostMData.getTypes()) != null) {
            this.serialize(qNameSet, xmlSerializer, constantsHelper.getDPWSNamespace(), constantsHelper.getDPWSElementTypes());
        }
        this.serializeUnknownElements(xmlSerializer, hostMData);
        xmlSerializer.endTag(constantsHelper.getDPWSNamespace(), constantsHelper.getDPWSElementRelationshipHost());
    }

    private void serialize(ReferenceParametersMData referenceParametersMData, XmlSerializer xmlSerializer, ConstantsHelper constantsHelper, boolean bl) throws IOException {
        String string = referenceParametersMData.getWseIdentifier();
        if (string != null && FrameworkProperties.REFERENCE_PARAM_MODE) {
            xmlSerializer.startTag("http://schemas.xmlsoap.org/ws/2004/08/eventing", "Identifier");
            if (bl) {
                xmlSerializer.attribute(constantsHelper.getWSANamespace(), "IsReferenceParameter", "true");
            }
            xmlSerializer.text(string == null ? "" : string);
            xmlSerializer.endTag("http://schemas.xmlsoap.org/ws/2004/08/eventing", "Identifier");
        } else {
            xmlSerializer.text("");
        }
        this.serializeUnknownElements(xmlSerializer, referenceParametersMData);
        ReferenceParametersMData.ReferenceParameter[] referenceParameterArray = referenceParametersMData.getParameters();
        for (int i = 0; i < referenceParameterArray.length; ++i) {
            ReferenceParametersMData.ReferenceParameter referenceParameter = referenceParameterArray[i];
            xmlSerializer.plainText("<");
            String string2 = xmlSerializer.getPrefix(referenceParameter.getNamespace(), true);
            xmlSerializer.plainText(string2);
            xmlSerializer.plainText(":");
            xmlSerializer.plainText(referenceParameter.getName());
            if (bl) {
                xmlSerializer.plainText(" ");
                string2 = xmlSerializer.getPrefix(constantsHelper.getWSANamespace(), true);
                xmlSerializer.plainText(string2);
                xmlSerializer.plainText(":");
                xmlSerializer.plainText("IsReferenceParameter");
                xmlSerializer.plainText("=\"true\"");
            }
            String[] stringArray = referenceParameter.getChunks();
            for (int j = 0; j < stringArray.length; ++j) {
                if (j % 2 == 0) {
                    xmlSerializer.plainText(stringArray[j]);
                    continue;
                }
                string2 = xmlSerializer.getPrefix(stringArray[j], true);
                xmlSerializer.plainText(string2);
            }
        }
    }

    private void serializeNamespacePrefixes(ReferenceParametersMData referenceParametersMData, XmlSerializer xmlSerializer) {
        ReferenceParametersMData.ReferenceParameter[] referenceParameterArray = referenceParametersMData.getParameters();
        for (int i = 0; i < referenceParameterArray.length; ++i) {
            ReferenceParametersMData.ReferenceParameter referenceParameter = referenceParameterArray[i];
            String[] stringArray = referenceParameter.getChunks();
            for (int j = 1; j < stringArray.length; j += 2) {
                xmlSerializer.getPrefix(stringArray[j], true);
            }
        }
    }

    private void serialize(RelationshipMData relationshipMData, XmlSerializer xmlSerializer, ConstantsHelper constantsHelper) throws IllegalArgumentException, IllegalStateException, IOException {
        DataStructure dataStructure;
        xmlSerializer.startTag(constantsHelper.getDPWSNamespace(), constantsHelper.getDPWSElementRelationship());
        xmlSerializer.attribute(null, constantsHelper.getDPWSAttributeRelationshipType(), constantsHelper.getMetadataRelationshipHostingType());
        this.serializeUnknownAttributes(xmlSerializer, relationshipMData);
        HostMData hostMData = relationshipMData.getHost();
        if (hostMData != null) {
            this.serialize(hostMData, xmlSerializer, constantsHelper);
        }
        if ((dataStructure = relationshipMData.getHosted()) != null) {
            Iterator iterator = dataStructure.iterator();
            while (iterator.hasNext()) {
                HostedMData hostedMData = (HostedMData)iterator.next();
                this.serialize(hostedMData, xmlSerializer, constantsHelper);
            }
        }
        this.serializeUnknownElements(xmlSerializer, relationshipMData);
        xmlSerializer.endTag(constantsHelper.getDPWSNamespace(), constantsHelper.getDPWSElementRelationship());
    }

    private void serialize(ThisDeviceMData thisDeviceMData, XmlSerializer xmlSerializer, ConstantsHelper constantsHelper) throws IllegalArgumentException, IllegalStateException, IOException {
        String string;
        Object object;
        LocalizedString localizedString = null;
        xmlSerializer.startTag(constantsHelper.getDPWSNamespace(), constantsHelper.getDPWSElementThisDevice());
        this.serializeUnknownAttributes(xmlSerializer, thisDeviceMData);
        DataStructure dataStructure = thisDeviceMData.getFriendlyNames();
        if (dataStructure == null || dataStructure.size() == 0) {
            Log.warn("Message2SOAPGenerator.addThisDevice: No friendly name defined within device");
        } else {
            object = dataStructure.iterator();
            while (object.hasNext()) {
                localizedString = (LocalizedString)object.next();
                SerializeUtil.serializeTagWithAttribute(xmlSerializer, constantsHelper.getDPWSNamespace(), constantsHelper.getDPWSElementFriendlyName(), localizedString.getValue(), "http://www.w3.org/XML/1998/namespace", "lang", localizedString.getLanguage());
            }
        }
        object = thisDeviceMData.getFirmwareVersion();
        if (object != null && !((String)object).equals("")) {
            SerializeUtil.serializeTag(xmlSerializer, constantsHelper.getDPWSNamespace(), constantsHelper.getDPWSElementFirmwareVersion(), (String)object);
        }
        if ((string = thisDeviceMData.getSerialNumber()) != null && !string.equals("")) {
            SerializeUtil.serializeTag(xmlSerializer, constantsHelper.getDPWSNamespace(), constantsHelper.getDPWSElementSerialnumber(), string);
        }
        this.serializeUnknownElements(xmlSerializer, thisDeviceMData);
        xmlSerializer.endTag(constantsHelper.getDPWSNamespace(), constantsHelper.getDPWSElementThisDevice());
    }

    private void serialize(ThisModelMData thisModelMData, XmlSerializer xmlSerializer, ConstantsHelper constantsHelper) throws IllegalArgumentException, IllegalStateException, IOException {
        URI uRI;
        URI uRI2;
        Object object;
        LocalizedString localizedString = null;
        xmlSerializer.startTag(constantsHelper.getDPWSNamespace(), constantsHelper.getDPWSElementThisModel());
        this.serializeUnknownAttributes(xmlSerializer, thisModelMData);
        DataStructure dataStructure = thisModelMData.getManufacturerNames();
        Object object2 = dataStructure.iterator();
        while (object2.hasNext()) {
            localizedString = (LocalizedString)object2.next();
            SerializeUtil.serializeTagWithAttribute(xmlSerializer, constantsHelper.getDPWSNamespace(), constantsHelper.getDPWSElementManufacturer(), localizedString.getValue(), "http://www.w3.org/XML/1998/namespace", "lang", localizedString.getLanguage());
        }
        object2 = thisModelMData.getManufacturerUrl();
        if (object2 != null && !((URI)object2).toString().equals("")) {
            SerializeUtil.serializeTag(xmlSerializer, constantsHelper.getDPWSNamespace(), constantsHelper.getDPWSElementManufacturerURL(), ((URI)object2).toString() == null ? "" : ((URI)object2).toString());
        }
        localizedString = null;
        DataStructure dataStructure2 = thisModelMData.getModelNames();
        if (dataStructure2 == null || dataStructure2.size() == 0) {
            Log.warn("Message2SOAPGenerator.addThisModel: No model name defined within device");
        } else {
            object = dataStructure2.iterator();
            while (object.hasNext()) {
                localizedString = (LocalizedString)object.next();
                SerializeUtil.serializeTagWithAttribute(xmlSerializer, constantsHelper.getDPWSNamespace(), constantsHelper.getDPWSElementModelName(), localizedString.getValue(), "http://www.w3.org/XML/1998/namespace", "lang", localizedString.getLanguage());
            }
        }
        object = thisModelMData.getModelNumber();
        if (object != null && !((String)object).equals("")) {
            SerializeUtil.serializeTag(xmlSerializer, constantsHelper.getDPWSNamespace(), constantsHelper.getDPWSElementModelNumber(), (String)(object == null ? "" : object));
        }
        if ((uRI2 = thisModelMData.getModelUrl()) != null && !uRI2.toString().equals("")) {
            SerializeUtil.serializeTag(xmlSerializer, constantsHelper.getDPWSNamespace(), constantsHelper.getDPWSElementModelURL(), uRI2.toString() == null ? "" : uRI2.toString());
        }
        if ((uRI = thisModelMData.getPresentationUrl()) != null && !uRI.toString().equals("")) {
            SerializeUtil.serializeTag(xmlSerializer, constantsHelper.getDPWSNamespace(), constantsHelper.getDPWSElementPresentationURL(), uRI.toString() == null ? "" : uRI.toString());
        }
        this.serializeUnknownElements(xmlSerializer, thisModelMData);
        xmlSerializer.endTag(constantsHelper.getDPWSNamespace(), constantsHelper.getDPWSElementThisModel());
    }

    private void serialize(QNameSet qNameSet, XmlSerializer xmlSerializer, String string, String string2) throws IllegalArgumentException, IllegalStateException, IOException {
        QName[] qNameArray = qNameSet.toArray();
        if (qNameArray == null) {
            return;
        }
        int n = qNameArray.length;
        if (qNameArray.length > 0) {
            String string3;
            int n2;
            for (n2 = 0; n2 < n; ++n2) {
                string3 = xmlSerializer.getPrefix(qNameArray[n2].getNamespace(), false);
                if (string3 != null && !string3.equals("")) continue;
                xmlSerializer.setPrefix(qNameArray[n2].getPrefix(), qNameArray[n2].getNamespace());
            }
            xmlSerializer.startTag(string, string2);
            for (n2 = 0; n2 < n; ++n2) {
                string3 = xmlSerializer.getPrefix(qNameArray[n2].getNamespace(), false);
                if (string3 != null && !string3.equals("")) {
                    xmlSerializer.text(string3 + ":" + qNameArray[n2].getLocalPart());
                } else {
                    xmlSerializer.text(qNameArray[n2].getLocalPart());
                }
                if (n2 >= n) continue;
                xmlSerializer.text(" ");
            }
            xmlSerializer.endTag(string, string2);
        }
    }

    private void serialize(ProbeScopeSet probeScopeSet, XmlSerializer xmlSerializer, String string) throws IOException {
        if (!probeScopeSet.isEmpty()) {
            HashMap hashMap;
            xmlSerializer.startTag(string, "Scopes");
            String string2 = probeScopeSet.getMatchBy();
            if (string2 != null) {
                xmlSerializer.attribute(string, "MatchBy", string2);
            }
            if ((hashMap = probeScopeSet.getUnknownAttributes()) != null && !hashMap.isEmpty()) {
                Iterator iterator = hashMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    HashMap.Entry entry = (HashMap.Entry)iterator.next();
                    QName qName = (QName)entry.getKey();
                    String string3 = (String)entry.getValue();
                    xmlSerializer.attribute(qName.getNamespace(), qName.getLocalPart(), string3);
                }
            }
            xmlSerializer.text(probeScopeSet.getScopesAsString());
            xmlSerializer.endTag(string, "Scopes");
        }
    }

    private void serialize(ScopeSet scopeSet, XmlSerializer xmlSerializer, String string) throws IOException {
        if (!scopeSet.isEmpty()) {
            xmlSerializer.startTag(string, "Scopes");
            HashMap hashMap = scopeSet.getUnknownAttributes();
            if (hashMap != null && !hashMap.isEmpty()) {
                Iterator iterator = hashMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    HashMap.Entry entry = (HashMap.Entry)iterator.next();
                    QName qName = (QName)entry.getKey();
                    String string2 = (String)entry.getValue();
                    xmlSerializer.attribute(qName.getNamespace(), qName.getLocalPart(), string2);
                }
            }
            xmlSerializer.text(scopeSet.getScopesAsString());
            xmlSerializer.endTag(string, "Scopes");
        }
    }

    private void serialize(URISet uRISet, XmlSerializer xmlSerializer, String string) throws IllegalArgumentException, IllegalStateException, IOException {
        xmlSerializer.startTag(string, "XAddrs");
        xmlSerializer.text(uRISet.toString() == null ? "" : uRISet.toString());
        xmlSerializer.endTag(string, "XAddrs");
    }

    private void serialize(XAddressInfoSet xAddressInfoSet, XmlSerializer xmlSerializer, String string) throws IllegalArgumentException, IllegalStateException, IOException {
        xmlSerializer.startTag(string, "XAddrs");
        xmlSerializer.text(xAddressInfoSet.toString() == null ? "" : xAddressInfoSet.toString());
        xmlSerializer.endTag(string, "XAddrs");
    }

    private ConstantsHelper getConstantsHelper(Message message, ProtocolData protocolData) {
        return this.getConstantsHelper(message.getHeader(), protocolData);
    }

    private ConstantsHelper getConstantsHelper(SOAPHeader sOAPHeader, ProtocolData protocolData) {
        if (protocolData == null) {
            return null;
        }
        CommunicationManager communicationManager = DPWSFramework.getCommunicationManager(protocolData.getCommunicationManagerId());
        CommunicationUtil communicationUtil = communicationManager.getCommunicationUtil();
        ConstantsHelper constantsHelper = communicationUtil.getHelper(sOAPHeader.getProtocolInfo().getVersion());
        return constantsHelper;
    }
}

