/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication.protocol.soap.server;

import java.io.IOException;
import java.io.InputStream;
import org.ws4d.java.DPWSFramework;
import org.ws4d.java.communication.ProtocolData;
import org.ws4d.java.communication.connection.ip.IPAddress;
import org.ws4d.java.communication.monitor.MonitorStreamFactory;
import org.ws4d.java.communication.monitor.MonitoredMessageReceiver;
import org.ws4d.java.communication.monitor.MonitoringContext;
import org.ws4d.java.communication.protocol.http.HTTPGroup;
import org.ws4d.java.communication.protocol.http.HTTPResponse;
import org.ws4d.java.communication.protocol.http.header.HTTPRequestHeader;
import org.ws4d.java.communication.protocol.http.server.HTTPRequestHandler;
import org.ws4d.java.communication.protocol.http.server.HTTPServer;
import org.ws4d.java.communication.protocol.soap.SOAPResponse;
import org.ws4d.java.communication.protocol.soap.generator.MessageReceiver;
import org.ws4d.java.communication.protocol.soap.generator.SOAPMessageGeneratorFactory;
import org.ws4d.java.message.Message;
import org.ws4d.java.structures.HashMap;
import org.ws4d.java.types.InternetMediaType;
import org.ws4d.java.types.URI;

public class SOAPServer {
    private HTTPServer server = null;
    private static HashMap servers = new HashMap();

    public static synchronized SOAPServer get(HTTPServer hTTPServer) {
        SOAPServer sOAPServer = (SOAPServer)servers.get(hTTPServer);
        if (sOAPServer != null) {
            return sOAPServer;
        }
        sOAPServer = new SOAPServer(hTTPServer);
        servers.put(hTTPServer, sOAPServer);
        return sOAPServer;
    }

    public static synchronized void unregisterAndStop(SOAPServer sOAPServer) throws IOException {
        HTTPServer hTTPServer = sOAPServer.getHTTPServer();
        servers.remove(hTTPServer);
        sOAPServer.stop();
        HTTPServer.unregisterAndStop(hTTPServer);
    }

    public static synchronized SOAPServer get(IPAddress iPAddress, int n, boolean bl, String string) throws IOException {
        HTTPServer hTTPServer = HTTPServer.get(iPAddress, n, bl, string);
        return SOAPServer.get(hTTPServer);
    }

    private SOAPServer(HTTPServer hTTPServer) {
        this.server = hTTPServer;
    }

    public void register(String string, SOAPHandler sOAPHandler, HTTPGroup hTTPGroup) {
        this.server.register(string, InternetMediaType.getSOAPXML(), sOAPHandler, hTTPGroup);
    }

    public MessageReceiver unregister(String string) {
        return (SOAPHandler)this.server.unregister(string, InternetMediaType.getSOAPXML());
    }

    public HTTPServer getHTTPServer() {
        return this.server;
    }

    public synchronized void start() throws IOException {
        this.server.start();
    }

    public synchronized void stop() throws IOException {
        this.server.stop();
    }

    public static abstract class SOAPHandler
    implements HTTPRequestHandler,
    MessageReceiver {
        private final HashMap responses = new HashMap();

        protected SOAPHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final HTTPResponse handle(URI uRI, HTTPRequestHeader hTTPRequestHeader, InputStream inputStream, ProtocolData protocolData, MonitoringContext monitoringContext) throws IOException {
            MonitorStreamFactory monitorStreamFactory = DPWSFramework.getMonitorStreamFactory();
            MessageReceiver messageReceiver = monitorStreamFactory != null ? new MonitoredMessageReceiver(this, monitoringContext) : this;
            SOAPMessageGeneratorFactory.getInstance().getSOAP2MessageGeneratorForCurrentThread().deliverMessage(inputStream, messageReceiver, protocolData);
            HashMap hashMap = this.responses;
            synchronized (hashMap) {
                return (HTTPResponse)this.responses.remove(Thread.currentThread());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void respond(int n, Message message) {
            HashMap hashMap = this.responses;
            synchronized (hashMap) {
                this.responses.put(Thread.currentThread(), new SOAPResponse(n, message));
            }
        }
    }
}

