/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication.protocol.soap.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.ws4d.java.DPWSFramework;
import org.ws4d.java.communication.ProtocolData;
import org.ws4d.java.communication.connection.ip.IPAddress;
import org.ws4d.java.communication.connection.udp.Datagram;
import org.ws4d.java.communication.connection.udp.DatagramInputStream;
import org.ws4d.java.communication.connection.udp.UDPDatagramHandler;
import org.ws4d.java.communication.connection.udp.UDPServer;
import org.ws4d.java.communication.monitor.MonitorStreamFactory;
import org.ws4d.java.communication.monitor.MonitoredInputStream;
import org.ws4d.java.communication.monitor.MonitoredMessageReceiver;
import org.ws4d.java.communication.monitor.MonitoredOutputStream;
import org.ws4d.java.communication.monitor.MonitoringContext;
import org.ws4d.java.communication.protocol.soap.generator.DefaultMessageDiscarder;
import org.ws4d.java.communication.protocol.soap.generator.MessageReceiver;
import org.ws4d.java.communication.protocol.soap.generator.SOAPMessageGeneratorFactory;
import org.ws4d.java.message.Message;
import org.ws4d.java.types.ByteArrayBuffer;
import org.ws4d.java.util.Log;
import org.ws4d.java.util.Math;

public class SOAPoverUDPServer {
    private IPAddress ipAddress = null;
    private int port = -1;
    private String ifaceName;
    private final SOAPoverUDPDatagramHandler handler;
    private boolean running = false;

    public SOAPoverUDPServer(IPAddress iPAddress, int n, String string, SOAPoverUDPDatagramHandler sOAPoverUDPDatagramHandler) throws IOException {
        this.ipAddress = iPAddress;
        this.port = n;
        this.ifaceName = string;
        this.handler = sOAPoverUDPDatagramHandler;
        this.start();
    }

    public synchronized void start() throws IOException {
        if (this.running) {
            return;
        }
        UDPServer.open(this.ipAddress, this.port, this.ifaceName, this.handler);
        this.running = true;
    }

    public synchronized void stop() throws IOException {
        if (!this.running) {
            return;
        }
        UDPServer.close(this.ipAddress, this.port, this.ifaceName);
        this.running = false;
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    public void send(IPAddress iPAddress, int n, byte[] byArray, int n2) throws IOException {
        UDPServer.send(this.ipAddress, this.port, this.ifaceName, iPAddress, n, byArray, n2);
    }

    public SOAPoverUDPDatagramHandler getHandler() {
        return this.handler;
    }

    public static abstract class SOAPoverUDPDatagramHandler
    implements UDPDatagramHandler,
    MessageReceiver {
        public void handle(Datagram datagram, ProtocolData protocolData) throws IOException {
            MessageReceiver messageReceiver;
            MonitorStreamFactory monitorStreamFactory = DPWSFramework.getMonitorStreamFactory();
            InputStream inputStream = monitorStreamFactory != null ? new MonitoredInputStream(new DatagramInputStream(datagram), protocolData) : new DatagramInputStream(datagram);
            if (monitorStreamFactory != null) {
                MonitoringContext monitoringContext = monitorStreamFactory.getNewMonitoringContextIn(protocolData);
                messageReceiver = new MonitoredMessageReceiver(this, monitoringContext);
            } else {
                messageReceiver = this;
            }
            SOAPMessageGeneratorFactory.getInstance().getSOAP2MessageGeneratorForCurrentThread().deliverMessage(inputStream, messageReceiver, protocolData, this.getDiscarder());
            inputStream.close();
        }

        protected abstract DefaultMessageDiscarder getDiscarder();

        protected final void respond(Message message, IPAddress iPAddress, int n, ProtocolData protocolData) {
            block9: {
                MonitorStreamFactory monitorStreamFactory = DPWSFramework.getMonitorStreamFactory();
                MonitoringContext monitoringContext = null;
                try {
                    ByteArrayBuffer byteArrayBuffer = SOAPMessageGeneratorFactory.getInstance().getMessage2SOAPGeneratorForCurrentThread().generateSOAPMessage(message, protocolData);
                    UDPServer.send(this, iPAddress, n, byteArrayBuffer.getBuffer(), byteArrayBuffer.getContentLength());
                    int n2 = 1;
                    if (n2 <= 0) {
                        return;
                    }
                    int n3 = Math.nextInt(50, 250);
                    while (true) {
                        try {
                            Thread.sleep(n3);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (monitorStreamFactory != null) {
                            OutputStream outputStream = new ByteArrayOutputStream(byteArrayBuffer.getContentLength());
                            outputStream = new MonitoredOutputStream(outputStream, protocolData);
                            monitoringContext = monitorStreamFactory.getNewMonitoringContextOut(protocolData);
                            outputStream.write(byteArrayBuffer.getBuffer(), 0, byteArrayBuffer.getContentLength());
                            outputStream.flush();
                            outputStream.close();
                        }
                        UDPServer.send(this, iPAddress, n, byteArrayBuffer.getBuffer(), byteArrayBuffer.getContentLength());
                        if (monitorStreamFactory != null) {
                            monitorStreamFactory.send(protocolData, monitoringContext, message);
                        }
                        if (--n2 != 0) {
                            if ((n3 *= 2) <= 450) continue;
                            n3 = 450;
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException iOException) {
                    Log.error("Unable to send SOAP-over-UDP response: " + iOException);
                    Log.printStackTrace(iOException);
                    if (monitorStreamFactory == null) break block9;
                    monitorStreamFactory.sendFault(protocolData, monitoringContext, iOException);
                }
            }
        }
    }
}

