/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.concurrency;

import org.ws4d.java.concurrency.DeadlockException;
import org.ws4d.java.concurrency.Lockable;
import org.ws4d.java.structures.HashMap;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.structures.LinkedList;
import org.ws4d.java.structures.List;
import org.ws4d.java.util.WS4DIllegalStateException;

public class LockSupport
implements Lockable {
    private static final int UNLOCKED = 0;
    private static final int SHARED_LOCKED = 1;
    private static final int EXCLUSIVE_LOCKED = 2;
    private final HashMap allocatedLocks = new HashMap();
    private int allocatedSharedLockNum = 0;
    private boolean isExclusivelyLocked = false;
    private final List waitingForLock = new LinkedList();
    private boolean firstInListAwaitsExclusive = false;
    private boolean sharedAwaitingExclusive = false;

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("LockSupport (").append(this.hashCode()).append("): [");
        stringBuffer.append(" ASL=").append(this.allocatedSharedLockNum);
        stringBuffer.append(", AEL=").append(this.isExclusivelyLocked);
        stringBuffer.append(", allocatedLocks=").append(this.allocatedLocks);
        stringBuffer.append(", waiting=").append(this.waitingForLock);
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sharedLock() {
        Lock lock = null;
        LockSupport lockSupport = this;
        synchronized (lockSupport) {
            lock = this.getLockForCurrentThread();
            if (lock.tryAllocateShared()) {
                return;
            }
            lock.prepareAwaitSharedAllocation();
        }
        lock.awaitSharedAllocation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exclusiveLock() {
        Lock lock = null;
        LockSupport lockSupport = this;
        synchronized (lockSupport) {
            lock = this.getLockForCurrentThread();
            if (lock.tryAllocateExclusive()) {
                return;
            }
            lock.prepareAwaitExclusiveAllocation();
        }
        lock.awaitExclusiveAllocation();
    }

    public synchronized boolean trySharedLock() {
        return this.getLockForCurrentThread().tryAllocateShared();
    }

    public synchronized boolean tryExclusiveLock() {
        return this.getLockForCurrentThread().tryAllocateExclusive();
    }

    public synchronized void releaseSharedLock() {
        Lock lock = (Lock)this.allocatedLocks.get(Thread.currentThread());
        if (lock == null || lock.tSharedLocksNum == 0) {
            throw new WS4DIllegalStateException("Current thread has no allocated shared lock!");
        }
        if (lock.releaseShared()) {
            this.checkWaitingLockRequests();
        }
    }

    public synchronized boolean releaseExclusiveLock() {
        Lock lock = (Lock)this.allocatedLocks.get(Thread.currentThread());
        if (lock == null || lock.tExclusiveLocksNum == 0) {
            throw new WS4DIllegalStateException("Current thread has no allocated exclusive lock!");
        }
        if (lock.releaseExclusive()) {
            this.checkWaitingLockRequests();
            return true;
        }
        return false;
    }

    private int getState() {
        if (this.isExclusivelyLocked) {
            return 2;
        }
        if (this.allocatedSharedLockNum > 0) {
            return 1;
        }
        return 0;
    }

    private Lock getLockForCurrentThread() {
        Thread thread = Thread.currentThread();
        Lock lock = (Lock)this.allocatedLocks.get(thread);
        if (lock == null) {
            lock = new Lock(thread);
        }
        return lock;
    }

    private void checkWaitingLockRequests() {
        Lock lock;
        Iterator iterator = this.waitingForLock.iterator();
        while (iterator.hasNext() && (lock = (Lock)iterator.next()).tryAllocateAfterDelay()) {
            iterator.remove();
        }
        this.firstInListAwaitsExclusive = this.waitingForLock.size() == 0 ? false : ((Lock)this.waitingForLock.get(0)).isWaitingForExclusiveLock();
    }

    private class Lock {
        private final Thread thread;
        private volatile boolean tHasLock = false;
        private int tSharedLocksNum = 0;
        private volatile int tExclusiveLocksNum = 0;
        private static final int WAITING_FOR_EXCLUSIVE_LOCK = -1;
        private volatile long lockNumber = 0L;

        public Lock(Thread thread) {
            ++this.lockNumber;
            this.thread = thread;
        }

        public boolean isWaitingForExclusiveLock() {
            return this.tExclusiveLocksNum == -1;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Lock [ n=").append(this.lockNumber);
            stringBuffer.append(", thread=").append(this.thread);
            stringBuffer.append(", hl=").append(this.tHasLock);
            stringBuffer.append(", SL=").append(this.tSharedLocksNum);
            stringBuffer.append(", EL=").append(this.tExclusiveLocksNum);
            stringBuffer.append(" ]");
            return stringBuffer.toString();
        }

        boolean tryAllocateShared() {
            switch (LockSupport.this.getState()) {
                case 0: {
                    this.allocateShared();
                    return true;
                }
                case 1: {
                    if (!this.tHasLock && LockSupport.this.firstInListAwaitsExclusive) {
                        return false;
                    }
                    this.allocateShared();
                    return true;
                }
                case 2: {
                    if (this.tExclusiveLocksNum > 0) {
                        this.allocateShared();
                        return true;
                    }
                    return false;
                }
            }
            return false;
        }

        boolean tryAllocateExclusive() {
            switch (LockSupport.this.getState()) {
                case 0: {
                    this.allocateExclusive();
                    return true;
                }
                case 1: {
                    if (this.tSharedLocksNum == LockSupport.this.allocatedSharedLockNum) {
                        this.allocateExclusive();
                        return true;
                    }
                    if (this.tSharedLocksNum > 0 && LockSupport.this.sharedAwaitingExclusive) {
                        throw new DeadlockException("Deadlock because two threads try to upgrade. Implement exception handling for this case.");
                    }
                    return false;
                }
                case 2: {
                    if (this.tExclusiveLocksNum > 0) {
                        this.allocateExclusive();
                        return true;
                    }
                    return false;
                }
            }
            return false;
        }

        boolean tryAllocateAfterDelay() {
            switch (LockSupport.this.getState()) {
                case 0: {
                    if (this.tExclusiveLocksNum == -1) {
                        LockSupport.this.isExclusivelyLocked = true;
                        this.tExclusiveLocksNum = 1;
                    } else {
                        LockSupport.this.allocatedSharedLockNum = 1;
                    }
                    this.allocateAfterDelay();
                    return true;
                }
                case 1: {
                    if (this.tExclusiveLocksNum == -1) {
                        if (this.tSharedLocksNum == LockSupport.this.allocatedSharedLockNum) {
                            LockSupport.this.sharedAwaitingExclusive = false;
                            LockSupport.this.isExclusivelyLocked = true;
                            this.allocateAfterDelay();
                            return true;
                        }
                        return false;
                    }
                    LockSupport.this.allocatedSharedLockNum++;
                    this.allocateAfterDelay();
                    return true;
                }
                case 2: {
                    if (this.tExclusiveLocksNum == -1) {
                        return false;
                    }
                    if (this.tExclusiveLocksNum > 0) {
                        LockSupport.this.allocatedSharedLockNum++;
                        this.allocateAfterDelay();
                        return true;
                    }
                    return false;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void allocateAfterDelay() {
            if (this.tExclusiveLocksNum == -1) {
                this.tExclusiveLocksNum = 1;
            }
            this.allocate();
            Lock lock = this;
            synchronized (lock) {
                this.notify();
            }
        }

        private void allocateShared() {
            ++this.tSharedLocksNum;
            LockSupport.this.allocatedSharedLockNum++;
            this.allocate();
        }

        private void allocateExclusive() {
            ++this.tExclusiveLocksNum;
            LockSupport.this.isExclusivelyLocked = true;
            this.allocate();
        }

        private void allocate() {
            this.tHasLock = true;
            LockSupport.this.allocatedLocks.put(this.thread, this);
        }

        boolean releaseShared() {
            --this.tSharedLocksNum;
            LockSupport.this.allocatedSharedLockNum--;
            if (this.tSharedLocksNum == 0 && this.tExclusiveLocksNum == 0) {
                LockSupport.this.allocatedLocks.remove(this.thread);
                this.tHasLock = false;
                return true;
            }
            return false;
        }

        boolean releaseExclusive() {
            --this.tExclusiveLocksNum;
            if (this.tExclusiveLocksNum == 0) {
                LockSupport.this.isExclusivelyLocked = false;
                if (this.tSharedLocksNum == 0) {
                    LockSupport.this.allocatedLocks.remove(this.thread);
                    this.tHasLock = false;
                }
                return true;
            }
            return false;
        }

        void prepareAwaitSharedAllocation() {
            this.tSharedLocksNum = 1;
            LockSupport.this.waitingForLock.add(this);
            if (LockSupport.this.waitingForLock.size() == 1) {
                LockSupport.this.firstInListAwaitsExclusive = false;
            }
        }

        void prepareAwaitExclusiveAllocation() {
            this.tExclusiveLocksNum = -1;
            if (this.tSharedLocksNum > 0) {
                LockSupport.this.sharedAwaitingExclusive = true;
                LockSupport.this.firstInListAwaitsExclusive = true;
                LockSupport.this.waitingForLock.add(0, this);
            } else {
                if (LockSupport.this.waitingForLock.size() == 0) {
                    LockSupport.this.firstInListAwaitsExclusive = true;
                }
                LockSupport.this.waitingForLock.add(this);
            }
        }

        synchronized void awaitSharedAllocation() {
            while (!this.tHasLock) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        synchronized void awaitExclusiveAllocation() {
            while (this.tExclusiveLocksNum == -1) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

