/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.concurrency;

import org.ws4d.java.structures.LinkedList;
import org.ws4d.java.structures.List;
import org.ws4d.java.util.Log;

public class ThreadPool {
    private static int DEFAULT_SIZE = 10;
    private static long DEFAULT_TIMEOUT = 10000L;
    private final List idleThreads = new LinkedList();
    private final List activeThreads = new LinkedList();
    private final List waitingTasks = new LinkedList();
    private volatile int size;
    private final long timeout;
    private final Object lock = new Object();

    public ThreadPool() {
        this(DEFAULT_SIZE, DEFAULT_TIMEOUT);
    }

    public ThreadPool(int n, long l) {
        this.size = n;
        this.timeout = l;
    }

    public ThreadPool(int n) {
        this(n, DEFAULT_TIMEOUT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signalAvailability(WorkerThread workerThread) {
        Object object = this.lock;
        synchronized (object) {
            if (this.waitingTasks.size() > 0) {
                workerThread.setTask((Runnable)this.waitingTasks.remove(0));
            } else {
                this.idleThreads.add(workerThread);
                this.activeThreads.remove(workerThread);
                workerThread.setTask(null);
            }
        }
    }

    private void signalTermination(WorkerThread workerThread) {
        this.idleThreads.remove(workerThread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Runnable runnable) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.tryAllocation(runnable)) {
                this.waitingTasks.add(runnable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeOrAbort(Runnable runnable) {
        Object object = this.lock;
        synchronized (object) {
            return this.tryAllocation(runnable);
            {
            }
        }
    }

    private boolean tryAllocation(Runnable runnable) {
        if (this.idleThreads.size() == 0) {
            if (this.activeThreads.size() < this.size) {
                WorkerThread workerThread = new WorkerThread();
                this.allocate(workerThread, runnable);
                workerThread.start();
                return true;
            }
        } else {
            WorkerThread workerThread = (WorkerThread)this.idleThreads.remove(0);
            this.allocate(workerThread, runnable);
            return true;
        }
        return false;
    }

    private void allocate(WorkerThread workerThread, Runnable runnable) {
        this.activeThreads.add(workerThread);
        workerThread.setTask(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object;
        Thread thread = Thread.currentThread();
        LinkedList linkedList = new LinkedList();
        Object object2 = this.lock;
        synchronized (object2) {
            WorkerThread workerThread;
            object = this.activeThreads.iterator();
            while (object.hasNext()) {
                workerThread = (WorkerThread)object.next();
                ((List)linkedList).add(workerThread);
                workerThread.shutdown();
            }
            object = this.idleThreads.iterator();
            while (object.hasNext()) {
                workerThread = (WorkerThread)object.next();
                ((List)linkedList).add(workerThread);
                workerThread.shutdown();
                object.remove();
            }
        }
        object2 = ((List)linkedList).iterator();
        while (object2.hasNext()) {
            object = (WorkerThread)object2.next();
            if (object == thread) continue;
            try {
                ((Thread)object).join();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    class WorkerThread
    extends Thread {
        private volatile boolean shutdown = false;
        private volatile Runnable task;

        WorkerThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                Object object = this;
                synchronized (object) {
                    if (!this.shutdown && this.task == null) {
                        try {
                            this.wait(ThreadPool.this.timeout);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (this.shutdown) {
                            return;
                        }
                    }
                }
                object = ThreadPool.this.lock;
                synchronized (object) {
                    if (this.task == null) {
                        this.shutdown = true;
                        ThreadPool.this.signalTermination(this);
                        return;
                    }
                }
                try {
                    this.task.run();
                    continue;
                }
                catch (Exception exception) {
                    Log.error("Exception occurred while running thread. " + exception.getMessage());
                    Log.printStackTrace(exception);
                    continue;
                }
                finally {
                    ThreadPool.this.signalAvailability(this);
                    continue;
                }
                break;
            }
        }

        public synchronized void setTask(Runnable runnable) {
            this.task = runnable;
            this.notify();
        }

        public synchronized void shutdown() {
            this.shutdown = true;
            this.notify();
        }
    }
}

