/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.configuration;

import org.ws4d.java.configuration.Properties;
import org.ws4d.java.configuration.PropertiesHandler;
import org.ws4d.java.configuration.Property;
import org.ws4d.java.configuration.PropertyHeader;
import org.ws4d.java.structures.DataStructure;
import org.ws4d.java.structures.HashSet;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.util.Log;
import org.ws4d.java.util.StringUtil;

public class DPWSProperties
implements PropertiesHandler {
    public static final String PROP_DPWS_ROUTER = "UseCLDCUDPRouter";
    public static final String PROP_DPWS_ROUTER_ADDR = "CLDCUDPRouterAddr";
    public static final String PROP_DPWS_ROUTER_PORT = "CLDCUDPRouterPort";
    public static final String PROP_DPWS_HTTP_SERVER_KEEPALIVE = "HTTPServerKeepAlive";
    public static final String PROP_DPWS_HTTP_CLIENT_KEEPALIVE = "HTTPClientKeepAlive";
    public static final String PROP_DPWS_HTTP_RESPONSE_CHUNKED_MODE = "HTTPResponseChunkedMode";
    public static final String PROP_DPWS_HTTP_REQUEST_CHUNKED_MODE = "HTTPRequestChunkedMode";
    public static final String PROP_DPWS_HTTP_SERVER_REQUEST_TIMEOUT = "HTTPServerRequestTimeout";
    public static final String PROP_DPWS_HTTP_CLIENT_REQUEST_TIMEOUT = "HTTPClientRquesttimeout";
    public static final String PROP_DPWS_SUPPORTED_DPWS_VERSIONS = "SupportedDPWSVersions";
    public static final String PROP_DPWS_SOAPMSG_GENERATOR_FACTORY_CLASS = "SOAPMessageGeneratorFactoryClass";
    public static final int DEFAULT_DPWS_VERSION = 0;
    private DataStructure supportedDPWSVersions = new HashSet();
    private boolean useNativeRouter = false;
    private String routerIp = "127.0.0.1";
    private int routerPort = 1111;
    private boolean httpServerKeepAlive = true;
    private boolean httpClientKeepAlive = true;
    public static final int HTTP_CHUNKED_OFF = 0;
    public static final int HTTP_CHUNKED_ON = 1;
    public static final int HTTP_CHUNKED_ON_FOR_INVOKE = 2;
    public static final int DEFAULT_HTTP_CHUNKED_MODE = 2;
    private int httpResponseChunkedMode = 2;
    private int httpRequestChunkedMode = 2;
    private long httpServerRequestTimeout = 20000L;
    private long httpClientRequestTimeout = 20000L;
    private String soapMessageGeneratorFactoryClass = null;

    public static DPWSProperties getInstance() {
        return (DPWSProperties)Properties.forClassName("org.ws4d.java.configuration.DPWSProperties");
    }

    DPWSProperties() {
        this.supportedDPWSVersions.add(new Integer(0));
        this.supportedDPWSVersions.add(new Integer(1));
    }

    public boolean getNativeRouter() {
        return this.useNativeRouter;
    }

    public String getNativeRouterIp() {
        return this.routerIp;
    }

    public int getNativeRouterPort() {
        return this.routerPort;
    }

    public boolean getHTTPServerKeepAlive() {
        return this.httpServerKeepAlive;
    }

    public boolean getHTTPClientKeepAlive() {
        return this.httpClientKeepAlive;
    }

    public int getHTTPResponseChunkedMode() {
        return this.httpResponseChunkedMode;
    }

    public int getHTTPRequestChunkedMode() {
        return this.httpRequestChunkedMode;
    }

    public long getHTTPServerRequestTimeout() {
        return this.httpServerRequestTimeout;
    }

    public long getHTTPClientRequestTimeout() {
        return this.httpClientRequestTimeout;
    }

    public String getSOAPMessageGeneratorFactoryClass() {
        return this.soapMessageGeneratorFactoryClass;
    }

    public void setNativeRouterPort(int n) {
        this.routerPort = n;
    }

    public void setNativeRouterIp(String string) {
        this.routerIp = string;
    }

    public void setNativeRouter(boolean bl) {
        this.useNativeRouter = bl;
    }

    public void setHTTPServerKeepAlive(boolean bl) {
        this.httpServerKeepAlive = bl;
    }

    public void setHTTPClientKeepAlive(boolean bl) {
        this.httpClientKeepAlive = bl;
    }

    public void setHTTPResponseChunkedMode(int n) {
        this.httpResponseChunkedMode = n;
    }

    public void setHTTPRequestChunkedMode(int n) {
        this.httpRequestChunkedMode = n;
    }

    public void setHTTPServerRequestTimeout(long l) {
        this.httpServerRequestTimeout = l;
    }

    public void setHTTPClientRequestTimeout(long l) {
        this.httpClientRequestTimeout = l;
    }

    public void setSOAPMessageGeneratorFactoryClass(String string) {
        this.soapMessageGeneratorFactoryClass = string;
    }

    public void addSupportedDPWSVersion(int n) {
        this.supportedDPWSVersions.add(new Integer(n));
    }

    public void removeSupportedDPWSVersion(int n) {
        this.supportedDPWSVersions.remove(new Integer(n));
    }

    public HashSet getSupportedDPWSVersions() {
        if (this.supportedDPWSVersions.size() < 1) {
            this.supportedDPWSVersions.add(new Integer(0));
        }
        return (HashSet)this.supportedDPWSVersions;
    }

    private void setSupportedDPWSVersions(String string) {
        if (string != null && !string.equals("")) {
            String[] stringArray = StringUtil.split(string, ',');
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i].trim();
                if (StringUtil.equalsIgnoreCase("DPWS1.1", string2)) {
                    this.supportedDPWSVersions.add(new Integer(0));
                    continue;
                }
                if (StringUtil.equalsIgnoreCase("DPWS2006", string2)) {
                    this.supportedDPWSVersions.add(new Integer(1));
                    continue;
                }
                throw new RuntimeException("Unrecognized DPWS Version in Properties defined, known values are: 'DPWS1.1', 'DPWS2006' or both (comma separated).");
            }
        } else {
            throw new RuntimeException("No Supported Version in Properties defined, for example use DPWS1.1, DPWS2006 or both (comma separated).");
        }
    }

    public void finishedSection(int n) {
    }

    public String printSupportedDPWSVersions() {
        HashSet hashSet = this.getSupportedDPWSVersions();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Supported DPWS Version(s): ");
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            if (n == 0) {
                stringBuffer.append("DPWS1.1");
            } else if (n == 1) {
                stringBuffer.append("DPWS2006");
            }
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    public void setProperties(PropertyHeader propertyHeader, Property property) {
        if (Properties.HEADER_SECTION_DPWS.equals(propertyHeader)) {
            try {
                if (PROP_DPWS_ROUTER.equals(property.key)) {
                    this.useNativeRouter = property.value.equals("true");
                } else if (PROP_DPWS_ROUTER_ADDR.equals(property.key)) {
                    this.routerIp = property.value;
                } else if (PROP_DPWS_ROUTER_PORT.equals(property.key)) {
                    this.routerPort = Integer.parseInt(property.value.trim());
                } else if (PROP_DPWS_HTTP_SERVER_KEEPALIVE.equals(property.key)) {
                    this.setHTTPServerKeepAlive(property.value.equals("true"));
                } else if (PROP_DPWS_HTTP_CLIENT_KEEPALIVE.equals(property.key)) {
                    this.setHTTPClientKeepAlive(property.value.equals("true"));
                } else if (PROP_DPWS_HTTP_RESPONSE_CHUNKED_MODE.equals(property.key)) {
                    this.setHTTPResponseChunkedMode(Integer.parseInt(property.value.trim()));
                } else if (PROP_DPWS_HTTP_REQUEST_CHUNKED_MODE.equals(property.key)) {
                    this.setHTTPRequestChunkedMode(Integer.parseInt(property.value.trim()));
                } else if (PROP_DPWS_SUPPORTED_DPWS_VERSIONS.equals(property.key)) {
                    this.setSupportedDPWSVersions(property.value);
                } else if (PROP_DPWS_HTTP_CLIENT_REQUEST_TIMEOUT.equals(property.key)) {
                    this.setHTTPClientRequestTimeout(Long.parseLong(property.value.trim()));
                } else if (PROP_DPWS_HTTP_SERVER_REQUEST_TIMEOUT.equals(property.key)) {
                    this.setHTTPServerRequestTimeout(Long.parseLong(property.value.trim()));
                } else if (PROP_DPWS_SOAPMSG_GENERATOR_FACTORY_CLASS.equals(property.key)) {
                    this.setSOAPMessageGeneratorFactoryClass(property.value);
                }
            }
            catch (NumberFormatException numberFormatException) {
                Log.printStackTrace(numberFormatException);
            }
        }
    }
}

