/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.configuration;

import org.ws4d.java.communication.DPWSDiscoveryBinding;
import org.ws4d.java.communication.DiscoveryBinding;
import org.ws4d.java.configuration.BindingProperties;
import org.ws4d.java.configuration.Properties;
import org.ws4d.java.configuration.PropertiesHandler;
import org.ws4d.java.configuration.Property;
import org.ws4d.java.configuration.PropertyHeader;
import org.ws4d.java.util.Log;

public class DiscoveryBindingProperties
implements PropertiesHandler {
    public static final String PROP_IFACE = "IFace";
    public static final String PROP_IP_VERSION = "IPVersion";
    public static final String SUBSECTION_DISCOVERY_BINDINGS = "DiscoveryBindings";
    public static final String SUBSUBSECTION_DISCOVERY_BINDING = "DiscoveryBinding";
    public static final PropertyHeader HEADER_SUBSECTION_DISCOVERY_BINDINGS = new PropertyHeader("DiscoveryBindings", Properties.HEADER_SECTION_BINDINGS);
    public static final PropertyHeader HEADER_SUBSUBSECTION_DISCOVERY_BINDING = new PropertyHeader("DiscoveryBinding", HEADER_SUBSECTION_DISCOVERY_BINDINGS);
    private static DiscoveryBindingProperties handler = null;
    private BuildUpProperties buildUpBinding = null;

    DiscoveryBindingProperties() {
        if (handler != null) {
            throw new RuntimeException("DiscoveryBindingProperties: class already instantiated!");
        }
        handler = this;
    }

    static synchronized DiscoveryBindingProperties getInstance() {
        if (handler == null) {
            handler = new DiscoveryBindingProperties();
        }
        return handler;
    }

    public void setProperties(PropertyHeader propertyHeader, Property property) {
        if (!HEADER_SUBSECTION_DISCOVERY_BINDINGS.equals(propertyHeader) && HEADER_SUBSUBSECTION_DISCOVERY_BINDING.equals(propertyHeader)) {
            if (this.buildUpBinding == null) {
                this.buildUpBinding = new BuildUpProperties();
            }
            if ("BindingId".equals(property.key)) {
                this.buildUpBinding.bindingId = Integer.valueOf(property.value);
            } else if (PROP_IFACE.equals(property.key)) {
                this.buildUpBinding.buildUpIface = property.value;
            } else if (PROP_IP_VERSION.equals(property.key)) {
                this.buildUpBinding.buildUpIPVersion = Integer.parseInt(property.value.trim());
            }
        }
    }

    public void finishedSection(int n) {
        if (n == 3 && this.buildUpBinding != null) {
            if (!this.buildUpBinding.bindingId.equals(BindingProperties.DEFAULT_BINDING_ID)) {
                BindingProperties.getInstance().addDiscoveryBinding(this.buildUpBinding.bindingId, this.buildUpBinding.createBinding());
            } else {
                Log.error("HTTPBindingProperties: binding id not set: " + this.buildUpBinding);
            }
        }
        this.buildUpBinding = null;
    }

    private class BuildUpProperties {
        Integer bindingId = BindingProperties.DEFAULT_BINDING_ID;
        String buildUpIface = null;
        int buildUpIPVersion = -1;

        public DiscoveryBinding createBinding() {
            return new DPWSDiscoveryBinding(this.buildUpIPVersion, this.buildUpIface);
        }
    }
}

