/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.configuration;

import org.ws4d.java.configuration.Properties;
import org.ws4d.java.configuration.PropertiesHandler;
import org.ws4d.java.configuration.Property;
import org.ws4d.java.configuration.PropertyHeader;

public class DispatchingProperties
implements PropertiesHandler {
    public static final String PROP_REFERENCE_CACHING_TIME = "TargetReferenceCachingTime";
    public static final String PROP_RESPONSE_WAIT_TIME = "ResponseWaitTime";
    public static final String PROP_MATCH_WAIT_TIME = "MatchWaitTime";
    public static final String PROP_APPLICATION_MAX_DELAY = "ApplicationMaxDelay";
    public static final String PROP_MESSAGE_ID_BUFFER_SIZE = "MessageIdBufferSize";
    public static final String PROP_SERVICE_REFERENCE_CACHE_SIZE = "ServiceReferenceCacheSize";
    public static final String PROP_DEVICE_REFERENCE_AUTO_BUILD = "DeviceReferenceAutoBuild";
    private int targetReferenceCachingTime = 20000;
    private int responseWaitTime = 10000;
    private long matchWaitTime = 10000L;
    private int msgIdBufferSize = 50;
    private int servRefCacheSize = 50;
    private boolean deviceReferenceAutoBuild = false;

    DispatchingProperties() {
    }

    public static DispatchingProperties getInstance() {
        return (DispatchingProperties)Properties.forClassName("org.ws4d.java.configuration.DispatchingProperties");
    }

    public void setProperties(PropertyHeader propertyHeader, Property property) {
        if (Properties.HEADER_SUBSECTION_DISPATCHING.equals(propertyHeader)) {
            if (PROP_REFERENCE_CACHING_TIME.equals(property.key)) {
                this.targetReferenceCachingTime = Integer.parseInt(property.value.trim());
            } else if (PROP_RESPONSE_WAIT_TIME.equals(property.key)) {
                this.responseWaitTime = Integer.parseInt(property.value.trim());
            } else if (PROP_MATCH_WAIT_TIME.equals(property.key)) {
                this.matchWaitTime = Integer.parseInt(property.value.trim());
            } else if (PROP_MESSAGE_ID_BUFFER_SIZE.equals(property.key)) {
                this.setMessageIdBufferSize(Integer.parseInt(property.value.trim()));
            } else if (PROP_SERVICE_REFERENCE_CACHE_SIZE.equals(property.key)) {
                this.setServiceReferenceCacheSize(Integer.parseInt(property.value.trim()));
            } else if (PROP_DEVICE_REFERENCE_AUTO_BUILD.equals(property.key)) {
                if (property.value.equals("true")) {
                    this.setDeviceReferenceAutoBuild(true);
                } else {
                    this.setDeviceReferenceAutoBuild(false);
                }
            }
        }
    }

    public void finishedSection(int n) {
        if (n == 2) {
            // empty if block
        }
    }

    public int getReferenceCachingTime() {
        return this.targetReferenceCachingTime;
    }

    public void setReferenceCachingTime(int n) {
        this.targetReferenceCachingTime = n;
    }

    public int getResponseWaitTime() {
        return this.responseWaitTime;
    }

    public void setResponseWaitTime(int n) {
        this.responseWaitTime = n;
    }

    public int getMessageIdBufferSize() {
        return this.msgIdBufferSize;
    }

    public void setMessageIdBufferSize(int n) {
        this.msgIdBufferSize = n;
    }

    public int getServiceReferenceCacheSize() {
        return this.servRefCacheSize;
    }

    public void setServiceReferenceCacheSize(int n) {
        this.servRefCacheSize = n;
    }

    public long getMatchWaitTime() {
        return this.matchWaitTime;
    }

    public void setMatchWaitTime(long l) {
        this.matchWaitTime = l;
    }

    public boolean isDeviceReferenceAutoBuild() {
        return this.deviceReferenceAutoBuild;
    }

    public void setDeviceReferenceAutoBuild(boolean bl) {
        this.deviceReferenceAutoBuild = bl;
    }
}

