/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.configuration;

import org.ws4d.java.configuration.Properties;
import org.ws4d.java.configuration.PropertiesHandler;
import org.ws4d.java.configuration.Property;
import org.ws4d.java.configuration.PropertyHeader;
import org.ws4d.java.util.Log;

public class FrameworkProperties
implements PropertiesHandler {
    public static final String PROP_WSDL_SUPPORT_FACTORY_CLASS = "WsdlSupportFactoryClass";
    public static final String PROP_PROXY_SERVICE_FACTORY_CLASS = "ProxyServiceFactoryClass";
    public static final String PROP_SERVREF_FACTRORY_CLASS = "ServiceReferenceFactoryClass";
    public static final String PROP_KILL_ON_SHUTDOWN_HOOK = "KillOnShutdownHook";
    public static final String PROP_THREADPOOL_SIZE = "ThreadPoolSize";
    public static final String PROP_MAX_DGRAM_SIZE = "MaxDatagramSize";
    public static final String PROP_BYPASS_WSDL_REPOSITORY = "BypassWSDLRepository";
    private String wsdlSupportFactoryClass = null;
    private String serviceReferenceFactoryClass = null;
    private String proxyServiceFactoryClass = null;
    private int threadPoolSize = 10000;
    private int maxDatagramSize = 3000;
    private boolean killOnShutdownHook = true;
    public static boolean REFERENCE_PARAM_MODE = true;
    private boolean bypassWsdlRepository = false;

    FrameworkProperties() {
    }

    public static FrameworkProperties getInstance() {
        return (FrameworkProperties)Properties.forClassName("org.ws4d.java.configuration.FrameworkProperties");
    }

    public void setProperties(PropertyHeader propertyHeader, Property property) {
        if (Properties.HEADER_SUBSECTION_FRAMEWORK.equals(propertyHeader)) {
            try {
                if (PROP_WSDL_SUPPORT_FACTORY_CLASS.equals(property.key)) {
                    this.setWsdlSupportFactoryClass(property.value);
                } else if (PROP_PROXY_SERVICE_FACTORY_CLASS.equals(property.key)) {
                    this.setProxyServiceFactoryClass(property.value);
                } else if (PROP_SERVREF_FACTRORY_CLASS.equals(property.key)) {
                    this.setServiceReferenceFactoryClass(property.value);
                } else if (PROP_KILL_ON_SHUTDOWN_HOOK.equals(property.key)) {
                    this.setKillOnShutdownHook("true".equals(property.value));
                } else if (PROP_THREADPOOL_SIZE.equals(property.key)) {
                    this.setThreadPoolSize(Integer.valueOf(property.value));
                } else if (PROP_MAX_DGRAM_SIZE.equals(property.key)) {
                    this.setMaxDatagramSize(Integer.valueOf(property.value));
                } else if (PROP_BYPASS_WSDL_REPOSITORY.equals(property.key)) {
                    this.setBypassWsdlRepository("true".equals(property.value));
                }
            }
            catch (NumberFormatException numberFormatException) {
                Log.printStackTrace(numberFormatException);
            }
        }
    }

    public void finishedSection(int n) {
    }

    public String getWsdlSupportFactoryClass() {
        return this.wsdlSupportFactoryClass;
    }

    public String getProxyServiceFactroryClass() {
        return this.proxyServiceFactoryClass;
    }

    public String getServiceReferenceFactoryClass() {
        return this.serviceReferenceFactoryClass;
    }

    public boolean getKillOnShutdownHook() {
        return this.killOnShutdownHook;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public int getMaxDatagramSize() {
        return this.maxDatagramSize;
    }

    public boolean isBypassWsdlRepository() {
        return this.bypassWsdlRepository;
    }

    public void setBypassWsdlRepository(boolean bl) {
        this.bypassWsdlRepository = bl;
    }

    public void setProxyServiceFactoryClass(String string) {
        this.proxyServiceFactoryClass = string;
    }

    public void setServiceReferenceFactoryClass(String string) {
        this.serviceReferenceFactoryClass = string;
    }

    public void setKillOnShutdownHook(boolean bl) {
        this.killOnShutdownHook = bl;
    }

    public void setThreadPoolSize(int n) {
        this.threadPoolSize = n;
    }

    public void setMaxDatagramSize(int n) {
        this.maxDatagramSize = n;
    }

    public void setWsdlSupportFactoryClass(String string) {
        if (string != null && "".equals(string)) {
            string = null;
        }
        this.wsdlSupportFactoryClass = string;
    }
}

