/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.configuration;

import org.ws4d.java.configuration.Properties;
import org.ws4d.java.configuration.PropertiesHandler;
import org.ws4d.java.configuration.Property;
import org.ws4d.java.configuration.PropertyHeader;
import org.ws4d.java.util.Log;

public class GlobalPropertiesHandler
implements PropertiesHandler {
    public static final String PROP_LOG_LEVEL = "LogLevel";
    public static final String PROP_LOG_TIMESTAMP = "LogTimestamp";
    public static final String PROP_LOG_STACK_TRACE = "LogStackTrace";

    GlobalPropertiesHandler() {
    }

    public static GlobalPropertiesHandler getInstance() {
        return (GlobalPropertiesHandler)Properties.forClassName("org.ws4d.java.configuration.GlobalPropertiesHandler");
    }

    public void setProperties(PropertyHeader propertyHeader, Property property) {
        if (Log.isDebug()) {
            Log.debug("GlobalPropertiesHandler.setProperties: " + property, 4);
        }
        if (Properties.HEADER_SUBSECTION_LOGGING.equals(propertyHeader)) {
            if (PROP_LOG_LEVEL.equals(property.key)) {
                Log.setLogLevel(Integer.parseInt(property.value.trim()));
            } else if (PROP_LOG_TIMESTAMP.equals(property.key)) {
                if ("true".equals(property.value)) {
                    Log.setShowTimestamp(true);
                } else if ("false".equals(property.value)) {
                    Log.setShowTimestamp(false);
                }
            } else if (PROP_LOG_STACK_TRACE.equals(property.key)) {
                if ("true".equals(property.value)) {
                    Log.setLogStackTrace(true);
                } else if ("false".equals(property.value)) {
                    Log.setLogStackTrace(false);
                }
            }
        }
    }

    public void finishedSection(int n) {
        if (n <= 1) {
            Properties.getInstance().unregister(Properties.HEADER_SECTION_GLOBAL);
        }
    }
}

