/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.configuration;

import org.ws4d.java.configuration.BindingProperties;
import org.ws4d.java.configuration.Property;
import org.ws4d.java.structures.ArrayList;
import org.ws4d.java.structures.List;
import org.ws4d.java.types.URI;

public class ServiceProperties {
    public static final String PROP_CONFIGURATION_ID = "ConfigurationId";
    public static final String PROP_SERVICE_SECURED = "ServiceSecured";
    public static final String PROP_SEC_PRIVATEKEY_ALIAS = "PrivateKeyAlias";
    public static final String PROP_SEC_PRIVATEKEY_PASS = "PrivateKeyPassphrase";
    public static final String PROP_SERVICE_ID = "ServiceId";
    public static final String PROP_BINDING = "Binding";
    public static final Integer DEFAULT_CONFIGURATION_ID = new Integer(-1);
    private Integer configurationId = DEFAULT_CONFIGURATION_ID;
    private boolean serviceSecured = false;
    private List bindings = new ArrayList(2);
    private URI serviceId = null;
    private String privateKeyAlias = null;
    private String privateKeyPass = null;
    private static final BindingProperties bindProps = BindingProperties.getInstance();

    ServiceProperties() {
    }

    ServiceProperties(ServiceProperties serviceProperties) {
        this.configurationId = serviceProperties.configurationId;
        this.serviceSecured = serviceProperties.serviceSecured;
        this.bindings = new ArrayList(serviceProperties.bindings);
    }

    public Integer getConfigurationId() {
        return this.configurationId;
    }

    public void setConfigurationId(Integer n) {
        this.configurationId = n;
    }

    public boolean isServiceSecured() {
        return this.serviceSecured;
    }

    public void setServiceSecured(boolean bl) {
        this.serviceSecured = bl;
    }

    public List getBindings() {
        return this.bindings;
    }

    public URI getServiceId() {
        return this.serviceId;
    }

    public String getPrivateKeyAlias() {
        return this.privateKeyAlias;
    }

    public String getPrivateKeyPass() {
        return this.privateKeyPass;
    }

    void addProperty(Property property) {
        if (PROP_CONFIGURATION_ID.equals(property.key)) {
            this.configurationId = Integer.valueOf(property.value);
        } else if (PROP_SERVICE_SECURED.equals(property.key)) {
            if ("true".equals(property.value)) {
                this.serviceSecured = true;
            } else if ("false".equals(property.value)) {
                this.serviceSecured = false;
            }
        } else if (PROP_SEC_PRIVATEKEY_ALIAS.equals(property.key)) {
            this.privateKeyAlias = property.value;
        } else if (PROP_SEC_PRIVATEKEY_PASS.equals(property.key)) {
            this.privateKeyPass = property.value;
        } else if (PROP_BINDING.equals(property.key)) {
            ArrayList arrayList = (ArrayList)bindProps.getCommunicationBinding(Integer.valueOf(property.value));
            for (int i = 0; i < arrayList.size(); ++i) {
                this.bindings.add(arrayList.get(i));
            }
        } else if (PROP_SERVICE_ID.equals(property.key)) {
            this.serviceId = new URI(property.value);
        }
    }
}

