/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.dispatch;

import java.util.NoSuchElementException;
import org.ws4d.java.DPWSFramework;
import org.ws4d.java.communication.CommunicationManager;
import org.ws4d.java.communication.DefaultResponseCallback;
import org.ws4d.java.communication.Discovery;
import org.ws4d.java.communication.ProtocolData;
import org.ws4d.java.communication.ResponseCallback;
import org.ws4d.java.communication.TimeoutException;
import org.ws4d.java.configuration.DispatchingProperties;
import org.ws4d.java.constants.WSSecurityConstants;
import org.ws4d.java.dispatch.DeviceListenerQueue;
import org.ws4d.java.dispatch.DeviceServiceRegistry;
import org.ws4d.java.dispatch.OutDispatcher;
import org.ws4d.java.dispatch.ServiceReferenceInternal;
import org.ws4d.java.message.FaultMessage;
import org.ws4d.java.message.Message;
import org.ws4d.java.message.discovery.ByeMessage;
import org.ws4d.java.message.discovery.HelloMessage;
import org.ws4d.java.message.discovery.ProbeMatch;
import org.ws4d.java.message.discovery.ProbeMatchesMessage;
import org.ws4d.java.message.discovery.ProbeMessage;
import org.ws4d.java.message.discovery.ResolveMatch;
import org.ws4d.java.message.discovery.ResolveMatchesMessage;
import org.ws4d.java.message.discovery.ResolveMessage;
import org.ws4d.java.message.metadata.GetMessage;
import org.ws4d.java.message.metadata.GetResponseMessage;
import org.ws4d.java.service.Device;
import org.ws4d.java.service.LocalDevice;
import org.ws4d.java.service.ProxyFactory;
import org.ws4d.java.service.reference.DeviceListener;
import org.ws4d.java.service.reference.DeviceReference;
import org.ws4d.java.structures.AppSequenceTracker;
import org.ws4d.java.structures.DataStructure;
import org.ws4d.java.structures.EmptyStructures;
import org.ws4d.java.structures.HashMap;
import org.ws4d.java.structures.HashSet;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.structures.LockedMap;
import org.ws4d.java.structures.ReadOnlyIterator;
import org.ws4d.java.types.AppSequence;
import org.ws4d.java.types.AttributedURI;
import org.ws4d.java.types.DiscoveryData;
import org.ws4d.java.types.EndpointReference;
import org.ws4d.java.types.HostMData;
import org.ws4d.java.types.QName;
import org.ws4d.java.types.QNameSet;
import org.ws4d.java.types.ScopeSet;
import org.ws4d.java.types.URI;
import org.ws4d.java.types.URISet;
import org.ws4d.java.types.XAddressInfo;
import org.ws4d.java.types.XAddressInfoSet;
import org.ws4d.java.util.Log;
import org.ws4d.java.util.TimedEntry;
import org.ws4d.java.util.WatchDog;

public class DefaultDeviceReference
extends TimedEntry
implements DeviceReference {
    public static final AppSequence APP_SEQUENCE_ZERO = new AppSequence(-1L, 0L);
    public static final int EVENT_DEVICE_SEEN = 0;
    public static final int EVENT_DEVICE_BYE = 1;
    public static final int EVENT_DEVICE_GET_RSP = 2;
    public static final int EVENT_DEVICE_CHANGED = 3;
    public static final int EVENT_DEVICE_COMPLETELY_DISCOVERED = 4;
    public static final int EVENT_DEVICE_FAULT_RESET = 5;
    private static final GetRequestSynchronizer UP_TO_DATE_GET_SYNCHRONIZER = new GetRequestSynchronizer();
    private static final RequestSynchronizer UP_TO_DATE_PROBE_SYNCHRONIZER = new RequestSynchronizer();
    private static final ResolveRequestSynchronizer UP_TO_DATE_RESOLVE_SYNCHRONIZER = new ResolveRequestSynchronizer();
    private static final int SYNC_WAITTIME = 5000;
    private static final int SYNC_WAITRETRY = 5;
    private boolean isSecure = false;
    private Device device = null;
    private LockedMap listeners = new LockedMap();
    private DiscoveryData discoveryData = null;
    private String customMData = null;
    private XAddressInfo preferredXAddressInfo = null;
    private int location = 0;
    private AppSequenceTracker appSequenceTracker = null;
    private StateManager proxyReferenceState = new StateManager();
    private GetRequestSynchronizer getSynchronizer = null;
    private RequestSynchronizer probeSynchronizer = null;
    private ResolveRequestSynchronizer resolveSynchronizer = null;
    private final HashMap synchronizers = new HashMap();
    private boolean autoUpdateDevice = false;

    DefaultDeviceReference(AppSequence appSequence, DiscoveryData discoveryData, ProtocolData protocolData) {
        DiscoveryData discoveryData2 = new DiscoveryData(discoveryData);
        XAddressInfoSet xAddressInfoSet = discoveryData2.getXAddressInfoSet();
        if (xAddressInfoSet != null) {
            xAddressInfoSet.mergeProtocolInfo(protocolData.getProtocolInfo());
        }
        this.setDiscoveryData(discoveryData2);
        this.location = 1;
        this.appSequenceTracker = new AppSequenceTracker(appSequence);
        this.setPreferredXAddress(discoveryData2, protocolData);
        this.setPreferredVersion(protocolData.getCommunicationManagerId());
        if (discoveryData2.getMetadataVersion() > -1L) {
            this.proxyReferenceState.setState(2);
        }
        WatchDog.getInstance().register(this, DispatchingProperties.getInstance().getReferenceCachingTime());
    }

    DefaultDeviceReference(EndpointReference endpointReference) {
        if (endpointReference == null) {
            throw new IllegalArgumentException("endpoint reference must not be null");
        }
        this.setDiscoveryData(new DiscoveryData(endpointReference));
        this.appSequenceTracker = new AppSequenceTracker();
        WatchDog.getInstance().register(this, DispatchingProperties.getInstance().getReferenceCachingTime());
    }

    DefaultDeviceReference(EndpointReference endpointReference, XAddressInfoSet xAddressInfoSet) {
        DiscoveryData discoveryData = new DiscoveryData(endpointReference);
        discoveryData.setXAddresInfoSet(xAddressInfoSet);
        this.setDiscoveryData(discoveryData);
        this.appSequenceTracker = new AppSequenceTracker();
        this.preferredXAddressInfo = xAddressInfoSet.toArray()[0];
        WatchDog.getInstance().register(this, DispatchingProperties.getInstance().getReferenceCachingTime());
    }

    DefaultDeviceReference(LocalDevice localDevice) {
        this.setDiscoveryData(localDevice.getDiscoveryData());
        this.setLocalDevice(localDevice);
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer("DeviceReference [ discoveryData=");
        stringBuffer.append(this.discoveryData);
        String string = this.location == 0 ? "unknown" : (this.location == 1 ? "remote" : "local");
        stringBuffer.append(", location=").append(string);
        if (this.location != 2) {
            stringBuffer.append(", address=").append(this.preferredXAddressInfo);
        }
        stringBuffer.append(", device=").append(this.device);
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getState() {
        if (this.location == 2) {
            LocalDevice localDevice = (LocalDevice)this.device;
            if (localDevice != null) {
                return localDevice.isRunning() ? 3 : 1;
            }
            Log.error("DefaultDeviceReference.getState: Location is local, but no device specified");
            return 0;
        }
        DefaultDeviceReference defaultDeviceReference = this;
        synchronized (defaultDeviceReference) {
            return this.proxyReferenceState.getState();
        }
    }

    public Device getDevice() throws TimeoutException {
        return this.getDevice(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Device getDevice(boolean bl) throws TimeoutException {
        boolean bl2 = false;
        GetRequestSynchronizer getRequestSynchronizer = null;
        boolean bl3 = false;
        XAddressInfo xAddressInfo = null;
        Object object = this;
        synchronized (object) {
            if (this.location == 2) {
                return this.device;
            }
            if (!bl || this.getSynchronizer == UP_TO_DATE_GET_SYNCHRONIZER) {
                return this.device;
            }
            if (this.getSynchronizer != null) {
                getRequestSynchronizer = this.getSynchronizer;
                bl3 = true;
            } else {
                getRequestSynchronizer = this.getSynchronizer = new GetRequestSynchronizer(this);
            }
            if (this.proxyReferenceState.getState() == 1) {
                bl2 = true;
                this.resolveSynchronizer = null;
            }
            xAddressInfo = this.preferredXAddressInfo;
        }
        if (bl3) {
            return this.waitForDevice(getRequestSynchronizer);
        }
        if (xAddressInfo == null || xAddressInfo.getXAddress() == null) {
            xAddressInfo = this.resolveRemoteDevice();
        } else if (bl2) {
            this.fetchCompleteDiscoveryDataSync(this.resolveRemoteDevice());
        }
        Object object2 = this;
        synchronized (object2) {
            object = this.getSynchronizer;
            if (object == getRequestSynchronizer) {
                getRequestSynchronizer.metadataVersion = this.discoveryData.getMetadataVersion();
            }
        }
        if (object != getRequestSynchronizer) {
            try {
                getRequestSynchronizer.device = this.getDevice(true);
            }
            catch (TimeoutException timeoutException) {
                getRequestSynchronizer.exception = timeoutException;
            }
            object2 = getRequestSynchronizer;
            synchronized (object2) {
                getRequestSynchronizer.pending = false;
                getRequestSynchronizer.notifyAll();
            }
            if (getRequestSynchronizer.exception != null) {
                throw getRequestSynchronizer.exception;
            }
            return getRequestSynchronizer.device;
        }
        object2 = this;
        synchronized (object2) {
            this.synchronizers.put(this.sendGet(xAddressInfo).getMessageId(), getRequestSynchronizer);
        }
        return this.waitForDevice(getRequestSynchronizer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Device waitForDevice(GetRequestSynchronizer getRequestSynchronizer) throws TimeoutException {
        while (true) {
            Object object = getRequestSynchronizer;
            synchronized (object) {
                int n = 0;
                while (getRequestSynchronizer.pending) {
                    try {
                        getRequestSynchronizer.wait(5000L);
                        if (++n < 5) continue;
                        throw new TimeoutException("Device has not send an answer within 25000ms.");
                    }
                    catch (InterruptedException interruptedException) {
                        Log.printStackTrace(interruptedException);
                    }
                }
                if (getRequestSynchronizer.exception != null) {
                    throw getRequestSynchronizer.exception;
                }
                if (getRequestSynchronizer.device != null) {
                    return getRequestSynchronizer.device;
                }
            }
            object = this;
            synchronized (object) {
                if (this.getSynchronizer == UP_TO_DATE_GET_SYNCHRONIZER) {
                    return this.device;
                }
                if (this.getSynchronizer == null) {
                    throw new TimeoutException("Unknown communication error with device.");
                }
                getRequestSynchronizer = this.getSynchronizer;
            }
        }
    }

    public Device rebuildDevice() throws TimeoutException {
        this.reset(true);
        return this.getDevice();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildUpDevice() {
        GetRequestSynchronizer getRequestSynchronizer;
        DefaultDeviceReference defaultDeviceReference = this;
        synchronized (defaultDeviceReference) {
            if (this.getSynchronizer != null) {
                return;
            }
            getRequestSynchronizer = this.getSynchronizer = new GetRequestSynchronizer(this);
        }
        this.buildUpDevice(getRequestSynchronizer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildUpDevice(final GetRequestSynchronizer getRequestSynchronizer) {
        XAddressInfo xAddressInfo = null;
        DefaultDeviceReference defaultDeviceReference = this;
        synchronized (defaultDeviceReference) {
            if (this.getSynchronizer != getRequestSynchronizer) {
                return;
            }
            xAddressInfo = this.preferredXAddressInfo;
            if (xAddressInfo != null) {
                getRequestSynchronizer.metadataVersion = this.discoveryData.getMetadataVersion();
                this.synchronizers.put(this.sendGet(xAddressInfo).getMessageId(), getRequestSynchronizer);
                return;
            }
        }
        DPWSFramework.getThreadPool().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block9: {
                    try {
                        XAddressInfo xAddressInfo = DefaultDeviceReference.this.resolveRemoteDevice();
                        boolean bl = true;
                        Object object = DefaultDeviceReference.this;
                        synchronized (object) {
                            if (getRequestSynchronizer == DefaultDeviceReference.this.getSynchronizer) {
                                getRequestSynchronizer.metadataVersion = DefaultDeviceReference.this.discoveryData.getMetadataVersion();
                                DefaultDeviceReference.this.synchronizers.put(DefaultDeviceReference.this.sendGet(xAddressInfo).getMessageId(), getRequestSynchronizer);
                                bl = false;
                            }
                        }
                        if (!bl) break block9;
                        object = getRequestSynchronizer;
                        synchronized (object) {
                            getRequestSynchronizer.pending = false;
                            getRequestSynchronizer.notifyAll();
                        }
                    }
                    catch (TimeoutException timeoutException) {
                        Log.warn("Unablte to resolve remote device: " + timeoutException.getMessage());
                    }
                }
            }
        });
    }

    public Device setLocalDevice(LocalDevice localDevice) {
        if (this.device == localDevice) {
            return localDevice;
        }
        if (localDevice == null) {
            this.location = 0;
            Device device = this.device;
            this.device = null;
            this.discoveryData = new DiscoveryData(this.discoveryData.getEndpointReference(), this.discoveryData.getMetadataVersion());
            this.getSynchronizer = null;
            this.probeSynchronizer = null;
            this.resolveSynchronizer = null;
            return device;
        }
        if (this.location == 1) {
            Log.error("DefaultDeviceReference.setDevice: Setting local device to remote reference: Two devices using the same endpoint reference!");
            throw new RuntimeException("Setting local device to a remote reference!");
        }
        this.location = 2;
        this.getSynchronizer = UP_TO_DATE_GET_SYNCHRONIZER;
        this.resolveSynchronizer = UP_TO_DATE_RESOLVE_SYNCHRONIZER;
        this.probeSynchronizer = UP_TO_DATE_PROBE_SYNCHRONIZER;
        this.preferredXAddressInfo = null;
        LocalDevice localDevice2 = (LocalDevice)this.device;
        this.device = localDevice;
        WatchDog.getInstance().unregister(this);
        this.setDiscoveryData(localDevice.getDiscoveryData());
        if ((localDevice2 == null || !localDevice.equals(localDevice2)) && localDevice.isRunning()) {
            this.announceDeviceChangedAndBuildUp();
        }
        return localDevice2;
    }

    public void setDiscoveryData(DiscoveryData discoveryData) {
        if (discoveryData == null) {
            throw new IllegalArgumentException("discoverData must not be null");
        }
        if (discoveryData.getEndpointReference() == null) {
            throw new IllegalArgumentException("endpoint reference within discoverData must not be null");
        }
        this.discoveryData = discoveryData;
    }

    public synchronized void reset() {
        this.reset(false);
    }

    public synchronized void reset(boolean bl) {
        if (this.location == 2) {
            Log.warn("DefaultDeviceReference.reset: Not allowed to reset references to local devices!");
            return;
        }
        if (Log.isInfo()) {
            Log.info("DefaultDeviceReference.reset: Resetting device reference with endpoint reference " + this.discoveryData.getEndpointReference());
        }
        this.disconnectAllServiceReferences(bl);
        this.device = null;
        this.discoveryData = new DiscoveryData(this.discoveryData.getEndpointReference(), -1L);
        this.changeProxyReferenceState(5);
        this.location = 0;
        this.appSequenceTracker = new AppSequenceTracker();
        this.preferredXAddressInfo = null;
        this.getSynchronizer = null;
        this.probeSynchronizer = null;
        this.resolveSynchronizer = null;
    }

    public void fetchCompleteDiscoveryDataSync() throws TimeoutException {
        this.fetchCompleteDiscoveryDataSync(this.resolveRemoteDevice());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchCompleteDiscoveryDataSync(XAddressInfo xAddressInfo) throws TimeoutException {
        RequestSynchronizer requestSynchronizer;
        Object object = this;
        synchronized (object) {
            if (this.probeSynchronizer == UP_TO_DATE_PROBE_SYNCHRONIZER) {
                return;
            }
            requestSynchronizer = this.probeSynchronizer;
            if (requestSynchronizer == null) {
                requestSynchronizer = this.probeSynchronizer = new RequestSynchronizer(this);
                this.sendDirectedProbe(xAddressInfo);
                ProbeMessage probeMessage = new ProbeMessage(xAddressInfo.getComManId());
                this.synchronizers.put(probeMessage.getMessageId(), requestSynchronizer);
                probeMessage.setProtocolInfo(xAddressInfo.getProtocolInfo());
                probeMessage.getHeader().setTo(new AttributedURI("urn:docs-oasis-open-org:ws-dd:ns:discovery:2009:01"));
                probeMessage.setTargetXAddressInfo(xAddressInfo);
                OutDispatcher.getInstance().send(probeMessage, xAddressInfo, (ResponseCallback)new DefaultDeviceReferenceCallback(xAddressInfo));
            }
        }
        while (true) {
            object = requestSynchronizer;
            synchronized (object) {
                while (requestSynchronizer.pending) {
                    try {
                        requestSynchronizer.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Log.printStackTrace(interruptedException);
                    }
                }
                if (requestSynchronizer.exception != null) {
                    throw requestSynchronizer.exception;
                }
            }
            object = this;
            synchronized (object) {
                if (this.probeSynchronizer == UP_TO_DATE_PROBE_SYNCHRONIZER) {
                    return;
                }
                if (this.probeSynchronizer == null) {
                    throw new TimeoutException("Unknown communication error with device.");
                }
                requestSynchronizer = this.probeSynchronizer;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchCompleteDiscoveryDataAsync() {
        RequestSynchronizer requestSynchronizer;
        DefaultDeviceReference defaultDeviceReference = this;
        synchronized (defaultDeviceReference) {
            if (this.probeSynchronizer != null) {
                return;
            }
            requestSynchronizer = this.probeSynchronizer = new RequestSynchronizer(this);
        }
        this.fetchCompleteDiscoveryDataAsync(requestSynchronizer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchCompleteDiscoveryDataAsync(final RequestSynchronizer requestSynchronizer) {
        XAddressInfo xAddressInfo = null;
        DefaultDeviceReference defaultDeviceReference = this;
        synchronized (defaultDeviceReference) {
            if (this.probeSynchronizer != requestSynchronizer) {
                return;
            }
            xAddressInfo = this.preferredXAddressInfo;
            if (xAddressInfo != null) {
                this.synchronizers.put(this.sendDirectedProbe(xAddressInfo).getMessageId(), requestSynchronizer);
                return;
            }
        }
        DPWSFramework.getThreadPool().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block9: {
                    try {
                        XAddressInfo xAddressInfo = DefaultDeviceReference.this.resolveRemoteDevice();
                        boolean bl = true;
                        Object object = DefaultDeviceReference.this;
                        synchronized (object) {
                            if (requestSynchronizer == DefaultDeviceReference.this.probeSynchronizer) {
                                DefaultDeviceReference.this.synchronizers.put(DefaultDeviceReference.this.sendDirectedProbe(xAddressInfo).getMessageId(), requestSynchronizer);
                                bl = false;
                            }
                        }
                        if (!bl) break block9;
                        object = requestSynchronizer;
                        synchronized (object) {
                            requestSynchronizer.pending = false;
                            requestSynchronizer.notifyAll();
                        }
                    }
                    catch (TimeoutException timeoutException) {
                        Log.warn("Unablte to resolve remote device: " + timeoutException.getMessage());
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XAddressInfo resolveRemoteDevice() throws TimeoutException {
        ResolveRequestSynchronizer resolveRequestSynchronizer;
        Object object = this;
        synchronized (object) {
            resolveRequestSynchronizer = this.resolveSynchronizer;
            if (resolveRequestSynchronizer == UP_TO_DATE_RESOLVE_SYNCHRONIZER) {
                if (this.preferredXAddressInfo == null) {
                    throw new TimeoutException("No usable transport addresses found!");
                }
                return this.preferredXAddressInfo;
            }
            if (resolveRequestSynchronizer == null) {
                resolveRequestSynchronizer = this.resolveSynchronizer = new ResolveRequestSynchronizer(this);
                this.synchronizers.put(this.sendResolve(this.preferredXAddressInfo).getMessageId(), resolveRequestSynchronizer);
            }
        }
        while (true) {
            object = resolveRequestSynchronizer;
            synchronized (object) {
                while (resolveRequestSynchronizer.pending) {
                    try {
                        resolveRequestSynchronizer.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Log.printStackTrace(interruptedException);
                    }
                }
                if (resolveRequestSynchronizer.exception != null) {
                    throw resolveRequestSynchronizer.exception;
                }
                if (resolveRequestSynchronizer.xAddressInfo != null) {
                    return resolveRequestSynchronizer.xAddressInfo;
                }
            }
            object = this;
            synchronized (object) {
                if (this.preferredXAddressInfo != null) {
                    return this.preferredXAddressInfo;
                }
                if (this.resolveSynchronizer == UP_TO_DATE_RESOLVE_SYNCHRONIZER) {
                    if (this.preferredXAddressInfo == null) {
                        throw new TimeoutException("No usable transport addresses found!");
                    }
                    return this.preferredXAddressInfo;
                }
                if (this.resolveSynchronizer == null) {
                    throw new TimeoutException("Unknown communication error with device.");
                }
                resolveRequestSynchronizer = this.resolveSynchronizer;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveRemoteDeviceAsync(final ResolveRequestSynchronizer resolveRequestSynchronizer) {
        XAddressInfo xAddressInfo = null;
        DefaultDeviceReference defaultDeviceReference = this;
        synchronized (defaultDeviceReference) {
            if (this.resolveSynchronizer != resolveRequestSynchronizer) {
                return;
            }
            xAddressInfo = this.preferredXAddressInfo;
            if (xAddressInfo != null) {
                return;
            }
        }
        DPWSFramework.getThreadPool().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                boolean bl = true;
                Object object = DefaultDeviceReference.this;
                synchronized (object) {
                    if (resolveRequestSynchronizer != DefaultDeviceReference.this.resolveSynchronizer) {
                        DefaultDeviceReference.this.synchronizers.put(DefaultDeviceReference.this.sendResolve(DefaultDeviceReference.this.preferredXAddressInfo).getMessageId(), resolveRequestSynchronizer);
                        bl = false;
                    }
                }
                if (bl) {
                    object = resolveRequestSynchronizer;
                    synchronized (object) {
                        resolveRequestSynchronizer.pending = false;
                        resolveRequestSynchronizer.notifyAll();
                    }
                }
            }
        });
    }

    private GetMessage sendGet(XAddressInfo xAddressInfo) {
        GetMessage getMessage = new GetMessage(xAddressInfo.getComManId());
        EndpointReference endpointReference = this.getEndpointReference();
        getMessage.setProtocolInfo(xAddressInfo.getProtocolInfo());
        getMessage.getHeader().setEndpointReference(endpointReference);
        getMessage.setTargetXAddressInfo(xAddressInfo);
        OutDispatcher.getInstance().send(getMessage, xAddressInfo, (ResponseCallback)new DefaultDeviceReferenceCallback(xAddressInfo));
        return getMessage;
    }

    private ProbeMessage sendDirectedProbe(XAddressInfo xAddressInfo) {
        ProbeMessage probeMessage = new ProbeMessage(xAddressInfo.getComManId());
        probeMessage.setProtocolInfo(xAddressInfo.getProtocolInfo());
        probeMessage.getHeader().setTo(new AttributedURI("urn:docs-oasis-open-org:ws-dd:ns:discovery:2009:01"));
        probeMessage.setTargetXAddressInfo(xAddressInfo);
        OutDispatcher.getInstance().send(probeMessage, xAddressInfo, (ResponseCallback)new DefaultDeviceReferenceCallback(xAddressInfo));
        return probeMessage;
    }

    private ResolveMessage sendResolve(XAddressInfo xAddressInfo) {
        ResolveMessage resolveMessage = new ResolveMessage(CommunicationManager.ID_NULL);
        EndpointReference endpointReference = this.getEndpointReference();
        resolveMessage.setEndpointReference(endpointReference);
        OutDispatcher.getInstance().send(resolveMessage, xAddressInfo, Discovery.getDefaultOutputDomains(), (ResponseCallback)new DefaultDeviceReferenceCallback(xAddressInfo));
        return resolveMessage;
    }

    public int getLocation() {
        return this.location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getDevicePortTypes(boolean bl) throws TimeoutException {
        Object object = this;
        synchronized (object) {
            if (bl) {
                bl = (this.discoveryData.getTypes() == null || this.discoveryData.getTypes().size() == 0) && this.preferredXAddressInfo == null;
            }
        }
        if (bl) {
            this.resolveRemoteDevice();
        }
        return (object = this.discoveryData.getTypes()) == null ? EmptyStructures.EMPTY_ITERATOR : new ReadOnlyIterator(((QNameSet)object).iterator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QName[] getDevicePortTypesAsArray(boolean bl) throws TimeoutException {
        Object object = this;
        synchronized (object) {
            if (bl) {
                bl = (this.discoveryData.getTypes() == null || this.discoveryData.getTypes().size() == 0) && this.preferredXAddressInfo == null;
            }
        }
        if (bl) {
            this.resolveRemoteDevice();
        }
        return (object = this.discoveryData.getTypes()) == null ? (QName[])EmptyStructures.EMPTY_OBJECT_ARRAY : ((QNameSet)object).toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getScopes(boolean bl) throws TimeoutException {
        Object object = this;
        synchronized (object) {
            if (bl) {
                bl = (this.discoveryData.getScopes() == null || this.discoveryData.getScopes().size() == 0) && this.preferredXAddressInfo == null;
            }
        }
        if (bl) {
            this.resolveRemoteDevice();
        }
        URISet uRISet = (object = this.discoveryData.getScopes()) == null ? null : ((ScopeSet)object).getScopesAsUris();
        return uRISet == null ? EmptyStructures.EMPTY_ITERATOR : new ReadOnlyIterator(uRISet.iterator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI[] getScopesAsArray(boolean bl) throws TimeoutException {
        Object object = this;
        synchronized (object) {
            if (bl) {
                bl = (this.discoveryData.getScopes() == null || this.discoveryData.getScopes().size() == 0) && this.preferredXAddressInfo == null;
            }
        }
        if (bl) {
            this.resolveRemoteDevice();
        }
        URISet uRISet = (object = this.discoveryData.getScopes()) == null ? null : ((ScopeSet)object).getScopesAsUris();
        return uRISet == null ? (URI[])EmptyStructures.EMPTY_OBJECT_ARRAY : uRISet.toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMetadataVersion(boolean bl) throws TimeoutException {
        DefaultDeviceReference defaultDeviceReference = this;
        synchronized (defaultDeviceReference) {
            if (bl) {
                bl = this.discoveryData.getMetadataVersion() == -1L && this.preferredXAddressInfo == null;
            }
        }
        if (bl) {
            this.resolveRemoteDevice();
        }
        return this.discoveryData.getMetadataVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getXAddressInfos(boolean bl) throws TimeoutException {
        Object object = this;
        synchronized (object) {
            if (bl) {
                bl = (this.discoveryData.getXAddressInfoSet() == null || this.discoveryData.getXAddressInfoSet().size() == 0) && this.preferredXAddressInfo == null;
            }
        }
        if (bl) {
            this.resolveRemoteDevice();
        }
        return (object = this.discoveryData.getXAddressInfoSet()) == null ? EmptyStructures.EMPTY_ITERATOR : new ReadOnlyIterator(((XAddressInfoSet)object).iterator());
    }

    public synchronized URI getPreferredXAddress() {
        return this.preferredXAddressInfo == null ? null : this.preferredXAddressInfo.getXAddress();
    }

    public synchronized String getPreferredCommunicationManagerID() {
        return this.preferredXAddressInfo == null ? CommunicationManager.ID_NULL : this.preferredXAddressInfo.getComManId();
    }

    public EndpointReference getEndpointReference() {
        return this.discoveryData.getEndpointReference();
    }

    public String getCustomMData() {
        return this.customMData;
    }

    public void setCustomMData(String string) {
        this.customMData = string;
    }

    protected synchronized boolean checkAppSequence(AppSequence appSequence) {
        if (this.location == 2) {
            Log.error("DefaultDeviceReference.checkAppSequence is not available for local devices.");
            throw new RuntimeException("checkAppSequence is not available for local devices!");
        }
        return this.appSequenceTracker.checkAndUpdate(appSequence);
    }

    protected synchronized int changeProxyReferenceState(int n) {
        return this.proxyReferenceState.transit(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void timedOut() {
        this.listeners.sharedLock();
        try {
            if (this.listeners.size() == 0 && this.location != 2 && this.discoveryData.getEndpointReference() != null) {
                DeviceServiceRegistry.unregisterDeviceReference(this);
            }
        }
        finally {
            this.listeners.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(DeviceListener deviceListener) {
        if (deviceListener == null) {
            return;
        }
        this.listeners.exclusiveLock();
        try {
            if (this.listeners.size() == 0 && this.location != 2) {
                WatchDog.getInstance().unregister(this);
            }
            if (this.listeners.containsKey(deviceListener)) {
                return;
            }
            this.listeners.put(deviceListener, new DeviceListenerQueue(deviceListener, this));
        }
        finally {
            this.listeners.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(DeviceListener deviceListener) {
        if (deviceListener == null) {
            return;
        }
        this.listeners.exclusiveLock();
        try {
            this.listeners.remove(deviceListener);
            if (this.listeners.size() == 0 && this.location != 2) {
                WatchDog.getInstance().register(this, DispatchingProperties.getInstance().getReferenceCachingTime());
            }
        }
        finally {
            this.listeners.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int sizeOfListeners() {
        this.listeners.sharedLock();
        try {
            int n = this.listeners.size();
            return n;
        }
        finally {
            this.listeners.releaseSharedLock();
        }
    }

    private void setPreferredVersion(String string) {
        CommunicationManager communicationManager = DPWSFramework.getCommunicationManager(string);
        HashSet hashSet = communicationManager.getSupportedVersions();
        if (hashSet.size() == 1) {
            if (this.preferredXAddressInfo == null) {
                this.preferredXAddressInfo = new XAddressInfo();
            }
            Integer n = (Integer)hashSet.toArray()[0];
            this.preferredXAddressInfo.setProtocolInfo(communicationManager.createProtocolInfo(n));
        }
    }

    private void setPreferredXAddress(DiscoveryData discoveryData, ProtocolData protocolData) {
        XAddressInfoSet xAddressInfoSet = discoveryData.getXAddressInfoSet();
        if (xAddressInfoSet == null || xAddressInfoSet.size() == 0) {
            return;
        }
        if (this.preferredXAddressInfo != null && xAddressInfoSet.contains(this.preferredXAddressInfo)) {
            return;
        }
        Iterator iterator = xAddressInfoSet.iterator();
        while (iterator.hasNext()) {
            XAddressInfo xAddressInfo = (XAddressInfo)iterator.next();
            if (!protocolData.sourceMatches(xAddressInfo.getXAddress())) continue;
            this.preferredXAddressInfo = xAddressInfo;
            return;
        }
        this.preferredXAddressInfo = (XAddressInfo)xAddressInfoSet.iterator().next();
    }

    public boolean isDeviceObjectExisting() {
        return this.device != null;
    }

    public boolean isDiscovered() {
        if (this.location == 2) {
            return true;
        }
        return this.discoveryData.getMetadataVersion() != -1L;
    }

    public synchronized boolean isCompleteDiscovered() {
        return this.probeSynchronizer == UP_TO_DATE_PROBE_SYNCHRONIZER;
    }

    public synchronized void setAutoUpdateDevice(boolean bl) {
        this.autoUpdateDevice = bl;
    }

    public synchronized boolean isAutoUpdateDevice() {
        return this.autoUpdateDevice;
    }

    synchronized void disconnectAllServiceReferences(boolean bl) {
        if (this.device == null) {
            return;
        }
        Iterator iterator = this.device.getServiceReferences();
        while (iterator.hasNext()) {
            ServiceReferenceInternal serviceReferenceInternal = (ServiceReferenceInternal)iterator.next();
            serviceReferenceInternal.disconnectFromDevice();
            if (!bl) continue;
            serviceReferenceInternal.reset();
        }
    }

    private boolean updateDiscoveryData(HostMData hostMData) {
        if (this.location == 2) {
            throw new RuntimeException("Updating Discovery Data for a local device is prohibited outside of the device");
        }
        if (hostMData == null) {
            return false;
        }
        QNameSet qNameSet = this.discoveryData.getTypes();
        if (qNameSet == null) {
            qNameSet = new QNameSet(hostMData.getTypes());
        } else {
            qNameSet.addAll(hostMData.getTypes());
        }
        if (this.discoveryData.getEndpointReference() == null) {
            this.discoveryData.setEndpointReference(hostMData.getEndpointReference());
            return true;
        }
        return false;
    }

    synchronized void updateFromHello(HelloMessage helloMessage, ProtocolData protocolData) {
        if (this.checkAppSequence(helloMessage.getAppSequence())) {
            if (Log.isInfo()) {
                Log.info("Set DPWS Version for " + this.getEndpointReference().toString() + " to : " + protocolData.getProtocolInfo().getDisplayName());
            }
            this.setSecureDevice(helloMessage.getHeader().getSignature() != null);
            this.updateDiscoveryData(helloMessage.getDiscoveryData(), protocolData);
        } else if (Log.isDebug()) {
            Log.debug("DefaultDeviceReference.updateFromHello: old AppSequence in HelloMessage (msgId = " + helloMessage.getMessageId() + ")", 4);
        }
    }

    synchronized void updateFromBye(ByeMessage byeMessage, ProtocolData protocolData) {
        if (this.checkAppSequence(byeMessage.getAppSequence())) {
            this.preferredXAddressInfo = null;
            this.resolveSynchronizer = null;
            this.changeProxyReferenceState(1);
        } else if (Log.isDebug()) {
            Log.debug("DefaultDeviceReference.updateFromBye: old AppSequence in ByeMessage (msgId = " + byeMessage.getMessageId() + ")", 4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean updateDiscoveryData(DiscoveryData discoveryData, ProtocolData protocolData) {
        GetRequestSynchronizer getRequestSynchronizer = null;
        RequestSynchronizer requestSynchronizer = null;
        ResolveRequestSynchronizer resolveRequestSynchronizer = null;
        boolean bl = false;
        DefaultDeviceReference defaultDeviceReference = this;
        synchronized (defaultDeviceReference) {
            XAddressInfoSet xAddressInfoSet = this.discoveryData.getXAddressInfoSet();
            if (xAddressInfoSet != null) {
                xAddressInfoSet.mergeProtocolInfo(protocolData.getProtocolInfo());
            }
            if (bl = this.discoveryData.update(discoveryData)) {
                if (this.getSynchronizer != null) {
                    this.getSynchronizer = this.getSynchronizer != UP_TO_DATE_GET_SYNCHRONIZER ? (getRequestSynchronizer = new GetRequestSynchronizer(this)) : null;
                }
                if (this.probeSynchronizer != null) {
                    this.probeSynchronizer = this.probeSynchronizer != UP_TO_DATE_PROBE_SYNCHRONIZER ? (requestSynchronizer = new RequestSynchronizer(this)) : null;
                }
            }
            this.setPreferredXAddress(discoveryData, protocolData);
            if (this.preferredXAddressInfo == null && this.resolveSynchronizer != null) {
                this.resolveSynchronizer = this.resolveSynchronizer != UP_TO_DATE_RESOLVE_SYNCHRONIZER ? (resolveRequestSynchronizer = new ResolveRequestSynchronizer(this)) : null;
            }
            if (bl) {
                if (this.autoUpdateDevice) {
                    this.buildUpDevice();
                }
                this.changeProxyReferenceState(3);
            } else {
                this.changeProxyReferenceState(0);
            }
        }
        if (resolveRequestSynchronizer != null) {
            this.resolveRemoteDeviceAsync(resolveRequestSynchronizer);
        }
        if (getRequestSynchronizer != null) {
            this.buildUpDevice(getRequestSynchronizer);
        }
        if (requestSynchronizer != null) {
            this.fetchCompleteDiscoveryDataAsync(requestSynchronizer);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void announceDeviceListenerEvent(byte by, Device device) {
        this.listeners.sharedLock();
        try {
            DeviceListenerQueue.DeviceEvent deviceEvent = new DeviceListenerQueue.DeviceEvent(by, device);
            Iterator iterator = this.listeners.values().iterator();
            while (iterator.hasNext()) {
                DeviceListenerQueue deviceListenerQueue = (DeviceListenerQueue)iterator.next();
                deviceListenerQueue.announce(deviceEvent);
            }
        }
        finally {
            this.listeners.releaseSharedLock();
        }
    }

    private void announceDeviceRunning() {
        this.announceDeviceListenerEvent((byte)1, null);
    }

    private void announceDeviceCompletelyDiscovered() {
        this.announceDeviceListenerEvent((byte)2, null);
    }

    private void announceDeviceBuildUp() {
        this.announceDeviceListenerEvent((byte)3, this.device);
    }

    public void announceDeviceBye() {
        this.announceDeviceListenerEvent((byte)4, null);
    }

    private void announceDeviceChanged() {
        this.announceDeviceListenerEvent((byte)5, null);
    }

    private void announceDeviceCommunicationErrorOrReset() {
        this.announceDeviceListenerEvent((byte)8, null);
    }

    public void announceDeviceChangedAndBuildUp() {
        this.announceDeviceListenerEvent((byte)6, this.device);
    }

    public void announceDeviceRunningAndBuildUp() {
        this.announceDeviceListenerEvent((byte)7, this.device);
    }

    public boolean isSecureDevice() {
        return this.isSecure;
    }

    public void setSecureDevice(boolean bl) {
        this.isSecure = bl;
    }

    public XAddressInfo getPreferredXAddressInfo() {
        return this.preferredXAddressInfo;
    }

    private static class GetRequestSynchronizer
    extends RequestSynchronizer {
        Device device;

        GetRequestSynchronizer() {
        }

        GetRequestSynchronizer(DefaultDeviceReference defaultDeviceReference) {
            super(defaultDeviceReference);
        }
    }

    private static class ResolveRequestSynchronizer
    extends RequestSynchronizer {
        XAddressInfo xAddressInfo;

        ResolveRequestSynchronizer() {
        }

        ResolveRequestSynchronizer(DefaultDeviceReference defaultDeviceReference) {
            super(defaultDeviceReference);
        }
    }

    private static class RequestSynchronizer {
        long metadataVersion;
        volatile boolean pending = true;
        TimeoutException exception;

        RequestSynchronizer() {
            this.metadataVersion = -1L;
        }

        RequestSynchronizer(DefaultDeviceReference defaultDeviceReference) {
            this.metadataVersion = defaultDeviceReference.discoveryData.getMetadataVersion();
        }
    }

    private class StateManager {
        private int state = 0;

        private StateManager() {
        }

        private void setState(int n) {
            this.state = n;
        }

        private int getState() {
            return this.state;
        }

        private int transit(int n) {
            if (DefaultDeviceReference.this.location == 2) {
                throw new RuntimeException("Use of StateManager is dedicated to proxy devices!");
            }
            switch (this.getState()) {
                case 0: {
                    this.changeUnknownState(n);
                    break;
                }
                case 2: {
                    this.changeRunningState(n);
                    break;
                }
                case 3: {
                    this.changeBuildUpState(n);
                    break;
                }
                case 1: {
                    this.changeStoppedState(n);
                }
            }
            switch (n) {
                case 3: {
                    DefaultDeviceReference.this.probeSynchronizer = null;
                    if (DefaultDeviceReference.this.device == null) break;
                    DefaultDeviceReference.this.device.invalidate();
                    break;
                }
                case 4: {
                    DefaultDeviceReference.this.announceDeviceCompletelyDiscovered();
                }
            }
            return this.getState();
        }

        private void changeUnknownState(int n) {
            switch (n) {
                case 1: {
                    this.setState(1);
                    DefaultDeviceReference.this.announceDeviceBye();
                    break;
                }
                case 3: {
                    this.setState(2);
                    DefaultDeviceReference.this.announceDeviceRunning();
                    break;
                }
                case 2: {
                    this.setState(3);
                    DefaultDeviceReference.this.announceDeviceBuildUp();
                    break;
                }
                case 0: {
                    this.setState(2);
                    DefaultDeviceReference.this.announceDeviceRunning();
                }
            }
        }

        private void changeRunningState(int n) {
            switch (n) {
                case 1: {
                    this.setState(1);
                    DefaultDeviceReference.this.announceDeviceBye();
                    break;
                }
                case 3: {
                    DefaultDeviceReference.this.announceDeviceChanged();
                    break;
                }
                case 2: {
                    this.setState(3);
                    DefaultDeviceReference.this.announceDeviceBuildUp();
                    break;
                }
                case 5: {
                    this.setState(0);
                    DefaultDeviceReference.this.announceDeviceCommunicationErrorOrReset();
                }
            }
        }

        private void changeBuildUpState(int n) {
            switch (n) {
                case 1: {
                    this.setState(1);
                    DefaultDeviceReference.this.announceDeviceBye();
                    break;
                }
                case 3: {
                    this.setState(2);
                    DefaultDeviceReference.this.announceDeviceChanged();
                    break;
                }
                case 5: {
                    this.setState(0);
                    DefaultDeviceReference.this.announceDeviceCommunicationErrorOrReset();
                }
            }
        }

        private void changeStoppedState(int n) {
            switch (n) {
                case 3: {
                    this.setState(2);
                    DefaultDeviceReference.this.announceDeviceChanged();
                    break;
                }
                case 2: {
                    this.setState(3);
                    DefaultDeviceReference.this.announceDeviceBuildUp();
                    break;
                }
                case 0: {
                    if (DefaultDeviceReference.this.device != null) {
                        this.setState(3);
                        DefaultDeviceReference.this.announceDeviceBuildUp();
                        break;
                    }
                    this.setState(2);
                    DefaultDeviceReference.this.announceDeviceRunning();
                }
            }
        }
    }

    private class DefaultDeviceReferenceCallback
    extends DefaultResponseCallback {
        DefaultDeviceReferenceCallback(XAddressInfo xAddressInfo) {
            super(xAddressInfo);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(Message message, ProbeMatchesMessage probeMatchesMessage, ProtocolData protocolData) {
            DefaultDeviceReference defaultDeviceReference;
            Object object = null;
            try {
                defaultDeviceReference = DefaultDeviceReference.this;
                synchronized (defaultDeviceReference) {
                    DefaultDeviceReference.this.location = 1;
                    protocolData.setProtocolInfo(probeMatchesMessage.getProtocolInfo());
                    DefaultDeviceReference.this.checkAppSequence(probeMatchesMessage.getAppSequence());
                    object = (RequestSynchronizer)DefaultDeviceReference.this.synchronizers.remove(message.getMessageId());
                    if (object == null) {
                        Log.warn("DefaultDeviceReference: ignoring unexpected ProbeMatches message " + probeMatchesMessage);
                        return;
                    }
                    long l = DefaultDeviceReference.this.discoveryData.getMetadataVersion();
                    if (((RequestSynchronizer)object).metadataVersion == l) {
                        DefaultDeviceReference.this.setSecureDevice(probeMatchesMessage.getHeader().getSignature() != null);
                        DataStructure dataStructure = probeMatchesMessage.getProbeMatches();
                        boolean bl = false;
                        Iterator iterator = dataStructure.iterator();
                        while (iterator.hasNext()) {
                            ProbeMatch probeMatch = (ProbeMatch)iterator.next();
                            if (!DefaultDeviceReference.this.discoveryData.getEndpointReference().equals(probeMatch.getEndpointReference())) continue;
                            bl = true;
                            DefaultDeviceReference.this.updateDiscoveryData(probeMatch, protocolData);
                            break;
                        }
                        if (bl) {
                            if (object == DefaultDeviceReference.this.probeSynchronizer) {
                                DefaultDeviceReference.this.probeSynchronizer = UP_TO_DATE_PROBE_SYNCHRONIZER;
                                DefaultDeviceReference.this.changeProxyReferenceState(4);
                            }
                        } else {
                            ((RequestSynchronizer)object).exception = new TimeoutException("No matching endpoint reference in directed probe result found!");
                            if (object == DefaultDeviceReference.this.probeSynchronizer) {
                                DefaultDeviceReference.this.probeSynchronizer = null;
                            }
                        }
                    } else {
                        ((RequestSynchronizer)object).exception = new TimeoutException("Device update detected while probing device directly");
                    }
                }
            }
            catch (Throwable throwable) {
                ((RequestSynchronizer)object).exception = new TimeoutException("Unexpected exception during probe matches processing: " + throwable);
            }
            defaultDeviceReference = object;
            synchronized (defaultDeviceReference) {
                ((RequestSynchronizer)object).pending = false;
                object.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(Message message, ResolveMatchesMessage resolveMatchesMessage, ProtocolData protocolData) {
            DefaultDeviceReference defaultDeviceReference;
            Object object = null;
            try {
                defaultDeviceReference = DefaultDeviceReference.this;
                synchronized (defaultDeviceReference) {
                    DefaultDeviceReference.this.location = 1;
                    protocolData.setProtocolInfo(resolveMatchesMessage.getProtocolInfo());
                    boolean bl = DefaultDeviceReference.this.checkAppSequence(resolveMatchesMessage.getAppSequence());
                    object = (ResolveRequestSynchronizer)DefaultDeviceReference.this.synchronizers.remove(message.getMessageId());
                    if (object == null) {
                        Log.warn("DefaultDeviceReference: ignoring unexpected ResolveMatches message " + resolveMatchesMessage);
                        return;
                    }
                    if (bl) {
                        long l = DefaultDeviceReference.this.discoveryData.getMetadataVersion();
                        if (((ResolveRequestSynchronizer)object).metadataVersion == l) {
                            DefaultDeviceReference.this.setSecureDevice(resolveMatchesMessage.getHeader().getSignature() != null);
                            ResolveMatch resolveMatch = resolveMatchesMessage.getResolveMatch();
                            DefaultDeviceReference.this.updateDiscoveryData(resolveMatch, protocolData);
                            ((ResolveRequestSynchronizer)object).xAddressInfo = DefaultDeviceReference.this.preferredXAddressInfo;
                        }
                        if (object == DefaultDeviceReference.this.resolveSynchronizer) {
                            DefaultDeviceReference.this.resolveSynchronizer = UP_TO_DATE_RESOLVE_SYNCHRONIZER;
                        }
                    } else if (Log.isDebug()) {
                        Log.debug("DefaultDeviceReference.handle: old AppSequence in ResolveMatches message (msgId = " + resolveMatchesMessage.getMessageId() + ")", 4);
                    }
                }
            }
            catch (Throwable throwable) {
                ((ResolveRequestSynchronizer)object).exception = new TimeoutException("Unexpected exception during resolve matches processing: " + throwable);
            }
            defaultDeviceReference = object;
            synchronized (defaultDeviceReference) {
                ((ResolveRequestSynchronizer)object).pending = false;
                object.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(Message message, GetResponseMessage getResponseMessage, ProtocolData protocolData) {
            DefaultDeviceReference defaultDeviceReference;
            Object object = null;
            try {
                defaultDeviceReference = DefaultDeviceReference.this;
                synchronized (defaultDeviceReference) {
                    if (DefaultDeviceReference.this.location == 2) {
                        return;
                    }
                    DefaultDeviceReference.this.location = 1;
                    protocolData.setProtocolInfo(getResponseMessage.getProtocolInfo());
                    object = (GetRequestSynchronizer)DefaultDeviceReference.this.synchronizers.remove(message.getMessageId());
                    if (object == null) {
                        Log.warn("DefaultDeviceReference: ignoring unexpected GetResponse message " + getResponseMessage);
                        return;
                    }
                    long l = DefaultDeviceReference.this.discoveryData.getMetadataVersion();
                    if (((GetRequestSynchronizer)object).metadataVersion == l) {
                        DefaultDeviceReference.this.setCustomMData(getResponseMessage.getCustomMdata());
                        DefaultDeviceReference.this.updateDiscoveryData(getResponseMessage.getHost());
                        ProxyFactory proxyFactory = DPWSFramework.getProxyFactory();
                        boolean bl = false;
                        if (DefaultDeviceReference.this.device == null) {
                            DefaultDeviceReference.this.device = proxyFactory.createProxyDevice(getResponseMessage, DefaultDeviceReference.this, null, protocolData);
                            bl = true;
                        } else if (!DefaultDeviceReference.this.device.isValid()) {
                            DefaultDeviceReference.this.device = proxyFactory.createProxyDevice(getResponseMessage, DefaultDeviceReference.this, DefaultDeviceReference.this.device, protocolData);
                            bl = true;
                        }
                        if (bl) {
                            DefaultDeviceReference.this.changeProxyReferenceState(2);
                        }
                        ((GetRequestSynchronizer)object).device = DefaultDeviceReference.this.device;
                        if (object == DefaultDeviceReference.this.getSynchronizer) {
                            DefaultDeviceReference.this.getSynchronizer = UP_TO_DATE_GET_SYNCHRONIZER;
                        }
                    } else if (Log.isDebug()) {
                        Log.debug("Concurrent device update detected, rebuilding device proxy", 4);
                    }
                }
            }
            catch (Throwable throwable) {
                ((GetRequestSynchronizer)object).exception = new TimeoutException("Unexpected exception during get response processing: " + throwable);
            }
            defaultDeviceReference = object;
            synchronized (defaultDeviceReference) {
                ((GetRequestSynchronizer)object).pending = false;
                object.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(Message message, FaultMessage faultMessage, ProtocolData protocolData) {
            Object object;
            boolean bl = false;
            boolean bl2 = false;
            RequestSynchronizer requestSynchronizer = null;
            try {
                object = DefaultDeviceReference.this;
                synchronized (object) {
                    protocolData.setProtocolInfo(faultMessage.getProtocolInfo());
                    requestSynchronizer = (RequestSynchronizer)DefaultDeviceReference.this.synchronizers.remove(message.getMessageId());
                    if (requestSynchronizer == null) {
                        Log.warn("DefaultDeviceReference.handle(FaultMessage): no synchronizer found for request message " + message);
                        return;
                    }
                    Log.warn("Fault returned for xaddress " + message.getTargetAddress() + ": " + faultMessage);
                    if (requestSynchronizer == DefaultDeviceReference.this.resolveSynchronizer) {
                        DefaultDeviceReference.this.resolveSynchronizer = null;
                    } else if (requestSynchronizer == DefaultDeviceReference.this.probeSynchronizer) {
                        try {
                            if (this.retransmitRequest(message)) {
                                return;
                            }
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            bl = true;
                        }
                        DefaultDeviceReference.this.probeSynchronizer = null;
                    } else if (requestSynchronizer == DefaultDeviceReference.this.getSynchronizer) {
                        if (faultMessage.getSubcode().equals(WSSecurityConstants.WSSE_FAULT_AUTHENTICATION)) {
                            bl2 = true;
                        } else {
                            try {
                                if (this.retransmitRequest(message)) {
                                    return;
                                }
                            }
                            catch (NoSuchElementException noSuchElementException) {
                                bl = true;
                            }
                        }
                        DefaultDeviceReference.this.getSynchronizer = null;
                    }
                    DefaultDeviceReference.this.synchronizers.remove(message.getMessageId());
                    DefaultDeviceReference.this.changeProxyReferenceState(5);
                }
            }
            catch (Throwable throwable) {
                Log.warn("Unexpected exception during fault processing: " + throwable);
            }
            object = requestSynchronizer;
            synchronized (object) {
                if (bl) {
                    requestSynchronizer.exception = new TimeoutException("No further xaddress to communicate with.");
                } else if (bl2) {
                    requestSynchronizer.exception = new TimeoutException("Authorization Required.");
                } else {
                    switch (message.getType()) {
                        case 3: {
                            requestSynchronizer.exception = new TimeoutException("Device send fault, probably doesn't support directed probing: " + faultMessage);
                            break;
                        }
                        default: {
                            requestSynchronizer.exception = new TimeoutException("Device send fault, probably WSDAPI Device: " + faultMessage);
                        }
                    }
                }
                requestSynchronizer.pending = false;
                requestSynchronizer.notifyAll();
            }
            if (Log.isDebug()) {
                object = faultMessage.getRelatesTo();
                Log.debug("DefaultDeviceReference.CallbackHandler.receivedFault: get, msgId = " + object, 4);
            }
        }

        public void handleMalformedResponseException(Message message, Exception exception, ProtocolData protocolData) {
            Log.warn("DefaultDeviceReference.handleMalformedResponseException: malformed response exception: " + exception + ". Request was: " + message);
            this.handleMalformedResponseOrTimeout(message, "handleMalformedResponseException");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleTransmissionException(Message message, Exception exception, ProtocolData protocolData) {
            Object object;
            boolean bl = false;
            RequestSynchronizer requestSynchronizer = null;
            try {
                object = DefaultDeviceReference.this;
                synchronized (object) {
                    requestSynchronizer = (RequestSynchronizer)DefaultDeviceReference.this.synchronizers.get(message.getMessageId());
                    if (requestSynchronizer == null) {
                        Log.warn("DefaultDeviceReference.handleTransmissionException: no synchronizer found for request message " + message);
                        return;
                    }
                    Log.warn("Transmission error with xaddress " + message.getTargetAddress() + ": " + exception);
                    if (requestSynchronizer == DefaultDeviceReference.this.resolveSynchronizer) {
                        DefaultDeviceReference.this.resolveSynchronizer = null;
                    } else if (requestSynchronizer == DefaultDeviceReference.this.getSynchronizer || requestSynchronizer == DefaultDeviceReference.this.probeSynchronizer) {
                        try {
                            if (this.retransmitRequest(message)) {
                                return;
                            }
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            bl = true;
                        }
                        if (requestSynchronizer == DefaultDeviceReference.this.getSynchronizer) {
                            DefaultDeviceReference.this.getSynchronizer = null;
                        } else {
                            DefaultDeviceReference.this.probeSynchronizer = null;
                        }
                    }
                    DefaultDeviceReference.this.synchronizers.remove(message.getMessageId());
                    DefaultDeviceReference.this.changeProxyReferenceState(5);
                }
            }
            catch (Throwable throwable) {
                Log.warn("Unexpected exception: " + throwable);
            }
            object = requestSynchronizer;
            synchronized (object) {
                requestSynchronizer.exception = bl ? new TimeoutException("No further xaddress to communicate with.") : new TimeoutException("Unable to send request message " + message);
                requestSynchronizer.pending = false;
                requestSynchronizer.notifyAll();
            }
        }

        public void handleTimeout(Message message) {
            this.handleMalformedResponseOrTimeout(message, "handleTimeout");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleMalformedResponseOrTimeout(Message message, String string) {
            Object object;
            boolean bl = false;
            RequestSynchronizer requestSynchronizer = null;
            try {
                object = DefaultDeviceReference.this;
                synchronized (object) {
                    requestSynchronizer = (RequestSynchronizer)DefaultDeviceReference.this.synchronizers.remove(message.getMessageId());
                    if (requestSynchronizer == null) {
                        if (message.getType() == 5) {
                            if (Log.isDebug()) {
                                Log.debug("DefaultDeviceReference." + string + ": no synchronizer found for request message " + message, 4);
                            }
                        } else {
                            Log.warn("DefaultDeviceReference." + string + ": no synchronizer found for request message " + message);
                        }
                        return;
                    }
                    if (requestSynchronizer == DefaultDeviceReference.this.resolveSynchronizer) {
                        DefaultDeviceReference.this.resolveSynchronizer = null;
                    } else if (requestSynchronizer == DefaultDeviceReference.this.getSynchronizer || requestSynchronizer == DefaultDeviceReference.this.probeSynchronizer) {
                        try {
                            if (this.retransmitRequest(message)) {
                                return;
                            }
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            bl = true;
                        }
                        if (requestSynchronizer == DefaultDeviceReference.this.getSynchronizer) {
                            DefaultDeviceReference.this.getSynchronizer = null;
                        } else {
                            DefaultDeviceReference.this.probeSynchronizer = null;
                        }
                    }
                    DefaultDeviceReference.this.synchronizers.remove(message.getMessageId());
                    DefaultDeviceReference.this.changeProxyReferenceState(5);
                }
            }
            catch (Throwable throwable) {
                Log.warn("Unexpected exception: " + throwable);
            }
            object = requestSynchronizer;
            synchronized (object) {
                requestSynchronizer.exception = bl ? new TimeoutException("No further xaddress to communicate with.") : new TimeoutException("Device state unknown, probably offline");
                requestSynchronizer.pending = false;
                requestSynchronizer.notifyAll();
            }
        }

        private boolean retransmitRequest(Message message) {
            XAddressInfo xAddressInfo = message.getTargetXAddressInfo();
            XAddressInfoSet xAddressInfoSet = DefaultDeviceReference.this.discoveryData.getXAddressInfoSet();
            xAddressInfoSet.remove(xAddressInfo);
            if (xAddressInfoSet.size() == 0) {
                DefaultDeviceReference.this.preferredXAddressInfo = null;
                DefaultDeviceReference.this.resolveSynchronizer = null;
            } else if (DefaultDeviceReference.this.preferredXAddressInfo != null && xAddressInfo.equals(DefaultDeviceReference.this.preferredXAddressInfo)) {
                DefaultDeviceReference.this.preferredXAddressInfo = (XAddressInfo)xAddressInfoSet.iterator().next();
                message.setTargetXAddressInfo(DefaultDeviceReference.this.preferredXAddressInfo);
                if (message.getType() == 3) {
                    OutDispatcher.getInstance().send((ProbeMessage)message, DefaultDeviceReference.this.preferredXAddressInfo, (ResponseCallback)this);
                    return true;
                }
                if (message.getType() == 101) {
                    OutDispatcher.getInstance().send((GetMessage)message, DefaultDeviceReference.this.preferredXAddressInfo, (ResponseCallback)this);
                    return true;
                }
                throw new IllegalArgumentException("Unable to retransmit unrecognized message type: " + message);
            }
            return false;
        }
    }
}

