/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.dispatch;

import java.io.IOException;
import org.ws4d.java.DPWSFramework;
import org.ws4d.java.communication.CommunicationManager;
import org.ws4d.java.communication.Discovery;
import org.ws4d.java.communication.ProtocolData;
import org.ws4d.java.communication.ProtocolInfo;
import org.ws4d.java.communication.ResponseCallback;
import org.ws4d.java.communication.TimeoutException;
import org.ws4d.java.dispatch.DeviceServiceRegistry;
import org.ws4d.java.dispatch.MissingMetadataException;
import org.ws4d.java.dispatch.OutDispatcher;
import org.ws4d.java.dispatch.ServiceReferenceEventRegistry;
import org.ws4d.java.dispatch.ServiceReferenceFactory;
import org.ws4d.java.dispatch.ServiceReferenceInternal;
import org.ws4d.java.message.discovery.ResolveMessage;
import org.ws4d.java.message.metadata.GetMetadataMessage;
import org.ws4d.java.service.LocalService;
import org.ws4d.java.service.ProxyFactory;
import org.ws4d.java.service.Service;
import org.ws4d.java.service.reference.DeviceReference;
import org.ws4d.java.structures.ArrayList;
import org.ws4d.java.structures.DataStructure;
import org.ws4d.java.structures.EmptyStructures;
import org.ws4d.java.structures.HashMap;
import org.ws4d.java.structures.HashSet;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.structures.LinkedList;
import org.ws4d.java.structures.List;
import org.ws4d.java.structures.ReadOnlyIterator;
import org.ws4d.java.types.AttributedURI;
import org.ws4d.java.types.EndpointReference;
import org.ws4d.java.types.EndpointReferenceSet;
import org.ws4d.java.types.EprInfo;
import org.ws4d.java.types.EprInfoSet;
import org.ws4d.java.types.HostedMData;
import org.ws4d.java.types.QNameSet;
import org.ws4d.java.types.URI;
import org.ws4d.java.types.URISet;
import org.ws4d.java.types.XAddressInfo;
import org.ws4d.java.util.IDGenerator;
import org.ws4d.java.util.Log;
import org.ws4d.java.wsdl.WSDL;

public class DefaultServiceReference
implements ServiceReferenceInternal {
    private static final int STATE_NEW = 0;
    private static final int STATE_NEEDS_UPDATE = 1;
    private static final int STATE_UP_TO_DATE = 2;
    private static final int SYNC_WAITTIME = 5000;
    private static final int SYNC_WAITRETRY = 5;
    private int currentState = 0;
    private Service service = null;
    private HostedMData hosted = null;
    int hostedBlockVersion = 0;
    List resolvedEprInfos = null;
    List unresolvedEPRs = null;
    int currentXAddressIndex = -1;
    private DeviceReference parentDevRef = null;
    private DataStructure metadataReferences = null;
    private DataStructure metadataLocations = null;
    private DataStructure wsdls = null;
    EprInfo preferredXAddressInfo;
    private int location = 0;
    private boolean secure = false;
    private ServiceReferenceEventRegistry eventAnnouncer = ServiceReferenceEventRegistry.getInstance();
    GetMetadataRequestSynchronizer getMetadataSynchronizer = null;
    ResolveRequestSynchronizer resolveSynchronizer = null;
    HashMap synchronizers = new HashMap();

    protected DefaultServiceReference(HostedMData hostedMData, String string, ProtocolData protocolData) {
        if (DPWSFramework.hasModule(64)) {
            Iterator iterator = hostedMData.getEprInfoSet().iterator();
            while (iterator.hasNext()) {
                URI uRI = ((EprInfo)iterator.next()).getXAddress();
                if (uRI == null || !DPWSFramework.getSecurityManager().isHTTPS(uRI)) continue;
                this.setSecureService(true);
                break;
            }
        }
        this.setHostedFromDevice(hostedMData, string, protocolData);
    }

    protected DefaultServiceReference(EndpointReference endpointReference, String string) {
        this.hosted = new HostedMData();
        EprInfo eprInfo = new EprInfo(endpointReference, string);
        EprInfoSet eprInfoSet = new EprInfoSet();
        eprInfoSet.add(eprInfo);
        this.hosted.setEprInfoSet(eprInfoSet);
        if (eprInfo.getXAddress() != null) {
            this.resolvedEprInfos = new ArrayList();
            this.resolvedEprInfos.add(eprInfo);
            if (DPWSFramework.hasModule(64)) {
                this.secure = DPWSFramework.getSecurityManager().isHTTPS(eprInfo.getXAddress());
            }
        }
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer("DefaultServiceReference [ hosted=");
        stringBuffer.append(this.hosted);
        String string = this.location == 0 ? "unknown" : (this.location == 1 ? "remote" : "local");
        stringBuffer.append(", location=").append(string);
        if (this.location != 2) {
            stringBuffer.append(", address=").append(this.preferredXAddressInfo);
        }
        stringBuffer.append(", service=").append(this.service);
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }

    public Service getService() throws TimeoutException {
        return this.getService(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Service getService(boolean bl) throws TimeoutException {
        GetMetadataRequestSynchronizer getMetadataRequestSynchronizer = null;
        boolean bl2 = false;
        EprInfo eprInfo = null;
        Object object = this;
        synchronized (object) {
            if (this.location == 2) {
                return this.service;
            }
            DeviceServiceRegistry.updateServiceReferenceInGarbageList(this);
            if (!bl || this.currentState == 2) {
                return this.service;
            }
            if (this.getMetadataSynchronizer != null) {
                getMetadataRequestSynchronizer = this.getMetadataSynchronizer;
                bl2 = true;
            } else {
                getMetadataRequestSynchronizer = this.getMetadataSynchronizer = new GetMetadataRequestSynchronizer(this.hostedBlockVersion);
            }
        }
        if (bl2) {
            return this.waitForService(getMetadataRequestSynchronizer);
        }
        eprInfo = (EprInfo)this.getPreferredXAddressInfo();
        Object object2 = this;
        synchronized (object2) {
            object = this.getMetadataSynchronizer;
        }
        if (object != getMetadataRequestSynchronizer) {
            try {
                getMetadataRequestSynchronizer.service = this.getService(true);
            }
            catch (TimeoutException timeoutException) {
                getMetadataRequestSynchronizer.exception = timeoutException;
            }
            object2 = getMetadataRequestSynchronizer;
            synchronized (object2) {
                getMetadataRequestSynchronizer.pending = false;
                getMetadataRequestSynchronizer.notifyAll();
            }
            if (getMetadataRequestSynchronizer.exception != null) {
                throw getMetadataRequestSynchronizer.exception;
            }
            return getMetadataRequestSynchronizer.service;
        }
        object2 = this;
        synchronized (object2) {
            this.synchronizers.put(this.sendGetMetadata(eprInfo).getMessageId(), getMetadataRequestSynchronizer);
        }
        return this.waitForService(getMetadataRequestSynchronizer);
    }

    synchronized Service createProxyServiceFromLocalMetadata() {
        QNameSet qNameSet;
        QNameSet qNameSet2 = qNameSet = this.hosted == null ? null : this.hosted.getTypes();
        if (qNameSet != null && !qNameSet.isEmpty()) {
            try {
                ProxyFactory proxyFactory = DPWSFramework.getProxyFactory();
                this.service = proxyFactory.createProxyService(this, null);
                URI uRI = this.hosted.getServiceId();
                if (uRI == null) {
                    uRI = IDGenerator.getUUIDasURI();
                    this.hosted.setServiceId(uRI);
                }
                this.eventAnnouncer.announceServiceCreated(this, this.service);
                return this.service;
            }
            catch (MissingMetadataException missingMetadataException) {
            }
            catch (IOException iOException) {
                Log.error("Cannot create service proxy from local metadata. " + iOException.getMessage());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildUpService() {
        GetMetadataRequestSynchronizer getMetadataRequestSynchronizer;
        DefaultServiceReference defaultServiceReference = this;
        synchronized (defaultServiceReference) {
            if (this.getMetadataSynchronizer != null) {
                return;
            }
            getMetadataRequestSynchronizer = this.getMetadataSynchronizer = new GetMetadataRequestSynchronizer(this.hostedBlockVersion);
        }
        this.buildUpService(getMetadataRequestSynchronizer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildUpService(final GetMetadataRequestSynchronizer getMetadataRequestSynchronizer) {
        EprInfo eprInfo = null;
        DefaultServiceReference defaultServiceReference = this;
        synchronized (defaultServiceReference) {
            if (this.getMetadataSynchronizer != getMetadataRequestSynchronizer) {
                return;
            }
            eprInfo = this.preferredXAddressInfo;
            if (eprInfo != null) {
                this.synchronizers.put(this.sendGetMetadata(eprInfo).getMessageId(), getMetadataRequestSynchronizer);
                return;
            }
        }
        DPWSFramework.getThreadPool().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block9: {
                    try {
                        EprInfo eprInfo = (EprInfo)DefaultServiceReference.this.getPreferredXAddressInfo();
                        boolean bl = true;
                        Object object = DefaultServiceReference.this;
                        synchronized (object) {
                            if (getMetadataRequestSynchronizer == DefaultServiceReference.this.getMetadataSynchronizer) {
                                DefaultServiceReference.this.synchronizers.put(DefaultServiceReference.this.sendGetMetadata(eprInfo).getMessageId(), getMetadataRequestSynchronizer);
                                bl = false;
                            }
                        }
                        if (!bl) break block9;
                        object = getMetadataRequestSynchronizer;
                        synchronized (object) {
                            getMetadataRequestSynchronizer.pending = false;
                            getMetadataRequestSynchronizer.notifyAll();
                        }
                    }
                    catch (TimeoutException timeoutException) {
                        Log.warn("Unablte to resolve remote service: " + timeoutException.getMessage());
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Service waitForService(GetMetadataRequestSynchronizer getMetadataRequestSynchronizer) throws TimeoutException {
        while (true) {
            Object object = getMetadataRequestSynchronizer;
            synchronized (object) {
                int n = 0;
                while (getMetadataRequestSynchronizer.pending) {
                    try {
                        getMetadataRequestSynchronizer.wait(5000L);
                        if (++n < 5) continue;
                        throw new TimeoutException("Service has not send an answer within 25000ms.");
                    }
                    catch (InterruptedException interruptedException) {
                        Log.printStackTrace(interruptedException);
                    }
                }
                if (getMetadataRequestSynchronizer.exception != null) {
                    throw getMetadataRequestSynchronizer.exception;
                }
                if (getMetadataRequestSynchronizer.service != null) {
                    return getMetadataRequestSynchronizer.service;
                }
            }
            object = this;
            synchronized (object) {
                if (this.currentState == 2) {
                    return this.service;
                }
                if (this.getMetadataSynchronizer == null) {
                    throw new TimeoutException("Unknown communication error with service.");
                }
                getMetadataRequestSynchronizer = this.getMetadataSynchronizer;
            }
        }
    }

    GetMetadataMessage sendGetMetadata(EprInfo eprInfo) {
        GetMetadataMessage getMetadataMessage = new GetMetadataMessage(eprInfo.getComManId());
        getMetadataMessage.getHeader().setEndpointReference(eprInfo.getEndpointReference());
        getMetadataMessage.setTargetXAddressInfo(eprInfo);
        ProtocolInfo protocolInfo = eprInfo.getProtocolInfo();
        if (protocolInfo == null && this.parentDevRef != null) {
            protocolInfo = this.parentDevRef.getPreferredXAddressInfo().getProtocolInfo();
        }
        getMetadataMessage.setProtocolInfo(protocolInfo);
        ResponseCallback responseCallback = ServiceReferenceFactory.getInstance().newResponseCallbackForServiceReference(this, eprInfo);
        OutDispatcher.getInstance().send(getMetadataMessage, (XAddressInfo)eprInfo, responseCallback);
        return getMetadataMessage;
    }

    private ResolveMessage sendResolve(EndpointReference endpointReference) {
        ResolveMessage resolveMessage = new ResolveMessage(CommunicationManager.ID_NULL);
        resolveMessage.setEndpointReference(endpointReference);
        ResponseCallback responseCallback = ServiceReferenceFactory.getInstance().newResponseCallbackForServiceReference(this, null);
        OutDispatcher.getInstance().send(resolveMessage, null, Discovery.getDefaultOutputDomains(), responseCallback);
        return resolveMessage;
    }

    public synchronized Service setService(LocalService localService, HostedMData hostedMData) {
        Service service = this.service;
        this.service = localService;
        if (localService != null) {
            this.hosted = hostedMData;
            if (this.location == 0) {
                this.location = 2;
            }
            this.eventAnnouncer.announceServiceCreated(this, localService);
        } else {
            this.eventAnnouncer.announceServiceDisposed(this);
        }
        return service;
    }

    public Service rebuildService() throws TimeoutException {
        this.reset();
        return this.getService();
    }

    public synchronized void reset() {
        if (this.location == 2) {
            Log.warn("DefaultServiceReference.reset: Not allowed to reset references to local services!");
            return;
        }
        if (this.hosted != null) {
            this.hosted.setServiceId(null);
            this.hosted.setTypes(null);
        }
        this.hostedBlockVersion = 0;
        this.resolvedEprInfos = null;
        this.currentXAddressIndex = -1;
        this.unresolvedEPRs = null;
        this.currentState = 1;
        this.parentDevRef = null;
        this.metadataReferences = null;
        this.metadataLocations = null;
        this.wsdls = null;
        this.preferredXAddressInfo = null;
        this.location = 0;
        this.secure = false;
        DeviceServiceRegistry.addServiceReferenceToGarbageList(this);
        if (this.service != null) {
            this.service = null;
            this.eventAnnouncer.announceServiceDisposed(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(HostedMData hostedMData, DeviceReference deviceReference, ProtocolData protocolData) {
        DefaultServiceReference defaultServiceReference = this;
        synchronized (defaultServiceReference) {
            if (hostedMData == this.hosted) {
                this.parentDevRef = deviceReference;
                return;
            }
            if (this.location == 2) {
                Log.error("ServiceReferenceHandler.update: location is local");
                return;
            }
            this.location = 1;
            this.parentDevRef = deviceReference;
            DeviceServiceRegistry.updateServiceReferenceRegistration(hostedMData, this);
        }
        if (!hostedMData.getServiceId().equals(this.hosted.getServiceId())) {
            Log.info("ServiceReferenceHandler.update: Updating a service reference with a different service id: " + hostedMData.getServiceId());
        }
        this.setHostedFromDevice(hostedMData, protocolData.getCommunicationManagerId(), protocolData);
    }

    public synchronized void disconnectFromDevice() {
        if (this.parentDevRef != null) {
            this.parentDevRef = null;
            DeviceServiceRegistry.addServiceReferenceToGarbageList(this);
        }
    }

    public synchronized Iterator getPortTypes() {
        QNameSet qNameSet = this.hosted.getTypes();
        return qNameSet == null ? EmptyStructures.EMPTY_ITERATOR : new ReadOnlyIterator(qNameSet.iterator());
    }

    public synchronized int getPortTypeCount() {
        QNameSet qNameSet = this.hosted.getTypes();
        return qNameSet == null ? 0 : qNameSet.size();
    }

    public synchronized boolean containsAllPortTypes(QNameSet qNameSet) {
        QNameSet qNameSet2;
        if (qNameSet == null || qNameSet.size() == 0) {
            return true;
        }
        QNameSet qNameSet3 = qNameSet2 = this.hosted == null ? null : this.hosted.getTypes();
        if (qNameSet2 == null) {
            return false;
        }
        if (qNameSet.size() > qNameSet2.size()) {
            return false;
        }
        return qNameSet2.containsAll(qNameSet);
    }

    public synchronized int getLocation() {
        return this.location;
    }

    public synchronized void setLocation(int n) {
        this.location = n;
    }

    public synchronized Iterator getEprInfos() {
        EprInfoSet eprInfoSet = this.hosted.getEprInfoSet();
        return eprInfoSet == null ? EmptyStructures.EMPTY_ITERATOR : new ReadOnlyIterator(eprInfoSet.iterator());
    }

    public synchronized URI getServiceId() {
        return this.hosted.getServiceId();
    }

    public synchronized Iterator getMetadataReferences() {
        return this.metadataReferences == null ? EmptyStructures.EMPTY_ITERATOR : new ReadOnlyIterator(this.metadataReferences);
    }

    public synchronized Iterator getMetadataLocations() {
        return this.metadataLocations == null ? EmptyStructures.EMPTY_ITERATOR : new ReadOnlyIterator(this.metadataLocations);
    }

    public synchronized Iterator getWSDLs() {
        return this.wsdls == null ? EmptyStructures.EMPTY_ITERATOR : new ReadOnlyIterator(this.wsdls);
    }

    public synchronized URI getPreferredXAddress() throws TimeoutException {
        return this.getPreferredXAddressInfo().getXAddress();
    }

    public synchronized String getPreferredCommunicationManagerID() throws TimeoutException {
        return this.getPreferredXAddressInfo().getComManId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XAddressInfo getPreferredXAddressInfo() throws TimeoutException {
        ResolveRequestSynchronizer resolveRequestSynchronizer;
        Object object = this;
        synchronized (object) {
            if (this.preferredXAddressInfo != null) {
                return this.preferredXAddressInfo;
            }
            if (this.resolvedEprInfos != null && this.currentXAddressIndex < this.resolvedEprInfos.size() - 1) {
                this.preferredXAddressInfo = (EprInfo)this.resolvedEprInfos.get(++this.currentXAddressIndex);
                return this.preferredXAddressInfo;
            }
            resolveRequestSynchronizer = this.resolveSynchronizer;
            if (resolveRequestSynchronizer == null) {
                if (this.unresolvedEPRs == null || this.unresolvedEPRs.size() == 0) {
                    if (this.hosted != null) {
                        Iterator iterator = this.hosted.getEprInfoSet().iterator();
                        while (iterator.hasNext()) {
                            EprInfo eprInfo = (EprInfo)iterator.next();
                            EndpointReference endpointReference = eprInfo.getEndpointReference();
                            if (!endpointReference.getAddress().isURN() && eprInfo.getXAddress() != null) continue;
                            if (this.unresolvedEPRs == null) {
                                this.unresolvedEPRs = new LinkedList();
                            }
                            this.unresolvedEPRs.add(endpointReference);
                        }
                    }
                    this.currentXAddressIndex = -1;
                    throw new TimeoutException("No more options to obtain transport address for service.");
                }
                resolveRequestSynchronizer = this.resolveSynchronizer = new ResolveRequestSynchronizer(this.hostedBlockVersion);
                this.synchronizers.put(this.sendResolve((EndpointReference)this.unresolvedEPRs.remove(0)).getMessageId(), resolveRequestSynchronizer);
            }
        }
        while (true) {
            object = resolveRequestSynchronizer;
            synchronized (object) {
                while (resolveRequestSynchronizer.pending) {
                    try {
                        resolveRequestSynchronizer.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Log.printStackTrace(interruptedException);
                    }
                }
                if (resolveRequestSynchronizer.exception != null) {
                    throw resolveRequestSynchronizer.exception;
                }
                if (resolveRequestSynchronizer.xAddress != null) {
                    return resolveRequestSynchronizer.xAddress;
                }
            }
            object = this;
            synchronized (object) {
                if (this.preferredXAddressInfo != null) {
                    return this.preferredXAddressInfo;
                }
                if (this.resolveSynchronizer == null) {
                    break;
                }
                resolveRequestSynchronizer = this.resolveSynchronizer;
            }
        }
        return this.getPreferredXAddressInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XAddressInfo getNextXAddressInfoAfterFailure(URI uRI) throws TimeoutException {
        DefaultServiceReference defaultServiceReference = this;
        synchronized (defaultServiceReference) {
            URI uRI2;
            if (this.preferredXAddressInfo != null && uRI.equals(uRI2 = this.preferredXAddressInfo.getXAddress())) {
                this.preferredXAddressInfo = null;
            }
        }
        return this.getPreferredXAddressInfo();
    }

    public synchronized void setParentDeviceReference(DeviceReference deviceReference) {
        this.parentDevRef = deviceReference;
    }

    public synchronized DeviceReference getParentDeviceRef() {
        return this.parentDevRef;
    }

    public synchronized boolean isServiceObjectExisting() {
        return this.service != null;
    }

    public synchronized boolean isSecureService() {
        return this.secure;
    }

    synchronized void setSecureService(boolean bl) {
        this.secure = bl;
    }

    void checkAndUpdateService(ProtocolData protocolData) throws MissingMetadataException {
        try {
            ProxyFactory proxyFactory = DPWSFramework.getProxyFactory();
            if (this.service == null) {
                Service service;
                this.service = service = proxyFactory.createProxyService(this, protocolData);
                this.currentState = 2;
                ServiceReferenceEventRegistry.getInstance().announceServiceCreated(this, service);
            } else if (this.currentState == 1) {
                QNameSet qNameSet = this.hosted.getTypes();
                if (qNameSet != null) {
                    this.currentState = 2;
                    if (proxyFactory.checkServiceUpdate(this.service, qNameSet)) {
                        this.eventAnnouncer.announceServiceChanged(this, this.service);
                    }
                } else {
                    this.currentState = 2;
                }
            }
        }
        catch (IOException iOException) {
            Log.error(iOException.getMessage());
        }
    }

    private synchronized void setHostedFromDevice(HostedMData hostedMData, String string, ProtocolData protocolData) {
        if (hostedMData.isEqualTo(this.hosted)) {
            return;
        }
        this.checkPortTypeIncompatibilityAndUpdate(hostedMData);
        this.hosted = hostedMData;
        this.resetTransportAddresses(string, protocolData);
    }

    public synchronized void setHostedFromService(HostedMData hostedMData, String string, ProtocolData protocolData) {
        if (hostedMData.isEqualTo(this.hosted)) {
            return;
        }
        if (this.hosted == null) {
            this.hosted = hostedMData;
            this.currentState = 1;
        } else if (this.checkPortTypeIncompatibilityAndUpdate(hostedMData)) {
            this.hosted = hostedMData;
            this.resetTransportAddresses(string, protocolData);
        } else {
            EprInfoSet eprInfoSet = this.hosted.getEprInfoSet();
            this.hosted = hostedMData;
            Iterator iterator = hostedMData.getEprInfoSet().iterator();
            block0: while (iterator.hasNext()) {
                EprInfo eprInfo = (EprInfo)iterator.next();
                if (eprInfoSet.contains(eprInfo)) continue;
                EndpointReference endpointReference = eprInfo.getEndpointReference();
                AttributedURI attributedURI = endpointReference.getAddress();
                if (attributedURI.isURN() || eprInfo.getXAddress() == null) {
                    if (this.unresolvedEPRs == null) {
                        this.unresolvedEPRs = new LinkedList();
                    }
                    if (this.unresolvedEPRs.contains(endpointReference)) continue;
                    this.unresolvedEPRs.add(endpointReference);
                    continue;
                }
                if (this.resolvedEprInfos == null) {
                    this.resolvedEprInfos = new ArrayList();
                }
                Iterator iterator2 = this.resolvedEprInfos.iterator();
                while (iterator2.hasNext()) {
                    EprInfo eprInfo2 = (EprInfo)iterator2.next();
                    if (!eprInfo2.getXAddress().equals(attributedURI)) continue;
                    continue block0;
                }
                this.resolvedEprInfos.add(eprInfo);
            }
        }
    }

    private boolean checkPortTypeIncompatibilityAndUpdate(HostedMData hostedMData) {
        QNameSet qNameSet = hostedMData.getTypes();
        if (this.hosted != null && (this.hosted.getTypes() != null && qNameSet == null || qNameSet != null && !qNameSet.containsAll(this.hosted.getTypes()))) {
            this.service = null;
            this.currentState = 1;
            this.eventAnnouncer.announceServiceDisposed(this);
            return true;
        }
        QNameSet qNameSet2 = this.hosted == null ? null : this.hosted.getTypes();
        int n = qNameSet2 == null ? 0 : qNameSet2.size();
        if (n < (qNameSet == null ? 0 : qNameSet.size())) {
            this.currentState = 1;
        }
        return false;
    }

    private void resetTransportAddresses(String string, ProtocolData protocolData) {
        ++this.hostedBlockVersion;
        this.currentXAddressIndex = -1;
        this.resolvedEprInfos = null;
        this.unresolvedEPRs = null;
        this.resolveSynchronizer = null;
        this.getMetadataSynchronizer = null;
        Iterator iterator = this.hosted.getEprInfoSet().iterator();
        while (iterator.hasNext()) {
            EprInfo eprInfo = (EprInfo)iterator.next();
            AttributedURI attributedURI = eprInfo.getEndpointReference().getAddress();
            if (attributedURI.isURN() || eprInfo.getXAddress() == null) {
                if (this.unresolvedEPRs == null) {
                    this.unresolvedEPRs = new LinkedList();
                }
                this.unresolvedEPRs.add(eprInfo.getEndpointReference());
                continue;
            }
            if (this.resolvedEprInfos == null) {
                this.resolvedEprInfos = new ArrayList();
            }
            if (protocolData != null && protocolData.sourceMatches(attributedURI)) {
                this.resolvedEprInfos.add(0, eprInfo);
                continue;
            }
            this.resolvedEprInfos.add(eprInfo);
        }
    }

    public synchronized void setMetaDataLocations(URISet uRISet) {
        if (this.metadataLocations == null) {
            this.metadataLocations = new HashSet();
        } else {
            this.metadataLocations.clear();
        }
        if (uRISet != null) {
            Iterator iterator = uRISet.iterator();
            while (iterator.hasNext()) {
                URI uRI = (URI)iterator.next();
                this.metadataLocations.add(uRI);
            }
        }
    }

    public synchronized void setMetadataReferences(EndpointReferenceSet endpointReferenceSet) {
        if (this.metadataReferences == null) {
            this.metadataReferences = new HashSet();
        } else {
            this.metadataReferences.clear();
        }
        if (endpointReferenceSet != null) {
            Iterator iterator = endpointReferenceSet.iterator();
            while (iterator.hasNext()) {
                EndpointReference endpointReference = (EndpointReference)iterator.next();
                this.metadataReferences.add(endpointReference);
            }
        }
    }

    public synchronized void setWSDLs(DataStructure dataStructure) {
        if (this.wsdls == null) {
            this.wsdls = new HashSet();
        } else {
            this.wsdls.clear();
        }
        if (dataStructure != null) {
            Iterator iterator = dataStructure.iterator();
            while (iterator.hasNext()) {
                WSDL wSDL = (WSDL)iterator.next();
                this.wsdls.add(wSDL);
            }
        }
    }

    static class GetMetadataRequestSynchronizer
    extends RequestSynchronizer {
        Service service;

        GetMetadataRequestSynchronizer(int n) {
            super(n);
        }
    }

    static class ResolveRequestSynchronizer
    extends RequestSynchronizer {
        EprInfo xAddress;

        ResolveRequestSynchronizer(int n) {
            super(n);
        }
    }

    static class RequestSynchronizer {
        final int hostedBlockVersion;
        TimeoutException exception;
        volatile boolean pending = true;

        RequestSynchronizer(int n) {
            this.hostedBlockVersion = n;
        }
    }
}

