/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.dispatch;

import org.ws4d.java.communication.CommunicationManager;
import org.ws4d.java.communication.DefaultResponseCallback;
import org.ws4d.java.communication.Discovery;
import org.ws4d.java.communication.ProtocolData;
import org.ws4d.java.communication.ProtocolInfo;
import org.ws4d.java.communication.ResponseCallback;
import org.ws4d.java.communication.TimeoutException;
import org.ws4d.java.dispatch.DefaultServiceReference;
import org.ws4d.java.dispatch.DeviceServiceRegistry;
import org.ws4d.java.dispatch.MissingMetadataException;
import org.ws4d.java.dispatch.OutDispatcher;
import org.ws4d.java.message.FaultMessage;
import org.ws4d.java.message.Message;
import org.ws4d.java.message.discovery.ResolveMatch;
import org.ws4d.java.message.discovery.ResolveMatchesMessage;
import org.ws4d.java.message.discovery.ResolveMessage;
import org.ws4d.java.message.metadata.GetMetadataMessage;
import org.ws4d.java.message.metadata.GetMetadataResponseMessage;
import org.ws4d.java.service.Service;
import org.ws4d.java.structures.ArrayList;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.types.EndpointReference;
import org.ws4d.java.types.EprInfo;
import org.ws4d.java.types.HostedMData;
import org.ws4d.java.types.URI;
import org.ws4d.java.types.UnknownDataContainer;
import org.ws4d.java.types.XAddressInfo;
import org.ws4d.java.types.XAddressInfoSet;
import org.ws4d.java.util.Log;

public class DefaultServiceReferenceCallback
extends DefaultResponseCallback {
    protected final DefaultServiceReference servRef;

    public DefaultServiceReferenceCallback(DefaultServiceReference defaultServiceReference, XAddressInfo xAddressInfo) {
        super(xAddressInfo);
        this.servRef = defaultServiceReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(Message message, ResolveMatchesMessage resolveMatchesMessage, ProtocolData protocolData) {
        Object object;
        DefaultServiceReference.ResolveRequestSynchronizer resolveRequestSynchronizer = null;
        try {
            object = this.servRef;
            synchronized (object) {
                resolveRequestSynchronizer = (DefaultServiceReference.ResolveRequestSynchronizer)this.servRef.synchronizers.remove(message.getMessageId());
                if (resolveRequestSynchronizer == null) {
                    Log.warn("Ignoring unexpected ResolveMatches message " + resolveMatchesMessage);
                    return;
                }
                if (resolveRequestSynchronizer.hostedBlockVersion == this.servRef.hostedBlockVersion) {
                    ResolveMatch resolveMatch;
                    XAddressInfoSet xAddressInfoSet;
                    XAddressInfo xAddressInfo = this.getTargetAddress();
                    if (xAddressInfo != null) {
                        xAddressInfo.mergeProtocolInfo(protocolData.getProtocolInfo());
                    }
                    if ((xAddressInfoSet = (resolveMatch = resolveMatchesMessage.getResolveMatch()).getXAddressInfoSet()) != null) {
                        EndpointReference endpointReference = resolveMatch.getEndpointReference();
                        String string = protocolData.getCommunicationManagerId();
                        Iterator iterator = xAddressInfoSet.iterator();
                        block8: while (iterator.hasNext()) {
                            XAddressInfo xAddressInfo2 = (XAddressInfo)iterator.next();
                            URI uRI = xAddressInfo2.getXAddress();
                            if (this.servRef.resolvedEprInfos == null) {
                                this.servRef.resolvedEprInfos = new ArrayList(xAddressInfoSet.size());
                                while (true) {
                                    if (protocolData.sourceMatches(uRI)) {
                                        this.servRef.resolvedEprInfos.add(0, new EprInfo(endpointReference, uRI, string, protocolData.getProtocolInfo()));
                                    } else {
                                        this.servRef.resolvedEprInfos.add(new EprInfo(endpointReference, uRI, string, protocolData.getProtocolInfo()));
                                    }
                                    if (!iterator.hasNext()) break;
                                    xAddressInfo2 = (XAddressInfo)iterator.next();
                                    uRI = xAddressInfo2.getXAddress();
                                }
                                this.servRef.currentXAddressIndex = -1;
                                break;
                            }
                            Iterator iterator2 = this.servRef.resolvedEprInfos.iterator();
                            while (iterator2.hasNext()) {
                                EprInfo eprInfo = (EprInfo)iterator2.next();
                                if (!eprInfo.getXAddress().equals(uRI)) continue;
                                continue block8;
                            }
                            if (protocolData.sourceMatches(uRI)) {
                                this.servRef.resolvedEprInfos.add(this.servRef.currentXAddressIndex, new EprInfo(endpointReference, uRI, string, protocolData.getProtocolInfo()));
                                continue;
                            }
                            this.servRef.resolvedEprInfos.add(new EprInfo(endpointReference, uRI, string, protocolData.getProtocolInfo()));
                        }
                        if (this.servRef.resolvedEprInfos == null || this.servRef.currentXAddressIndex >= this.servRef.resolvedEprInfos.size() - 1) {
                            if (this.maybeSendNextResolve(resolveRequestSynchronizer, protocolData.getProtocolInfo())) {
                                return;
                            }
                        } else {
                            resolveRequestSynchronizer.xAddress = this.servRef.preferredXAddressInfo = (EprInfo)this.servRef.resolvedEprInfos.get(++this.servRef.currentXAddressIndex);
                        }
                    }
                } else if (Log.isDebug()) {
                    Log.debug("Concurrent service update detected.", 4);
                }
                if (resolveRequestSynchronizer == this.servRef.resolveSynchronizer) {
                    this.servRef.resolveSynchronizer = null;
                }
            }
        }
        catch (Throwable throwable) {
            resolveRequestSynchronizer.exception = new TimeoutException("Unexpected exception during resolve matches processing: " + throwable);
        }
        object = resolveRequestSynchronizer;
        synchronized (object) {
            resolveRequestSynchronizer.pending = false;
            resolveRequestSynchronizer.notifyAll();
        }
    }

    private boolean maybeSendNextResolve(DefaultServiceReference.ResolveRequestSynchronizer resolveRequestSynchronizer, ProtocolInfo protocolInfo) {
        if (this.servRef.unresolvedEPRs != null && this.servRef.unresolvedEPRs.size() > 0) {
            EndpointReference endpointReference = (EndpointReference)this.servRef.unresolvedEPRs.remove(0);
            ResolveMessage resolveMessage = new ResolveMessage(CommunicationManager.ID_NULL);
            this.servRef.synchronizers.put(resolveMessage.getMessageId(), resolveRequestSynchronizer);
            resolveMessage.setProtocolInfo(protocolInfo);
            resolveMessage.setEndpointReference(endpointReference);
            OutDispatcher.getInstance().send(resolveMessage, null, Discovery.getDefaultOutputDomains(), (ResponseCallback)this);
            return true;
        }
        resolveRequestSynchronizer.exception = new TimeoutException("No more options to obtain transport address for service.");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(Message message, GetMetadataResponseMessage getMetadataResponseMessage, ProtocolData protocolData) {
        DefaultServiceReference defaultServiceReference;
        DefaultServiceReference.GetMetadataRequestSynchronizer getMetadataRequestSynchronizer = null;
        try {
            defaultServiceReference = this.servRef;
            synchronized (defaultServiceReference) {
                if (this.servRef.getLocation() == 2) {
                    Log.error("Received GetMetadataResponse message for a local reference");
                    return;
                }
                this.servRef.setLocation(1);
                getMetadataRequestSynchronizer = (DefaultServiceReference.GetMetadataRequestSynchronizer)this.servRef.synchronizers.remove(message.getMessageId());
                if (getMetadataRequestSynchronizer == null) {
                    Log.warn("Ignoring unexpected GetMetadataResponse message " + getMetadataResponseMessage);
                    return;
                }
                if (getMetadataRequestSynchronizer.hostedBlockVersion == this.servRef.hostedBlockVersion) {
                    UnknownDataContainer unknownDataContainer;
                    this.getTargetAddress().mergeProtocolInfo(protocolData.getProtocolInfo());
                    if (getMetadataResponseMessage.getHost() != null && (unknownDataContainer = getMetadataResponseMessage.getHost().getEndpointReference()) != null) {
                        this.servRef.setParentDeviceReference(DeviceServiceRegistry.getDeviceReference(unknownDataContainer));
                    }
                    this.servRef.setMetadataReferences(getMetadataResponseMessage.getMetadataReferences());
                    this.servRef.setMetaDataLocations(getMetadataResponseMessage.getMetadataLocations());
                    this.servRef.setWSDLs(getMetadataResponseMessage.getWSDLs());
                    unknownDataContainer = getMetadataResponseMessage.getHosted(message.getTo());
                    if (unknownDataContainer == null) {
                        Service service = this.servRef.createProxyServiceFromLocalMetadata();
                        if (service == null) {
                            getMetadataRequestSynchronizer.exception = new TimeoutException("No Hosted block within GetMetadataResponse: " + getMetadataResponseMessage);
                        } else {
                            getMetadataRequestSynchronizer.service = service;
                            Log.warn("Proxy service created from local metadata because no Hosted block was found within GetMetadataResponse: " + getMetadataResponseMessage);
                        }
                    } else {
                        DeviceServiceRegistry.updateServiceReferenceRegistration((HostedMData)unknownDataContainer, this.servRef);
                        this.servRef.setHostedFromService((HostedMData)unknownDataContainer, protocolData.getCommunicationManagerId(), protocolData);
                        try {
                            this.servRef.checkAndUpdateService(protocolData);
                        }
                        catch (MissingMetadataException missingMetadataException) {
                            getMetadataRequestSynchronizer.exception = new TimeoutException("Unable to create service proxy: " + missingMetadataException);
                        }
                    }
                } else if (Log.isDebug()) {
                    Log.debug("Concurrent service update detected, rebuilding service proxy", 4);
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            getMetadataRequestSynchronizer.exception = new TimeoutException("Unexpected exception during get metadata response processing: " + throwable);
        }
        defaultServiceReference = getMetadataRequestSynchronizer;
        synchronized (defaultServiceReference) {
            getMetadataRequestSynchronizer.pending = false;
            getMetadataRequestSynchronizer.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(Message message, FaultMessage faultMessage, ProtocolData protocolData) {
        Object object;
        if (message.getType() != 201) {
            Log.warn("DefaultDeviceReferenceCallback.handle(FaultMessage): unexpected fault message " + faultMessage + ", request was " + message);
            return;
        }
        DefaultServiceReference.RequestSynchronizer requestSynchronizer = null;
        boolean bl = false;
        try {
            object = this.servRef;
            synchronized (object) {
                requestSynchronizer = (DefaultServiceReference.RequestSynchronizer)this.servRef.synchronizers.get(message.getMessageId());
                if (requestSynchronizer == null) {
                    Log.warn("No synchronizer found for request message " + message);
                    return;
                }
                this.getTargetAddress().mergeProtocolInfo(protocolData.getProtocolInfo());
                Log.error("Get metadata request leads to fault message: " + faultMessage);
                boolean bl2 = bl = requestSynchronizer.hostedBlockVersion == this.servRef.hostedBlockVersion;
                if (!bl) {
                    this.servRef.synchronizers.remove(message.getMessageId());
                }
            }
            if (bl) {
                object = this.servRef.getNextXAddressInfoAfterFailure(message.getTargetAddress());
                message.setTargetXAddressInfo((XAddressInfo)object);
                OutDispatcher.getInstance().send((GetMetadataMessage)message, (XAddressInfo)object, (ResponseCallback)this);
            } else {
                requestSynchronizer.exception = new TimeoutException("Get metadata request leads to fault message: " + faultMessage);
            }
        }
        catch (Throwable throwable) {
            requestSynchronizer.exception = new TimeoutException("Exception occured during fault processing: " + throwable);
        }
        object = requestSynchronizer;
        synchronized (object) {
            requestSynchronizer.pending = false;
            requestSynchronizer.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMalformedResponseException(Message message, Exception exception, ProtocolData protocolData) {
        Object object;
        if (this.causedByResolve(message)) {
            return;
        }
        if (message.getType() != 201) {
            Log.warn("Unexpected malformed response, request was " + message);
        }
        DefaultServiceReference.RequestSynchronizer requestSynchronizer = null;
        boolean bl = false;
        try {
            object = this.servRef;
            synchronized (object) {
                requestSynchronizer = (DefaultServiceReference.RequestSynchronizer)this.servRef.synchronizers.get(message.getMessageId());
                if (requestSynchronizer == null) {
                    Log.warn("No synchronizer found for request message " + message);
                    return;
                }
                Log.error("Get metadata request leads to an exception: " + exception);
                boolean bl2 = bl = requestSynchronizer.hostedBlockVersion == this.servRef.hostedBlockVersion;
                if (!bl) {
                    this.servRef.synchronizers.remove(message.getMessageId());
                }
            }
            if (bl) {
                object = this.servRef.getNextXAddressInfoAfterFailure(message.getTargetAddress());
                message.setTargetXAddressInfo((XAddressInfo)object);
                OutDispatcher.getInstance().send((GetMetadataMessage)message, (XAddressInfo)object, (ResponseCallback)this);
            } else {
                requestSynchronizer.exception = new TimeoutException("Get metadata request leads to an exception: " + exception);
            }
        }
        catch (Throwable throwable) {
            if (requestSynchronizer instanceof DefaultServiceReference.GetMetadataRequestSynchronizer) {
                DefaultServiceReference.GetMetadataRequestSynchronizer getMetadataRequestSynchronizer = (DefaultServiceReference.GetMetadataRequestSynchronizer)requestSynchronizer;
                Service service = this.servRef.createProxyServiceFromLocalMetadata();
                if (service != null) {
                    getMetadataRequestSynchronizer.service = service;
                } else {
                    requestSynchronizer.exception = new TimeoutException("Exception occured during malformed response processing: " + throwable);
                }
            }
            requestSynchronizer.exception = new TimeoutException("Exception occured during malformed response processing: " + throwable);
        }
        object = requestSynchronizer;
        synchronized (object) {
            requestSynchronizer.pending = false;
            requestSynchronizer.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleTransmissionException(Message message, Exception exception, ProtocolData protocolData) {
        Object object;
        if (this.causedByResolve(message)) {
            return;
        }
        if (message.getType() != 201) {
            Log.warn("Unexpected transmission exception, request was " + message);
            return;
        }
        DefaultServiceReference.RequestSynchronizer requestSynchronizer = null;
        boolean bl = false;
        try {
            object = this.servRef;
            synchronized (object) {
                requestSynchronizer = (DefaultServiceReference.RequestSynchronizer)this.servRef.synchronizers.get(message.getMessageId());
                if (requestSynchronizer == null) {
                    Log.warn("No synchronizer found for request message " + message);
                    return;
                }
                Log.error("Get metadata request leads to transmission exception: " + exception);
                boolean bl2 = bl = requestSynchronizer.hostedBlockVersion == this.servRef.hostedBlockVersion;
                if (!bl) {
                    this.servRef.synchronizers.remove(message.getMessageId());
                }
            }
            if (bl) {
                object = this.servRef.getNextXAddressInfoAfterFailure(message.getTargetAddress());
                message.setTargetXAddressInfo((XAddressInfo)object);
                OutDispatcher.getInstance().send((GetMetadataMessage)message, (XAddressInfo)object, (ResponseCallback)this);
            } else {
                requestSynchronizer.exception = new TimeoutException("Get metadata request leads to transmission exception: " + exception);
            }
        }
        catch (Throwable throwable) {
            requestSynchronizer.exception = new TimeoutException("Exception occured during transmission exception processing: " + throwable);
        }
        object = requestSynchronizer;
        synchronized (object) {
            requestSynchronizer.pending = false;
            requestSynchronizer.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleTimeout(Message message) {
        Object object;
        if (this.causedByResolve(message)) {
            return;
        }
        if (message.getType() != 201) {
            Log.warn("Unexpected timeout, request was " + message);
            return;
        }
        DefaultServiceReference.RequestSynchronizer requestSynchronizer = null;
        boolean bl = false;
        try {
            object = this.servRef;
            synchronized (object) {
                requestSynchronizer = (DefaultServiceReference.RequestSynchronizer)this.servRef.synchronizers.get(message.getMessageId());
                if (requestSynchronizer == null) {
                    Log.warn("No synchronizer found for request message " + message);
                    return;
                }
                Log.error("Get metadata request timeout.");
                boolean bl2 = bl = requestSynchronizer.hostedBlockVersion == this.servRef.hostedBlockVersion;
                if (!bl) {
                    this.servRef.synchronizers.remove(message.getMessageId());
                }
            }
            if (bl) {
                object = this.servRef.getNextXAddressInfoAfterFailure(message.getTargetAddress());
                message.setTargetXAddressInfo((XAddressInfo)object);
                OutDispatcher.getInstance().send((GetMetadataMessage)message, (XAddressInfo)object, (ResponseCallback)this);
            } else {
                requestSynchronizer.exception = new TimeoutException("Get metadata request timeout.");
            }
        }
        catch (Throwable throwable) {
            requestSynchronizer.exception = new TimeoutException("Exception occured during timeout processing: " + throwable);
        }
        object = requestSynchronizer;
        synchronized (object) {
            requestSynchronizer.pending = false;
            requestSynchronizer.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean causedByResolve(Message message) {
        if (message.getType() == 5) {
            DefaultServiceReference.ResolveRequestSynchronizer resolveRequestSynchronizer;
            Object object = this.servRef;
            synchronized (object) {
                resolveRequestSynchronizer = (DefaultServiceReference.ResolveRequestSynchronizer)this.servRef.synchronizers.get(message.getMessageId());
                if (resolveRequestSynchronizer == null) {
                    return true;
                }
                if (resolveRequestSynchronizer.hostedBlockVersion == this.servRef.hostedBlockVersion && this.maybeSendNextResolve(resolveRequestSynchronizer, message.getProtocolInfo())) {
                    return true;
                }
                if (resolveRequestSynchronizer == this.servRef.resolveSynchronizer) {
                    this.servRef.resolveSynchronizer = null;
                }
            }
            object = resolveRequestSynchronizer;
            synchronized (object) {
                resolveRequestSynchronizer.pending = false;
                resolveRequestSynchronizer.notifyAll();
            }
            return true;
        }
        return false;
    }
}

