/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.dispatch;

import org.ws4d.java.DPWSFramework;
import org.ws4d.java.service.Device;
import org.ws4d.java.service.reference.DeviceListener;
import org.ws4d.java.service.reference.DeviceReference;
import org.ws4d.java.structures.LinkedList;
import org.ws4d.java.structures.List;
import org.ws4d.java.util.Log;

class DeviceListenerQueue {
    static final byte DEVICE_RUNNING_EVENT = 1;
    static final byte DEVICE_COMPLETELY_DISCOVERED_EVENT = 2;
    static final byte DEVICE_BUILT_UP_EVENT = 3;
    static final byte DEVICE_BYE_EVENT = 4;
    static final byte DEVICE_CHANGED_EVENT = 5;
    static final byte DEVICE_CHANGED_AND_BUILT_UP_EVENT = 6;
    static final byte DEVICE_RUNNING_AND_BUILT_UP_EVENT = 7;
    static final byte DEVICE_COMMUNICATION_ERROR_OR_RESET_EVENT = 8;
    private final DeviceListener listener;
    private final DeviceReference devRef;
    private List queue = new LinkedList();
    private DeviceEvent currentEvent = null;

    DeviceListenerQueue(DeviceListener deviceListener, DeviceReference deviceReference) {
        this.listener = deviceListener;
        this.devRef = deviceReference;
    }

    synchronized void announce(DeviceEvent deviceEvent) {
        if (this.currentEvent == null) {
            this.currentEvent = deviceEvent;
            DPWSFramework.getThreadPool().execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    while (true) {
                        DeviceListenerQueue.this.deliverCurrentEvent();
                        DeviceListenerQueue deviceListenerQueue = DeviceListenerQueue.this;
                        synchronized (deviceListenerQueue) {
                            boolean bl = true;
                            while (DeviceListenerQueue.this.queue.size() > 0) {
                                DeviceEvent deviceEvent = (DeviceEvent)DeviceListenerQueue.this.queue.remove(0);
                                if (deviceEvent.eventType == ((DeviceListenerQueue)DeviceListenerQueue.this).currentEvent.eventType) continue;
                                DeviceListenerQueue.this.currentEvent = deviceEvent;
                                bl = false;
                                break;
                            }
                            if (bl) {
                                DeviceListenerQueue.this.currentEvent = null;
                                return;
                            }
                        }
                    }
                }
            });
        } else {
            this.queue.add(deviceEvent);
        }
    }

    private void deliverCurrentEvent() {
        try {
            switch (this.currentEvent.eventType) {
                case 1: {
                    this.listener.deviceRunning(this.devRef);
                    break;
                }
                case 2: {
                    this.listener.deviceCompletelyDiscovered(this.devRef);
                    break;
                }
                case 3: {
                    this.listener.deviceBuiltUp(this.devRef, this.currentEvent.device);
                    break;
                }
                case 4: {
                    this.listener.deviceBye(this.devRef);
                    break;
                }
                case 5: {
                    this.listener.deviceChanged(this.devRef);
                    break;
                }
                case 6: {
                    this.listener.deviceChanged(this.devRef);
                    this.listener.deviceBuiltUp(this.devRef, this.currentEvent.device);
                    break;
                }
                case 7: {
                    this.listener.deviceRunning(this.devRef);
                    this.listener.deviceBuiltUp(this.devRef, this.currentEvent.device);
                    break;
                }
                case 8: {
                    this.listener.deviceCommunicationErrorOrReset(this.devRef);
                }
            }
        }
        catch (Throwable throwable) {
            Log.error("Exception during listener notification: " + throwable.getMessage());
            Log.printStackTrace(throwable);
        }
    }

    static class DeviceEvent {
        byte eventType;
        Device device;

        DeviceEvent(byte by, Device device) {
            this.eventType = by;
            this.device = device;
        }
    }
}

