/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.dispatch;

import org.ws4d.java.communication.ProtocolData;
import org.ws4d.java.communication.ProtocolInfo;
import org.ws4d.java.message.discovery.HelloMessage;
import org.ws4d.java.structures.EmptyStructures;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.structures.ReadOnlyIterator;
import org.ws4d.java.types.AppSequence;
import org.ws4d.java.types.DiscoveryData;
import org.ws4d.java.types.EndpointReference;
import org.ws4d.java.types.QNameSet;
import org.ws4d.java.types.ScopeSet;
import org.ws4d.java.types.XAddressInfoSet;

public class HelloData {
    private final HelloMessage hello;
    private final ProtocolData protocolData;

    public HelloData(HelloMessage helloMessage, ProtocolData protocolData) {
        this.hello = helloMessage;
        this.protocolData = protocolData;
    }

    public EndpointReference getEndpointReference() {
        return this.hello.getDiscoveryData().getEndpointReference();
    }

    public long getMetadataVersion() {
        return this.hello.getDiscoveryData().getMetadataVersion();
    }

    public Iterator getScopes() {
        ScopeSet scopeSet = this.hello.getDiscoveryData().getScopes();
        if (scopeSet != null && scopeSet.size() > 0) {
            return new ReadOnlyIterator(scopeSet.getScopesAsUris().iterator());
        }
        return EmptyStructures.EMPTY_ITERATOR;
    }

    public Iterator getDevicePortTypes() {
        QNameSet qNameSet = this.hello.getDiscoveryData().getTypes();
        if (qNameSet != null && qNameSet.size() > 0) {
            return new ReadOnlyIterator(qNameSet.iterator());
        }
        return EmptyStructures.EMPTY_ITERATOR;
    }

    public Iterator getXAddressInfos() {
        XAddressInfoSet xAddressInfoSet = this.hello.getDiscoveryData().getXAddressInfoSet();
        if (xAddressInfoSet != null) {
            new ReadOnlyIterator(xAddressInfoSet.iterator());
        }
        return EmptyStructures.EMPTY_ITERATOR;
    }

    public ProtocolInfo getVersion() {
        return this.hello.getProtocolInfo();
    }

    public String toString() {
        if (this.hello != null && this.protocolData != null) {
            return this.hello.toString() + " at " + this.protocolData.toString();
        }
        if (this.hello != null) {
            return this.hello.toString();
        }
        return "Hello data is empty!";
    }

    DiscoveryData getDiscoveryData() {
        return this.hello.getDiscoveryData();
    }

    AppSequence getAppSequence() {
        return this.hello.getAppSequence();
    }

    public ProtocolData getProtocolData() {
        return this.protocolData;
    }

    boolean isInbound() {
        return this.hello.isInbound();
    }
}

