/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.dispatch;

import org.ws4d.java.DPWSFramework;
import org.ws4d.java.communication.ProtocolData;
import org.ws4d.java.concurrency.LockSupport;
import org.ws4d.java.dispatch.AllMessageSelector;
import org.ws4d.java.dispatch.MessageListener;
import org.ws4d.java.dispatch.MessageSelector;
import org.ws4d.java.message.Message;
import org.ws4d.java.structures.ArrayList;
import org.ws4d.java.structures.HashMap;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.structures.List;
import org.ws4d.java.util.Log;

public class MessageInformer {
    private static MessageInformer instance;
    private final HashMap listeners = new HashMap();
    private final LockSupport listenersLock = new LockSupport();
    private final List queuedMessages = new ArrayList();
    private final LockSupport queuedMessagesLock = new LockSupport();
    private final Object notifier = new Object();
    private volatile boolean stopRunning = true;

    public static synchronized MessageInformer getInstance() {
        if (instance == null) {
            instance = new MessageInformer();
        }
        return instance;
    }

    private MessageInformer() {
    }

    public void start() {
        if (!this.stopRunning) {
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                while (true) {
                    try {
                        do {
                            MessageInformer.this.deliverMessages();
                        } while (!MessageInformer.this.stopRunning);
                        return;
                    }
                    catch (Throwable throwable) {
                        Log.error("MessageInformer: uncaught exception broke out: " + throwable);
                        continue;
                    }
                    break;
                }
            }
        };
        this.stopRunning = false;
        DPWSFramework.getThreadPool().execute(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.stopRunning = true;
        Object object = this.notifier;
        synchronized (object) {
            this.notifier.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageListener(MessageListener messageListener, MessageSelector messageSelector) {
        if (messageListener == null) {
            return;
        }
        if (messageSelector == null) {
            messageSelector = AllMessageSelector.INSTANCE;
        }
        try {
            this.listenersLock.exclusiveLock();
            this.listeners.put(messageListener, messageSelector);
        }
        finally {
            this.listenersLock.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageListener(MessageListener messageListener) {
        if (messageListener == null) {
            return;
        }
        try {
            this.listenersLock.exclusiveLock();
            this.listeners.remove(messageListener);
        }
        finally {
            this.listenersLock.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageListener[] getMessageListeners() {
        MessageListener[] messageListenerArray;
        try {
            this.listenersLock.sharedLock();
            messageListenerArray = (MessageListener[])this.listeners.keySet().toArray(new MessageListener[this.listeners.size()]);
        }
        finally {
            this.listenersLock.releaseSharedLock();
        }
        return messageListenerArray;
    }

    public void forwardMessage(Message message, ProtocolData protocolData) {
        this.forwardMessageInternal(message, protocolData, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forwardMessages(Message[] messageArray) {
        if (messageArray == null) {
            return;
        }
        for (int i = 0; i < messageArray.length; ++i) {
            this.forwardMessageInternal(messageArray[i], null, false);
        }
        Object object = this.notifier;
        synchronized (object) {
            this.notifier.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forwardMessageInternal(Message message, ProtocolData protocolData, boolean bl) {
        if (message == null) {
            return;
        }
        try {
            this.queuedMessagesLock.exclusiveLock();
            this.queuedMessages.add(new MessageEntry(message, protocolData));
        }
        finally {
            this.queuedMessagesLock.releaseExclusiveLock();
        }
        if (bl) {
            Object object = this.notifier;
            synchronized (object) {
                this.notifier.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverMessages() {
        Object object;
        try {
            this.queuedMessagesLock.sharedLock();
            while (this.queuedMessages.size() == 0) {
                this.queuedMessagesLock.releaseSharedLock();
                try {
                    object = this.notifier;
                    synchronized (object) {
                        this.notifier.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.queuedMessagesLock.sharedLock();
                if (!this.stopRunning) continue;
                try {
                    this.queuedMessagesLock.exclusiveLock();
                    this.queuedMessages.clear();
                }
                finally {
                    this.queuedMessagesLock.releaseExclusiveLock();
                }
                return;
            }
        }
        finally {
            this.queuedMessagesLock.releaseSharedLock();
        }
        try {
            this.queuedMessagesLock.exclusiveLock();
            object = (MessageEntry)this.queuedMessages.remove(0);
        }
        finally {
            this.queuedMessagesLock.releaseExclusiveLock();
        }
        try {
            this.listenersLock.sharedLock();
            Iterator iterator = this.listeners.entrySet().iterator();
            while (iterator.hasNext()) {
                Message message;
                HashMap.Entry entry = (HashMap.Entry)iterator.next();
                MessageSelector messageSelector = (MessageSelector)entry.getValue();
                if (!messageSelector.matches(message = ((MessageEntry)object).message)) continue;
                MessageListener messageListener = (MessageListener)entry.getKey();
                if (message.isInbound()) {
                    messageListener.receivedInboundMessage(message, ((MessageEntry)object).protocolData);
                    continue;
                }
                messageListener.receivedOutboundMessage(message, ((MessageEntry)object).protocolData);
            }
        }
        finally {
            this.listenersLock.releaseSharedLock();
        }
    }

    private static final class MessageEntry {
        final Message message;
        final ProtocolData protocolData;

        MessageEntry(Message message, ProtocolData protocolData) {
            this.message = message;
            this.protocolData = protocolData;
        }
    }
}

