/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.dispatch;

import org.ws4d.java.dispatch.ServiceListenerQueue;
import org.ws4d.java.service.Service;
import org.ws4d.java.service.reference.ServiceListener;
import org.ws4d.java.service.reference.ServiceReference;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.structures.LockedMap;

public class ServiceReferenceEventRegistry {
    private static ServiceReferenceEventRegistry instance = new ServiceReferenceEventRegistry();
    private LockedMap listeners = new LockedMap();

    public static ServiceReferenceEventRegistry getInstance() {
        return instance;
    }

    private ServiceReferenceEventRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerServiceListening(ServiceListener serviceListener) {
        if (this.listeners == null) {
            this.listeners = new LockedMap();
        }
        this.listeners.exclusiveLock();
        try {
            if (this.listeners.containsKey(serviceListener)) {
                return;
            }
            this.listeners.put(serviceListener, new ServiceListenerQueue(serviceListener));
        }
        finally {
            this.listeners.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterServiceListening(ServiceListener serviceListener) {
        this.listeners.exclusiveLock();
        try {
            this.listeners.remove(serviceListener);
        }
        finally {
            this.listeners.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void announceServiceListenerEvent(byte by, ServiceReference serviceReference, Service service) {
        this.listeners.sharedLock();
        try {
            ServiceListenerQueue.ServiceEvent serviceEvent = new ServiceListenerQueue.ServiceEvent(by, serviceReference, service);
            Iterator iterator = this.listeners.values().iterator();
            while (iterator.hasNext()) {
                ServiceListenerQueue serviceListenerQueue = (ServiceListenerQueue)iterator.next();
                serviceListenerQueue.announce(serviceEvent);
            }
        }
        finally {
            this.listeners.releaseSharedLock();
        }
    }

    protected void announceServiceChanged(ServiceReference serviceReference, Service service) {
        this.announceServiceListenerEvent((byte)2, serviceReference, service);
    }

    protected void announceServiceCreated(ServiceReference serviceReference, Service service) {
        this.announceServiceListenerEvent((byte)1, serviceReference, service);
    }

    protected void announceServiceDisposed(ServiceReference serviceReference) {
        this.announceServiceListenerEvent((byte)3, serviceReference, null);
    }
}

