/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.message.metadata;

import org.ws4d.java.constants.ConstantsHelper;
import org.ws4d.java.message.Message;
import org.ws4d.java.message.SOAPHeader;
import org.ws4d.java.structures.ArrayList;
import org.ws4d.java.structures.DataStructure;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.types.AttributedURI;
import org.ws4d.java.types.EndpointReference;
import org.ws4d.java.types.EndpointReferenceSet;
import org.ws4d.java.types.HostMData;
import org.ws4d.java.types.HostedMData;
import org.ws4d.java.types.RelationshipMData;
import org.ws4d.java.types.URI;
import org.ws4d.java.types.URISet;
import org.ws4d.java.util.StringUtil;
import org.ws4d.java.wsdl.WSDL;

public class GetMetadataResponseMessage
extends Message {
    public static final URI ACTION = new URI("http://schemas.xmlsoap.org/ws/2004/09/mex/GetMetadata/Response");
    private EndpointReferenceSet metadataReferences;
    private URISet metadataLocations;
    private DataStructure wsdls;
    private RelationshipMData relationship;

    public GetMetadataResponseMessage(String string) {
        this(SOAPHeader.createHeader("http://schemas.xmlsoap.org/ws/2004/09/mex/GetMetadata/Response", string));
    }

    public GetMetadataResponseMessage(SOAPHeader sOAPHeader) {
        super(sOAPHeader);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(StringUtil.formatClassName(this.getClass()));
        stringBuffer.append(" [ header=").append(this.header);
        stringBuffer.append(", inbound=").append(this.inbound);
        stringBuffer.append(", metadataReferences=").append(this.metadataReferences);
        stringBuffer.append(", metadataLocations=").append(this.metadataLocations);
        stringBuffer.append(", relationship=").append(this.relationship);
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }

    public int getType() {
        return 202;
    }

    public RelationshipMData getRelationship() {
        return this.relationship;
    }

    public HostMData getHost() {
        return this.relationship == null ? null : this.relationship.getHost();
    }

    public HostedMData getHosted(AttributedURI attributedURI) {
        if (this.relationship == null) {
            return null;
        }
        Iterator iterator = this.relationship.getHosted().iterator();
        while (iterator.hasNext()) {
            HostedMData hostedMData = (HostedMData)iterator.next();
            if (!hostedMData.getEprInfoSet().containsEprAddress(attributedURI)) continue;
            return hostedMData;
        }
        return null;
    }

    public void addRelationship(RelationshipMData relationshipMData, ConstantsHelper constantsHelper) {
        if (this.relationship == null) {
            this.relationship = relationshipMData;
        } else {
            this.relationship.mergeWith(relationshipMData, constantsHelper);
        }
    }

    public EndpointReferenceSet getMetadataReferences() {
        return this.metadataReferences;
    }

    public void addMetadataReference(EndpointReference endpointReference) {
        if (this.metadataReferences == null) {
            this.metadataReferences = new EndpointReferenceSet();
        }
        this.metadataReferences.add(endpointReference);
    }

    public URISet getMetadataLocations() {
        return this.metadataLocations;
    }

    public void setMetadataLocations(URISet uRISet) {
        this.metadataLocations = uRISet;
    }

    public void addMetadataLocation(URI uRI) {
        if (this.metadataLocations == null) {
            this.metadataLocations = new URISet();
        }
        this.metadataLocations.add(uRI);
    }

    public DataStructure getWSDLs() {
        return this.wsdls;
    }

    public void addWSDL(WSDL wSDL) {
        if (this.wsdls == null) {
            this.wsdls = new ArrayList();
        }
        this.wsdls.add(wSDL);
    }
}

