/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.platform.io.fs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.ws4d.java.io.fs.FileSystem;

public class SEFileSystem
implements FileSystem {
    private static boolean deleteRecursively(File file) {
        boolean bl = false;
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            bl = file2.isFile() ? file2.delete() : (file2.isDirectory() ? SEFileSystem.deleteRecursively(file2) : false);
            if (bl) continue;
            return false;
        }
        return file.delete();
    }

    public String escapeFileName(String string) {
        if (string == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        block3: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '*': 
                case '/': 
                case ':': 
                case '<': 
                case '>': 
                case '?': 
                case '\\': 
                case '|': {
                    stringBuffer.append('_');
                    continue block3;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public boolean deleteFile(String string) {
        if (string == null) {
            return false;
        }
        File file = new File(string);
        if (file.isFile()) {
            return file.delete();
        }
        if (file.isDirectory()) {
            return SEFileSystem.deleteRecursively(file);
        }
        return false;
    }

    public String fileSeparator() {
        return File.separator;
    }

    public String[] listFiles(String string) {
        return string == null ? null : new File(string).list();
    }

    public InputStream readFile(String string) throws IOException {
        String string2 = System.getProperty("user.dir");
        return string == null ? null : new FileInputStream(string);
    }

    public OutputStream writeFile(String string) throws IOException {
        File file;
        if (string == null) {
            throw new FileNotFoundException("File name not set.");
        }
        File file2 = new File(string);
        if (!(file2.exists() || (file = file2.getParentFile()) == null || file.exists() || file.mkdirs())) {
            throw new IOException("unable to create parent directory " + file);
        }
        return new FileOutputStream(file2);
    }

    public boolean renameFile(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        return new File(string).renameTo(new File(string2));
    }

    public long fileSize(String string) {
        return new File(string).length();
    }

    public boolean fileExists(String string) {
        return new File(string).exists();
    }

    public long lastModified(String string) {
        if (string == null) {
            return -1L;
        }
        File file = new File(string);
        return file.lastModified();
    }
}

