/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.platform.util;

import java.io.PrintStream;
import org.ws4d.java.DPWSFramework;
import org.ws4d.java.configuration.FrameworkProperties;
import org.ws4d.java.util.Log;
import org.ws4d.java.util.Toolkit;

public final class SEToolkit
implements Toolkit {
    private volatile boolean shutdownAdded = false;

    public SEToolkit() {
        this.addShutdownHook();
    }

    private synchronized void addShutdownHook() {
        if (this.shutdownAdded) {
            return;
        }
        Thread thread = new Thread(){

            public void run() {
                if (FrameworkProperties.getInstance().getKillOnShutdownHook()) {
                    DPWSFramework.kill();
                    if (DPWSFramework.isRunning()) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                    }
                    if (Log.isDebug() && DPWSFramework.isRunning()) {
                        Log.debug("Killing DPWS Framework and JavaVM");
                    }
                    Runtime.getRuntime().halt(0);
                } else {
                    DPWSFramework.stop();
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(thread);
        this.shutdownAdded = true;
    }

    public void printStackTrace(PrintStream printStream, Throwable throwable) {
        throwable.printStackTrace(printStream);
    }

    public String[] getStackTrace(Throwable throwable) {
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        String[] stringArray = new String[stackTraceElementArray.length];
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            stringArray[i] = stackTraceElementArray[i].getClassName() + "." + stackTraceElementArray[i].getMethodName() + " at " + stackTraceElementArray[i].getLineNumber();
        }
        return stringArray;
    }
}

