/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.schema;

import java.io.IOException;
import org.ws4d.java.io.xml.ElementParser;
import org.ws4d.java.schema.ComplexType;
import org.ws4d.java.schema.ExtendedComplexContent;
import org.ws4d.java.schema.InheritType;
import org.ws4d.java.schema.RestrictedComplexContent;
import org.ws4d.java.schema.Schema;
import org.ws4d.java.schema.SchemaException;
import org.ws4d.java.schema.Type;
import org.ws4d.java.types.QName;
import org.ws4d.java.util.StringUtil;
import org.xmlpull.v1.XmlPullParserException;

public abstract class ComplexContent
extends ComplexType
implements InheritType {
    static final String TAG_COMPLEXCONTENT = "complexContent";
    protected Type base = null;
    protected QName baseLink = null;

    static final ComplexContent handleComplexContent(ElementParser elementParser, QName qName, String string, Schema schema) throws XmlPullParserException, IOException, SchemaException {
        int n = elementParser.getDepth();
        ComplexContent complexContent = null;
        while (elementParser.nextTag() != 3 && elementParser.getDepth() == n + 1) {
            ComplexContent complexContent2;
            String string2 = elementParser.getNamespace();
            String string3 = elementParser.getName();
            if (!"http://www.w3.org/2001/XMLSchema".equals(string2)) continue;
            if (StringUtil.equalsIgnoreCase("extension", string3)) {
                complexContent2 = new ExtendedComplexContent(qName);
                ExtendedComplexContent.handleExtension(elementParser, complexContent2, string, schema);
                complexContent = complexContent2;
                continue;
            }
            if (!StringUtil.equalsIgnoreCase("restriction", string3)) continue;
            complexContent2 = new RestrictedComplexContent(qName);
            RestrictedComplexContent.handleRestriction(elementParser, (RestrictedComplexContent)complexContent2, string, schema);
            complexContent = complexContent2;
        }
        return complexContent;
    }

    ComplexContent() {
    }

    ComplexContent(QName qName, int n) {
        super(qName, n);
    }

    ComplexContent(QName qName) {
        super(qName);
    }

    public Type getBase() {
        return this.base;
    }

    public void setBase(Type type) {
        this.baseLink = null;
        this.base = type;
        type.addSubtype(this);
    }

    QName getBaseLink() {
        return this.baseLink;
    }

    void setBaseLink(QName qName) {
        this.baseLink = qName;
    }
}

