/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.schema;

import java.io.IOException;
import org.ws4d.java.io.xml.ElementParser;
import org.ws4d.java.schema.Annotation;
import org.ws4d.java.schema.AnyElement;
import org.ws4d.java.schema.ComplexType;
import org.ws4d.java.schema.Schema;
import org.ws4d.java.schema.SchemaException;
import org.ws4d.java.schema.SchemaUtil;
import org.ws4d.java.schema.SimpleType;
import org.ws4d.java.schema.Type;
import org.ws4d.java.structures.HashMap;
import org.ws4d.java.types.Attributable;
import org.ws4d.java.types.AttributableSupport;
import org.ws4d.java.types.CustomAttributeValue;
import org.ws4d.java.types.QName;
import org.ws4d.java.types.StringAttributeValue;
import org.ws4d.java.util.StringUtil;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class Element
extends AnyElement
implements Attributable {
    static final String TAG_ELEMENT = "element";
    static final String ATTRIBUTE_NILLABLE = "nillable";
    static final String ATTRIBUTE_TYPE = "type";
    static final String ATTRIBUTE_SUBSTITUTIONGROUP = "substitutionGroup";
    protected static int count = 0;
    protected boolean globalScope = false;
    protected QName typeLink = null;
    protected Type type = null;
    protected QName subtitutionGroup = null;
    protected String fixed = null;
    protected boolean nillable = false;
    private Attributable attributableDelegate;
    protected Type localType = null;

    public static int getElementCount() {
        return count;
    }

    static final Element createElement(ElementParser elementParser, String string, Schema schema) throws XmlPullParserException, IOException, SchemaException {
        return Element.createElement(elementParser, string, schema, false);
    }

    static final Element createElement(ElementParser elementParser, String string, Schema schema, boolean bl) throws XmlPullParserException, IOException, SchemaException {
        Object object;
        String string2;
        String string3;
        String string4;
        HashMap hashMap = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        String string11 = null;
        String string12 = null;
        int n = elementParser.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            string4 = elementParser.getAttributeName(i);
            string3 = elementParser.getAttributeNamespace(i);
            string2 = elementParser.getAttributeValue(i);
            if (string3 == null || "".equals(string3)) {
                if ("name".equals(string4)) {
                    string5 = string2;
                    continue;
                }
                if (ATTRIBUTE_TYPE.equals(string4)) {
                    string6 = string2;
                    continue;
                }
                if ("ref".equals(string4)) {
                    string7 = string2;
                    continue;
                }
                if (ATTRIBUTE_SUBSTITUTIONGROUP.equals(string4)) {
                    string8 = string2;
                    continue;
                }
                if ("abstract".equals(string4)) {
                    string9 = string2;
                    continue;
                }
                if ("minOccurs".equals(string4)) {
                    string10 = string2;
                    continue;
                }
                if ("maxOccurs".equals(string4)) {
                    string11 = string2;
                    continue;
                }
                if (ATTRIBUTE_NILLABLE.equals(string4)) {
                    string12 = string2;
                    continue;
                }
                if (hashMap == null) {
                    hashMap = new HashMap();
                }
                hashMap.put(new QName(string4, string3), new StringAttributeValue(string2));
                continue;
            }
            if (hashMap == null) {
                hashMap = new HashMap();
            }
            hashMap.put(new QName(string4, string3), new StringAttributeValue(string2));
        }
        if (string6 != null && string7 != null) {
            throw new SchemaException("Cannot create element. Element definition SHOULD NOT have both, type and ref attribute.");
        }
        Element element = new Element();
        element.setParentSchema(schema);
        element.globalScope = bl;
        if (hashMap != null) {
            element.setAttributes(hashMap);
        }
        if (string5 != null) {
            element.setName(new QName(string5, string));
        }
        if (!bl && string10 != null) {
            element.setMinOccurs(Integer.valueOf(string10));
        }
        if (!bl && string11 != null) {
            if (string11.equals("unbounded")) {
                element.setMaxOccurs(-1);
            } else {
                element.setMaxOccurs(Integer.valueOf(string11));
            }
        }
        if (string12 != null && StringUtil.equalsIgnoreCase("true", string12)) {
            element.setNillable(true);
        }
        if (string9 != null) {
            element.setAbstract(StringUtil.equalsIgnoreCase("true", string9));
        }
        if (string8 != null) {
            string4 = SchemaUtil.getPrefix(string8);
            string3 = SchemaUtil.getName(string8);
            string2 = elementParser.getNamespace(string4);
            element.setSubstitutionGroup(new QName(string3, string2));
        }
        if (string6 != null && string7 == null) {
            string4 = SchemaUtil.getPrefix(string6);
            string3 = SchemaUtil.getName(string6);
            string2 = elementParser.getNamespace(string4);
            object = new QName(string3, string2);
            if ("http://www.w3.org/2001/XMLSchema".equals(string2)) {
                Type type = SchemaUtil.getType((QName)object);
                if (type != null) {
                    element.setType(type);
                }
            } else {
                element.setTypeLink((QName)object);
                schema.addElementForResolve(element);
            }
        } else if (string7 != null && string6 == null) {
            string4 = SchemaUtil.getPrefix(string7);
            string3 = SchemaUtil.getName(string7);
            string2 = elementParser.getNamespace(string4);
            element.setReferenceLink(new QName(string3, string2));
            schema.addElementForResolve(element);
        }
        int n2 = elementParser.getDepth();
        while (elementParser.nextTag() != 3 && elementParser.getDepth() == n2 + 1) {
            string3 = elementParser.getNamespace();
            string2 = elementParser.getName();
            if (!"http://www.w3.org/2001/XMLSchema".equals(string3)) continue;
            if (StringUtil.equalsIgnoreCase("complexType", string2)) {
                object = ComplexType.createComplexType(elementParser, string, schema);
                element.setType((Type)object);
                continue;
            }
            if (StringUtil.equalsIgnoreCase("simpleType", string2)) {
                object = SimpleType.createSimpleType(elementParser, string, schema);
                element.setType((Type)object);
                continue;
            }
            if (!StringUtil.equalsIgnoreCase("annotation", string2)) continue;
            Annotation.handleAnnotation(elementParser, element);
        }
        return element;
    }

    Element() {
        this((QName)null);
    }

    public Element(String string, String string2) {
        this(new QName(string, string2));
    }

    public Element(String string, String string2, Type type) {
        this(new QName(string, string2), type);
    }

    public Element(QName qName) {
        this(qName, null);
    }

    public Element(String string, Type type) {
        this(new QName(string, null), type);
    }

    public Element(Type type) {
        this((QName)null, type);
    }

    public Element(QName qName, Type type) {
        this.name = qName;
        if (qName != null && !"http://www.w3.org/2001/XMLSchema".equals(qName.getNamespace()) || qName == null) {
            ++count;
        }
        if (this.name == null) {
            this.name = new QName(StringUtil.simpleClassName(this.getClass()), null);
        }
        this.setType(type);
    }

    public Element(String string, String string2, Type type, int n, int n2) {
        this(new QName(string, string2), type, n, n2);
    }

    public Element(QName qName, Type type, int n, int n2) {
        this.name = qName;
        if (qName != null && !"http://www.w3.org/2001/XMLSchema".equals(qName.getNamespace()) || qName == null) {
            ++count;
        }
        this.setType(type);
        this.setMinOccurs(n);
        this.setMaxOccurs(n2);
    }

    public Element(Element element) {
        this((QName)null);
        this.setReference(element);
    }

    public Element(Element element, int n, int n2) {
        this((QName)null);
        this.setReference(element);
        this.setMinOccurs(n);
        this.setMaxOccurs(n2);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(StringUtil.formatClassName(this.getClass()));
        QName qName = this.getName();
        if (qName != null) {
            stringBuffer.append(" [ name=").append(qName.getLocalPart());
            stringBuffer.append(", namespace=").append(qName.getNamespace());
            stringBuffer.append(", type=").append(this.getType().getName());
            stringBuffer.append(" ]");
        }
        return stringBuffer.toString();
    }

    public int getSchemaIdentifier() {
        return 1;
    }

    public CustomAttributeValue getAttribute(QName qName) {
        return this.attributableDelegate == null ? null : this.attributableDelegate.getAttribute(qName);
    }

    public void setAttribute(QName qName, CustomAttributeValue customAttributeValue) {
        if (this.attributableDelegate == null) {
            this.attributableDelegate = new AttributableSupport();
        }
        this.attributableDelegate.setAttribute(qName, customAttributeValue);
    }

    public void setAttribute(QName qName, String string) {
        this.setAttribute(qName, new StringAttributeValue(string));
    }

    public HashMap getAttributes() {
        if (this.attributableDelegate == null) {
            this.attributableDelegate = new AttributableSupport();
        }
        return this.attributableDelegate.getAttributes();
    }

    public void setAttributes(HashMap hashMap) {
        if (this.attributableDelegate == null) {
            if (hashMap == null) {
                return;
            }
            this.attributableDelegate = new AttributableSupport();
        }
        this.attributableDelegate.setAttributes(hashMap);
    }

    public boolean hasAttributes() {
        return this.attributableDelegate != null && this.attributableDelegate.hasAttributes();
    }

    public void serializeAttributes(XmlSerializer xmlSerializer) throws IOException {
        if (this.attributableDelegate != null) {
            this.attributableDelegate.serializeAttributes(xmlSerializer);
        }
    }

    public Type getType() {
        if (this.reference != null) {
            return ((Element)this.reference).getType();
        }
        if (this.type == null) {
            return this.localType != null ? this.localType : Schema.ANY_TYPE;
        }
        return this.type;
    }

    public boolean isFixed() {
        return this.fixed == null;
    }

    public String getFixedValue() {
        return this.fixed;
    }

    public void setSubstitutionGroup(QName qName) {
        this.subtitutionGroup = qName;
    }

    public QName getSubstitutionGroup() {
        return this.subtitutionGroup;
    }

    public void setType(Type type) {
        this.typeLink = null;
        this.abstractValue = false;
        this.localType = null;
        this.type = type;
    }

    protected void setLocalType(Type type) {
    }

    public boolean isNillable() {
        return this.nillable;
    }

    public void setNillable(boolean bl) {
        this.nillable = bl;
    }

    void setTypeLink(QName qName) {
        this.typeLink = qName;
    }

    QName getTypeLink() {
        return this.typeLink;
    }

    void serialize(XmlSerializer xmlSerializer, Schema schema) throws IOException {
        xmlSerializer.startTag("http://www.w3.org/2001/XMLSchema", TAG_ELEMENT);
        if (this.name != null && this.reference == null) {
            xmlSerializer.attribute(null, "name", this.name.getLocalPart());
        }
        if (this.subtitutionGroup != null) {
            xmlSerializer.attribute(null, ATTRIBUTE_SUBSTITUTIONGROUP, this.subtitutionGroup.getLocalPart());
        }
        if (this.abstractValue) {
            xmlSerializer.attribute(null, "abstract", "true");
        }
        if (this.nillable) {
            xmlSerializer.attribute(null, ATTRIBUTE_NILLABLE, "true");
        }
        if (!this.globalScope) {
            if (this.min != 1) {
                xmlSerializer.attribute(null, "minOccurs", String.valueOf(this.min));
            }
            if (this.max != 1) {
                if (this.max == -1) {
                    xmlSerializer.attribute(null, "maxOccurs", "unbounded");
                } else {
                    xmlSerializer.attribute(null, "maxOccurs", String.valueOf(this.max));
                }
            }
        }
        if (this.type != null) {
            QName qName = this.type.getName();
            if (qName == null) {
                this.serializeAttributes(xmlSerializer);
                this.type.serialize(xmlSerializer, schema);
            } else {
                String string = xmlSerializer.getPrefix(qName.getNamespace(), false);
                if (string != null && !"".equals(string)) {
                    qName.setPrefix(string);
                    xmlSerializer.attribute(null, ATTRIBUTE_TYPE, qName.getLocalPartPrefixed());
                } else {
                    xmlSerializer.attribute(null, ATTRIBUTE_TYPE, qName.getLocalPart());
                }
                this.serializeAttributes(xmlSerializer);
            }
        } else if (this.reference != null) {
            QName qName = this.reference.getName();
            schema.addReferenceElement((Element)this.reference);
            String string = xmlSerializer.getPrefix(qName.getNamespace(), false);
            if (string != null && !"".equals(string)) {
                qName.setPrefix(string);
                xmlSerializer.attribute(null, "ref", qName.getLocalPartPrefixed());
            } else {
                xmlSerializer.attribute(null, "ref", qName.getLocalPart());
            }
            this.serializeAttributes(xmlSerializer);
        } else {
            this.serializeAttributes(xmlSerializer);
        }
        xmlSerializer.endTag("http://www.w3.org/2001/XMLSchema", TAG_ELEMENT);
    }
}

