/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.schema;

import java.io.IOException;
import org.ws4d.java.io.xml.ElementParser;
import org.ws4d.java.schema.Annotation;
import org.ws4d.java.schema.SchemaException;
import org.ws4d.java.util.StringUtil;
import org.xmlpull.v1.XmlPullParserException;

public class Notation
extends Annotation {
    static final String TAG_NOTATION = "notation";
    static final String ATTRIBUTE_PUBLIC = "public";
    static final String ATTRIBUTE_SYSTEM = "system";
    protected static int count = 0;
    protected String name = null;
    protected String pub = null;
    protected String sys = null;

    static final Notation createNotation(ElementParser elementParser) throws XmlPullParserException, IOException, SchemaException {
        String string;
        String string2 = elementParser.getAttributeValue(null, "name");
        if (string2 == null) {
            throw new SchemaException("Cannot create notation. No name set.");
        }
        Notation notation = new Notation(string2);
        String string3 = elementParser.getAttributeValue(null, ATTRIBUTE_PUBLIC);
        if (string3 != null) {
            notation.setPublic(string3);
        }
        if ((string = elementParser.getAttributeValue(null, ATTRIBUTE_SYSTEM)) != null) {
            notation.setSystem(string);
        }
        int n = elementParser.getDepth();
        while (elementParser.nextTag() != 3 && elementParser.getDepth() == n + 1) {
            String string4 = elementParser.getNamespace();
            String string5 = elementParser.getName();
            if (!"http://www.w3.org/2001/XMLSchema".equals(string4) || !StringUtil.equalsIgnoreCase("annotation", string5)) continue;
            Annotation.handleAnnotation(elementParser, notation);
        }
        return notation;
    }

    Notation(String string) {
        this.name = string;
        if (string != null) {
            ++count;
        }
    }

    public int getSchemaIdentifier() {
        return 12;
    }

    public String getName() {
        return this.name;
    }

    public String getPublic() {
        return this.pub;
    }

    public String getSystem() {
        return this.sys;
    }

    public String getSchemaElementName() {
        return TAG_NOTATION;
    }

    boolean isResolved() {
        return true;
    }

    void setPublic(String string) {
        this.pub = string;
    }

    void setSystem(String string) {
        this.sys = string;
    }
}

