/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.schema;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import org.ws4d.java.DPWSFramework;
import org.ws4d.java.communication.RequestHeader;
import org.ws4d.java.communication.Resource;
import org.ws4d.java.communication.monitor.ResourceLoader;
import org.ws4d.java.io.xml.ElementParser;
import org.ws4d.java.io.xml.XmlPullParserSupport;
import org.ws4d.java.io.xml.XmlSerializerImplementation;
import org.ws4d.java.schema.Annotation;
import org.ws4d.java.schema.Any;
import org.ws4d.java.schema.Attribute;
import org.ws4d.java.schema.AttributeGroup;
import org.ws4d.java.schema.ComplexContent;
import org.ws4d.java.schema.ComplexType;
import org.ws4d.java.schema.Element;
import org.ws4d.java.schema.ExtendedComplexContent;
import org.ws4d.java.schema.ExtendedSimpleContent;
import org.ws4d.java.schema.Group;
import org.ws4d.java.schema.InheritType;
import org.ws4d.java.schema.NamedObject;
import org.ws4d.java.schema.Notation;
import org.ws4d.java.schema.Reference;
import org.ws4d.java.schema.RestrictedComplexContent;
import org.ws4d.java.schema.RestrictedSimpleContent;
import org.ws4d.java.schema.RestrictedSimpleType;
import org.ws4d.java.schema.SchemaException;
import org.ws4d.java.schema.SchemaUtil;
import org.ws4d.java.schema.SimpleType;
import org.ws4d.java.schema.Type;
import org.ws4d.java.structures.ArrayList;
import org.ws4d.java.structures.DataStructure;
import org.ws4d.java.structures.EmptyStructures;
import org.ws4d.java.structures.HashMap;
import org.ws4d.java.structures.HashSet;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.structures.LinkedList;
import org.ws4d.java.structures.List;
import org.ws4d.java.structures.ReadOnlyIterator;
import org.ws4d.java.structures.Set;
import org.ws4d.java.types.InternetMediaType;
import org.ws4d.java.types.QName;
import org.ws4d.java.types.URI;
import org.ws4d.java.util.StringUtil;
import org.ws4d.java.wsdl.WSDLRepository;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class Schema
extends Annotation
implements Resource {
    public static final Type ANY_TYPE = SchemaUtil.getAnyType();
    private static final HashMap SCHEMA_CACHE = new HashMap();
    private static final boolean USE_SCHEMA_CACHE = false;
    private String targetNamespace = "";
    private HashMap elements = EmptyStructures.EMPTY_MAP;
    private HashMap types = EmptyStructures.EMPTY_MAP;
    private HashMap attributes = EmptyStructures.EMPTY_MAP;
    private HashMap groups = EmptyStructures.EMPTY_MAP;
    private HashMap attributeGroups = EmptyStructures.EMPTY_MAP;
    private HashMap notations = EmptyStructures.EMPTY_MAP;
    private List elementResolver = EmptyStructures.EMPTY_LIST;
    private List attributeResolver = EmptyStructures.EMPTY_LIST;
    private List groupResolver = EmptyStructures.EMPTY_LIST;
    private List attributeGroupResolver = EmptyStructures.EMPTY_LIST;
    private List baseResolver = EmptyStructures.EMPTY_LIST;
    private List referenceResolver = EmptyStructures.EMPTY_LIST;
    private List baseReferenceResolver = EmptyStructures.EMPTY_LIST;
    private List listItemTypeResolver = EmptyStructures.EMPTY_LIST;
    private List unionMemberResolver = EmptyStructures.EMPTY_LIST;
    private HashMap linkedSchemas = EmptyStructures.EMPTY_MAP;
    private HashMap imports = EmptyStructures.EMPTY_MAP;
    private Set includes = EmptyStructures.EMPTY_SET;
    private long lastMod = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushSchemaCache() {
        HashMap hashMap = SCHEMA_CACHE;
        synchronized (hashMap) {
            SCHEMA_CACHE.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Schema parse(XmlPullParser xmlPullParser, URI uRI, String string, boolean bl) throws XmlPullParserException, IOException, SchemaException {
        Schema schema;
        HashMap hashMap = SCHEMA_CACHE;
        synchronized (hashMap) {
            schema = (Schema)SCHEMA_CACHE.get(string);
        }
        if (schema == null) {
            schema = new Schema(string);
            schema.handleSchema(new ElementParser(xmlPullParser), uRI, bl);
            if (bl) {
                schema.resolveSchema();
            }
        } else {
            new ElementParser(xmlPullParser).consume();
        }
        return schema;
    }

    public static Schema parse(URI uRI) throws XmlPullParserException, IOException, SchemaException {
        return Schema.parse(uRI, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Schema parse(URI uRI, boolean bl) throws XmlPullParserException, IOException, SchemaException {
        ResourceLoader resourceLoader = DPWSFramework.getResourceAsStream(uRI);
        InputStream inputStream = resourceLoader.getInputStream();
        try {
            Schema schema = Schema.parse(inputStream, uRI, bl);
            if (schema != null && bl) {
                schema.resolveSchema();
            }
            Schema schema2 = schema;
            return schema2;
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Schema parse(InputStream inputStream, URI uRI, boolean bl) throws XmlPullParserException, IOException, SchemaException {
        Schema schema;
        XmlPullParser xmlPullParser = XmlPullParserSupport.getFactory().newPullParser();
        xmlPullParser.setInput(inputStream, null);
        xmlPullParser.nextTag();
        String string = xmlPullParser.getNamespace();
        String string2 = xmlPullParser.getName();
        if (!"http://www.w3.org/2001/XMLSchema".equals(string) || !StringUtil.equalsIgnoreCase("schema", string2)) {
            throw new IOException("This is not an XML schema.");
        }
        String string3 = xmlPullParser.getAttributeValue(null, "targetNamespace");
        HashMap hashMap = SCHEMA_CACHE;
        synchronized (hashMap) {
            schema = (Schema)SCHEMA_CACHE.get(string3);
        }
        if (schema == null) {
            schema = new Schema(string3);
            schema.handleSchema(new ElementParser(xmlPullParser), uRI, bl);
            schema.resolveSchema();
        }
        return schema;
    }

    Schema() {
        this("");
    }

    Schema(String string) {
        this.updateLastModified();
        this.setTargetNamespace(string);
    }

    protected synchronized void updateLastModified() {
        Date date = new Date();
        this.lastMod = date.getTime();
    }

    public String toString() {
        return "Schema [ targetNamespace=" + this.getTargetNamespace() + " ]";
    }

    public int getSchemaIdentifier() {
        return 0;
    }

    public InternetMediaType getContentType() {
        return InternetMediaType.getXML();
    }

    public void serialize(URI uRI, RequestHeader requestHeader, InputStream inputStream, OutputStream outputStream) throws IOException {
        this.serialize0(outputStream);
    }

    public long size() {
        return -1L;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public Iterator getLinkedSchemas() {
        return new ReadOnlyIterator(this.linkedSchemas.values());
    }

    public Iterator getElements() {
        return new ReadOnlyIterator(this.elements.values());
    }

    public Element getElement(QName qName) {
        String string;
        String string2 = string = qName == null ? null : qName.getNamespace();
        if (this.targetNamespace.equals(string)) {
            return (Element)this.elements.get(qName);
        }
        Schema schema = (Schema)this.linkedSchemas.get(string);
        if (schema != null) {
            return schema.getElement(qName);
        }
        Iterator iterator = this.linkedSchemas.values().iterator();
        while (iterator.hasNext()) {
            schema = (Schema)iterator.next();
            Element element = schema.getElement(qName);
            if (element == null) continue;
            return element;
        }
        return null;
    }

    public Element getElement(String string, String string2) {
        QName qName = new QName(string, string2);
        return this.getElement(qName);
    }

    public int getElementCount() {
        return this.elements.size();
    }

    public Iterator getTypes() {
        return new ReadOnlyIterator(this.types.values());
    }

    public Type getType(String string, String string2) {
        QName qName = new QName(string, string2);
        return this.getType(qName);
    }

    public Type getType(QName qName) {
        String string;
        String string2 = string = qName == null ? null : qName.getNamespace();
        if ("http://www.w3.org/2001/XMLSchema".equals(string)) {
            return SchemaUtil.getType(qName);
        }
        if (this.targetNamespace.equals(string)) {
            return (Type)this.types.get(qName);
        }
        Schema schema = (Schema)this.linkedSchemas.get(string);
        if (schema != null) {
            return schema.getType(qName);
        }
        Iterator iterator = this.linkedSchemas.values().iterator();
        while (iterator.hasNext()) {
            schema = (Schema)iterator.next();
            Type type = schema.getType(qName);
            if (type == null) continue;
            return type;
        }
        return null;
    }

    public int getTypeCount() {
        return this.types.size();
    }

    public Iterator getAttributes() {
        return new ReadOnlyIterator(this.attributes.values());
    }

    public Attribute getAttribute(String string, String string2) {
        QName qName = new QName(string, string2);
        return this.getAttribute(qName);
    }

    public Attribute getAttribute(QName qName) {
        String string;
        String string2 = string = qName == null ? null : qName.getNamespace();
        if (this.targetNamespace.equals(string)) {
            return (Attribute)this.attributes.get(qName);
        }
        Schema schema = (Schema)this.linkedSchemas.get(string);
        if (schema != null) {
            return schema.getAttribute(qName);
        }
        Iterator iterator = this.linkedSchemas.values().iterator();
        while (iterator.hasNext()) {
            schema = (Schema)iterator.next();
            Attribute attribute = schema.getAttribute(qName);
            if (attribute == null) continue;
            return attribute;
        }
        return null;
    }

    public int getAttributCount() {
        return this.attributes.size();
    }

    public Group getGroup(String string, String string2) {
        QName qName = new QName(string, string2);
        return this.getGroup(qName);
    }

    public Group getGroup(QName qName) {
        String string;
        String string2 = string = qName == null ? null : qName.getNamespace();
        if (this.targetNamespace.equals(string)) {
            return (Group)this.groups.get(qName);
        }
        Schema schema = (Schema)this.linkedSchemas.get(string);
        if (schema != null) {
            return schema.getGroup(qName);
        }
        Iterator iterator = this.linkedSchemas.values().iterator();
        while (iterator.hasNext()) {
            schema = (Schema)iterator.next();
            Group group = schema.getGroup(qName);
            if (group == null) continue;
            return group;
        }
        return null;
    }

    public int getGroupCount() {
        return this.groups.size();
    }

    public AttributeGroup getAttributeGroup(String string, String string2) {
        QName qName = new QName(string, string2);
        return this.getAttributeGroup(qName);
    }

    public AttributeGroup getAttributeGroup(QName qName) {
        String string;
        String string2 = string = qName == null ? null : qName.getNamespace();
        if (this.targetNamespace.equals(string)) {
            return (AttributeGroup)this.attributeGroups.get(qName);
        }
        Schema schema = (Schema)this.linkedSchemas.get(string);
        if (schema != null) {
            return schema.getAttributeGroup(qName);
        }
        Iterator iterator = this.linkedSchemas.values().iterator();
        while (iterator.hasNext()) {
            schema = (Schema)iterator.next();
            AttributeGroup attributeGroup = schema.getAttributeGroup(qName);
            if (attributeGroup == null) continue;
            return attributeGroup;
        }
        return null;
    }

    public int getAttributeGroupCount() {
        return this.attributeGroups.size();
    }

    public Notation getNotation(String string) {
        return (Notation)this.notations.get(string);
    }

    public int getNotationCount() {
        return this.notations.size();
    }

    public void addImport(String string, String string2) {
        this.updateLastModified();
        if (this.imports == EmptyStructures.EMPTY_MAP) {
            this.imports = new HashMap();
        }
        this.imports.put(string, string2);
    }

    public void removeImport(String string) {
        this.updateLastModified();
        this.imports.remove(string);
    }

    public HashMap getImports() {
        if (this.imports.isEmpty()) {
            return EmptyStructures.EMPTY_MAP;
        }
        return new HashMap(this.imports);
    }

    public void addInclude(String string) {
        this.updateLastModified();
        if (this.includes == EmptyStructures.EMPTY_SET) {
            this.includes = new HashSet();
        }
        this.includes.add(string);
    }

    public Set getIncludes() {
        if (this.includes.isEmpty()) {
            return EmptyStructures.EMPTY_SET;
        }
        return new HashSet(this.includes);
    }

    public void serialize(XmlSerializer xmlSerializer) throws IOException {
        this.serialize0(xmlSerializer);
    }

    private void setTargetNamespace(String string) {
        if (string == null) {
            string = "";
        }
        this.targetNamespace = string;
    }

    void addElement(Element element) {
        String string;
        if (element == null) {
            return;
        }
        if (this.elements == EmptyStructures.EMPTY_MAP) {
            this.elements = new HashMap();
        }
        if (!this.targetNamespace.equals(string = element.getName().getNamespace())) {
            Schema schema = (Schema)this.linkedSchemas.get(string);
            if (schema != null) {
                schema.addElement(element);
            } else {
                boolean bl = false;
                Object object = this.linkedSchemas.values().iterator();
                while (object.hasNext()) {
                    schema = (Schema)object.next();
                    if (!string.equals(schema.getTargetNamespace())) continue;
                    bl = true;
                    schema.addElement(element);
                    break;
                }
                if (!bl) {
                    object = new Schema(string);
                    ((Schema)object).addElement(element);
                    this.addLinkedSchema((Schema)object);
                }
            }
            return;
        }
        this.elements.put(element.getName(), element);
        Type type = element.getType();
        if (type != null) {
            if (type.getName() != null) {
                this.addType(type);
            } else {
                this.addType(type, string);
            }
        }
    }

    public void addType(Type type) {
        if (type == null) {
            return;
        }
        this.updateLastModified();
        this.addType(type, type.getName().getNamespace());
    }

    private void addType(Type type, String string) {
        int n;
        if ("http://www.w3.org/2001/XMLSchema".equals(string)) {
            return;
        }
        if (this.types == EmptyStructures.EMPTY_MAP) {
            this.types = new HashMap();
        }
        if (!this.targetNamespace.equals(string)) {
            if (type.getName() != null) {
                Schema schema = (Schema)this.linkedSchemas.get(string);
                if (schema != null) {
                    schema.addType(type);
                } else {
                    boolean bl = false;
                    Object object = this.linkedSchemas.values().iterator();
                    while (object.hasNext()) {
                        schema = (Schema)object.next();
                        if (!string.equals(schema.getTargetNamespace())) continue;
                        bl = true;
                        schema.addType(type);
                        break;
                    }
                    if (!bl) {
                        object = new Schema(string);
                        super.addType(type, string);
                        this.addLinkedSchema((Schema)object);
                    }
                }
            }
            return;
        }
        if (type.getName() != null) {
            this.types.put(type.getName(), type);
        }
        if ((n = type.getSchemaIdentifier()) == 4 || n == 7 || n == 10) {
            Object object;
            ComplexType complexType = (ComplexType)type;
            if (n == 7) {
                object = (ExtendedComplexContent)complexType;
                this.addType(((ComplexContent)object).getBase());
            } else if (n == 10) {
                object = (RestrictedComplexContent)complexType;
                this.addType(((ComplexContent)object).getBase());
            }
            object = complexType.elements();
            while (object.hasNext()) {
                Element element;
                Type type2;
                Any any = (Any)object.next();
                if (any.getSchemaIdentifier() != 1 || (type2 = (element = (Element)any).getType()) == null) continue;
                if (type2.getName() != null) {
                    if (this.types.containsKey(type2.getName())) continue;
                    this.addType(type2);
                    continue;
                }
                this.addType(type2, string);
            }
        }
    }

    private void addAttribute(Attribute attribute) {
        if (attribute == null) {
            return;
        }
        if (this.attributes == EmptyStructures.EMPTY_MAP) {
            this.attributes = new HashMap();
        }
        this.attributes.put(attribute.getName(), attribute);
        Type type = attribute.getType();
        if (type != null) {
            if (type.getName() != null) {
                this.addType(type);
            } else {
                this.addType(type, attribute.getName().getNamespace());
            }
        }
    }

    private void addGroup(Group group) {
        if (group == null) {
            return;
        }
        if (this.groups == EmptyStructures.EMPTY_MAP) {
            this.groups = new HashMap();
        }
        this.groups.put(group.getName(), group);
    }

    private void addAttributeGroup(AttributeGroup attributeGroup) {
        if (attributeGroup == null) {
            return;
        }
        if (this.attributeGroups == EmptyStructures.EMPTY_MAP) {
            this.attributeGroups = new HashMap();
        }
        this.attributeGroups.put(attributeGroup.getName(), attributeGroup);
    }

    private void addNotation(Notation notation) {
        if (notation == null) {
            return;
        }
        if (this.notations == EmptyStructures.EMPTY_MAP) {
            this.notations = new HashMap();
        }
        this.notations.put(notation.getName(), notation);
    }

    void addElementForResolve(Element element) {
        if (element == null) {
            return;
        }
        if (this.elementResolver == EmptyStructures.EMPTY_LIST) {
            this.elementResolver = new LinkedList();
        }
        this.elementResolver.add(element);
    }

    void addAttributeForResolve(Attribute attribute) {
        if (attribute == null) {
            return;
        }
        if (this.attributeResolver == EmptyStructures.EMPTY_LIST) {
            this.attributeResolver = new LinkedList();
        }
        this.attributeResolver.add(attribute);
    }

    void addGroupForResolve(Group group) {
        if (group == null) {
            return;
        }
        if (this.groupResolver == EmptyStructures.EMPTY_LIST) {
            this.groupResolver = new LinkedList();
        }
        this.groupResolver.add(group);
    }

    void addAttributeGroupForResolve(AttributeGroup attributeGroup) {
        if (attributeGroup == null) {
            return;
        }
        if (this.attributeGroupResolver == EmptyStructures.EMPTY_LIST) {
            this.attributeGroupResolver = new LinkedList();
        }
        this.attributeGroupResolver.add(attributeGroup);
    }

    void addBaseForResolve(InheritType inheritType) {
        if (inheritType == null) {
            return;
        }
        if (this.baseResolver == EmptyStructures.EMPTY_LIST) {
            this.baseResolver = new LinkedList();
        }
        this.baseResolver.add(inheritType);
    }

    void addListForResolve(SimpleType simpleType) {
        if (simpleType == null) {
            return;
        }
        if (this.listItemTypeResolver == EmptyStructures.EMPTY_LIST) {
            this.listItemTypeResolver = new LinkedList();
        }
        this.listItemTypeResolver.add(simpleType);
    }

    void addUnionForResolve(SimpleType simpleType) {
        if (simpleType == null) {
            return;
        }
        if (this.unionMemberResolver == EmptyStructures.EMPTY_LIST) {
            this.unionMemberResolver = new LinkedList();
        }
        this.unionMemberResolver.add(simpleType);
    }

    void addReferenceElement(Element element) {
        if (this.elements.containsKey(element.getName())) {
            return;
        }
        if (this.referenceResolver == EmptyStructures.EMPTY_LIST) {
            this.referenceResolver = new LinkedList();
        }
        if (!this.referenceResolver.contains(element) && !this.elements.containsValue(element)) {
            this.referenceResolver.add(element);
        }
    }

    void addBaseReference(Type type) {
        if (this.types.containsKey(type.getName())) {
            return;
        }
        if (this.baseReferenceResolver == EmptyStructures.EMPTY_LIST) {
            this.baseReferenceResolver = new LinkedList();
        }
        if (!this.baseReferenceResolver.contains(type) && !this.types.containsValue(type)) {
            this.baseReferenceResolver.add(type);
        }
    }

    void resolveSchema() throws SchemaException {
        this.resolveElements();
        this.resolveAttributes();
        this.resolveGroups();
        this.resolveAttributeGroups();
        this.resolveListItemTypes();
        this.resolveUnionMemberTypes();
        this.resolveBaseTypes();
    }

    private void serialize0(OutputStream outputStream) throws IOException {
        XmlSerializerImplementation xmlSerializerImplementation = new XmlSerializerImplementation();
        xmlSerializerImplementation.setOutput(outputStream, "UTF-8");
        xmlSerializerImplementation.startDocument("UTF-8", null);
        this.serialize0(xmlSerializerImplementation);
        xmlSerializerImplementation.endDocument();
    }

    private void serialize0(XmlSerializer xmlSerializer) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        String string = xmlSerializer.getPrefix("http://www.w3.org/2001/XMLSchema", false);
        if (string == null) {
            xmlSerializer.setPrefix("xs", "http://www.w3.org/2001/XMLSchema");
        }
        if (!"".equals(this.targetNamespace) && (string = xmlSerializer.getPrefix(this.targetNamespace, false)) == null) {
            xmlSerializer.setPrefix("tns", this.targetNamespace);
        }
        xmlSerializer.startTag("http://www.w3.org/2001/XMLSchema", "schema");
        if (this.linkedSchemas != null) {
            object5 = this.linkedSchemas.values().iterator();
            while (object5.hasNext()) {
                object4 = (Schema)object5.next();
                xmlSerializer.getPrefix(((Schema)object4).getTargetNamespace(), true);
            }
        }
        if (!"".equals(this.targetNamespace)) {
            xmlSerializer.attribute(null, "targetNamespace", this.targetNamespace);
        }
        xmlSerializer.attribute(null, "elementFormDefault", "qualified");
        xmlSerializer.attribute(null, "attributeFormDefault", "unqualified");
        if (this.imports.size() > 0) {
            object5 = this.imports.entrySet();
            object4 = ((DataStructure)object5).iterator();
            while (object4.hasNext()) {
                object3 = (HashMap.Entry)object4.next();
                object2 = (String)((HashMap.Entry)object3).getKey();
                object = (String)((HashMap.Entry)object3).getValue();
                xmlSerializer.startTag("http://www.w3.org/2001/XMLSchema", "import");
                xmlSerializer.attribute(null, "namespace", (String)object2);
                xmlSerializer.attribute(null, "schemaLocation", (String)object);
                xmlSerializer.endTag("http://www.w3.org/2001/XMLSchema", "import");
            }
        }
        object5 = this.elements.values().iterator();
        while (object5.hasNext()) {
            object4 = (Element)object5.next();
            ((Element)object4).serialize(xmlSerializer, this);
        }
        object5 = this.types.values().iterator();
        while (object5.hasNext()) {
            object4 = (Type)object5.next();
            ((Type)object4).serialize(xmlSerializer, this);
        }
        object5 = this.attributes.values().iterator();
        while (object5.hasNext()) {
            object4 = (Attribute)object5.next();
            ((Attribute)object4).serialize(xmlSerializer, this);
        }
        object5 = this.groups.values().iterator();
        while (object5.hasNext()) {
            object4 = (Group)object5.next();
            ((Group)object4).serialize(xmlSerializer, this);
        }
        object5 = this.attributeGroups.values().iterator();
        while (object5.hasNext()) {
            object4 = (AttributeGroup)object5.next();
            ((AttributeGroup)object4).serialize(xmlSerializer, this);
        }
        this.resolveReferences(xmlSerializer);
        object5 = new ArrayList();
        object4 = this.types.values().iterator();
        while (object4.hasNext()) {
            object3 = (Type)object4.next();
            object2 = ((Type)object3).getKownSubtypes();
            while (object2.hasNext()) {
                object = (Type)object2.next();
                ((ArrayList)object5).add(object);
            }
        }
        while (!((DataStructure)object5).isEmpty()) {
            object4 = (Type)((ArrayList)object5).remove(0);
            object3 = ((Type)object4).getKownSubtypes();
            while (object3.hasNext()) {
                object2 = (Type)object3.next();
                ((ArrayList)object5).add(object2);
            }
            object3 = ((NamedObject)object4).getName();
            if (object3 == null || this.types.containsKey(object3)) continue;
            this.addType((Type)object4);
            if (this.targetNamespace == null || !this.targetNamespace.equals(((QName)object3).getNamespace())) continue;
            ((Type)object4).serialize(xmlSerializer, this);
        }
        xmlSerializer.endTag("http://www.w3.org/2001/XMLSchema", "schema");
    }

    private void resolveReferences(XmlSerializer xmlSerializer) throws IOException {
        LinkedList linkedList = new LinkedList();
        LinkedList linkedList2 = new LinkedList();
        LinkedList linkedList3 = new LinkedList();
        if (!this.types.isEmpty()) {
            linkedList3.addAll(this.types.values());
        }
        while (!this.referenceResolver.isEmpty() || !this.baseReferenceResolver.isEmpty()) {
            Object object;
            LinkedList linkedList4 = new LinkedList();
            linkedList.addAll(this.referenceResolver);
            linkedList.addAll(this.baseReferenceResolver);
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                NamedObject namedObject;
                object = iterator.next();
                if (object instanceof Element) {
                    namedObject = (Element)object;
                    if (this.elements.containsValue(namedObject)) {
                        linkedList2.add(namedObject);
                        continue;
                    }
                    ((Element)namedObject).serialize(xmlSerializer, this);
                    if (this.elements == EmptyStructures.EMPTY_MAP) {
                        this.elements = new HashMap();
                    }
                    this.elements.put(((Reference)namedObject).getName(), namedObject);
                    linkedList2.add(namedObject);
                    Type type = ((Element)namedObject).getType();
                    if (type.getName() == null) continue;
                    String string = type.getName().getNamespace();
                    if (this.types == null || this.types.containsValue(type) || "http://www.w3.org/2001/XMLSchema".equals(string)) continue;
                    ((List)linkedList4).add(type);
                    continue;
                }
                if (object instanceof SimpleType && !"http://www.w3.org/2001/XMLSchema".equals((namedObject = (SimpleType)object).getName().getNamespace())) {
                    ((SimpleType)namedObject).serialize(xmlSerializer, this);
                }
                linkedList2.add(object);
            }
            linkedList.clear();
            iterator = linkedList2.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                if (this.referenceResolver != EmptyStructures.EMPTY_LIST) {
                    this.referenceResolver.remove(object);
                }
                if (this.baseReferenceResolver == EmptyStructures.EMPTY_LIST) continue;
                this.baseReferenceResolver.remove(object);
            }
            linkedList2.clear();
            if (!linkedList4.isEmpty() && this.types == EmptyStructures.EMPTY_MAP) {
                this.types = new HashMap();
            }
            iterator = ((List)linkedList4).iterator();
            while (iterator.hasNext()) {
                object = (Type)iterator.next();
                this.addType((Type)object);
            }
            if (this.types.isEmpty()) continue;
            iterator = this.types.values().iterator();
            while (iterator.hasNext()) {
                object = (Type)iterator.next();
                if (linkedList3.contains(object)) continue;
                ((Type)object).serialize(xmlSerializer, this);
                linkedList3.add(object);
            }
        }
    }

    private void resolveElements() throws SchemaException {
        if (this.elementResolver == null) {
            return;
        }
        if (this.elementResolver.size() > 0) {
            Iterator iterator = this.elementResolver.iterator();
            while (iterator.hasNext()) {
                Type type;
                Object object;
                Element element = (Element)iterator.next();
                QName qName = element.getReferenceLink();
                if (qName != null && (object = this.getElement(qName)) != null) {
                    element.setReference((Reference)object);
                    continue;
                }
                object = element.getTypeLink();
                if (object != null && (type = this.getType((QName)object)) != null) {
                    element.setType(type);
                    continue;
                }
                throw new SchemaException("Cannot resolve element: " + element + " within " + this.targetNamespace);
            }
        }
        this.elementResolver = null;
    }

    private void resolveAttributes() throws SchemaException {
        if (this.attributeResolver == null) {
            return;
        }
        if (this.attributeResolver.size() > 0) {
            Iterator iterator = this.attributeResolver.iterator();
            while (iterator.hasNext()) {
                Type type;
                Object object;
                Attribute attribute = (Attribute)iterator.next();
                QName qName = attribute.getReferenceLink();
                if (qName != null && (object = this.getAttribute(qName)) != null) {
                    attribute.setReference((Reference)object);
                    continue;
                }
                object = attribute.getTypeLink();
                if (object != null && (type = this.getType((QName)object)) != null) {
                    attribute.setType(type);
                    continue;
                }
                throw new SchemaException("Cannot resolve attribute: " + attribute);
            }
        }
        this.attributeResolver = null;
    }

    private void resolveGroups() throws SchemaException {
        if (this.groupResolver == null) {
            return;
        }
        if (this.groupResolver.size() > 0) {
            Iterator iterator = this.groupResolver.iterator();
            while (iterator.hasNext()) {
                Group group;
                Group group2 = (Group)iterator.next();
                QName qName = group2.getReferenceLink();
                if (qName != null && (group = this.getGroup(qName)) != null) {
                    group2.setReference(group);
                    continue;
                }
                throw new SchemaException("Cannot resolve group: " + group2);
            }
        }
        this.groupResolver = null;
    }

    private void resolveAttributeGroups() throws SchemaException {
        if (this.attributeGroupResolver == null) {
            return;
        }
        if (this.attributeGroupResolver.size() > 0) {
            Iterator iterator = this.attributeGroupResolver.iterator();
            while (iterator.hasNext()) {
                AttributeGroup attributeGroup;
                AttributeGroup attributeGroup2 = (AttributeGroup)iterator.next();
                QName qName = attributeGroup2.getReferenceLink();
                if (qName != null && (attributeGroup = this.getAttributeGroup(qName)) != null) {
                    attributeGroup2.setReference(attributeGroup);
                    continue;
                }
                throw new SchemaException("Cannot resolve attribute group: " + attributeGroup2);
            }
        }
        this.attributeGroupResolver = null;
    }

    private void resolveListItemTypes() throws SchemaException {
        if (this.listItemTypeResolver == null) {
            return;
        }
        if (this.listItemTypeResolver.size() > 0) {
            Iterator iterator = this.listItemTypeResolver.iterator();
            while (iterator.hasNext()) {
                Type type;
                SimpleType simpleType = (SimpleType)iterator.next();
                QName qName = simpleType.getListItemLink();
                if (qName != null && (type = this.getType(qName)) != null) {
                    simpleType.setListItemType(type);
                    continue;
                }
                throw new SchemaException("Cannot resolve list item type: " + simpleType);
            }
        }
        this.listItemTypeResolver = null;
    }

    private void resolveUnionMemberTypes() throws SchemaException {
        if (this.unionMemberResolver == null) {
            return;
        }
        if (this.unionMemberResolver.size() > 0) {
            Iterator iterator = this.unionMemberResolver.iterator();
            while (iterator.hasNext()) {
                SimpleType simpleType = (SimpleType)iterator.next();
                ArrayList arrayList = new ArrayList();
                Iterator iterator2 = simpleType.getMemberLinks();
                while (iterator2.hasNext()) {
                    Type type;
                    QName qName = (QName)iterator2.next();
                    if (qName != null && (type = this.getType(qName)) != null) {
                        ((List)arrayList).add(type);
                        continue;
                    }
                    throw new SchemaException("Cannot resolve union member types: " + simpleType);
                }
                simpleType.insertMembers(arrayList);
            }
        }
        this.unionMemberResolver = null;
    }

    private void resolveBaseTypes() throws SchemaException {
        if (this.baseResolver == null) {
            return;
        }
        if (this.baseResolver.size() > 0) {
            Iterator iterator = this.baseResolver.iterator();
            while (iterator.hasNext()) {
                Type type;
                InheritType inheritType = (InheritType)iterator.next();
                QName qName = null;
                if (inheritType instanceof RestrictedSimpleContent) {
                    qName = ((RestrictedSimpleContent)inheritType).getBaseLink();
                } else if (inheritType instanceof RestrictedComplexContent) {
                    qName = ((RestrictedComplexContent)inheritType).getBaseLink();
                } else if (inheritType instanceof ExtendedSimpleContent) {
                    qName = ((ExtendedSimpleContent)inheritType).getBaseLink();
                } else if (inheritType instanceof ExtendedComplexContent) {
                    qName = ((ExtendedComplexContent)inheritType).getBaseLink();
                } else if (inheritType instanceof RestrictedSimpleType) {
                    qName = ((RestrictedSimpleType)inheritType).getBaseLink();
                }
                if (qName != null && (type = this.getType(qName)) != null) {
                    inheritType.setBase(type);
                    continue;
                }
                throw new SchemaException("Cannot resolve the base for: " + inheritType);
            }
        }
        this.baseResolver = null;
    }

    private void handleSchema(ElementParser elementParser, URI uRI, boolean bl) throws XmlPullParserException, IOException, SchemaException {
        int n = elementParser.getDepth();
        while (elementParser.nextTag() != 3 && elementParser.getDepth() == n + 1) {
            Object object;
            Object object2;
            Object object3;
            String string = elementParser.getNamespace();
            String string2 = elementParser.getName();
            if (!"http://www.w3.org/2001/XMLSchema".equals(string)) continue;
            if (StringUtil.equalsIgnoreCase("element", string2)) {
                object3 = Element.createElement(elementParser, this.targetNamespace, this, true);
                this.addElement((Element)object3);
                continue;
            }
            if (StringUtil.equalsIgnoreCase("complexType", string2)) {
                object3 = ComplexType.createComplexType(elementParser, this.targetNamespace, this);
                this.addType((Type)object3);
                continue;
            }
            if (StringUtil.equalsIgnoreCase("simpleType", string2)) {
                object3 = SimpleType.createSimpleType(elementParser, this.targetNamespace, this);
                this.addType((Type)object3);
                continue;
            }
            if (StringUtil.equalsIgnoreCase("attribute", string2)) {
                object3 = Attribute.createAttribute(elementParser, this.targetNamespace, this);
                this.addAttribute((Attribute)object3);
                continue;
            }
            if (StringUtil.equalsIgnoreCase("group", string2)) {
                object3 = Group.createGroup(elementParser, this.targetNamespace, this);
                this.addGroup((Group)object3);
                continue;
            }
            if (StringUtil.equalsIgnoreCase("attributeGroup", string2)) {
                object3 = AttributeGroup.createAttributeGroup(elementParser, this.targetNamespace, this);
                this.addAttributeGroup((AttributeGroup)object3);
                continue;
            }
            if (StringUtil.equalsIgnoreCase("annotation", string2)) {
                Annotation.handleAnnotation(elementParser, this);
                continue;
            }
            if (StringUtil.equalsIgnoreCase("notation", string2)) {
                object3 = Notation.createNotation(elementParser);
                this.addNotation((Notation)object3);
                continue;
            }
            if (StringUtil.equalsIgnoreCase("include", string2)) {
                object3 = elementParser.getAttributeValue(null, "schemaLocation");
                if (uRI == null) {
                    new ElementParser(elementParser).consume();
                    object2 = WSDLRepository.getInstance().getSchema((String)object3, this.getTargetNamespace());
                } else {
                    object = URI.absolutize(uRI, (String)object3);
                    object2 = SchemaUtil.includeOrImportSchema(elementParser, (URI)object, bl);
                }
                if (object2 != null) {
                    if (!this.getTargetNamespace().equals(((Schema)object2).targetNamespace)) {
                        throw new SchemaException("Cannot include " + (String)object3 + " with different target namespace. Try to import.");
                    }
                    if (bl) {
                        ((Schema)object2).resolveSchema();
                    }
                    this.mergeSchema((Schema)object2, this);
                }
                this.addInclude((String)object3);
                continue;
            }
            if (!StringUtil.equalsIgnoreCase("import", string2)) continue;
            object3 = elementParser.getAttributeValue(null, "namespace");
            object2 = elementParser.getAttributeValue(null, "schemaLocation");
            if (bl) {
                if (uRI == null) {
                    new ElementParser(elementParser).consume();
                    object = WSDLRepository.getInstance().getSchema((String)object2, (String)object3);
                } else {
                    URI uRI2 = URI.absolutize(uRI, (String)object2);
                    object = SchemaUtil.includeOrImportSchema(elementParser, uRI2, true);
                    if (object3 != null && !((String)object3).equals(((Schema)object).targetNamespace)) {
                        throw new SchemaException("Import schema from " + (String)object2 + " doesn't match expected target namespace " + (String)object3 + ".");
                    }
                }
                if (object != null) {
                    ((Schema)object).resolveSchema();
                    this.addLinkedSchema((Schema)object);
                }
            } else {
                new ElementParser(elementParser).consume();
            }
            this.addImport((String)object3, (String)object2);
        }
    }

    private void mergeSchema(Schema schema, Schema schema2) {
        if (schema.imports.size() > 0) {
            if (schema2.imports == EmptyStructures.EMPTY_MAP) {
                schema2.imports = new HashMap();
            }
            schema2.imports.putAll(schema.imports);
        }
        if (schema.types.size() > 0) {
            if (schema2.types == EmptyStructures.EMPTY_MAP) {
                schema2.types = new HashMap();
            }
            schema2.types.putAll(schema.types);
        }
        if (schema.elements.size() > 0) {
            if (schema2.elements == EmptyStructures.EMPTY_MAP) {
                schema2.elements = new HashMap();
            }
            schema2.elements.putAll(schema.elements);
        }
        if (schema.attributes.size() > 0) {
            if (schema2.attributes == EmptyStructures.EMPTY_MAP) {
                schema2.attributes = new HashMap();
            }
            schema2.attributes.putAll(schema.attributes);
        }
        if (schema.attributeGroups.size() > 0) {
            if (schema2.attributeGroups == EmptyStructures.EMPTY_MAP) {
                schema2.attributeGroups = new HashMap();
            }
            schema2.attributeGroups.putAll(schema.attributeGroups);
        }
        if (schema.groups.size() > 0) {
            if (schema2.groups == EmptyStructures.EMPTY_MAP) {
                schema2.groups = new HashMap();
            }
            schema2.groups.putAll(schema.groups);
        }
    }

    private void addLinkedSchema(Schema schema) {
        if (this.linkedSchemas == EmptyStructures.EMPTY_MAP) {
            this.linkedSchemas = new HashMap();
        }
        this.linkedSchemas.put(schema.getTargetNamespace(), schema);
    }

    public HashMap getHeaderFields() {
        return null;
    }

    public String shortDescription() {
        return "XSD [ " + this.getTargetNamespace() + " ]";
    }

    public long getLastModifiedDate() {
        return this.lastMod;
    }
}

