/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.schema;

import java.io.IOException;
import java.io.InputStream;
import org.ws4d.java.DPWSFramework;
import org.ws4d.java.communication.TimeoutException;
import org.ws4d.java.communication.monitor.ResourceLoader;
import org.ws4d.java.constants.SchemaConstants;
import org.ws4d.java.io.xml.ElementParser;
import org.ws4d.java.schema.AnySimpleType;
import org.ws4d.java.schema.ComplexType;
import org.ws4d.java.schema.Element;
import org.ws4d.java.schema.Schema;
import org.ws4d.java.schema.SchemaException;
import org.ws4d.java.schema.SimpleType;
import org.ws4d.java.schema.Type;
import org.ws4d.java.service.Fault;
import org.ws4d.java.service.OperationCommons;
import org.ws4d.java.service.OperationDescription;
import org.ws4d.java.service.Service;
import org.ws4d.java.structures.HashMap;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.types.QName;
import org.ws4d.java.types.URI;
import org.ws4d.java.util.Log;
import org.ws4d.java.util.StringUtil;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public final class SchemaUtil
implements SchemaConstants {
    public static final String TYPE_ANYTYPE = SCHEMA_STYPES[44];
    public static final String TYPE_ANYSIMPLETYPE = SCHEMA_STYPES[45];
    public static final String TYPE_STRING = SCHEMA_STYPES[0];
    public static final String TYPE_NORMALIZED_STRING = SCHEMA_STYPES[1];
    public static final String TYPE_TOKEN = SCHEMA_STYPES[2];
    public static final String TYPE_BASE64_BINARY = SCHEMA_STYPES[3];
    public static final String TYPE_HEX_BINARY = SCHEMA_STYPES[4];
    public static final String TYPE_INTEGER = SCHEMA_STYPES[5];
    public static final String TYPE_POSITIVE_INTEGER = SCHEMA_STYPES[6];
    public static final String TYPE_NEGATIVE_INTEGER = SCHEMA_STYPES[7];
    public static final String TYPE_NON_NEGATIVE_INTEGER = SCHEMA_STYPES[8];
    public static final String TYPE_NON_POSITIVE_INTEGER = SCHEMA_STYPES[9];
    public static final String TYPE_LONG = SCHEMA_STYPES[10];
    public static final String TYPE_UNSIGNED_LONG = SCHEMA_STYPES[11];
    public static final String TYPE_INT = SCHEMA_STYPES[12];
    public static final String TYPE_UNSIGNED_INT = SCHEMA_STYPES[13];
    public static final String TYPE_SHORT = SCHEMA_STYPES[14];
    public static final String TYPE_UNSIGNED_SHORT = SCHEMA_STYPES[15];
    public static final String TYPE_BYTE = SCHEMA_STYPES[16];
    public static final String TYPE_UNSIGNED_BYTE = SCHEMA_STYPES[17];
    public static final String TYPE_DECIMAL = SCHEMA_STYPES[18];
    public static final String TYPE_FLOAT = SCHEMA_STYPES[19];
    public static final String TYPE_DOUBLE = SCHEMA_STYPES[20];
    public static final String TYPE_BOOLEAN = SCHEMA_STYPES[21];
    public static final String TYPE_DURATION = SCHEMA_STYPES[22];
    public static final String TYPE_DATE_TIME = SCHEMA_STYPES[23];
    public static final String TYPE_DATE = SCHEMA_STYPES[24];
    public static final String TYPE_TIME = SCHEMA_STYPES[25];
    public static final String TYPE_G_YEAR = SCHEMA_STYPES[26];
    public static final String TYPE_G_YEARMONTH = SCHEMA_STYPES[27];
    public static final String TYPE_G_MONTH = SCHEMA_STYPES[28];
    public static final String TYPE_G_MONTH_DAY = SCHEMA_STYPES[29];
    public static final String TYPE_G_DAY = SCHEMA_STYPES[30];
    public static final String TYPE_NAME = SCHEMA_STYPES[31];
    public static final String TYPE_QNAME = SCHEMA_STYPES[32];
    public static final String TYPE_NCNAME = SCHEMA_STYPES[33];
    public static final String TYPE_ANYURI = SCHEMA_STYPES[34];
    public static final String TYPE_LANGUAGE = SCHEMA_STYPES[35];
    public static final String TYPE_ID = SCHEMA_STYPES[36];
    public static final String TYPE_IDREF = SCHEMA_STYPES[37];
    public static final String TYPE_IDREFS = SCHEMA_STYPES[38];
    public static final String TYPE_ENTITY = SCHEMA_STYPES[39];
    public static final String TYPE_ENTITIES = SCHEMA_STYPES[40];
    public static final String TYPE_NOTATION = SCHEMA_STYPES[41];
    public static final String TYPE_NMTOKEN = SCHEMA_STYPES[42];
    public static final String TYPE_NMTOKENS = SCHEMA_STYPES[43];
    private static final String[] NATIVES = new String[]{TYPE_ANYTYPE, TYPE_ANYSIMPLETYPE, TYPE_STRING, TYPE_NORMALIZED_STRING, TYPE_TOKEN, TYPE_BYTE, TYPE_UNSIGNED_BYTE, TYPE_BASE64_BINARY, TYPE_HEX_BINARY, TYPE_INTEGER, TYPE_POSITIVE_INTEGER, TYPE_NEGATIVE_INTEGER, TYPE_NON_NEGATIVE_INTEGER, TYPE_NON_POSITIVE_INTEGER, TYPE_INT, TYPE_UNSIGNED_INT, TYPE_LONG, TYPE_UNSIGNED_LONG, TYPE_SHORT, TYPE_UNSIGNED_SHORT, TYPE_DECIMAL, TYPE_FLOAT, TYPE_DOUBLE, TYPE_BOOLEAN, TYPE_TIME, TYPE_DATE_TIME, TYPE_DURATION, TYPE_DATE, TYPE_G_MONTH, TYPE_G_YEAR, TYPE_G_YEARMONTH, TYPE_G_DAY, TYPE_G_MONTH_DAY, TYPE_NAME, TYPE_QNAME, TYPE_NCNAME, TYPE_ANYURI, TYPE_LANGUAGE, TYPE_ID, TYPE_IDREF, TYPE_IDREFS, TYPE_ENTITY, TYPE_ENTITIES, TYPE_NOTATION, TYPE_NMTOKEN, TYPE_NMTOKENS};
    private static final String[] BINARY = new String[]{TYPE_HEX_BINARY, TYPE_BASE64_BINARY};
    public static final long MILLIS_PER_SECOND = 1000L;
    public static final long MILLIS_PER_MINUTE = 60000L;
    public static final long MILLIS_PER_HOUR = 3600000L;
    public static final long MILLIS_PER_DAY = 86400000L;
    public static final long MILLIS_PER_MONTH = 2592000000L;
    public static final long MILLIS_PER_YEAR = 31536000000L;
    private static HashMap nativeTypes = null;

    private SchemaUtil() {
    }

    public static long parseDuration(String string) {
        if (string == null) {
            return 0L;
        }
        long l = 0L;
        long l2 = 1L;
        boolean bl = false;
        String string2 = "";
        int n = string.length();
        block11: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case 'P': {
                    continue block11;
                }
                case 'Y': {
                    l2 = 31536000000L;
                    break;
                }
                case 'M': {
                    l2 = bl ? 60000L : 2592000000L;
                    break;
                }
                case 'D': {
                    l2 = 86400000L;
                    break;
                }
                case 'T': {
                    bl = true;
                    continue block11;
                }
                case 'H': {
                    l2 = 3600000L;
                    break;
                }
                case 'S': {
                    l2 = 1000L;
                    break;
                }
                default: {
                    string2 = string2 + c;
                    continue block11;
                }
            }
            try {
                l += Long.parseLong(string2.trim()) * l2;
            }
            catch (NumberFormatException numberFormatException) {
                return -1L;
            }
            string2 = "";
        }
        return l;
    }

    public static String createDuration(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        if (l < 0L) {
            stringBuffer.append('-');
        }
        stringBuffer.append('P');
        if (l > 31536000000L) {
            stringBuffer.append(l / 31536000000L).append('Y');
            l %= 31536000000L;
        }
        if (l > 2592000000L) {
            stringBuffer.append(l / 2592000000L).append('M');
            l %= 2592000000L;
        }
        if (l > 86400000L) {
            stringBuffer.append(l / 86400000L).append('D');
            l %= 86400000L;
        }
        if (l > 0L) {
            stringBuffer.append('T');
        }
        if (l > 3600000L) {
            stringBuffer.append(l / 3600000L).append('H');
            l %= 3600000L;
        }
        if (l > 60000L) {
            stringBuffer.append(l / 60000L).append('M');
            l %= 60000L;
        }
        if (l >= 1000L) {
            stringBuffer.append(l / 1000L).append('S');
        }
        return stringBuffer.toString();
    }

    public static synchronized Type getType(QName qName) {
        if (nativeTypes == null) {
            SchemaUtil.initNatives();
        }
        return (Type)nativeTypes.get(qName);
    }

    public static Type getSchemaType(String string) {
        return SchemaUtil.getType(new QName(string, "http://www.w3.org/2001/XMLSchema"));
    }

    public static boolean isBinaryType(String string) {
        for (int i = 0; i < BINARY.length; ++i) {
            if (!BINARY[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public static String getPrefix(String string) {
        int n = string.indexOf(":");
        if (n == -1) {
            return null;
        }
        return string.substring(0, n);
    }

    public static String getPrefixedName(XmlSerializer xmlSerializer, QName qName) {
        if (qName == null) {
            return "";
        }
        String string = xmlSerializer.getPrefix(qName.getNamespace(), false);
        return string + ":" + qName.getLocalPart();
    }

    public static String getName(String string) {
        int n = string.indexOf(":");
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1, string.length());
    }

    private static void addElementMap(Element element, HashMap hashMap) {
        if (element != null) {
            Schema schema = null;
            String string = element.getName().getNamespace();
            if (hashMap.containsKey(string)) {
                schema = (Schema)hashMap.get(string);
            } else {
                schema = new Schema(string);
                hashMap.put(element.getName().getNamespace(), schema);
            }
            schema.addElement(element);
        }
    }

    private static void addTypeMap(Type type, HashMap hashMap) {
        if (type != null) {
            Schema schema = null;
            String string = type.getName().getNamespace();
            if (hashMap.containsKey(string)) {
                schema = (Schema)hashMap.get(string);
            } else {
                schema = new Schema(string);
                hashMap.put(type.getName().getNamespace(), schema);
            }
            schema.addType(type);
        }
    }

    public static void addToSchemaMap(Iterator iterator, HashMap hashMap) {
        while (iterator.hasNext()) {
            Object object;
            OperationCommons operationCommons = (OperationCommons)iterator.next();
            Element element = operationCommons.getInput();
            SchemaUtil.addElementMap(element, hashMap);
            Element element2 = operationCommons.getOutput();
            SchemaUtil.addElementMap(element2, hashMap);
            Iterator iterator2 = operationCommons.getFaults();
            while (iterator2.hasNext()) {
                object = (Fault)iterator2.next();
                Element element3 = ((Fault)object).getElement();
                SchemaUtil.addElementMap(element3, hashMap);
            }
            iterator2 = operationCommons.getCustomComplexTypes();
            while (iterator2.hasNext()) {
                object = (ComplexType)iterator2.next();
                SchemaUtil.addTypeMap((Type)object, hashMap);
            }
        }
    }

    public static HashMap createSchema(Service service, String string) {
        HashMap hashMap = new HashMap();
        SchemaUtil.addToSchemaMap(service.getOperations(), hashMap);
        SchemaUtil.addToSchemaMap(service.getEventSources(), hashMap);
        return hashMap;
    }

    public static Schema createSchema(Service service) {
        Schema schema = new Schema();
        String string = null;
        try {
            if (service.getParentDeviceReference() != null) {
                string = service.getParentDeviceReference().getDevice().getDefaultNamespace();
            }
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        SchemaUtil.addToSchema(service.getOperations(), schema, string);
        SchemaUtil.addToSchema(service.getEventSources(), schema, string);
        try {
            schema.resolveSchema();
        }
        catch (SchemaException schemaException) {
            Log.printStackTrace(schemaException);
        }
        return schema;
    }

    static Type getAnyType() {
        return SchemaUtil.getType(new QName(TYPE_ANYTYPE, "http://www.w3.org/2001/XMLSchema"));
    }

    static Type getAnySimpleType() {
        return SchemaUtil.getType(new QName(TYPE_ANYSIMPLETYPE, "http://www.w3.org/2001/XMLSchema"));
    }

    static Schema includeOrImportSchema(ElementParser elementParser, URI uRI, boolean bl) throws XmlPullParserException, IOException, SchemaException {
        Schema schema = null;
        ResourceLoader resourceLoader = DPWSFramework.getResourceAsStream(uRI);
        InputStream inputStream = resourceLoader.getInputStream();
        if (inputStream == null) {
            throw new IOException("Cannot include. Unable to access location " + uRI);
        }
        schema = Schema.parse(inputStream, uRI, bl);
        inputStream.close();
        int n = elementParser.getDepth();
        while (elementParser.nextTag() != 3 && elementParser.getDepth() == n + 1) {
            SchemaUtil.handleUnkownTags(elementParser);
        }
        return schema;
    }

    static void handleUnkownTags(ElementParser elementParser) throws XmlPullParserException, IOException {
        int n = elementParser.getDepth();
        int n2 = elementParser.getEventType();
        while (n2 != 3 && n2 != 1 && elementParser.getDepth() >= n) {
            n2 = elementParser.nextTag();
            SchemaUtil.handleUnkownTags(elementParser);
        }
    }

    private static void addToSchema(Iterator iterator, Schema schema, String string) {
        while (iterator.hasNext()) {
            Element element;
            OperationDescription operationDescription = (OperationDescription)iterator.next();
            Element element2 = operationDescription.getInput();
            if (element2 != null) {
                element2.globalScope = true;
                if (element2.name == null) {
                    element2.name = new QName(StringUtil.simpleClassName(element2.getClass()), string);
                }
                schema.addElement(element2);
            }
            if ((element = operationDescription.getOutput()) != null) {
                element.globalScope = true;
                schema.addElement(element);
            }
            Iterator iterator2 = operationDescription.getFaults();
            while (iterator2.hasNext()) {
                Fault fault = (Fault)iterator2.next();
                Element element3 = fault.getElement();
                if (element3 == null) continue;
                element3.globalScope = true;
                schema.addElement(element3);
            }
        }
    }

    private static void initNatives() {
        nativeTypes = new HashMap();
        for (int i = 0; i < NATIVES.length; ++i) {
            QName qName = new QName(NATIVES[i], "http://www.w3.org/2001/XMLSchema");
            SimpleType simpleType = new SimpleType(qName);
            nativeTypes.put(qName, simpleType);
        }
        QName qName = new QName(TYPE_ANYTYPE, "http://www.w3.org/2001/XMLSchema");
        nativeTypes.put(qName, new ComplexType(qName));
        qName = new QName(TYPE_ANYSIMPLETYPE, "http://www.w3.org/2001/XMLSchema");
        nativeTypes.put(qName, new AnySimpleType(qName));
    }
}

