/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.schema;

import java.io.IOException;
import org.ws4d.java.io.xml.ElementParser;
import org.ws4d.java.schema.Annotation;
import org.ws4d.java.schema.InheritType;
import org.ws4d.java.schema.NamedObject;
import org.ws4d.java.schema.RestrictedSimpleType;
import org.ws4d.java.schema.Schema;
import org.ws4d.java.schema.SchemaException;
import org.ws4d.java.schema.SchemaUtil;
import org.ws4d.java.schema.Type;
import org.ws4d.java.structures.EmptyStructures;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.structures.LinkedList;
import org.ws4d.java.structures.List;
import org.ws4d.java.types.QName;
import org.ws4d.java.util.StringUtil;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class SimpleType
extends Type {
    static final String TAG_SIMPLETYPE = "simpleType";
    static final String TAG_UNION = "union";
    static final String TAG_LIST = "list";
    static final String ATTRIBUTE_MEMBERTYPES = "memberTypes";
    static final String ATTRIBUTE_ITEMTYPE = "itemType";
    protected List member = EmptyStructures.EMPTY_LIST;
    protected List memberLinks = EmptyStructures.EMPTY_LIST;
    protected QName listItemLink = null;
    protected Type listItemType = null;

    static final Type createSimpleType(ElementParser elementParser, String string, Schema schema) throws XmlPullParserException, IOException, SchemaException {
        String string2 = elementParser.getAttributeValue(null, "name");
        Type type = null;
        type = string2 == null ? new SimpleType() : new SimpleType(new QName(string2, string));
        type.setParentSchema(schema);
        int n = elementParser.getDepth();
        while (elementParser.nextTag() != 3 && elementParser.getDepth() == n + 1) {
            Type type2;
            String string3 = elementParser.getNamespace();
            String string4 = elementParser.getName();
            if (!"http://www.w3.org/2001/XMLSchema".equals(string3)) continue;
            if (StringUtil.equalsIgnoreCase("restriction", string4)) {
                type = string2 == null ? new RestrictedSimpleType() : new RestrictedSimpleType(new QName(string2, string));
                type2 = (RestrictedSimpleType)type;
                RestrictedSimpleType.handleRestriction(elementParser, (RestrictedSimpleType)type2, string, schema);
                if (((RestrictedSimpleType)type2).getBase() != null) continue;
                schema.addBaseForResolve((InheritType)((Object)type2));
                continue;
            }
            if (TAG_UNION.equals(string4)) {
                type2 = type;
                SimpleType.handleUnion(elementParser, (SimpleType)type2, string, schema);
                continue;
            }
            if (TAG_LIST.equals(string4)) {
                type2 = type;
                SimpleType.handleList(elementParser, (SimpleType)type2, string, schema);
                continue;
            }
            if (!"annotation".equals(string4)) continue;
            Annotation.handleAnnotation(elementParser, type);
        }
        return type;
    }

    private static final void handleUnion(ElementParser elementParser, SimpleType simpleType, String string, Schema schema) throws XmlPullParserException, IOException, SchemaException {
        Object object;
        String string2;
        String string3 = elementParser.getAttributeValue(null, ATTRIBUTE_MEMBERTYPES);
        if (string3 != null) {
            String[] stringArray = StringUtil.split(string3, ' ');
            for (int i = 0; i < stringArray.length; ++i) {
                string2 = SchemaUtil.getPrefix(stringArray[i]);
                object = SchemaUtil.getName(stringArray[i]);
                String string4 = elementParser.getNamespace(string2);
                QName qName = new QName((String)object, string4);
                simpleType.addMemberLink(qName);
            }
            schema.addUnionForResolve(simpleType);
        }
        int n = elementParser.getDepth();
        while (elementParser.nextTag() != 3 && elementParser.getDepth() == n + 1) {
            String string5 = elementParser.getNamespace();
            string2 = elementParser.getName();
            if (!"http://www.w3.org/2001/XMLSchema".equals(string5) || !StringUtil.equalsIgnoreCase(TAG_SIMPLETYPE, string2)) continue;
            object = SimpleType.createSimpleType(elementParser, string, schema);
            simpleType.addMember((Type)object);
        }
    }

    private static final void handleList(ElementParser elementParser, SimpleType simpleType, String string, Schema schema) throws XmlPullParserException, IOException, SchemaException {
        Object object;
        String string2;
        String string3;
        String string4 = elementParser.getAttributeValue(null, ATTRIBUTE_ITEMTYPE);
        if (string4 != null) {
            String string5 = SchemaUtil.getPrefix(string4);
            string3 = SchemaUtil.getName(string4);
            string2 = elementParser.getNamespace(string5);
            object = new QName(string3, string2);
            simpleType.setListItemLink((QName)object);
            schema.addListForResolve(simpleType);
        }
        int n = elementParser.getDepth();
        while (elementParser.nextTag() != 3 && elementParser.getDepth() == n + 1) {
            string3 = elementParser.getNamespace();
            string2 = elementParser.getName();
            if (!"http://www.w3.org/2001/XMLSchema".equals(string3) || !StringUtil.equalsIgnoreCase(TAG_SIMPLETYPE, string2)) continue;
            object = SimpleType.createSimpleType(elementParser, string, schema);
            simpleType.setListItemType((Type)object);
        }
    }

    public SimpleType() {
    }

    public SimpleType(QName qName) {
        super(qName);
    }

    public int getSchemaIdentifier() {
        return 3;
    }

    public boolean isList() {
        return this.listItemLink != null || this.listItemType != null;
    }

    public boolean isUnion() {
        if (this.member != null && this.member.size() > 0) {
            return true;
        }
        return this.memberLinks != null && this.memberLinks.size() > 0;
    }

    public Iterator getMembers() {
        return this.member.iterator();
    }

    public void addMember(Type type) {
        if (this.member == EmptyStructures.EMPTY_LIST) {
            this.member = new LinkedList();
        }
        this.member.add(type);
    }

    public void setListItemType(Type type) {
        int n = type.getSchemaIdentifier();
        if (n != 3 && n != 9) {
            throw new IllegalArgumentException("Illegal list item type (expected a simple type): " + type);
        }
        this.listItemLink = null;
        this.listItemType = type;
    }

    public Type getListItemType() {
        return this.listItemType;
    }

    void serialize(XmlSerializer xmlSerializer, Schema schema) throws IOException {
        xmlSerializer.startTag("http://www.w3.org/2001/XMLSchema", TAG_SIMPLETYPE);
        if (this.name != null) {
            xmlSerializer.attribute(null, "name", this.name.getLocalPart());
        }
        if (this.isUnion()) {
            Object object;
            Object object2;
            xmlSerializer.startTag("http://www.w3.org/2001/XMLSchema", TAG_UNION);
            if (this.memberLinks.size() > 0) {
                object2 = new StringBuffer();
                object = this.getMemberLinks();
                while (object.hasNext()) {
                    QName qName = (QName)object.next();
                    String string = xmlSerializer.getPrefix(qName.getNamespace(), false);
                    if (string != null && !"".equals(string)) {
                        qName.setPrefix(string);
                        ((StringBuffer)object2).append(qName.getLocalPartPrefixed());
                    } else {
                        ((StringBuffer)object2).append(qName.getLocalPart());
                    }
                    if (!object.hasNext()) continue;
                    ((StringBuffer)object2).append(" ");
                }
                xmlSerializer.attribute(null, ATTRIBUTE_MEMBERTYPES, ((StringBuffer)object2).toString());
            }
            if (this.member.size() > 0) {
                object2 = this.getMembers();
                while (object2.hasNext()) {
                    object = (Type)object2.next();
                    if (((NamedObject)object).getName() != null) continue;
                    ((Type)object).serialize(xmlSerializer, schema);
                }
            }
            xmlSerializer.endTag("http://www.w3.org/2001/XMLSchema", TAG_UNION);
        } else if (this.isList()) {
            xmlSerializer.startTag("http://www.w3.org/2001/XMLSchema", TAG_LIST);
            if (this.listItemType == null) {
                xmlSerializer.attribute(null, ATTRIBUTE_ITEMTYPE, SchemaUtil.getPrefixedName(xmlSerializer, this.listItemLink));
            } else if (this.listItemType.getName() != null) {
                xmlSerializer.attribute(null, ATTRIBUTE_ITEMTYPE, SchemaUtil.getPrefixedName(xmlSerializer, this.listItemType.getName()));
            } else {
                this.listItemType.serialize(xmlSerializer, schema);
            }
            xmlSerializer.endTag("http://www.w3.org/2001/XMLSchema", TAG_LIST);
        }
        xmlSerializer.endTag("http://www.w3.org/2001/XMLSchema", TAG_SIMPLETYPE);
    }

    Iterator getMemberLinks() {
        return this.memberLinks.iterator();
    }

    void addMemberLink(QName qName) {
        if (this.memberLinks == EmptyStructures.EMPTY_LIST) {
            this.memberLinks = new LinkedList();
        }
        this.memberLinks.add(qName);
    }

    void insertMembers(List list) {
        if (this.member == EmptyStructures.EMPTY_LIST) {
            this.member = new LinkedList();
        }
        this.member.addAll(0, list);
    }

    void setListItemLink(QName qName) {
        this.listItemLink = qName;
    }

    QName getListItemLink() {
        return this.listItemLink;
    }
}

