/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.security;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.ws4d.java.util.StringUtil;

public class Base64Util {
    public static final int NO_OPTIONS = 0;
    public static final int ENCODE = 1;
    public static final int DECODE = 0;
    public static final int DONT_BREAK_LINES = 8;
    private static final int MAX_LINE_LENGTH = 76;
    private static final byte EQUALS_SIGN = 61;
    private static final byte NEW_LINE = 10;
    private static final String PREFERRED_ENCODING;
    private static final int BLOCK_SIZE = 4096;
    private static final byte[] ALPHABET;
    private static final byte[] NATIVE_ALPHABET;
    private static final byte[] DECODABET;
    private static final byte WHITE_SPACE_ENC = -5;
    private static final byte EQUALS_SIGN_ENC = -1;

    private Base64Util() {
    }

    private static byte[] encode3to4(byte[] byArray, byte[] byArray2, int n) {
        Base64Util.encode3to4(byArray2, 0, n, byArray, 0);
        return byArray;
    }

    private static byte[] encode3to4(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        int n4 = (n2 > 0 ? byArray[n] << 24 >>> 8 : 0) | (n2 > 1 ? byArray[n + 1] << 24 >>> 16 : 0) | (n2 > 2 ? byArray[n + 2] << 24 >>> 24 : 0);
        switch (n2) {
            case 3: {
                byArray2[n3] = ALPHABET[n4 >>> 18];
                byArray2[n3 + 1] = ALPHABET[n4 >>> 12 & 0x3F];
                byArray2[n3 + 2] = ALPHABET[n4 >>> 6 & 0x3F];
                byArray2[n3 + 3] = ALPHABET[n4 & 0x3F];
                return byArray2;
            }
            case 2: {
                byArray2[n3] = ALPHABET[n4 >>> 18];
                byArray2[n3 + 1] = ALPHABET[n4 >>> 12 & 0x3F];
                byArray2[n3 + 2] = ALPHABET[n4 >>> 6 & 0x3F];
                byArray2[n3 + 3] = 61;
                return byArray2;
            }
            case 1: {
                byArray2[n3] = ALPHABET[n4 >>> 18];
                byArray2[n3 + 1] = ALPHABET[n4 >>> 12 & 0x3F];
                byArray2[n3 + 2] = 61;
                byArray2[n3 + 3] = 61;
                return byArray2;
            }
        }
        return byArray2;
    }

    public static String encodeBytes(byte[] byArray) {
        return Base64Util.encodeBytes(byArray, 0, byArray.length, 0);
    }

    public static String encodeBytes(byte[] byArray, int n) {
        return Base64Util.encodeBytes(byArray, 0, byArray.length, n);
    }

    public static String encodeBytes(byte[] byArray, int n, int n2) {
        return Base64Util.encodeBytes(byArray, n, n2, 0);
    }

    public static String encodeBytes(byte[] byArray, int n, int n2, int n3) {
        int n4 = n3 & 8;
        boolean bl = n4 == 0;
        int n5 = n2 * 4 / 3;
        byte[] byArray2 = new byte[n5 + (n2 % 3 > 0 ? 4 : 0) + (bl ? n5 / 76 : 0)];
        int n6 = 0;
        int n7 = 0;
        int n8 = n2 - 2;
        int n9 = 0;
        while (n6 < n8) {
            Base64Util.encode3to4(byArray, n6 + n, 3, byArray2, n7);
            if (bl && (n9 += 4) == 76) {
                byArray2[n7 + 4] = 10;
                ++n7;
                n9 = 0;
            }
            n6 += 3;
            n7 += 4;
        }
        if (n6 < n2) {
            Base64Util.encode3to4(byArray, n6 + n, n2 - n6, byArray2, n7);
            n7 += 4;
        }
        try {
            return new String(byArray2, 0, n7, PREFERRED_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(byArray2, 0, n7);
        }
    }

    private static int decode4to3(byte[] byArray, int n, byte[] byArray2, int n2) {
        if (byArray[n + 2] == 61) {
            int n3 = (DECODABET[byArray[n]] & 0xFF) << 18 | (DECODABET[byArray[n + 1]] & 0xFF) << 12;
            byArray2[n2] = (byte)(n3 >>> 16);
            return 1;
        }
        if (byArray[n + 3] == 61) {
            int n4 = (DECODABET[byArray[n]] & 0xFF) << 18 | (DECODABET[byArray[n + 1]] & 0xFF) << 12 | (DECODABET[byArray[n + 2]] & 0xFF) << 6;
            byArray2[n2] = (byte)(n4 >>> 16);
            byArray2[n2 + 1] = (byte)(n4 >>> 8);
            return 2;
        }
        try {
            int n5 = (DECODABET[byArray[n]] & 0xFF) << 18 | (DECODABET[byArray[n + 1]] & 0xFF) << 12 | (DECODABET[byArray[n + 2]] & 0xFF) << 6 | DECODABET[byArray[n + 3]] & 0xFF;
            byArray2[n2] = (byte)(n5 >> 16);
            byArray2[n2 + 1] = (byte)(n5 >> 8);
            byArray2[n2 + 2] = (byte)n5;
            return 3;
        }
        catch (Exception exception) {
            System.out.println("" + byArray[n] + ": " + DECODABET[byArray[n]]);
            System.out.println("" + byArray[n + 1] + ": " + DECODABET[byArray[n + 1]]);
            System.out.println("" + byArray[n + 2] + ": " + DECODABET[byArray[n + 2]]);
            System.out.println("" + byArray[n + 3] + ": " + DECODABET[byArray[n + 3]]);
            return -1;
        }
    }

    public static byte[] decode(byte[] byArray, int n, int n2) {
        int n3 = n2 * 3 / 4;
        byte[] byArray2 = new byte[n3];
        int n4 = 0;
        byte[] byArray3 = new byte[4];
        int n5 = 0;
        int n6 = 0;
        byte by = 0;
        byte by2 = 0;
        for (n6 = n; n6 < n + n2; ++n6) {
            by = (byte)(byArray[n6] & 0x7F);
            by2 = DECODABET[by];
            if (by2 >= -5) {
                if (by2 < -1) continue;
                byArray3[n5++] = by;
                if (n5 <= 3) continue;
                n4 += Base64Util.decode4to3(byArray3, 0, byArray2, n4);
                n5 = 0;
                if (by != 61) continue;
                break;
            }
            System.err.println("Bad Base64 input character at " + n6 + ": " + byArray[n6] + "(decimal)");
            return null;
        }
        byte[] byArray4 = new byte[n4];
        System.arraycopy(byArray2, 0, byArray4, 0, n4);
        return byArray4;
    }

    public static byte[] decode(String string) {
        byte[] byArray;
        try {
            byArray = string.getBytes(PREFERRED_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string.getBytes();
        }
        byArray = Base64Util.decode(byArray, 0, byArray.length);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String encodeFromInputStream(java.io.InputStream inputStream) {
        String string = null;
        InputStream inputStream2 = null;
        try {
            byte[] byArray = new byte[4096];
            int n = 0;
            int n2 = 0;
            inputStream2 = new InputStream(inputStream, 1);
            n2 = inputStream2.read(byArray, n, 4096);
            if (n2 >= 0) {
                string = new String(byArray, 0, n, PREFERRED_ENCODING);
                n += n2;
                while ((n2 = inputStream2.read(byArray, n, 4096)) >= 0) {
                    string.concat(new String(byArray, 0, n, PREFERRED_ENCODING));
                    n += n2;
                }
            }
        }
        catch (IOException iOException) {
            System.err.println("Error encoding from InputStream");
        }
        finally {
            try {
                inputStream2.close();
            }
            catch (Exception exception) {}
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean encodeToOutputStream(java.io.OutputStream outputStream, byte[] byArray) {
        boolean bl = false;
        OutputStream outputStream2 = null;
        try {
            outputStream2 = new OutputStream(outputStream, 1);
            outputStream2.write(byArray);
            bl = true;
        }
        catch (IOException iOException) {
            bl = false;
        }
        finally {
            try {
                outputStream2.close();
            }
            catch (Exception exception) {}
        }
        return bl;
    }

    static {
        byte[] byArray;
        PREFERRED_ENCODING = StringUtil.getStringEncoding();
        NATIVE_ALPHABET = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
        try {
            byArray = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".getBytes(PREFERRED_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = NATIVE_ALPHABET;
        }
        ALPHABET = byArray;
        DECODABET = new byte[]{-9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -5, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, 62, -9, -9, -9, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -9, -9, -9, -1, -9, -9, -9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -9, -9, -9, -9, -9, -9, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -9, -9, -9, -9};
    }

    public static class OutputStream
    extends java.io.OutputStream {
        private boolean encode;
        private int position;
        private byte[] buffer;
        private int bufferLength;
        private int lineLength;
        private boolean breakLines;
        private byte[] b4;
        private boolean suspendEncoding;
        private java.io.OutputStream out;

        public OutputStream(java.io.OutputStream outputStream) {
            this(outputStream, 1);
        }

        public OutputStream(java.io.OutputStream outputStream, int n) {
            this.out = outputStream;
            this.breakLines = (n & 8) != 8;
            this.encode = (n & 1) == 1;
            this.bufferLength = this.encode ? 3 : 4;
            this.buffer = new byte[this.bufferLength];
            this.position = 0;
            this.lineLength = 0;
            this.suspendEncoding = false;
            this.b4 = new byte[4];
        }

        public void write(int n) throws IOException {
            if (this.suspendEncoding) {
                this.out.write(n);
                return;
            }
            if (this.encode) {
                this.buffer[this.position++] = (byte)n;
                if (this.position >= this.bufferLength) {
                    this.out.write(Base64Util.encode3to4(this.b4, this.buffer, this.bufferLength));
                    this.lineLength += 4;
                    if (this.breakLines && this.lineLength >= 76) {
                        this.out.write(10);
                        this.lineLength = 0;
                    }
                    this.position = 0;
                }
            } else if (DECODABET[n & 0x7F] > -5) {
                this.buffer[this.position++] = (byte)n;
                if (this.position >= this.bufferLength) {
                    int n2 = Base64Util.decode4to3(this.buffer, 0, this.b4, 0);
                    this.out.write(this.b4, 0, n2);
                    this.position = 0;
                }
            } else if (DECODABET[n & 0x7F] != -5) {
                throw new IOException("Invalid character in Base64 data.");
            }
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (this.suspendEncoding) {
                this.out.write(byArray, n, n2);
                return;
            }
            for (int i = 0; i < n2; ++i) {
                this.write(byArray[n + i]);
            }
        }

        public void flushBase64() throws IOException {
            if (this.position > 0) {
                if (this.encode) {
                    this.out.write(Base64Util.encode3to4(this.b4, this.buffer, this.position));
                    this.position = 0;
                } else {
                    throw new IOException("Base64 input not properly padded.");
                }
            }
        }

        public void close() throws IOException {
            this.flushBase64();
            this.out.close();
            this.buffer = null;
            this.out = null;
        }

        public void suspendEncoding() throws IOException {
            this.flushBase64();
            this.suspendEncoding = true;
        }

        public void resumeEncoding() {
            this.suspendEncoding = false;
        }

        public void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length);
        }

        public void flush() throws IOException {
            this.out.flush();
        }
    }

    public static class InputStream
    extends java.io.InputStream {
        private boolean encode;
        private int position;
        private byte[] buffer;
        private int bufferLength;
        private int numSigBytes;
        private int lineLength;
        private boolean breakLines;
        private java.io.InputStream in;

        public InputStream(java.io.InputStream inputStream) {
            this(inputStream, 0);
        }

        public InputStream(java.io.InputStream inputStream, int n) {
            this.in = inputStream;
            this.breakLines = (n & 8) != 8;
            this.encode = (n & 1) == 1;
            this.bufferLength = this.encode ? 4 : 3;
            this.buffer = new byte[this.bufferLength];
            this.position = -1;
            this.lineLength = 0;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public int read() throws IOException {
            if (this.position < 0) {
                byte[] byArray;
                if (this.encode) {
                    byArray = new byte[3];
                    int n = 0;
                    for (int i = 0; i < 3; ++i) {
                        try {
                            int n2 = this.in.read();
                            if (n2 < 0) continue;
                            byArray[i] = (byte)n2;
                            ++n;
                            continue;
                        }
                        catch (IOException iOException) {
                            if (i != 0) continue;
                            throw iOException;
                        }
                    }
                    if (n <= 0) return -1;
                    Base64Util.encode3to4(byArray, 0, n, this.buffer, 0);
                    this.position = 0;
                    this.numSigBytes = 4;
                } else {
                    byArray = new byte[4];
                    int n = 0;
                    for (n = 0; n < 4; ++n) {
                        int n3 = 0;
                        while ((n3 = this.in.read()) >= 0 && DECODABET[n3 & 0x7F] <= -5) {
                        }
                        if (n3 < 0) break;
                        byArray[n] = (byte)n3;
                    }
                    if (n == 4) {
                        this.numSigBytes = Base64Util.decode4to3(byArray, 0, this.buffer, 0);
                        this.position = 0;
                    } else {
                        if (n != 0) throw new IOException("Improperly padded Base64 input.");
                        return -1;
                    }
                }
            }
            if (this.position < 0) throw new IOException("Error in Base64 code reading stream.");
            if (this.position >= this.numSigBytes) {
                return -1;
            }
            if (this.encode && this.breakLines && this.lineLength >= 76) {
                this.lineLength = 0;
                return 10;
            }
            ++this.lineLength;
            byte by = this.buffer[this.position++];
            if (this.position < this.bufferLength) return by & 0xFF;
            this.position = -1;
            return by & 0xFF;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            for (n3 = 0; n3 < n2; ++n3) {
                int n4 = this.read();
                if (n4 < 0) {
                    if (n3 != 0) break;
                    return -1;
                }
                byArray[n + n3] = (byte)n4;
            }
            return n3;
        }

        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        public int available() throws IOException {
            return 0;
        }

        public void close() throws IOException {
            this.in.close();
        }

        public void mark(int n) {
            this.in.mark(n);
        }

        public boolean markSupported() {
            return this.in.markSupported();
        }

        public void reset() throws IOException {
            this.in.reset();
        }
    }
}

