/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.service;

import org.ws4d.java.DPWSFramework;
import org.ws4d.java.communication.CommunicationManager;
import org.ws4d.java.communication.CommunicationManagerRegistry;
import org.ws4d.java.communication.CommunicationUtil;
import org.ws4d.java.communication.ProtocolData;
import org.ws4d.java.communication.TimeoutException;
import org.ws4d.java.configuration.FrameworkProperties;
import org.ws4d.java.constants.ConstantsHelper;
import org.ws4d.java.constants.SOAPConstants;
import org.ws4d.java.constants.WSEConstants;
import org.ws4d.java.dispatch.OutDispatcher;
import org.ws4d.java.eventing.ClientSubscription;
import org.ws4d.java.eventing.EventSink;
import org.ws4d.java.eventing.EventingException;
import org.ws4d.java.eventing.SubscriptionManager;
import org.ws4d.java.message.FaultMessage;
import org.ws4d.java.message.Message;
import org.ws4d.java.message.SOAPException;
import org.ws4d.java.message.eventing.GetStatusMessage;
import org.ws4d.java.message.eventing.GetStatusResponseMessage;
import org.ws4d.java.message.eventing.RenewMessage;
import org.ws4d.java.message.eventing.RenewResponseMessage;
import org.ws4d.java.message.eventing.SubscribeMessage;
import org.ws4d.java.message.eventing.SubscribeResponseMessage;
import org.ws4d.java.message.eventing.SubscriptionEndMessage;
import org.ws4d.java.message.eventing.UnsubscribeMessage;
import org.ws4d.java.message.eventing.UnsubscribeResponseMessage;
import org.ws4d.java.schema.SchemaUtil;
import org.ws4d.java.service.DefaultClientSubscription;
import org.ws4d.java.service.DefaultEventSource;
import org.ws4d.java.service.LocalService;
import org.ws4d.java.service.ServiceSubscription;
import org.ws4d.java.structures.HashMap;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.structures.LockedMap;
import org.ws4d.java.types.AttributedURI;
import org.ws4d.java.types.Delivery;
import org.ws4d.java.types.EndpointReference;
import org.ws4d.java.types.EprInfo;
import org.ws4d.java.types.Filter;
import org.ws4d.java.types.LocalizedString;
import org.ws4d.java.types.QName;
import org.ws4d.java.types.ReferenceParametersMData;
import org.ws4d.java.types.URI;
import org.ws4d.java.types.URISet;
import org.ws4d.java.util.IDGenerator;
import org.ws4d.java.util.TimedEntry;
import org.ws4d.java.util.WatchDog;

public class DefaultSubscriptionManager
implements SubscriptionManager {
    private static final String FAULT_REASON_DELIVERY_MODE = "The requested delivery mode is not supported.";
    private static final String FAULT_REASON_FILTERING_DIALECT = "The requested filter dialect is not supported.";
    private static final String FAULT_REASON_FILTER_ACTION_NOT_SUPPORTED = "No notifications match the supplied filter.";
    private static final String FAULT_REASON_INVALID_MESSAGE = "The message is not valid and cannot be processed.";
    private static final String FAULT_REASON_UNABLE_TO_RENEW__NO_SUBSCRIPTION = "No such subscription";
    private static final String EVENT_SOURCE_SHUTTING_DOWN = "Event source shutting down.";
    private static final long REMOVAL_POLL_INTERVAL = 60000L;
    private final LockedMap subscriptions = new LockedMap();
    private final LocalService service;

    public DefaultSubscriptionManager(LocalService localService) {
        this.service = localService;
        TimedEntry timedEntry = new TimedEntry(){

            protected void timedOut() {
                DefaultSubscriptionManager.this.cleanUpSubscriptions();
                WatchDog.getInstance().register(this, 60000L);
            }
        };
        WatchDog.getInstance().register(timedEntry, 60000L);
    }

    static SOAPException createFault(Message message, QName qName, LocalizedString localizedString) {
        return DefaultSubscriptionManager.createFault(message, SOAPConstants.SOAP_FAULT_SENDER, qName, localizedString);
    }

    static SOAPException createFault(Message message, QName qName, QName qName2, LocalizedString localizedString) {
        FaultMessage faultMessage = new FaultMessage("http://www.w3.org/2005/08/addressing/fault", CommunicationManager.ID_NULL);
        faultMessage.setResponseTo(message);
        faultMessage.setCode(qName);
        faultMessage.setSubcode(qName2);
        faultMessage.addReason(localizedString);
        faultMessage.setResponseTo(message);
        return new SOAPException(faultMessage);
    }

    static SOAPException createDeliveryModeUnavailableFault(Message message) {
        return DefaultSubscriptionManager.createFault(message, WSEConstants.WSE_FAULT_DELIVERY_MODE_REQUESTED_UNVAILABLE, new LocalizedString(FAULT_REASON_DELIVERY_MODE, "en-US"));
    }

    static SOAPException createInvalidMessageFault(Message message) {
        return DefaultSubscriptionManager.createFault(message, WSEConstants.WSE_FAULT_INVALID_MESSAGE, new LocalizedString(FAULT_REASON_INVALID_MESSAGE, "en-US"));
    }

    static SOAPException createUnableToRenew(Message message) {
        return DefaultSubscriptionManager.createFault(message, SOAPConstants.SOAP_FAULT_RECEIVER, WSEConstants.WSE_FAULT_UNABLE_TO_RENEW, new LocalizedString(FAULT_REASON_UNABLE_TO_RENEW__NO_SUBSCRIPTION, "en-US"));
    }

    static EndpointReference createSubscriptionManager(URI uRI, String string) {
        ReferenceParametersMData referenceParametersMData = new ReferenceParametersMData();
        referenceParametersMData.setWseIdentifier(string);
        return new EndpointReference(uRI, referenceParametersMData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpSubscriptions() {
        this.subscriptions.exclusiveLock();
        try {
            long l = System.currentTimeMillis();
            Iterator iterator = this.subscriptions.entrySet().iterator();
            while (iterator.hasNext()) {
                HashMap.Entry entry = (HashMap.Entry)iterator.next();
                ServiceSubscription serviceSubscription = (ServiceSubscription)entry.getValue();
                if (serviceSubscription.expirationTime > l) continue;
                iterator.remove();
                this.removeSubscriptionFromEventSources(serviceSubscription);
            }
        }
        finally {
            this.subscriptions.releaseExclusiveLock();
        }
    }

    private void removeSubscriptionFromEventSources(ServiceSubscription serviceSubscription) {
        Iterator iterator = serviceSubscription.filterActions.iterator();
        while (iterator.hasNext()) {
            String string = ((URI)iterator.next()).toString();
            DefaultEventSource defaultEventSource = (DefaultEventSource)this.service.getEventSource(string);
            if (defaultEventSource == null) continue;
            defaultEventSource.removeSubscription(serviceSubscription);
        }
    }

    private boolean addSubscriptionToEventSource(ServiceSubscription serviceSubscription) {
        boolean bl = false;
        URISet uRISet = serviceSubscription.filterActions;
        Iterator iterator = uRISet.iterator();
        while (iterator.hasNext()) {
            String string = ((URI)iterator.next()).toString();
            DefaultEventSource defaultEventSource = (DefaultEventSource)this.service.getEventSource(string);
            if (defaultEventSource == null) continue;
            defaultEventSource.addSubscription(serviceSubscription);
            bl = true;
        }
        return bl;
    }

    private SubscriptionEndMessage subscriptionEnd(ServiceSubscription serviceSubscription, URI uRI, String string) {
        SubscriptionEndMessage subscriptionEndMessage = new SubscriptionEndMessage(serviceSubscription.getCommunicationManagerID());
        subscriptionEndMessage.setTargetXAddressInfo(serviceSubscription.endTo);
        subscriptionEndMessage.getHeader().setEndpointReference(serviceSubscription.endTo.getEndpointReference());
        subscriptionEndMessage.setStatus(uRI);
        subscriptionEndMessage.setReason(new LocalizedString(string, "en-US"));
        subscriptionEndMessage.setSubscriptionManager(serviceSubscription.getSubscriptionManager());
        return subscriptionEndMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubscribeResponseMessage subscribe(SubscribeMessage subscribeMessage, ProtocolData protocolData) throws SOAPException {
        Delivery delivery = subscribeMessage.getDelivery();
        if (delivery == null) {
            throw DefaultSubscriptionManager.createDeliveryModeUnavailableFault(subscribeMessage);
        }
        URI uRI = delivery.getMode();
        if (uRI == null || !"http://schemas.xmlsoap.org/ws/2004/08/eventing/DeliveryModes/Push".equals(uRI.toString())) {
            throw DefaultSubscriptionManager.createDeliveryModeUnavailableFault(subscribeMessage);
        }
        ServiceSubscription serviceSubscription = new ServiceSubscription(protocolData.getProtocolInfo());
        serviceSubscription.notifyTo = new EprInfo(delivery.getNotifyTo(), protocolData.getCommunicationManagerId());
        serviceSubscription.notifyTo.mergeProtocolInfo(protocolData.getProtocolInfo());
        if (subscribeMessage.getEndTo() != null) {
            serviceSubscription.endTo = new EprInfo(subscribeMessage.getEndTo(), protocolData.getCommunicationManagerId());
            serviceSubscription.endTo.mergeProtocolInfo(protocolData.getProtocolInfo());
        } else {
            serviceSubscription.endTo = null;
        }
        serviceSubscription.communicationManagerId = protocolData.getCommunicationManagerId();
        CommunicationManager communicationManager = DPWSFramework.getCommunicationManager(protocolData.getCommunicationManagerId());
        CommunicationUtil communicationUtil = communicationManager.getCommunicationUtil();
        ConstantsHelper constantsHelper = communicationUtil.getHelper(subscribeMessage.getProtocolInfo().getVersion());
        Filter filter = subscribeMessage.getFilter();
        if (filter != null) {
            EndpointReference endpointReference;
            URI uRI2 = filter.getDialect();
            if (uRI2 == null) {
                throw DefaultSubscriptionManager.createFault(subscribeMessage, SOAPConstants.SOAP_FAULT_SENDER, WSEConstants.WSE_FAULT_FILTERING_REQUESTED_UNAVAILABLE, new LocalizedString(FAULT_REASON_FILTERING_DIALECT, "en-US"));
            }
            if (constantsHelper.getDPWSFilterEventingAction().equals(uRI2.toString())) {
                serviceSubscription.filterActions = filter.getActions();
                boolean bl = this.addSubscriptionToEventSource(serviceSubscription);
                if (!bl) {
                    FaultMessage faultMessage = new FaultMessage(constantsHelper.getDPWSActionFault(), protocolData.getCommunicationManagerId());
                    faultMessage.setResponseTo(subscribeMessage);
                    faultMessage.setCode(SOAPConstants.SOAP_FAULT_SENDER);
                    faultMessage.setSubcode(constantsHelper.getDPWSFaultFilterActionNotSupported());
                    faultMessage.addReason(new LocalizedString(FAULT_REASON_FILTER_ACTION_NOT_SUPPORTED, "en-US"));
                    throw new SOAPException(faultMessage);
                }
            }
            serviceSubscription.setExpiration(subscribeMessage.getExpires(), subscribeMessage);
            SubscribeResponseMessage subscribeResponseMessage = new SubscribeResponseMessage(protocolData.getCommunicationManagerId());
            subscribeResponseMessage.setResponseTo(subscribeMessage);
            subscribeResponseMessage.setProtocolInfo(subscribeMessage.getProtocolInfo());
            AttributedURI attributedURI = subscribeMessage.getTo();
            String string = "urn:uuid:" + IDGenerator.getUUID();
            if (FrameworkProperties.REFERENCE_PARAM_MODE) {
                endpointReference = DefaultSubscriptionManager.createSubscriptionManager(attributedURI, string);
            } else {
                attributedURI.setFragmentEncoded(string);
                endpointReference = new EndpointReference((URI)attributedURI);
            }
            serviceSubscription.setSubscriptionManager(endpointReference);
            subscribeResponseMessage.setSubscriptionManager(endpointReference);
            subscribeResponseMessage.setExpires(SchemaUtil.createDuration(serviceSubscription.expirationTime - System.currentTimeMillis()));
            this.subscriptions.exclusiveLock();
            try {
                this.subscriptions.put(string, serviceSubscription);
            }
            finally {
                this.subscriptions.releaseExclusiveLock();
            }
            return subscribeResponseMessage;
        }
        throw DefaultSubscriptionManager.createFault(subscribeMessage, SOAPConstants.SOAP_FAULT_SENDER, WSEConstants.WSE_FAULT_FILTERING_REQUESTED_UNAVAILABLE, new LocalizedString(FAULT_REASON_FILTERING_DIALECT, "en-US"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientSubscription subscribe(EventSink eventSink, String string, URISet uRISet, long l) throws EventingException {
        ServiceSubscription serviceSubscription = new ServiceSubscription(null);
        serviceSubscription.filterActions = uRISet;
        serviceSubscription.sink = eventSink;
        serviceSubscription.clientSubscriptionId = string;
        serviceSubscription.setExpiration(l);
        serviceSubscription.communicationManagerId = CommunicationManagerRegistry.getDefault();
        boolean bl = this.addSubscriptionToEventSource(serviceSubscription);
        if (!bl) {
            CommunicationManager communicationManager = DPWSFramework.getCommunicationManager(serviceSubscription.getCommunicationManagerID());
            CommunicationUtil communicationUtil = communicationManager.getCommunicationUtil();
            Iterator iterator = communicationManager.getSupportedVersions().iterator();
            QName qName = iterator.hasNext() ? communicationUtil.getHelper((Integer)iterator.next()).getDPWSFaultFilterActionNotSupported() : new QName(null);
            throw new EventingException(qName, FAULT_REASON_FILTER_ACTION_NOT_SUPPORTED);
        }
        String string2 = "urn:uuid:" + IDGenerator.getUUID();
        this.subscriptions.exclusiveLock();
        try {
            this.subscriptions.put(string2, serviceSubscription);
        }
        finally {
            this.subscriptions.releaseExclusiveLock();
        }
        Iterator iterator = this.service.getEprInfos();
        EprInfo eprInfo = (EprInfo)iterator.next();
        AttributedURI attributedURI = eprInfo.getEndpointReference().getAddress();
        return new DefaultClientSubscription(eventSink, string, DefaultSubscriptionManager.createSubscriptionManager(attributedURI, string2), serviceSubscription.getCommunicationManagerID(), l, this.service.getServiceReference());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UnsubscribeResponseMessage unsubscribe(UnsubscribeMessage unsubscribeMessage, ProtocolData protocolData) throws SOAPException {
        String string = unsubscribeMessage.getHeader().getWseIdentifier();
        if (string == null) {
            throw DefaultSubscriptionManager.createInvalidMessageFault(unsubscribeMessage);
        }
        ServiceSubscription serviceSubscription = null;
        this.subscriptions.exclusiveLock();
        try {
            serviceSubscription = (ServiceSubscription)this.subscriptions.remove(string);
        }
        finally {
            this.subscriptions.releaseExclusiveLock();
        }
        if (serviceSubscription == null) {
            throw DefaultSubscriptionManager.createInvalidMessageFault(unsubscribeMessage);
        }
        this.removeSubscriptionFromEventSources(serviceSubscription);
        UnsubscribeResponseMessage unsubscribeResponseMessage = new UnsubscribeResponseMessage(protocolData.getCommunicationManagerId());
        unsubscribeResponseMessage.setResponseTo(unsubscribeMessage);
        unsubscribeResponseMessage.setProtocolInfo(unsubscribeMessage.getProtocolInfo());
        return unsubscribeResponseMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(ClientSubscription clientSubscription) throws EventingException {
        String string = clientSubscription.getServiceSubscriptionId();
        ServiceSubscription serviceSubscription = null;
        this.subscriptions.exclusiveLock();
        try {
            serviceSubscription = (ServiceSubscription)this.subscriptions.remove(string);
        }
        finally {
            this.subscriptions.releaseExclusiveLock();
        }
        if (serviceSubscription == null) {
            throw new EventingException(WSEConstants.WSE_FAULT_INVALID_MESSAGE, FAULT_REASON_INVALID_MESSAGE);
        }
        this.removeSubscriptionFromEventSources(serviceSubscription);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RenewResponseMessage renew(RenewMessage renewMessage, ProtocolData protocolData) throws SOAPException {
        String string = renewMessage.getHeader().getWseIdentifier();
        if (string == null) {
            throw DefaultSubscriptionManager.createInvalidMessageFault(renewMessage);
        }
        RenewResponseMessage renewResponseMessage = new RenewResponseMessage(protocolData.getCommunicationManagerId());
        renewResponseMessage.setResponseTo(renewMessage);
        renewResponseMessage.setProtocolInfo(renewMessage.getProtocolInfo());
        this.subscriptions.exclusiveLock();
        try {
            ServiceSubscription serviceSubscription = (ServiceSubscription)this.subscriptions.get(string);
            if (serviceSubscription == null) {
                throw DefaultSubscriptionManager.createUnableToRenew(renewMessage);
            }
            long l = System.currentTimeMillis();
            if (serviceSubscription.expirationTime <= l) {
                throw DefaultSubscriptionManager.createUnableToRenew(renewMessage);
            }
            serviceSubscription.setExpiration(renewMessage.getExpires(), renewMessage);
            renewResponseMessage.setExpires(SchemaUtil.createDuration(serviceSubscription.expirationTime - l));
        }
        finally {
            this.subscriptions.releaseExclusiveLock();
        }
        return renewResponseMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long renew(ClientSubscription clientSubscription, long l) throws EventingException {
        String string = clientSubscription.getServiceSubscriptionId();
        ServiceSubscription serviceSubscription = null;
        this.subscriptions.exclusiveLock();
        try {
            serviceSubscription = (ServiceSubscription)this.subscriptions.get(string);
            if (serviceSubscription == null) {
                throw new EventingException(WSEConstants.WSE_FAULT_INVALID_MESSAGE, FAULT_REASON_INVALID_MESSAGE);
            }
            long l2 = System.currentTimeMillis();
            if (serviceSubscription.expirationTime <= l2) {
                throw new EventingException(WSEConstants.WSE_FAULT_INVALID_MESSAGE, FAULT_REASON_INVALID_MESSAGE);
            }
            serviceSubscription.setExpiration(l);
            long l3 = l;
            return l3;
        }
        finally {
            this.subscriptions.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetStatusResponseMessage getStatus(GetStatusMessage getStatusMessage, ProtocolData protocolData) throws SOAPException {
        String string = getStatusMessage.getHeader().getWseIdentifier();
        if (string == null) {
            throw DefaultSubscriptionManager.createInvalidMessageFault(getStatusMessage);
        }
        GetStatusResponseMessage getStatusResponseMessage = new GetStatusResponseMessage(protocolData.getCommunicationManagerId());
        getStatusResponseMessage.setResponseTo(getStatusMessage);
        getStatusResponseMessage.setProtocolInfo(getStatusMessage.getProtocolInfo());
        this.subscriptions.sharedLock();
        try {
            ServiceSubscription serviceSubscription = (ServiceSubscription)this.subscriptions.get(string);
            if (serviceSubscription == null) {
                throw DefaultSubscriptionManager.createInvalidMessageFault(getStatusMessage);
            }
            long l = System.currentTimeMillis();
            if (serviceSubscription.expirationTime <= l) {
                throw DefaultSubscriptionManager.createInvalidMessageFault(getStatusMessage);
            }
            getStatusResponseMessage.setExpires(SchemaUtil.createDuration(serviceSubscription.expirationTime - l));
        }
        finally {
            this.subscriptions.releaseSharedLock();
        }
        return getStatusResponseMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getStatus(ClientSubscription clientSubscription) throws EventingException, TimeoutException {
        String string = clientSubscription.getServiceSubscriptionId();
        ServiceSubscription serviceSubscription = null;
        this.subscriptions.exclusiveLock();
        try {
            serviceSubscription = (ServiceSubscription)this.subscriptions.get(string);
            if (serviceSubscription == null) {
                throw new EventingException(WSEConstants.WSE_FAULT_INVALID_MESSAGE, FAULT_REASON_INVALID_MESSAGE);
            }
            long l = System.currentTimeMillis();
            if (serviceSubscription.expirationTime <= l) {
                throw new EventingException(WSEConstants.WSE_FAULT_INVALID_MESSAGE, FAULT_REASON_INVALID_MESSAGE);
            }
            long l2 = serviceSubscription.expirationTime - l;
            return l2;
        }
        finally {
            this.subscriptions.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendSubscriptionEnd() {
        this.subscriptions.exclusiveLock();
        try {
            Iterator iterator = this.subscriptions.values().iterator();
            while (iterator.hasNext()) {
                Object object;
                ServiceSubscription serviceSubscription = (ServiceSubscription)iterator.next();
                iterator.remove();
                this.removeSubscriptionFromEventSources(serviceSubscription);
                if (serviceSubscription.sink == null) {
                    object = this.subscriptionEnd(serviceSubscription, SubscriptionEndMessage.SOURCE_SHUTTING_DOWN_STATUS, EVENT_SOURCE_SHUTTING_DOWN);
                    OutDispatcher.getInstance().send((SubscriptionEndMessage)object, serviceSubscription.endTo);
                    continue;
                }
                object = serviceSubscription.sink.getSubscription(serviceSubscription.clientSubscriptionId);
                if (object == null) continue;
                serviceSubscription.sink.getEventListener().subscriptionEndReceived((ClientSubscription)object, SubscriptionEndMessage.SOURCE_SHUTTING_DOWN_STATUS);
            }
        }
        finally {
            this.subscriptions.releaseExclusiveLock();
        }
    }

    public boolean isRemote() {
        return false;
    }
}

